;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedures SetDate(),
;                             SetTime()
;Source File     : SETDTTIM.SC
;Author          : David Gordon
;                  Gordon Innovations
;                  Lincoln, NE
;
;Informant Issue : November 1992
;
;Description     : Set system date and time from within Paradox
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

PROC setdate(newdate)
  PRIVATE dd,mm,newdate,x,yyyy
  IF SUBSTR(TYPE(DATEVAL(newdate)),1,1) ="A" OR
     DATEVAL(newdate) < 01/01/80 THEN
    RETURN False
  ENDIF
  newdate=FORMAT("D8",newdate)
  X=MATCH(newdate,"../../..",mm,dd,yyyy)
  newdate=mm+"-"+dd+"-"+yyyy
  RUN NOREFRESH "DATE "+newdate+" >NULL"
  RETURN True
ENDPROC

PROC settime(newtime)
  PRIVATE hh,mm,ss,newtime,X
  hh="" mm="" ss=""
  X=MATCH(newtime,"..:..:..",hh,mm,ss)
  hh=NUMVAL(hh) mm=NUMVAL(mm) ss=NUMVAL(ss)
  IF (hh>24 OR hh<0) OR
     (mm>59 OR mm<0) OR
     (ss>59 OR mm<0) THEN
    RETURN False
  ENDIF
  newtime=STRVAL(hh)+":"+STRVAL(mm)+":"+STRVAL(ss)
  RUN NOREFRESH "TIME "+newtime+" >NULL"
  RETURN True
ENDPROC
