LibName = "Libs\\EdtHndlr"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

;=================================================
;            Editor Handling Procedures          
;=================================================

? " Working on ", LibName, " *"
;==================================================
PROC BlockAction(Action)

;-------------------------------------------------
; This procedure checks to see if the user has
; highlighted text before it does the Copy or Cut
; the user selected from the pulldown menu.
;-------------------------------------------------

PRIVATE BlockAction,
        EditInfo

BlockAction = UPPER(Action)
EDITOR INFO TO EditInfo

SWITCH

  CASE BlockAction = "COPY" OR BlockAction = "CUT" :
     IF EditInfo["SELSTART"] = 0 AND EditInfo["SELEND"] = 0 THEN
        EDITOR INFO TO EditInfo
        SOUND 300 50 SOUND 300 50
        MESSAGE "Can't ", Action, " text block as none has been highlighted"
        SLEEP 2500
        MESSAGE "Highlight text using Shift + Arrow Keys (or use Mouse)" 
        SLEEP 2500
        MESSAGE "" 
     ELSE
        BlockAction = UPPER(Action)
        SWITCH
           CASE BlockAction = "COPY" :
                CLIPCOPY
           CASE BlockAction = "CUT" :
                CLIPCUT
        ENDSWITCH
     ENDIF

  CASE BlockACtion = "PASTE" :
     CLIPPASTE
     
ENDSWITCH   

ENDPROC
WRITELIB LibName BlockAction
RELEASE PROCS BlockAction

?? "*"
;==================================================
PROC FilePut(TriggerType, TagValue, EventValue, ElementValue)

PRIVATE DebugMode, 
        DebugWH,
        DirStatus,
        FileStatus

;-------------------------------------------------
; Following code used for debugging. It creates a 
; canvas window on the righthand-side of the screen
; where it displays all the values generated by the 
; event for which this wait procedure is called.
;-------------------------------------------------
DebugMode = False             ; Set to True/False to turn On/Off 'debug' mode.
IF DebugMode OR GlobalVars["DebugMode"] THEN
   WINDOW CREATE FLOATING @1,40 HEIGHT 6 WIDTH 36 TO DebugWH
   ?? "TriggerType  = ", TriggerType
   ?  "TagValue     = ", TagValue
   ?  "EventValue   = ", EventValue
   ?  "ElementValue = ", ElementValue
   SLEEP 2000
   WINDOW CLOSE
ENDIF

;--------------------------------------------------
; User updated directory specification need to 
;    validate what s/he entered.
;--------------------------------------------------
IF TriggerType = "UPDATE" AND TagValue = "DirNameTag" THEN
   IF EventValue <> DefDirName THEN
      DirStatus = IsDir(EventValue)
      IF DirStatus = False THEN
         SELECTCONTROL "DirTag"
         RETURN False
      ENDIF   
      RETURN DirStatus
   ENDIF   
ENDIF

;--------------------------------------------------
; User selected Ok push button. Need to do some final
;    checks before exiting dialog and doing report.
;--------------------------------------------------
IF TriggerType = "UPDATE" AND TagValue = "ACCEPT" THEN
   IF SUBSTR(DirName, LEN(DirName), 1) <> "\\" THEN
      DirName = DirName + "\\"
   ENDIF   
   IF EventValue <> DefDirName THEN
      DirStatus = IsDir(DirName)
      IF DirStatus = False THEN
         SELECTCONTROL "DirTag"
         RETURN False
      ENDIF   
   ENDIF   
   IF FileName = "" THEN
      MESSAGE "File Name field is blank, enter a value or select Cancel"
      SLEEP 2500
      MESSAGE ""
      SELECTCONTROL "FileNameTag"
      RETURN False
   ENDIF
   FileSpec = DirName + FileName + "." + FileExt
   FileStatus = FileNoExists(FileSpec)
   IF FileStatus = False THEN
      SELECTCONTROL "FileNameTag"
      RETURN False
   ENDIF
   RETURN FileStatus   
ENDIF
            
ENDPROC
WRITELIB LibName FilePut
RELEASE PROCS FilePut

?? "*"
;==================================================
PROC FileGet(TriggerType, TagValue, EventValue, ElementValue)

PRIVATE DebugMode, 
        DebugWH,
        DirStatus

;-------------------------------------------------
; Following code used for debugging. It creates a 
; canvas window on the righthand-side of the screen
; where it displays all the values generated by the 
; event for which this wait procedure is called.
;-------------------------------------------------
DebugMode = False  ; Set to True/False to turn On/Off 'debug' mode.
IF DebugMode OR GlobalVars["DebugMode"] THEN
   WINDOW CREATE FLOATING @1,40 HEIGHT 6 WIDTH 36 TO DebugWH
   ?? "TriggerType  = ", TriggerType
   ?  "TagValue     = ", TagValue
   ?  "EventValue   = ", EventValue
   ?  "ElementValue = ", ElementValue
   SLEEP 2000
   WINDOW CLOSE
ENDIF

;--------------------------------------------------
; User selected Ok push button. Need to do some final
;    checks before exiting dialog and doing report.
;--------------------------------------------------
IF TriggerType = "UPDATE" AND TagValue = "ACCEPT" THEN
   IF SUBSTR(DirName, LEN(DirName), 1) <> "\\" THEN
      DirName = DirName + "\\"
   ENDIF   
   IF EventValue <> DefDirName THEN
      DirStatus = IsDir(DirName)
      IF DirStatus = False THEN
         SELECTCONTROL "DirTag"
      ENDIF   
   ENDIF   
   FileSpec = DirName + FileName + "." + FileExt
   IF NOT ISFILE(FileSpec) THEN
      MESSAGE "File couldn't be found, check file and directory specifications"
      SLEEP 2500
      MESSAGE ""
      SELECTCONTROL "FileNameTag"
      RETURN False
   ENDIF
   RETURN True
ENDIF
            
ENDPROC
WRITELIB LibName FileGet
RELEASE PROCS FileGet

?? "*"
;==================================================
PROC FileSpecDlg(DialogTitle, WaitProc)

PRIVATE ButtonValue, 
        DirName, 
        DefDirName,
        FileName, 
        FileExt, 
        FileSpec

FileExt     = "TXT"
DefFileName = "TempFile"
FileName    = DefFileName
DefDirName  = DIRECTORY()
DirName     = DefDirName

MESSAGE ""

SHOWDIALOG DialogTitle
   PROC WaitProc
   TRIGGER "UPDATE"
   @10,8 HEIGHT 9 WIDTH 42

   LABEL @1,0
      "~F~ile Name"
      FOR "FileNameTag"

   ACCEPT 
      @1,11 WIDTH 11 "A8"
      TAG "FileNameTag"
      TO FileName

   LABEL @1,23
      "~E~xt"
      FOR "FileExtTag"

   ACCEPT 
      @1,28 WIDTH 6 "A3"
      TAG "FileExtTag"
      TO FileExt

   LABEL @3,0
      "~D~irectory"
      FOR "DirTag"

   ACCEPT 
      @3,11 WIDTH 28 "A25"
      TAG "DirTag"
      TO DirName

   ;-------------------------------------------------
   ; Ok and Cancel push buttons.
   ;-------------------------------------------------
   PUSHBUTTON @5,8 WIDTH 10
      "~O~k"
      OK
      DEFAULT
      VALUE "Yes"
      TAG "ACCEPT"
      TO ButtonValue

   PUSHBUTTON @5,25 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "No"
      TO ButtonValue
   
ENDDIALOG   

RETURN IIF(ISASSIGNED(ButtonValue), FileSpec, False)

ENDPROC
WRITELIB LibName FileSpecDlg
RELEASE PROCS FileSpecDlg

?? "*"
;==================================================
PROC ReplaceDialog()

PRIVATE ButtonValue

MESSAGE ""

SHOWDIALOG "Replace"
   @10,8 HEIGHT 9 WIDTH 60

   LABEL @1,1
      "Target Value"
      FOR "TargetTag"

   ACCEPT 
      @1,15 WIDTH 40 "A80"
      TAG "TargetTag"
      TO TargetValue

   LABEL @3,1
      "New Value"
      FOR "NewValue"

   ACCEPT 
      @3,15 WIDTH 40 "A80"
      TAG "NewValue"
      TO NewValue

   ;-------------------------------------------------
   ; Ok and Cancel push buttons.
   ;-------------------------------------------------
   PUSHBUTTON @5,15 WIDTH 10
      "~O~k"
      OK
      DEFAULT
      VALUE "Yes"
      TAG "ACCEPT"
      TO ButtonValue

   PUSHBUTTON @5,33 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "No"
      TO ButtonValue
   
ENDDIALOG   

IF TargetValue <> "" and NewValue <> "" THEN
   ECHO OFF
   EDITOR REPLACE TargetValue NewValue
   ECHO NORMAL
ENDIF   


ENDPROC
WRITELIB LibName ReplaceDialog
RELEASE PROCS ReplaceDialog

?? "*"
;=================================================
PROC EditorMemoHndlrPullDown()

SHOWPULLDOWN
  "" : 
     "Common system interface menu" : 
     "SysMenu"
      SUBMENU
        "Max/Res [Shift+F5]" :
           "Maximize the current window (or restore its original size)" :
           "Max/Res",
         SEPARATOR,  
        "Time" :
           "Display the current time" :
           "TimeDisplay",
         SEPARATOR,            
        "About" : 
           "About Application" : 
           "AboutDialog",
        "System" : 
           "Show system information" : 
           "SysInfoProc"
      ENDSUBMENU,

   "File" :
      "Standard file options for current memo" :
       SUBMENU
         "Save As File" :
            "Write current text to a new file" :
            "FileSaveAs",
         "Insert File" :
            "Insert an external file starting at the current cursor position" :
            "FileIns",
          SEPARATOR,
         "Print" :
            "Send text to printer" :
            "PrintText"
       ENDSUBMENU,

   "Edit" :
       "Edit options for current text file" :
       "EditMenu"
        SUBMENU
          "Edit Mode ON      [F9]" :
             "Turn Edit Mode ON" :
             "EditModeOn",
          SEPARATOR,   
          "Copy Block   [Ctrl+Ins]" :
             "Copy text highlighted by shift and arrow keys to clipboard" :
             "CopyBlock",
          "Cu~t~ Block   [Shift+Del]" :
             "Delete text highlighted by shift and arrow keys" :
             "CutBlock",
          "Paste Block [Shift+Ins]" :
             "Insert current contents of clipboard at cursor" :
             "PasteBlock",
           SEPARATOR,
          "Replace to End [Ctrl+A]" :
             "Replace a specified value from cursor position to end of text" :
             "ReplaceValue"
       ENDSUBMENU,      

   "GoTo" :
       "Go to options for the current memo" :
        SUBMENU
          "Specific Value   [Ctrl+Z]" :
             "Move cursor to first occurrence of a specific value (pattern)" :
             "FindStr",
          "Next Occurrence   [Alt+Z]" :
             "Move cursor to next occurrence of value" :
             "FindNext",
           SEPARATOR,  
          "Start Of Text [Ctrl-PgUp]" :
             "Go to top of memo" :
             "GoToTop",       
          "End Of Text   [Ctrl-PgDn]" :
             "Go to bottom of memo" :
             "GoToEnd"
        ENDSUBMENU,     

   "Quit" : 
      "Quit current operation and return to previous level" : 
      "Quit"
       SUBMENU
         "No" : 
           "Do not quit current operation" : 
           "Quit/No",
         "Yes [Ctrl+Q]" : 
           "Yes quit current operation" : 
           "Quit/Yes"
         ENDSUBMENU
ENDMENU 

ENDPROC
WRITELIB LibName EditorMemoHndlrPullDown
RELEASE PROCS EditorMemoHndlrPullDown

?? "*"
;=================================================
PROC EditModeOn()

MESSAGE "One moment..."
COEDITKEY
MenuItemsState["EditModeOn"]   = False
MenuItemsState["CopyBlock"]    = True
MenuItemsState["CutBlock"]     = True
MenuItemsState["PasteBlock"]   = True
MenuItemsState["ReplaceValue"] = True
MenuItemsState["FileIns"]      = True   
MenuItemSetStatus(MenuItemsState)
IF DocType = "REPORT" THEN
   MsgPrompt("COEDITREPORT")
ELSE
   MsgPrompt("COEDITMEMO")
ENDIF   
MESSAGE ""

ENDPROC
WRITELIB LibName EditModeOn
RELEASE PROCS EditModeOn

?? "*"
;=================================================
PROC EditorWinClose()

MESSAGE "Returning to previous level..."

ECHO OFF                            ; Hide workspace.
SHOWPULLDOWN ENDMENU                ; Hide editor pulldown.
DO_IT!
WINCLOSE                            ; Close editor window.

;--------------------------------------------------
; If the Editor Handler was invoked as a result of the 
;    user requesting a report be sent to the screen 
;    the program must restore the correct environment.
;--------------------------------------------------
IF DocType = "REPORT" THEN          
   IF TABLE() = "Answer" THEN     ; If the Reporting Subsystem created
      IF SYSMODE() = "CoEdit" THEN
         DO_IT!
      ENDIF   
      CLEARIMAGE                  ;    a temporary table as the result of 
   ENDIF                          ;    sorting remove it from workspace.
   IF FormViewActive THEN         ; If the user was in FormView when s/he
      FORMKEY                     ;    requested the report restore it.
   ENDIF   
ENDIF

ECHO NORMAL                       ; Show updated workspace.

ENDPROC
WRITELIB LibName EditorWinClose
RELEASE PROCS EditorWinClose

?? "*"
;=================================================
PROC EditorHndlrWait(TriggerType, EventArray, CycleNumber)

PRIVATE ExitCode

ExitCode = 1

;-------------------------------------------------
; Menu selections
;-------------------------------------------------
IF ISASSIGNED(EventArray["MenuTag"]) THEN

   SWITCH

      ;-------------------------------------------
      ; File Menu Options
      ;-------------------------------------------
      CASE EventArray["MenuTag"] = "FileSaveAs" :
           IF FileSpecDlg("Save As File", "FilePut") <> False THEN
              ECHO OFF
              Menu {File} {CopyToFile} TYPEIN RetVal
              ENTER
              ECHO NORMAL
           ENDIF   

      CASE EventArray["MenuTag"] = "FileIns" :
           IF FileSpecDlg("File To Insert", "FileGet") <> False THEN
              ECHO OFF
              Menu {File} {InsertFile} TYPEIN RetVal
              ENTER
              ECHO NORMAL
           ENDIF   

      CASE EventArray["MenuTag"] = "PrintText" :
           MESSAGE "One moment..."
           IF IsPrinterOn() THEN
              ECHO OFF
              MENU {File} {Print}
              MESSAGE "Finished sending text to printer"
              SLEEP 2500
              ECHO NORMAL
           ELSE
              MESSAGE "Printer isn't ready, canceling request"
              SLEEP 2500   
           ENDIF   
           MESSAGE ""

      CASE EventArray["MenuTag"] = "EditModeOn" :
           EditModeOn()

      CASE EventArray["MenuTag"] = "CopyBlock" : 
           BlockAction("Copy")

      CASE EventArray["MenuTag"] = "CutBlock" : 
           BlockAction("Cut")

      CASE EventArray["MenuTag"] = "PasteBlock" : 
           BlockAction("Paste")

      CASE EventArray["MenuTag"] = "ReplaceValue" : 
           ReplaceDialog()

      ;-------------------------------------------
      ; GoTo Menu Options
      ;-------------------------------------------
      CASE EventArray["MenuTag"] = "FindStr" : 
           ZOOM

      CASE EventArray["MenuTag"] = "FindNext" : 
           ZOOMNEXT

      CASE EventArray["MenuTag"] = "GoToTop" : 
           CTRLPGUP

      CASE EventArray["MenuTag"] = "GoToEnd" : 
           CTRLPGDN

      ;-------------------------------------------
      ; Common System Menu Options
      ;-------------------------------------------
      CASE EventArray["MenuTag"] = "Max/Res"   : 
           WINMAX 

      ;-------------------------------------------
      ; Quit
      ;-------------------------------------------
      CASE EventArray["MenuTag"] = "Quit/No" : 
           ExitCode = 1

      CASE EventArray["MenuTag"] = "Quit/Yes" : 
           EditorWinClose()
           ExitCode = 2

      OTHERWISE :
           EXECPROC EventArray["MenuTag"]
           ExitCode = 0

   ENDSWITCH 

ENDIF

;-------------------------------------------------
; Wait messages
;-------------------------------------------------
IF ISASSIGNED(EventArray["MESSAGE"]) THEN
   IF EventArray["MESSAGE"] = "CLOSE" THEN
      EditorWinClose()
      ExitCode = 2
   ENDIF
ENDIF      

;-------------------------------------------------
; Key presses
;-------------------------------------------------
IF ISASSIGNED(EventArray["KEYCODE"]) THEN

   SWITCH

      CASE EventArray["KEYCODE"] = -60 OR     ; [F2] - DO_IT!.
              EventArray["KEYCODE"] = -101 OR ; [Ctrl-F8] - WinClose.
              EventArray["KEYCODE"] = -108 OR ; [Alt-F5] - FieldView.
              EventArray["KEYCODE"] = 6 :     ; [Ctrl-F] - FieldView.
            EditorWinClose()
            ExitCode = 2

      CASE EventArray["KEYCODE"] = -67 OR     ; [F9] - EditKey.  
           EventArray["KEYCODE"] = -112 :     ; [Alt+F9] - CoEdit.  
           IF CanEdit <> False THEN
              EditModeOn()                    ; Used here to turn CoEdit.
           ENDIF

      CASE EventArray["KEYCODE"] = -88 :      ; [Shift+F5] - WinMax.
           IF DocType = "MEMO" OR DocType = "HELP" THEN
              Exitcode = 0
           ELSE
              BEEP 
           ENDIF      
       
      CASE EventArray["KEYCODE"] = -98 :      ; [Ctrl+F5] - WinResize.  
           IF DocType = "MEMO" THEN
              Exitcode = 0
           ELSE
              BEEP 
           ENDIF      
                 
      CASE EventArray["KEYCODE"] = 1 :        ; [Ctrl+A] - REPLACE.
           ReplaceDialog()

      CASE EventArray["KeyCode"] = 17 :       ; [Ctrl+Q] - Quit/Yes.
           EditorWinClose()
           ExitCode = 2

      CASE EventArray["KEYCODE"] = -97 :      ; [Ctrl+F4] - WinNext.  
           BEEP 

      CASE EventArray["KEYCODE"] = -30 :      ; [Alt+A] - REPLACENEXT.
           BEEP

      CASE EventArray["KEYCODE"] = -24 :      ; [Alt+O] - DOSBig shell.  
           BEEP 

      CASE EventArray["KEYCODE"] = 15  :      ; [Ctrl+O] - DOS shell.  
           BEEP 

   ENDSWITCH
         
ENDIF

RETURN ExitCode

ENDPROC
WRITELIB LibName EditorHndlrWait
RELEASE PROCS EditorHndlrWait

?? "*"
;=================================================
PROC EditorHndlr(DocType,         ; Document Type - Memo or Report 
                 FormViewActive)  ; FormView active when proc was called.

PRIVATE CanEdit,
        CursorAtWindowRow,
        CycleNumber,
        DocType,
        EventArray,
        EditorWinAttrs,
        NewValue,       ; Used in ReplaceDialog--value to substitute with.
        TargetValue,    ; Used in RaplaceDialog--value to replace.
        MenuItemsState, ; DynArray used to hold current state of menu items.
        TriggerType

SHOWPULLDOWN ENDMENU                        ; Hide current PullDown menu.

DocType = UPPER(DocType)                 

DYNARRAY EditorWinAttrs[]                   ; DynArray to set Editor Window. 
DYNARRAY MenuItemsState[]   

;-------------------------------------------------
; Based on whether the Editor Handler was called for a
;    memo or to preview a report need to set different
;    attributes for its associated window and select
;    the correct pulldown menu.
;--------------------------------------------------
SWITCH
   
   ;-----------------------------------------------
   ; If Editor Handler was called to view a memo in 
   ;    a form determine row location of said field
   ;    and create a small memo window in a location
   ;    that does not overlap it.
   ;-----------------------------------------------
   CASE DocType = "MEMO" OR DocType = "HELP" :
        ECHO OFF                               ; Hide workspace.
        IF NOT ISFIELDVIEW() THEN              ; If not in field view.
           CursorAtWindowRow = ROWNO()    
           EditorWinAttrs["HEIGHT"]       = 10
           EditorWinAttrs["ORIGINCOL"]    = 40
           IF CursorAtWindowRow >= 7 THEN
              EditorWinAttrs["ORIGINROW"] = 2
           ELSE
              EditorWinAttrs["ORIGINROW"] = 12
           ENDIF
           EditorWinAttrs["WIDTH"]        = 38
           KEYPRESS -108                        ; [Alt-F5] - FieldView.  
        ENDIF   
        EditorWinAttrs["TITLE"]           = DocType
        WINDOW SETATTRIBUTES GETWINDOW() FROM EditorWinAttrs           
        MsgPrompt(SYSMODE()+"MEMO")
        MESSAGE ""
        EditorMemoHndlrPullDown()
        ECHO NORMAL

   CASE DocType = "REPORT" :
        ECHO OFF
        EditorWinAttrs["CANRESIZE"]   = False
        EditorWinAttrs["CANMAXIMIZE"] = False
        EditorWinAttrs["CANMOVE"]     = False
        EditorWinAttrs["MAXIMIZED"]   = True
        EditorWinAttrs["TITLE"] = DocType
        WINDOW SETATTRIBUTES GETWINDOW() FROM EditorWinAttrs           
        MsgPrompt("Report")
        MESSAGE ""
        EditorMemoHndlrPullDown()
        MenuItemsState["Max/Res"]     = False
        ECHO NORMAL

ENDSWITCH
   
IF DocType = "HELP" THEN
   CanEdit = False
   MenuItemsState["EditMenu"]        = False
   MenuItemsState["FileIns"]         = False
ELSE
   CanEdit = True
   IF SYSMODE() = "CoEdit" OR DocType = "REPORT" THEN
      MenuItemsState["EditModeOn"]   = False
   ELSE   
      MenuItemsState["CopyBlock"]    = False
      MenuItemsState["CutBlock"]     = False
      MenuItemsState["PasteBlock"]   = False
      MenuItemsState["ReplaceValue"] = False
      MenuItemsState["FileIns"]      = False
   ENDIF
ENDIF      
MenuItemSetStatus(MenuItemsState)

WAIT WORKSPACE
     PROC "EditorHndlrWait"
     KEY  -60,     ; [F2]        - DO_IT!.
         -112,     ; [Alt-F9]    - CoEdit--Used here to turn off CoEdit.
          -67,     ; [F9]        - EditKey--Used here to turn on CoEdit.
            6,     ; [Ctrl+F]    - FieldView.
         -108,     ; [Alt+F5]    - FieldView.   
          -97,     ; [Ctrl+F4]   - WinNext.
          -88,     ; [Shift+F5]  - WinMax.
          -98,     ; [Ctrl+F5]   - WinResize.
            1,     ; [Ctrl+A]    - REPLACE
          -30,     ; [Alt+A]     - REPLACENEXT  
          -24,     ; [Alt+O]     - DOSBig shell.
           15,     ; [Ctrl+O]    - DOS shell.
           17      ; [Ctrl-Q]    - Fast way to quit wait workspace loop.
     MESSAGE "MENUSELECT",    ;  - All pulldown menu selections.
             "CLOSE"
ENDWAIT   
MsgPrompt("")

ENDPROC
WRITELIB LibName EditorHndlr
RELEASE PROCS EditorHndlr
