LibName = "Libs\\DevMenu"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

;===================================================
;    Security Demo Developer Memo Procedures                
;===================================================

? " Working on ", LibName, " *"
;=================================================
PROC DeveloperPopUp()

SHOWPOPUP " Developers Menu " CENTERED

  "Security Demo" :
     "Invoke main menu for Security Demo Application" :
     "SecurityDemo",

  "Help Subsystem" :
     "Maintain Help Category, Subcategory, Item and Text Data":
      SUBMENU
        "Categories" :
           "Help Category maintenance" :
           "HelpCtgyMntc",
        "Subcategories" :
           "Help Subcategory maintenance" :
           "HelpSubcMntc",
        "Items" :
           "Help Item maintenance" :
           "HelpItemMntc"
      ENDSUBMENU,

  "Reports" :
     "Review/add reports and sort sequences to the Reporting Subsystem" :
     "ReportMntc",

  "User Security" :
     "Maintain User Access Rights":
      SUBMENU
        "Users" :
           "Users given access to system when level 1 security is activated" :
           "Users",
        "Form Rights" :
           "Define user access rights to system forms (level 2 security)" :
           "UserFormRights",
        "System Forms" :
           "System forms for which access rights are to be controled" :
           "SystemForms"
      ENDSUBMENU,

   "E~x~it" : 
      "Exit the Developers Menu" : 
       SUBMENU
         "No" : 
            "Do not exit application" : 
            "Exit/No",
         "Yes" : 
            "Exit this application" : 
            "Exit/Yes"
       ENDSUBMENU
     
ENDMENU     
TO MenuItemSel

ENDPROC
WRITELIB LibName DeveloperPopUp     
RELEASE PROCS DeveloperPopUp

?? "*"
;=================================================
PROC Developer()

PRIVATE KeyStateInit,
        KeyPressed, 
        MenuItemSel,
        WinTitle

MESSAGE "One moment..."

DYNARRAY KeyStateInit[]
KeyStateInit["NUM LOCK"]    = False
KeyStateInit["CAPS LOCK"]   = False
KeyStateInit["SCROLL LOCK"] = False
SETKEYBOARDSTATE FROM KeyStateInit

IF NOT ISRUNTIME() THEN
   RELEASE VARS ALL           ; Clear all stray vars from prior session.
   RELEASE PROCS ALL          ; Clear all stray procs from prior session.
   ALTSPACE {Desktop} {Empty} ; Set main mode, revoke passwords, flush buffers
                              ; write changes to disk, and remove locks.
   SHOWPULLDOWN ENDMENU       ; Remove Paradox menu.
   PROMPT ""                  ; Remove Paradox prompt.
   ECHO NORMAL                ; Display the empty desktop.
   ECHO OFF                   ; Turn echo off to freeze the screen display.
ENDIF

WHILE True
   ECHO NORMAL
   ECHO OFF
   AUTOLIB = "Libs\\DevMenu,"  +
             "Libs\\Security," +
             "Libs\\TblHndlr," +
             "Libs\\EdtHndlr," +
             "Libs\\RptProcs," +
             "Libs\\HelpDFN,"  +
             "Libs\\ToolsDFN"
   DYNARRAY GlobalVars[]
   GlobalVars["DebugMode"] = False
   GlobalVars["CanHelp"]   = False
   MESSAGE ""
   DeveloperPopUp()
   GETMENUSELECTION KEYTO KeyPressed TO MenuItemSel
   IF MenuItemSel = "Exit/No" THEN
      LOOP
   ENDIF
   IF MenuItemSel = "Exit/Yes" THEN
      QUITLOOP
   ELSE
      MESSAGE "One moment..."
      
      SWITCH
      
         ;-------------------------------------------
         ; Start demo application.
         ;-------------------------------------------
         CASE MenuItemSel = "SecurityDemo" :
              AUTOLIB = "Libs\\Security"
              IF DIRECTORY() <> SDIR() THEN
                 MESSAGE " Changing Paradox's Working Directory To ", SDIR()
                 SETDIR SDIR()
              ENDIF
              SecurityInit()
              
         ;-------------------------------------------
         ; Pick a help maintenance form.
         ;-------------------------------------------
         CASE MenuItemSel = "HelpCtgyMntc" :
              TblHndlr("Help Categories",
                       "HelpDFN\\", "Hlp_Ctgy", "F", 
                       "NoDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "HelpSubcMntc" :
              TblHndlr("Help Subcategories", 
                       "HelpDFN\\", "Hlp_Ctgy", "1", 
                       "YesDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "HelpItemMntc" :
              TblHndlr("Help Items", 
                       "HelpDFN\\", "Hlp_sctg", "1", 
                       "YesDetail", "YesEdit", "YesReport") 
      
         ;-------------------------------------------
         ; Pick a User/Security maintenance form.
         ;-------------------------------------------
         CASE MenuItemSel = "Users" :
              TblHndlr("System Users",
                       "System\\", "UsrScrty", "F", 
                       "NoDetail", "YesEdit", "NoReport") 
      
         CASE MenuItemSel = "UserFormRights" :
              TblHndlr("User Form Access Rights", 
                       "System\\", "UsrScrty", "1", 
                       "YesDetail", "YesEdit", "NoReport") 
      
         CASE MenuItemSel = "SystemForms" :
              TblHndlr("System Forms", 
                       "System\\", "SysForms", "F", 
                       "NoDetail", "YesEdit", "NoReport") 
      
         ;-------------------------------------------
         ; Pick the Report Options maintenance form.
         ;-------------------------------------------
         CASE MenuItemSel = "ReportMntc" :
              TblHndlr("Report Maintenance",
                       "Reports\\", "Rpt_Ctgy", "F", 
                       "YesDetail", "YesEdit", "NoReport")
      
         CASE MenuItemSel = "Esc" :
              LOOP              
      
         OTHERWISE:
              EXECPROC MenuItemSel

      ENDSWITCH
   ENDIF   
ENDWHILE

MESSAGE "Exiting Developers Menu at your request..."
SysCleanUp()

ENDPROC
WRITELIB LibName Developer     
RELEASE PROCS Developer

