LibName = "Libs\\ToolsDFN"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF

;=================================================
;    General/Tool Procedures for Paradox 4.0    
;=================================================

? " Working on ", LibName, " *"
;=================================================
PROC Security()

PRIVATE CheckName, 
        DisplayWindow,
        i,
        NameOk, 
        SecurityWindow, 
        UserPass,
        ValidPass, 
        WinAttrs
        
MESSAGE "Getting security..."

PASSWORD "DontShowIt"            ; Issue password for Securitys table.

DYNARRAY WinAttrs[]
WinAttrs["HASFRAME"] = False

VIEW "System\\UsrScrty"                   ; View the table.
MOVETO FIELD "User Id"
WINDOW HANDLE IMAGE 1 TO SecurityWindow
WINDOW ECHO SecurityWindow FALSE   ; Don't show the user the Security table.

WINDOW CREATE FLOATING @18,22 
       WIDTH 40 HEIGHT 4 
       ATTRIBUTES WinAttrs
       TO DisplayWindow

PAINTCANVAS BORDER FILL "" 0,0,3,39

MESSAGE ""

FOR i FROM 1 TO 3                ; Allow 3 chances to enter valid password.
   @ 1,5 ?? "Enter user name: "
   MESSAGE ""
   STYLE ATTRIBUTE 31
   ?? "          "
   @ 1,23
   ACCEPT "A8" TO CheckName
   IF RetVal = False THEN        ; If user presses "Esc" key then return
      STYLE                      ; false to calling procedure.
      WINDOW SELECT DisplayWindow
      WINCLOSE
      WINDOW SELECT SecurityWindow
      WINCLOSE
      RESET
      RETURN False               
   ENDIF   
   STYLE
   MOVETO FIELD "User Id"
   LOCATE CheckName              ; Try to find password in table.
   IF RetVal THEN
      NameOk = True              ; Set flag.
      QUITLOOP
   ELSE
      MESSAGE "Can't find name entered, try again or press Esc key to quit"
      NameOk = False
      SLEEP 2500
      MESSAGE ""                 ; Clear message window.
   ENDIF
ENDFOR

IF NameOk THEN
   FOR i FROM 1 TO 3             ; 3 chances to enter valid password.
       @ 2,5 ?? "...and password: "
       STYLE ATTRIBUTE 31
       ?? "          "
       @ 2,23
       CANVAS OFF                ; Hide paswword onscreen.
       ACCEPT "A8" TO UserPass
       IF RetVal = False THEN    ; If user presses "Esc" key then return
          STYLE                  ; false to calling procedure.
          WINDOW SELECT DisplayWindow
          WINCLOSE
          WINDOW SELECT SecurityWindow
          WINCLOSE
          RESET
          RETURN False           
       ENDIF   
       @ 2,22 ?? "          "    ; Clear password before turning canvas on.
       STYLE
       CANVAS ON
          IF [Password] = UserPass THEN   ; Password Ok.
             UNPASSWORD "DontShowIt"      ; Revoke password.
             WINDOW SELECT DisplayWindow
             WINCLOSE
             WINDOW SELECT SecurityWindow
             WINCLOSE
             GlobalVars["UserId"] = CheckName
             RETURN True
             RESET
          ELSE
             BEEP
             MESSAGE "Can't find password entered, " +
                     "try again or press Esc key to quit"
             SLEEP 2500
             MESSAGE ""
          ENDIF
   ENDFOR   
   UNPASSWORD "DontShowIt"
   WINDOW SELECT DisplayWindow
   WINCLOSE
   WINDOW SELECT SecurityWindow
   WINCLOSE
   RESET
   RETURN False
ELSE
   UNPASSWORD "DontShowIt"
   RESET
   WINDOW SELECT DisplayWindow
   WINCLOSE
   WINDOW SELECT SecurityWindow
   WINCLOSE
   RESET
   RETURN False
ENDIF

ENDPROC
WRITELIB LibName Security
RELEASE PROCS Security

?? "*"
;=================================================
PROC MsgPrompt(ForMode)

IF ForMode = "" THEN
   ForMode = SYSMODE()
ENDIF   
ForMode = UPPER(ForMode)

SWITCH 

   CASE ForMode = "MAIN" OR ForMode = "VIEW" : 
        PROMPT "[F10] Menu  " + 
               "[Alt+F5] Open memo                               VIEW "

   CASE ForMode = "COEDIT" : 
        PROMPT "[F10] Menu  " +
               "[Alt+F5] Open memo                               EDIT "

   CASE ForMode = "MAINMEMO" OR ForMode = "VIEWMEMO" : 
        PROMPT "[F10] Menu  " +
               "[Alt+F5] Close memo                              VIEW MEMO"

   CASE ForMode = "COEDITMEMO" : 
        PROMPT "[F10] Menu  " +
               "[Alt+F5] Close memo                              EDIT MEMO"

   CASE ForMode = "REPORT" : 
        PROMPT "[F10] Menu  " +
               "                                                 EDIT REPORT"

   CASE ForMode = "HELP" :
        PROMPT "[F10] Menu  " + 
               "[Alt+F5] Open memo (which contains help text)    HELP       "

   OTHERWISE :
        PROMPT ForMode
        
ENDSWITCH

ENDPROC
WRITELIB LibName MsgPrompt
RELEASE PROCS MsgPrompt

?? "*"
;===========================================================
PROC MsgStd(Msg, Secs, Erase)

MESSAGE Msg

IF (NOT Secs = 0) AND (NOT Secs = "") THEN
   SLEEP Secs * 1000
ENDIF

IF (Erase = "Y") OR (Erase = 1) THEN
   MESSAGE ""
ENDIF

ENDPROC
WRITELIB LibName MsgStd
RELEASE PROCS MsgStd

;=================================================
PROC Dummy()

PRIVATE Dummy, WaitForUser

WINDOW CREATE FLOATING @6,13 HEIGHT 9 WIDTH 56 TO Dummy 
@1,0 ?? FORMAT("W54,AC","This feature is still under development")
@3,0 ?? FORMAT("W54,AC","and can't be used at this point in time.")
@5,0 ?? FORMAT("W54,AC","Contact the system manager for more information.")

MESSAGE "Press any key to continue..."
WaitForUser = GETCHAR()

MESSAGE ""
WINCLOSE

ENDPROC 
WRITELIB LibName Dummy
RELEASE PROCS Dummy

;==================================================
PROC MenuItemSetStatus(MenuItems)

FOREACH Element IN MenuItems
   IF MenuItems[Element] = FALSE THEN
      MENUDISABLE Element
   ELSE
      MENUENABLE Element
   ENDIF      
ENDFOREACH

ENDPROC   
WRITELIB LibName MenuItemSetStatus
RELEASE PROCS MenuItemSetStatus

?? "*"
;=================================================
PROC HelpCall(DoHelpFor, HelpItemKeyValue)

PRIVATE ApplWin, DoHelpFor

MESSAGE "One moment..."

ECHO OFF

DoHelpFor = UPPER(DoHelpFor)
ApplWin   = GETWINDOW()

IF SYSMODE() = "CoEdit" THEN      ; If in CoEdit mode
   TableEditEnd()                 ; then save current changes.
ENDIF   

SWITCH
   CASE DoHelpFor = "HELPUSING" : 
        HelpMainProc("HELP", "USING", "HELP")
   CASE DoHelpFor = "HELPKEYS" : 
        HelpMainProc("HELP", "KEYS", "USAGE")
   CASE DoHelpFor = "HELPFORM" :
        HelpMainProc("APPLICATION", "FORMS", HelpItemKeyVal)     
   CASE DoHelpFor = "HELPSYSTEM" : 
        HelpMainProc("SYSTEM", "OVERVIEW", "INTRO")
   CASE DoHelpFor = "HELPSLIDES" : 
        HelpMainProc("SYSTEM", "SLIDES", "XXX")
ENDSWITCH

MESSAGE ""
EXECPROC GlobalVars["CurrPullDown"]
IF ApplWin <> 0 THEN
   WINDOW SELECT ApplWin
   MsgPrompt("")
ENDIF   

ECHO NORMAL

ENDPROC 
WRITELIB LibName HelpCall
RELEASE PROCS HelpCall

?? "*"
;==========================================================
PROC FileNoExists(FileSpec)

;------------------------------------------
; NOTE: This procedure actually returns the
;       value True if the file dosn't exist 
;       and False if it does.
;------------------------------------------

PRIVATE Choice, DOSCmd, FileCheck
  
FileCheck = ISFILE(FileSpec)
IF FileCheck = False THEN
   RETURN True
ELSE
   SHOWPOPUP " File Specified Exists " CENTERED 
      "Delete old file" : 
         "Delete existing file before creating new file" : 
         "DeleteFile",
      "Specify a different file name" : 
         "Specify a different file name" : 
         "AbortAction"
   ENDMENU TO Choice
   IF Choice = "DeleteFile" THEN
      SHOWPOPUP " Delete Confirmation " CENTERED  
         "No! Don't delete file" : 
            "Do not delete file" : 
            "Confirm/No",
         "Yes delete file" : 
            "Delete existing file" : 
            "Confirm/Yes"
      ENDMENU TO Choice
      IF Choice = "Confirm/Yes" THEN
         DOSCmd = "DEL " + FileSpec
         RUN NOREFRESH DOSCmd
         RETURN True
      ELSE
         RETURN False
      ENDIF
   ELSE
      RETURN False
   ENDIF
ENDIF

ENDPROC
WRITELIB LibName FileNoExists
RELEASE PROCS FileNoExists

?? "*"
;=================================================
PROC IsDir(DirName)

;--------------------------------------------------
; This procedure is used to check directory 
;    specifications given by the user. It returns
;    True if the specification is correct and False
;    if either the syntax of the value given by the
;    user is incorrect or if it doesn't translate 
;    into an actual directory. (On detecting an error
;    it will tell the user what the error was.)
;--------------------------------------------------



PRIVATE DirStatus

DirStatus = DIREXISTS(DirName)

SWITCH

   CASE DirStatus = 1 :                ; Directory exists.
        RETURN True

   CASE DirStatus = 0 :                ; Paradox couldn't find the directory.
        MESSAGE "Directory specified doesn't exist, try again"
        SLEEP 2000
        MESSAGE ""
        RETURN False

   CASE DirStatus = -1 :                ; Detected syntax err in dir spec.
        MESSAGE "Syntax error in directory specification, try again"       
        SLEEP 2000
        MESSAGE ""
        RETURN False

ENDSWITCH

ENDPROC
WRITELIB LibName IsDir
RELEASE PROCS IsDir

?? "*"
;==========================================================
PROC IsPrinterOn()

PRIVATE i
  
IF PRINTERSTATUS() THEN
   RETURN True
ELSE
   MESSAGE "Printer isn't ready, terminating print request"
   SOUND 300 50 SOUND 300 50
   SLEEP 2000
   MESSAGE ""
   RETURN False
ENDIF
  
ENDPROC
WRITELIB LibName IsPrinterOn
RELEASE PROCS IsPrinterOn

?? "*"
;=================================================
PROC RmvBadRecs(Tbl, Fld)

  MsgStd("Removing unwanted data records from table " + tbl + "...", 2.5, 0)
  EDIT Tbl
  MOVETO FIELD Fld
  SCAN
    IF ISBLANK(FieldStr()) THEN
      DEL
    ENDIF
  ENDSCAN
  DO_IT!
  CLEARIMAGE
  MsgStd(" ",0,1)

ENDPROC
WRITELIB LibName RmvBadRecs
RELEASE PROCS RmvBadRecs

;================================================
;     System Menu and Associated Procedures
;================================================

?? "*"
;================================================
PROC TimeUpdate(TriggerType, TagValue, EventValue, ElementValue)
  
  REPAINTDIALOG
  RETURN true
  
ENDPROC
WRITELIB LibName TimeUpdate
RELEASE PROCS TimeUpdate

?? "*"
;==================================================
PROC TimeDisplay()

MESSAGE ""

SHOWDIALOG "Current Time"
  PROC "TimeUpdate" IDLE
  @ 4,26 HEIGHT 11 WIDTH 24
  
  @ 3,6 ?? FORMAT("W10,AC", TIME())
  PAINTCANVAS BORDER FILL CHR(219) 1,5,5,16  ; Place a border around time.
  PAINTCANVAS ATTRIBUTE 15 + 16 2,6,4,15     ; Box interior white on blue.

  PUSHBUTTON @7,6 WIDTH 10
    "~O~k"
    OK
    DEFAULT
    VALUE "Accept"
    TAG "Yes"
    TO ButtonValue

ENDDIALOG

ENDPROC  
WRITELIB LibName TimeDisplay
RELEASE PROCS TimeDisplay

?? "*"
;==================================================
PROC SysInfoProc()

PRIVATE WinAttrs, 
        SysArray, 
        WaitForUser,
        PdoxCntrlMemPoolSize,
        PdoxCodePoolFree,
        PdoxMemLeft,
        DiskSpace,
        PdoxRunTime,
        PdoxVersion

DYNARRAY WinAttrs[]
WinAttrs["TITLE"]     = "System Information"

SYSINFO TO SysArray

SWITCH
  CASE SysArray["LANGUAGE"] = "001" : SysArray["LANGUAGE"] = "English"
  CASE SysArray["LANGUAGE"] = "033" : SysArray["LANGUAGE"] = "French"
  CASE SysArray["LANGUAGE"] = "034" : SysArray["LANGUAGE"] = "Spanish"
  CASE SysArray["LANGUAGE"] = "039" : SysArray["LANGUAGE"] = "Italian"
  CASE SysArray["LANGUAGE"] = "045" : SysArray["LANGUAGE"] = "Danish"
  CASE SysArray["LANGUAGE"] = "046" : SysArray["LANGUAGE"] = "Swedish"
  CASE SysArray["LANGUAGE"] = "049" : SysArray["LANGUAGE"] = "German"
ENDSWITCH

PdoxCodePoolFree       = RMEMLEFT()
PdoxCntrlMemPoolSize   = MEMLEFT()
DiskSpace              = DRIVESPACE(SUBSTR(DIRECTORY(),1,1))

SysArray["PDOXRUNTIME"]      = ISRUNTIME()
SYSARRAY["PDOXVERSION"]      = VERSION()
SysArray["EXTENDED"]         = FORMAT("W12,AR,EC", SysArray["EXTENDED"])
SysArray["EXPANDED"]         = FORMAT("W12,AR,EC", SysArray["EXPANDED"])
SysArray["DISKSPACE"]        = FORMAT("W12,AR,EC",DiskSpace)
SysArray["PDOXCODEPOOLFREE"] = FORMAT("W12,AR,EC",PdoxCodePoolFree)
SysArray["PDOXCNTRLMEMPOOLSIZE"] = FORMAT("W12,AR,EC", PdoxCntrlMemPoolSize)

MESSAGE "" 

SHOWDIALOG "System"
   @2,19 HEIGHT 21 WIDTH 41

   @ 1,2 ?? "Extended memory  =  ", SysArray["EXTENDED"]
   @ 2,2 ?? "Expanded memory  =  ", SysArray["EXPANDED"]
   @ 3,2 ?? "Disk space free  =  ", SysArray["DISKSPACE"]
   @ 4,2 ?? "Code pool free   =  ", SysArray["PDOXCODEPOOLFREE"]
   @ 5,2 ?? "Central mem pool =  ", SysArray["PDOXCNTRLMEMPOOLSIZE"]

   @ 7,2 ?? "Mouse present    =  ", SysArray["MOUSE"]
   @ 8,2 ?? "Language         =  ", SysArray["LANGUAGE"]
   @ 9,2 ?? "Autosave (secs)  =  ", SysArray["AUTOSAVE"]

   @11,2 ?? "Paradox mode     =  ", SysArray["UIMODE"]
   @12,2 ?? "Screen rows/cols =  ", SysArray["SCREENHEIGHT"], "/", 
                                    SysArray["SCREENWIDTH"]
   @13,2 ?? "Paradox runtime  =  ", SysArray["PDOXRUNTIME"]
   @14,2 ?? "Paradox version  =  ", SysArray["PDOXVERSION"]
   @15,2 ?? "Paradox build    =  ", SysArray["BUILD"]

   PUSHBUTTON @17,14 WIDTH 10
     "Ok"
     OK
     DEFAULT
     VALUE "Yes"
     TAG "Accept"
     TO ButtonValue

ENDDIALOG

ENDPROC
WRITELIB LibName SysInfoProc
RELEASE PROCS SysInfoProc


