LibName = "Libs\\Security"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

;=================================================
;           Security Demo Procedures                
;=================================================

? " Working on ", LibName, " *"
;=================================================
PROC AboutDialog()

PRIVATE ButtonValue

MESSAGE ""

SHOWDIALOG "About"
   @4,13 HEIGHT 14 WIDTH 56

   @2,0 ?? FORMAT("W54,AC","S E C U R I T Y    D E M O")
   @4,0 ?? FORMAT("W54,AC","Version 1.1")
   @6,0 ?? FORMAT("W54,AC","Desmond Finbarr Nolan")
   @7,0 ?? FORMAT("W54,AC","120 Jewett Ave., Bridgeport, CT 06606")
   @8,0 ?? FORMAT("W54,AC","Phone: (203) 431-8720  Fax: (203) 431-8165")

   PUSHBUTTON @10,23 WIDTH 10
     "Ok"
     OK
     DEFAULT
     VALUE "Yes"
     TAG "Accept"
     TO ButtonValue

ENDDIALOG

ENDPROC 
WRITELIB LibName AboutDialog
RELEASE PROCS AboutDialog

?? "*"
;=================================================
PROC SecurityEntryBanner()

PRIVATE WinAttrs, BannerScreen

DYNARRAY WinAttrs[]
WinAttrs["HASFRAME"] = False
WinAttrs["ECHO"]     = False

WINDOW CREATE FLOATING 
       @4,13 HEIGHT 12 WIDTH 56 ATTRIBUTES WinAttrs TO BannerScreen 
@ 2,0 ?? FORMAT("W54,AC","\5 \5 \5    S E C U R I T Y    D E M O    \5 \5 \5")
@ 5,0 ?? FORMAT("W54,AC","A Sample Application for Paradox 4.0")
@ 8,0 ?? FORMAT("W54,AC","Desmond Finbarr Nolan")
@ 9,0 ?? FORMAT("W54,AC","120 Jewett Ave., Bridgeport, CT 06606")
@10,0 ?? FORMAT("W54,AC","Phone: (203) 431-8720  Fax: (203) 431-8165")
WINDOW ECHO BannerScreen TRUE

RETURN BannerScreen

ENDPROC 
WRITELIB LibName SecurityEntryBanner
RELEASE PROCS SecurityEntryBanner

?? "*"
;=================================================
PROC SecurityMainMenuBanner()

PRIVATE WinAttrs, BannerScreen

DYNARRAY WinAttrs[]
WinAttrs["HASFRAME"] = False
WinAttrs["ECHO"]     = False

WINDOW CREATE FLOATING 
       @6,13 HEIGHT 12 WIDTH 56 ATTRIBUTES WinAttrs TO BannerScreen 
@2,0 ?? FORMAT("W54,AC","\5 \5 \5    M A I N    M E N U    \5 \5 \5")
@4,0 ?? FORMAT("W54,AC","for")
@6,0 ?? FORMAT("W54,AC","S E C U R I T Y    D E M O")
@9,0 ?? FORMAT("W54,AC","(A Sample Application for Paradox 4.0)")
WINDOW ECHO BannerScreen TRUE

RETURN BannerScreen

ENDPROC 
WRITELIB LibName SecurityMainMenuBanner
RELEASE PROCS SecurityMainMenuBanner

?? "*"
;==================================================
PROC SysCleanUp()

IF NOT ISRUNTIME() THEN
   ECHO OFF                   ; Turn Echo off while clearing desktop.
   SHOWPULLDOWN ENDMENU       ; Hide current PullDown Menu.
   RELEASE VARS ALL           ; Clear all stray vars from this session.
   RELEASE PROCS ALL          ; Clear all stray procs from this session.
   ALTSPACE {Desktop} {Empty} ; Set main mode, revoke passwords, flush buffers
                              ; write changes to disk, and remove locks.
   SETCANVAS DEFAULT          ; Set full screen canvas as default.
   CLEARALL                   ; Remove any stray images.
   PROMPT ""                  ; Remove last prompt.
   ECHO NORMAL                ; Display the empty desktop.
ENDIF

ENDPROC 
WRITELIB LibName SysCleanUp
RELEASE PROCS SysCleanUp

?? "*"
;==================================================
PROC SecurityPullDown()

SHOWPULLDOWN
  "" : 
     "Common system menu" : 
     "SysMenu"
      SUBMENU
        "Max/Res [Shift+F5]" :
           "Maximize the current memo window (or restore its original size)" :
           "Max/Res",
         SEPARATOR,  
        "Time" :
           "Display the current time" :
           "TimeDisplay",
         SEPARATOR,            
        "About" : 
           "About Application" : 
           "AboutDialog",
        "System" : 
           "Show system information" : 
           "SysInfoProc"
      ENDSUBMENU,

   "BaseFiles"     : 
      "View and maintain common (base) application reference files" : 
       SUBMENU
         "Facilities"  : 
            "Facility maintenance" : 
            "FcltsMntc",
         "Facility ~A~reas" : 
            "Facility/Area list maintenance" :
            "FAreasMntc",
         "Facility ~T~ypes" : 
            "Facility Type list maintenance" : 
            "FTypesMntc",
          SEPARATOR,
         "Personnel"  : 
            "Personnel maintenance" : 
            "PrsnlMntc",
         "Personnel ~C~lass"  : 
            "Personnel Classification list maintenance" : 
            "PClassMntc",
         "Departments" : 
            "Department list maintenance" :
            "DeptsMntc"
       ENDSUBMENU,

   "Access" : 
      "Access control verification and tracking" : 
       SUBMENU
         "Access ~L~ogs" :
            "Maintain access logs" :
            "ALogsMntc",
          SEPARATOR,
         "Closed Logs" :
            "View closed logs" :
            "ALogsClsd", 
         "Transfer Logs" :
            "Close open logs by tranferring entries to the closed logs file" :
            "AccessLogsTransfer"
       ENDSUBMENU,

   "Property" : 
      "Property control and tracking maintenance" : 
       SUBMENU
         "Property ~L~ogs" :
            "Property information and installation/removal log maintenance" :
            "PropertyLogs",
          SEPARATOR,   
         "Property" :
            "Property information maintenance" :
            "Property",
         "Property ~T~ypes" :
            "Property Type maintenance" :
            "PropertyTypes"    
       ENDSUBMENU,

   "Keys" : 
      "Key control and distribution maintenance" : 
       SUBMENU
         "Key ~L~ogs" :
            "Key information and distribution log maintenance" :
            "KeyLogs",
          SEPARATOR,   
         "Keys" :
            "Key information maintenance" :
            "Keys",
         "Key ~T~ypes" :
            "Key Type maintenance" :
            "KeyTypes"    
       ENDSUBMENU,
     
   "Lost&Found" : 
      "Lost and Found Item receipt and distribution tracking" : 
       SUBMENU
         "Items" :
            "Maintain detail Lost and Found Item data" :
            "Lst&FndMntc",
         "Item ~L~isting" :
            "Review/update listing for Lost and Found Items" :
            "Lst&FndList"
       ENDSUBMENU,

   "Help"     : 
      "Help Subsystem" :  
       SUBMENU
         "Using Help" : 
            "How to use the online context-sensitive help subsystem" : 
            "HelpUsing",
         "Keys/Mouse" : 
            "How to optimally use the keyboard and the mouse" : 
            "HelpKeys",
          SEPARATOR,  
         "System" : 
            "Review help text that provides an overview of this demo system" :
            "HelpSystem",
         "O/H Slides" : 
            "Review overhead 'slides' for the Paradox Fairfield User Group" :
            "HelpSlides"
       ENDSUBMENU,
     
   "E~x~it" : 
      "Exit the system" : 
      "Exit"
       SUBMENU
         "No" : 
            "Do not exit application" : 
            "Exit/No",
         "Yes" : 
            "Exit this application" : 
            "Exit/Yes"
       ENDSUBMENU

ENDMENU 

ENDPROC
WRITELIB LibName SecurityPullDown
RELEASE PROCS SecurityPullDown

?? "*"
;=================================================
PROC SecurityInit()

PRIVATE BannerScreen, 
        GlobalVars,
        KeyPressed,
        KeyStateInit, 
        MenuItemSel,
        WinTitle

DYNARRAY KeyStateInit[]
KeyStateInit["NUM LOCK"]    = False
KeyStateInit["CAPS LOCK"]   = False
KeyStateInit["SCROLL LOCK"] = False
SETKEYBOARDSTATE FROM KeyStateInit

IF NOT ISRUNTIME() THEN
   RELEASE VARS ALL           ; Clear all stray vars from prior session.
   RELEASE PROCS ALL          ; Clear all stray procs from prior session.
   ALTSPACE {Desktop} {Empty} ; Set main mode, revoke passwords, flush buffers
                              ; write changes to disk, and remove locks.
   SHOWPULLDOWN ENDMENU       ; Remove Paradox menu.
   PROMPT ""                  ; Remove Paradox prompt.
   ECHO NORMAL                ; Display the empty desktop.
   ECHO OFF                   ; Turn echo off to freeze the screen display.
ENDIF

AUTOLIB = "Libs\\Security," +
          "Libs\\TblHndlr," +
          "Libs\\EdtHndlr," +
          "Libs\\RptProcs," +
          "Libs\\HelpDFN,"  +
          "Libs\\ToolsDFN"

DYNARRAY GlobalVars[]
GlobalVars["CurrPullDown"]     = "SecurityPullDown"
GlobalVars["DebugMode"]        = False
GlobalVars["CanHelp"]          = True
GlobalVars["PasswordSecurity"] = False  ; Level one security.
GlobalVars["FormSecurity"]     = False  ; Level two security.

;--------------------------------------------------
; Set GlobalVars["PasswordSecurity"] to True/False to implement/ 
;    deimplement password security. Procedure "CheckPass" in 
;    ToolsDFN.SC is used to implement actual security. Also find
;    password to Security.DB table in that file. 
;--------------------------------------------------
IF GlobalVars["PasswordSecurity"] THEN   ; If System Access Security is on.
   BannerScreen = SecurityEntryBanner() 
   IF NOT Security() THEN        ; If user doesn't have System Access Rights.
      PROMPT ""
      SysCleanUp()
      WINDOW SELECT BannerScreen
      WINDOW CLOSE
      RETURN                     ; Exit system if security check failed.
   ELSE                          ; If the user does have System Access Rights.
      WINDOW SELECT BannerScreen
      WINDOW CLOSE
      BannerScreen = SecurityMainMenuBanner() 
   ENDIF   
ELSE
   BannerScreen = SecurityMainMenuBanner() 
ENDIF

WHILE True
   ECHO OFF
   EXECPROC GlobalVars["CurrPullDown"]
   MENUDISABLE "Max/Res"
   MESSAGE ""
   GETMENUSELECTION KEYTO KeyPressed TO MenuItemSel
   IF MenuItemSel = "Exit/No" THEN
      LOOP
   ENDIF
   IF MenuItemSel = "Exit/Yes" THEN
      QUITLOOP
   ELSE
      MESSAGE "One moment..."
      WINDOW SELECT BannerScreen
      WINDOW CLOSE
      
      SWITCH
      
         CASE MenuItemSel = "HelpUsing" OR 
                 MenuItemSel = "HelpSystem" OR
                 MenuItemSel = "HelpKeys" OR
                 MenuItemSel = "HelpSlides" :
              HelpCall(MenuItemSel, "")
      
         CASE MenuItemSel = "FAreasMntc" :
              TblHndlr("Facility Areas",
                       "Fclts\\", "FAreas", "F", 
                       "NoDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "FTypesMntc" :
              TblHndlr("Facility Types", 
                       "Fclts\\", "FTypes", "F", 
                       "NoDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "FcltsMntc" :
              TblHndlr("Facilities", 
                       "Fclts\\", "Fclts", "F", 
                       "NoDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "PrsnlMntc" :
              TblHndlr("Personnel",
                       "Prsnl\\", "Prsnl", "F", 
                       "NoDetail", "YesEdit", "YesReport")
      
         CASE MenuItemSel = "PClassMntc" :
              TblHndlr("Personnel Classifications",
                       "Prsnl\\", "PClass", "F", 
                       "NoDetail", "YesEdit", "YesReport") 
      
         CASE MenuItemSel = "DeptsMntc" :
              TblHndlr("Personnel Departments",
                       "Prsnl\\", "Depts", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "ALogsMntc" :    
              TblHndlr("Access Logs",
                       "Accss\\", "ADates", "F", 
                       "YesDetail", "YesEdit", "NoReport") 

         CASE MenuItemSel = "ALogsClsd" :    
              TblHndlr("Closed Access Logs",
                       "Accss\\", "CDates", "F", 
                       "YesDetail", "NoEdit", "YesReport") 
      
         CASE MenuItemSel = "PropertyLogs" :
              TblHndlr("Property Logs",
                       "Prty\\", "Prty", "1", 
                       "YesDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "Property" :
              TblHndlr("Property",
                       "Prty\\", "Prty", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "PropertyTypes" :
              TblHndlr("Property Types",
                       "Prty\\", "PTypes", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "KeyLogs" :
              TblHndlr("Key Logs",
                       "Keys\\", "Keys", "1", 
                       "YesDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "Keys" :
              TblHndlr("Keys",
                       "Keys\\", "Keys", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "KeyTypes" :
              TblHndlr("Key Types",
                       "Keys\\", "KTypes", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "Lst&FndMntc" :    
              TblHndlr("Lost and Found",         
                       "Lst&Fnd\\", "Lst&Fnd", "F", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "Lst&FndList" :    
              TblHndlr("Lost and Found",
                       "Lst&Fnd\\", "Lst&Fnd", "1", 
                       "NoDetail", "YesEdit", "YesReport") 

         CASE MenuItemSel = "Esc" :
              MESSAGE "One moment..."
              BannerScreen = SecurityMainMenuBanner()
              LOOP              
      
         OTHERWISE:
              EXECPROC MenuItemSel

      ENDSWITCH
   ENDIF   
BannerScreen = SecurityMainMenuBanner()
ENDWHILE

MESSAGE "Exiting Demo..."
WINDOW SELECT BannerScreen
WINDOW CLOSE
SysCleanUp()

ENDPROC
WRITELIB LibName SecurityInit     
RELEASE PROCS SecurityInit

