LibName = "Libs\\HelpDFN"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

? " Working on ", LibName, " *"
;=================================================
PROC HelpCategory()

HelpLevel = "Category"                 ; Declare active level of help subsys.

IF ISASSIGNED(HelpWH["CatTableWH"]) AND
      ISWINDOW(HelpWH["CatTableWH"]) THEN
   WINDOW SELECT HelpWH["CatTableWH"]
ELSE   
   VIEW "HelpDFN\\Hlp_Ctgy"
   HelpWH["CatTableWH"] = GETWINDOW()
   WINDOW SETATTRIBUTES HelpWH["CatTableWH"] FROM HelpWinAttrs
ENDIF
MOVETO FIELD "Category Id"
LOCATE HelpKeys["CatId"]

PICKFORM "3"
WINDOW SETATTRIBUTES GETWINDOW() FROM HelpWinAttrs
MOVETO FIELD "Category Short Descr"

ENDPROC 
WRITELIB LibName HelpCategory
RELEASE PROCS HelpCategory

?? "*"
;=================================================
PROC HelpSubcategory()

IF HelpLevel = "Category" THEN 
   HelpKeys["CatId"] = [Category Id]   
ENDIF   
HelpLevel = "Subcategory"

IF ISASSIGNED(HelpWH["CatTableWH"]) AND
      ISWINDOW(HelpWH["CatTableWH"]) THEN
   WINDOW SELECT HelpWH["CatTableWH"]
ELSE   
   VIEW "HelpDFN\\Hlp_Ctgy"
   HelpWH["CatTableWH"] = GETWINDOW()
   WINDOW SETATTRIBUTES HelpWH["CatTableWH"] FROM HelpWinAttrs
ENDIF

PICKFORM "4"
WINDOW SETATTRIBUTES GETWINDOW() FROM HelpWinAttrs
LOCATE HelpKeys["CatId"]
MOVETO "HelpDFN\\Hlp_SCtg"
LOCATE NEXT HelpKeys["CatId"], HelpKeys["SubId"]
MOVETO FIELD "Subcategory Short Descr"

ENDPROC 
WRITELIB LibName HelpSubcategory
RELEASE PROCS HelpSubcategory

?? "*"
;=================================================
PROC HelpItem()

IF HelpLevel = "Subcategory" THEN 
   HelpKeys["SubId"] = [HelpDFN\Hlp_Sctg -> Subcategory Id]   
ENDIF   
HelpLevel = "Item"

IF ISASSIGNED(HelpWH["SubTableWH"]) AND
      ISWINDOW(HelpWH["SubTableWH"]) THEN
   WINDOW SELECT HelpWH["SubTableWH"]
ELSE   
   VIEW "HelpDFN\\Hlp_SCtg"
   HelpWH["SubTableWH"] = GETWINDOW()
   WINDOW SETATTRIBUTES HelpWH["SubTableWH"] FROM HelpWinAttrs
ENDIF

PICKFORM "4"
WINDOW SETATTRIBUTES GETWINDOW() FROM HelpWinAttrs
LOCATE HelpKeys["CatId"], HelpKeys["SubId"]
MOVETO "HelpDFN\\Hlp_Item"
LOCATE NEXT HelpKeys["CatId"], HelpKeys["SubId"], HelpKeys["ItemId"]
MOVETO FIELD "Memo"

ENDPROC 
WRITELIB LibName HelpItem
RELEASE PROCS HelpItem

?? "*"
;==================================================
PROC HelpMemoClose()

IF FIELD() = "Memo" AND ISFIELDVIEW() THEN   ; Allow if in memo win.
   PROMPT ""   
   WINCLOSE
   MsgPrompt("HELP")
   RETURN 1
ELSE 
   MsgPrompt("HELP")
   RETURN 0   
ENDIF

ENDPROC
WRITELIB LibName HelpMemoClose
RELEASE PROCS HelpMemoClose

?? "*"
;==================================================
PROC HelpMemoOpen()

EditorHndlr("Help","")
MsgPrompt("HELP")
HelpPullDown()
MENUDISABLE "Max/Res"
MESSAGE ""
RETURN 1

ENDPROC
WRITELIB LibName HelpMemoOpen
RELEASE PROCS HelpMemoOpen

?? "*"
;==========================================================
PROC HelpPullDown()

SHOWPULLDOWN

  "" : 
     "Common system menu" : 
     "SysMenu"
      SUBMENU
        "Max/Res [Shift+F5]" :
           "Maximize the current window (or restore its original size)" :
           "Max/Res",
         SEPARATOR,  
        "Time" :
           "Display the current time" :
           "TimeDisplay",
         SEPARATOR,            
        "About" : 
           "About Application" : 
           "AboutDialog",
        "System" : 
           "Show system information" : 
           "SysInfoProc"
      ENDSUBMENU,

   "Categories" :
      "View the categories under which help data is organized" :
      "HelpCategory",

   "Subcategories" :
      "View the subcategories under which help data is organized" :
      "HelpSubcategory",

   "Items" :
      "View the actual help item entries" :
      "HelpItem",

   "Memo" :
      "View help memo/text for current help item" :
      "HelpMemoOpen",

   "Quit" : 
      "Quit help subsystem and return to what you were previously doing" : 
      "Quit"

          SUBMENU
         "No" : 
            "Do not quit help subsystem" : 
            "Quit/No",
         "Yes [Ctrl+Q]" : 
            "Yes quit help subsystem" : 
            "Quit/Yes"
          ENDSUBMENU

ENDMENU 

ENDPROC
WRITELIB LibName HelpPullDown
RELEASE PROCS HelpPullDown

?? "*"
;==================================================
PROC HelpWaitProc(TriggerType, EventArray, CycleNumber)

PRIVATE ExitCode

;--------------------------------------------------
; RETURN   AFFECT
;____________________________________________________
;  0   -   Process the event and proceed to next 
;          event in trigger cycle.
;  1   -   Deny the current event and break out of 
;          the trigger cycle but not the wait.
;  2   -   Deny the current event and break out of 
;          both the trigger cycle and the wait.

ExitCode = 1

;--------------------------------------------------
; Memu selections
;--------------------------------------------------
IF ISASSIGNED(EventArray["MenuTag"]) THEN

   SWITCH

      CASE EventArray["MenuTag"] = "Quit/Yes" : 
           MESSAGE "One moment..."
           ExitCode = 2     

      CASE EventArray["MenuTag"] = "Quit/No" : 
           MESSAGE "One moment..."

      CASE EventArray["MenuTag"] = "HelpMemoOpen" : 
           MESSAGE "One moment..."
           HelpMemoOpen()
 
      CASE EventArray["MenuTag"] = "HelpCategory" OR
              EventArray["MenuTag"] = "HelpSubcategory" OR
              EventArray["MenuTag"] = "HelpItem" AND NOT
              EventArray["MenuTag"] = "HelpMemoOpen" :
              ECHO OFF
              FORMKEY
           IF EventArray["MenuTag"] = "HelpItem" THEN
              MENUENABLE "HelpMemoOpen"
           ELSE
              MENUDISABLE "HelpMemoOpen"
           ENDIF      
           MESSAGE "One moment..."
           EXECPROC EventArray["MenuTag"] 
           ECHO NORMAL
           MESSAGE ""

        OTHERWISE :
           EXECPROC EventArray["MenuTag"]
 
   ENDSWITCH

ENDIF

;--------------------------------------------------
; Triggers
;--------------------------------------------------
IF TriggerType = "ARRIVEWINDOW" THEN
   IF UPPER(FIELD()) = "MEMO" AND ISFIELDVIEW() THEN
      MESSAGE "One moment..."
      HelpMemoOpen()
   ENDIF
ENDIF

;--------------------------------------------------
; Key presses
;--------------------------------------------------
IF ISASSIGNED(EventArray["KeyCode"]) THEN
 
   SWITCH
 
      ;-------------------------------------------
      ; Perform special processing for these keys.
      ;-------------------------------------------
      CASE EventArray["KeyCode"] = -88 AND     ; [Shift-F5] - Max/Min win.  
           FIELD() = "Memo" :                  ; Allow if on a memo field.
           ExitCode = 0

      CASE EventArray["KeyCode"] = -101 :      ; [Ctrl+F8] - Win close.
           ExitCode = HelpMemoClose()

      CASE EventArray["KeyCode"] = 17 :        ; [Ctrl+Q] - Quit/Yes.
           MESSAGE "One moment..."
           ExitCode = 2     

      ;-------------------------------------------
      ; Deny access to the following keys.
      ;-------------------------------------------
      CASE EventArray["KeyCode"] = -60 :       ; [F2] - DO_IT!.  
           BEEP 

      CASE EventArray["KeyCode"] = -61 :       ; [F3] - UpImage.  
           BEEP 

      CASE EventArray["KeyCode"] = -62 :       ; [F4] - DownImage.  
           BEEP 

      CASE EventArray["KeyCode"] = -97 :       ; [Ctrl+F4] - WinNext.  
           BEEP 

      CASE EventArray["KeyCode"] = -24 :       ; [Alt+O] - DOSBig shell.  
           BEEP 

      CASE EventArray["KeyCode"] = 15  :       ; [Ctrl+O] - DOS shell.  
           BEEP 

  ENDSWITCH  

ENDIF

;--------------------------------------------------
; Paradox messages
;--------------------------------------------------
IF TriggerType = "MESSAGE" THEN

   IF EventArray["MESSAGE"] = "CLOSE" THEN
      RETURN HelpMemoClose()
   ENDIF      

ENDIF


RETURN ExitCode

ENDPROC 
WRITELIB LibName HelpWaitProc
RELEASE PROCS HelpWaitProc

?? "*"
;=================================================
PROC HelpMainProc(CategoryId,SubcategoryId,ItemId)

PRIVATE Element,      ; Counter var--used to loop through dynamic array.
        HelpKeys,     ; DynArray which stores help table key values.
        HelpWH,       ; DynArray which is used to track open help windows.
        HelpLevel,    ; Var used to track active level of help subsystem.
        HelpWinAttrs  ; DynArray used to set def values for help dis windows.

DYNARRAY HelpWH[]

DYNARRAY HelpWinAttrs[]
HelpWinAttrs["CANCLOSE"]    = False
HelpWinAttrs["CANMAXIMIZE"] = False
HelpWinAttrs["CANMOVE"]     = False
HelpWinAttrs["CANRESIZE"]   = False
HelpWinAttrs["HASFRAME"]    = False
HelpWinAttrs["ORIGINROW"]   = 2
HelpWinAttrs["ORIGINCOL"]   = 20
HelpWinAttrs["WIDTH"]       = 43
HelpWinAttrs["HEIGHT"]      = 19
HelpWinAttrs["TITLE"]       = "HELP CONTENTS"

DYNARRAY HelpKeys[]
HelpKeys["CatId"]     =  CategoryId
HelpKeys["SubId"]     =  SubcategoryId
HelpKeys["ItemId"]    =  ItemId

HelpLevel = "Item"

ECHO OFF
HelpItem()
HelpPullDown()
MENUDISABLE "Max/Res"
MsgPrompt("HELP")

MESSAGE ""
ECHO NORMAL
WAIT WORKSPACE                ; The WAIT WORKSPACE cmd turns on echo.
  PROC "HelpWaitProc"
  KEY -88,     ; [Shift+F5]  - Max/Min win.
      -101,    ; [Ctrl-F8]   - Close win.
      -97,     ; [Ctrl+F4]   - WinNext.
      -61,     ; [F3]        - UpImage.
      -62,     ; [F4]        - DownImage.
      -60,     ; [F2]        - DO_IT!.
      -24,     ; [Alt+O]     - DOSBig shell.
      15,      ; [Ctrl+O]    - DOS shell.
      17       ; [Ctrl+Q]    - Fast way to exit workspace wait.    
  MESSAGE "MENUSELECT",   ;   - All menu selection messages.
          "CLOSE"
  TRIGGER "ARRIVEWINDOW" ;   - Arrive window.
ENDWAIT                       ; Echo turned off again
ECHO OFF

MESSAGE "One moment..."
SHOWPULLDOWN ENDMENU
PROMPT ""
ECHO OFF ; Hide desktop changes from user--need to reset ECHO in calling proc.
FORMKEY      
FOREACH Element IN HelpWH
   IF ISWINDOW(HelpWH[Element]) THEN
      WINDOW SELECT HelpWH[Element]
      WINDOW CLOSE
   ENDIF
ENDFOREACH      
MESSAGE ""
            
ENDPROC 
WRITELIB LibName HelpMainProc
RELEASE PROCS HelpMainProc


