LibName = "Libs\\TblHndlr"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

;=================================================
;             Table Handling Procedures          
;=================================================

? " Working on ", LibName, " *"
;=================================================
PROC RecDel()

PRIVATE Choice

IF SYSMODE() = "CoEdit" AND NOT ISFIELDVIEW() THEN ; If in Edit/CoEdit mode
                                                   ; and not in fieldview.
   SHOWPOPUP " Delete Confirmation " CENTERED      ; display a pop-up menu.
      "NO! Don't delete" : "Don't delete current record" : "Confirm/No",
      "Yes delete"       : "Yes delete current record"   : "Confirm/Yes"
   ENDMENU TO Choice
   IF Choice = "Confirm/Yes" THEN
      DEL
      RetVal = 1
   ELSE
      RetVal = 1
   ENDIF
ELSE                                             ; If not in Edit or CoEdit
   RetVal = 0                                    ; press the delete key.
ENDIF   

RETURN RetVal 

ENDPROC
WRITELIB LibName RecDel
RELEASE PROCS RecDel

?? "*"
;================================================
PROC RecPostCheck()

IF RECORDSTATUS("New") = TRUE OR RECORDSTATUS("Modified") THEN
   POSTRECORD NOPOST

   IF RetVal = False THEN
      SOUND 300 50 SOUND 500 50

      SHOWPOPUP " Record Conflict " CENTERED ; Display a popup menu.
        "Modify key data" : 
           "Position cursor so key data can be modified for record" : 
           "ModifyKey",
        "Undo changes" :
           "Undo edit changes made to current record" :   
           "UndoEdit",
        "Delete" : 
           "Delete current record" : 
           "EraseRecord"
      ENDMENU TO Choice

      SWITCH

          CASE Choice = "ModifyKey" :
               CTRLHOME                       ; Move to first field.
               RETURN 1

          CASE Choice = "UndoEdit" :
               UNDO                           ; Undo recent edits.
               RETURN 1

          CASE Choice = "EraseRecord" :
               RecDel()                  ; Delete confirmation.
               RETURN 1

      ENDSWITCH

   ELSE
      RETURN 0      
   ENDIF

ELSE
   RETURN 0   
ENDIF

RETURN 1

ENDPROC
WRITELIB LibName RecPostCheck
RELEASE PROCS RecPostCheck

?? "*"
;================================================
PROC TableHelpCall(HelpItemKeyVal)

PRIVATE DummyWindowDA,
        DummyWindowWH,
        Result,
        WinAttrsTmp
        
;--------------------------------------------------
; If user is currently in CoEdit (Edit) Mode switch
; back to Main (View) Mode to reduce risk of data 
; corruption.
;--------------------------------------------------
IF SYSMODE() = "CoEdit" THEN
   ECHO OFF
   Result = TableEditEnd()
   IF Result = 1 THEN
      RETURN 1
   ELSE
      ;--------------------------------------------------
      ; If table is empty the form is going to disappear thus
      ; a dummy blank form will be displayed on the desktop.
      ;--------------------------------------------------
      IF ISEMPTY(TABLE()) THEN
         DYNARRAY DummyWindowDA[]
         DummyWindowDA["CANMAXIMIZE"] = False       ; Hide max/res icons to
         DummyWindowDA["CANCLOSE"]    = False       ; maintain look of win.
         DummyWindowDA["FLOATING"]    = False       ; Set it below ECHO layer.
         DummyWindowDA["MAXIMIZED"]   = True        ; Maximize window.
         DummyWindowDA["TITLE"]       = EntityTitle ; Use curr entity title.
         WINDOW CREATE ATTRIBUTES DummyWindowDA To DummyWindowWH
         SOUND 300 50 SOUND 300 50
         MESSAGE "Current Form will be removed temporarily as table is empty"
         SLEEP 3000
         MESSAGE ""
      ENDIF
   ENDIF   
   ECHO NORMAL
ENDIF      

Result = 0
IF ISFORMVIEW() THEN 
   WINDOW GETATTRIBUTES TblWinHandle TO WinAttrsTmp
   WINDOW MOVE TblWinHandle TO 1,80
   HelpCall(EventArray["MENUTAG"], HelpItemKeyVal)
   WINDOW SETATTRIBUTES TblWinHandle FROM WinAttrsTmp
ELSE
   HelpCall(EventArray["MENUTAG"], HelpItemKeyVal)
ENDIF   

;--------------------------------------------------
; If DummyWindowWH is assigned it indicates that help
; was called in conjunction with an empty table. Thus
; we must invoke CoEdit (Edit) Mode before using 
; FORMKEY to restore the form for the user.
;--------------------------------------------------
IF ISASSIGNED(DummyWindowWH) THEN
   ECHO OFF                       ; Hide desktop changes from user.
   WINDOW SELECT DummyWindowWH    ; Make dummy window active.
   WINDOW CLOSE                   ; Close it.
   COEDITKEY                      ; Invoke CoEdit (Edit) Mode.
   FORMKEY                        ; Switch back to the entity's form.
ENDIF   

ECHO NORMAL                       ; Show the user the updated work space.

ENDPROC
WRITELIB LibName TableHelpCall
RELEASE PROCS TableHelpCall

?? "*"
;================================================
PROC TableEdit()

PRIVATE WaitForUser

IF SYSMODE() = "CoEdit" THEN
   MESSAGE "Edit mode already active, press any key to continue"
   WaitForUser = GETCHAR()
   MESSAGE ""
   RETURN 1
ELSE
   IF ISFIELDVIEW() THEN
      MESSAGE "Ending Field View before starting Edit Mode"
      SLEEP 1000
      MESSAGE ""
      ENTER
   ENDIF   
   TableMenuItems["EditModeOn"]  = False
   TableMenuItems["EditModeOff"] = True
   TableMenuItems["InsRcrd"]     = IIF(CanIns = "YesIns", True, False)
   TableMenuItems["RecDel"]      = IIF(CanDel = "YesDel", True, False)
   MenuItemSetStatus(TableMenuItems)
   COEDITKEY
   MsgPrompt("")
   RETURN 1
ENDIF   

ENDPROC
WRITELIB LibName TableEdit
RELEASE PROCS TableEdit

?? "*"
;================================================
PROC TableEditEnd()

IF ISFIELDVIEW() THEN
   ENTER
ENDIF

RecPostCheck()
IF RetVal = 1 THEN
   MESSAGE "Edit mode still active"
   SLEEP 1500
   MESSAGE ""
   RETURN 1
ELSE  
   TableMenuItems["EditModeOn"]    = True
   TableMenuItems["EditModeOff"]   = False
   TableMenuItems["InsRcrd"]       = False
   TableMenuItems["RecDel"]        = False
   MenuItemSetStatus(TableMenuItems)
   DO_IT!                                   ; End edit mode.
ENDIF      
MsgPrompt("")

RETURN 0

ENDPROC
WRITELIB LibName TableEditEnd
RELEASE PROCS TableEditEnd

?? "*"
;==================================================
PROC TableNextImage(TblSpec,Frm)

IF ISFORMVIEW() AND ISMULTIFORM(TblSpec,Frm) THEN
   IF ISEMPTY(Dir + Tbl) THEN 
      SOUND 300 50 SOUND 300 50
      MESSAGE "Can't move to next box as table is empty"
      SLEEP 2500
      MESSAGE ""
   ELSE   
      WHILE True
         DOWNIMAGE
         IF LINKTYPE() = "1-M Group" OR     ; If moved to a detail table
               LINKTYPE() = "None" THEN     ; or to the master table then
            QUITLOOP                        ; quit loop.
            RETURN 
         ELSE
            LOOP
         ENDIF      
      ENDWHILE   
   ENDIF   
ELSE
   BEEP 
   RETURN
ENDIF   

ENDPROC 
WRITELIB LibName TableNextImage
RELEASE PROCS TableNextImage

?? "*"
;==================================================
PROC FrmWinAttrs()

PRIVATE StdWinAttrs

;--------------------------------------------------
; Set attributes of window to be displayed to user.
;--------------------------------------------------
IF NOT ISASSIGNED(StdWinAttrs) THEN
   DYNARRAY StdWinAttrs[]                     
   StdWinAttrs["CANCLOSE"]    = False         
   StdWinAttrs["CANMOVE"]     = False        
   StdWinAttrs["CANRESIZE"]   = False        
   StdWinAttrs["CANMAXIMIZE"] = False
   StdWinAttrs["HASFRAME"]    = False        
   StdWinAttrs["HASSHADOW"]   = False        
   StdWinAttrs["MAXIMIZED"]   = True
ENDIF

WINDOW SETATTRIBUTES GETWINDOW() FROM StdWinAttrs 

ENDPROC 
WRITELIB LibName FrmWinAttrs
RELEASE PROCS FrmWinAttrs
 
?? "*"
;==================================================
PROC TblHndlrPullDown()

SHOWPULLDOWN
  "" : 
     "Common system menu" : 
     "SysMenu"
      SUBMENU
        "Max/Res [Shift+F5]" :
           "Maximize the current window (or restore its original size)" :
           "Max/Res",
         SEPARATOR,  
        "Time" :
           "Display the current time" :
           "TimeDisplay",
         SEPARATOR,            
        "About" : 
           "About Application" : 
           "AboutDialog",
        "System" : 
           "Show system information" : 
           "SysInfoProc"
      ENDSUBMENU,
     
   "Edit" : 
      "Edit data records of current entity" : 
         "EditMenu"
       SUBMENU
      "Edit Mode ON      [F9]" : 
         "Turn on Edit Mode for the current entity" : 
         "EditModeOn",
      "Edit Mode ~O~FF [Alt-F9]" : 
         "Switch off Edit Mode (switch back to View Mode--Read Only)" : 
         "EditModeOff",
      "Insert New       [Ins]" :
         "Create a new record by inserting one at the current location" :
         "InsRcrd",
      "Delete           [Del]" :
         "Delete the current record" :
         "RecDel"
       ENDSUBMENU,         

   "GoTo" : 
      "Go to a specific data record" : 
       SUBMENU
      "Prev Record  [Ctrl-PgUp]" : 
         "Go to previous record" : 
         "GotoPrevRec",
      "Next Record  [Ctrl-PgDn]" : 
         "Go to next record" : 
         "GotoNextRec",
      "First Record      [Home]" : 
         "Go to the first record of the current entity" :
          "GotoFirstRec",
      "Last Record        [End]" : 
         "Go to the last record for the current entity" : 
         "GotoLastRec",
       SEPARATOR,  
      "Next ~B~ox            [F4]" :
         "Move to the next boxed area on the current entity's form" :
         "GotoNextImg"
       ENDSUBMENU,  
         
   "Report" : 
      "Run standard reports for the current entity" : 
      "RptsForTbl",

   "Help"     : 
      "Help Subsystem" :  
      "HelpMenu"
       SUBMENU
      "Using Help" : 
         "How to use the online context-sensitive Help Subsystem" : 
         "HelpUsing",
      "Keys/Mouse" :
         "Review what functions are performed by key and mouse actions" :
         "HelpKeys",
      "About Form" :
         "Review help text on the current data entry form" :
         "HelpForm",   
       SEPARATOR,        
      "System" : 
         "Review help data that provides an overview of this demo system" :
         "HelpSystem"
       ENDSUBMENU,

   "Quit" : 
      "Quit current operation and return to previous menu" : 
      "Quit"
         SUBMENU
        "No" : 
           "Do not quit current operation" : 
           "Quit/No",
        "Yes [Ctrl+Q]" : 
           "Yes quit current operation" : 
           "Quit/Yes"
         ENDSUBMENU
         
ENDMENU 

IF ISASSIGNED(TableMenuItems) THEN
   MenuItemSetStatus(TableMenuItems)
ENDIF   

ENDPROC
WRITELIB LibName TblHndlrPullDown
RELEASE PROCS TblHndlrPullDown

?? "*" 
;=================================================
PROC TblHndlrWait(TriggerType,EventArray,CycleNumber)

PRIVATE CursorAtWindowRow,
        DebugMode,
        ExitCode, 
        EditorWinAttrs, 
        Result

ExitCode = 1
Result   = 0

;-------------------------------------------------
; Following code used for debugging. It creates a 
; canvas window on the righthand-side of the screen
; where it displays all the values generated by the 
; event for which this wait procedure is called.
;-------------------------------------------------
DebugMode = False  ; Set to True/False to turn On/Off 'debug' mode.
IF DebugMode OR GlobalVars["DebugMode"] THEN
   WINDOW CREATE FLOATING @1,40 HEIGHT 22 WIDTH 36 TO DebugWH
   ? "TriggerType = ", TriggerType
   ? "CycleNumber = ", CycleNumber
   ? ""
   FOREACH Element IN EventArray
      ? Element, " = ", EventArray[Element]
   ENDFOREACH   
   SLEEP 2000
   RELEASE VARS Element, WaitForUser, DebugWH
   WINDOW CLOSE
ENDIF

;-------------------------------------------------
; Wait triggers
;-------------------------------------------------
IF ISASSIGNED(TriggerType) THEN

   SWITCH
   
     CASE TriggerType = "DEPARTROW" :
          IF  SYSMODE() = "CoEdit" AND NOT ISFIELDVIEW() THEN
              ExitCode = RecPostCheck()  
          ELSE
              ExitCode = 0
          ENDIF        

     CASE TriggerType = "ARRIVEWINDOW" :
          IF UPPER(FIELD()) = "MEMO" AND ISFIELDVIEW() THEN
             MESSAGE "One moment..."
             EditorHndlr("Memo","")
             TblHndlrPullDown()
             MESSAGE ""
          ELSE
             ExitCode = 0   
          ENDIF

   ENDSWITCH
   
ENDIF   

;-------------------------------------------------
; Menu selections
;-------------------------------------------------
IF ISASSIGNED(EventArray["MENUTAG"]) THEN

 SWITCH

   CASE EventArray["MENUTAG"] = "EditModeOn" :
        MESSAGE "One moment..."
        ExitCode = TableEdit()
        MESSAGE ""

   CASE EventArray["MENUTAG"] = "EditModeOff" : 
        MESSAGE "One moment..."
        ECHO OFF
        IF SYSMODE() = "CoEdit" THEN
           Result = TableEditEnd()
        ENDIF   
        IF Result = 1 THEN
           ECHO NORMAL
        ELSE
           IF ISEMPTY(TABLE()) THEN
              MESSAGE "Returning to previous level as table is empty"
              SLEEP 2500
              PROMPT ""         ; Change custom prompt to "Null" before 
              ECHO OFF          ; turning echo off or the change won't take.
              CLEARIMAGE
              RETURN 2
          ENDIF   
        ENDIF   
        MESSAGE ""

   CASE EventArray["MENUTAG"] = "InsRcrd" :
        INS
        CTRLHOME
   
   CASE EventArray["MENUTAG"] = "GotoPrevRec" : 
        CTRLPGUP 

   CASE EventArray["MENUTAG"] = "GotoNextRec" : 
        CTRLPGDN 

   CASE EventArray["MENUTAG"] = "GotoFirstRec" : 
        HOME     

   CASE EventArray["MENUTAG"] = "GotoLastRec" : 
        END      

   CASE EventArray["MENUTAG"] = "GotoNextImg" : 
        TableNextImage(Dir + Tbl, Frm) 
        
   CASE EventArray["MENUTAG"] = "RptsForTbl" :     ; Reporting option.
        MESSAGE "Getting reports..."
        IF SYSMODE() = "CoEdit" THEN
           Result = TableEditEnd()
        ENDIF   
        IF Result <> 1 THEN
           ReportSpecsGet(EntityTitle, IIF(ISFORMVIEW(), True, False))
           TblHndlrPullDown()
           MESSAGE ""
        ENDIF  
        MsgPrompt("")

   CASE EventArray["MENUTAG"] = "HelpUsing" OR     ; Help option.
           EventArray["MENUTAG"] = "HelpSystem" OR
           EventArray["MENUTAG"] = "HelpKeys" OR
           EventArray["MenuTag"] = "HelpForm" :
        TableHelpCall(EntityTitle)

   CASE EventArray["MENUTAG"] = "Quit/No" :
        RETURN 1
         
   CASE EventArray["MENUTAG"] = "Quit/Yes" :
        MESSAGE "One moment..."
        ECHO OFF
        IF SYSMODE() = "CoEdit" THEN
           Result = TableEditEnd()
        ENDIF   
        IF Result = 1 THEN
           ECHO NORMAL
        ELSE
           PROMPT ""           ; Change custom prompt to "Null" before 
           ECHO OFF            ; turning echo off or the change won't take.
           CLEARIMAGE
           RETURN 2
        ENDIF   
    
   OTHERWISE : 
        EXECPROC EventArray["MENUTAG"]
        ExitCode = 0

 ENDSWITCH

ENDIF

;-------------------------------------------------
; Key presses
;-------------------------------------------------
IF ISASSIGNED(EventArray["KEYCODE"]) THEN

   SWITCH
      ;--------------------------------------------
      ; Do special processing if the following keys are used.
      ;--------------------------------------------
      CASE EventArray["KEYCODE"] = -67 :        ; [F9] - Edit (CoEdit).
           IF CanEdit = "YesEdit" THEN
              MESSAGE "One moment..."              
              ExitCode = TableEdit()
              MESSAGE ""
           ELSE
              BEEP
           ENDIF   

      CASE EventArray["KEYCODE"] = -112 :        ; [Alt-F9] - CoEdit.
           IF SYSMODE() = "CoEdit" THEN         ; Used to turn OFF CoEdit.
              TableEditEnd()
           ELSE
              BEEP
           ENDIF   

      CASE EventArray["KEYCODE"] = -82 :        ; [Ins] - INS.  
           IF CanIns = "YesIns" THEN      
              INS
              CTRLHOME                          ; Place cursor in first field.
           ELSE
              BEEP
           ENDIF    

      CASE EventArray["KEYCODE"] = -83 :        ; Delete key - [Delete].
           IF CanDel = "YesDel" THEN
              ExitCode = RecDel()
           ELSE   
              BEEP
           ENDIF   
    
      CASE EventArray["KEYCODE"] = -62 OR       ; [F4] - DownImage.  
              EventArray["KEYCODE"] = -61 :     ; [F3] - UpImage.
           IF HasDetail = "YesDetail" THEN   
              TableNextImage(Dir + Tbl, Frm) 
           ELSE
              BEEP
           ENDIF      
           
      CASE EventArray["KeyCode"] = 17 :         ; [Ctrl+Q] - Quit/Yes.
           MESSAGE "One moment..."
           ECHO OFF
           IF SYSMODE() = "CoEdit" THEN
              Result = TableEditEnd()
           ENDIF   
           IF Result = 1 THEN
              ECHO NORMAL
           ELSE
              PROMPT ""           ; Change custom prompt to "Null" before 
              ECHO OFF            ; turning echo off or the change won't take.
              CLEARIMAGE
              RETURN 2
           ENDIF   

      CASE EventArray["KEYCODE"] = -108 :          ; FieldView - [Alt+F5].
           IF UPPER(FIELD()) = "MEMO" THEN
              MESSAGE "One moment..."
              EditorHndlr("Memo","")
              TblHndlrPullDown()
              MESSAGE ""
           ELSE        
              KEYPRESS -108
           ENDIF

      ;-------------------------------------------
      ; Deny access to the following keys.
      ;-------------------------------------------
      CASE EventArray["KEYCODE"] = -60 :           ; [F2] - Do-It!  
           BEEP 

      CASE EventArray["KEYCODE"] = -97 :           ; [Ctrl+F4] - WinNext.  
           BEEP 

      CASE EventArray["KEYCODE"] = -24 :           ; [Alt+O] - DOSBig shell.  
           BEEP 

      CASE EventArray["KEYCODE"] = 15  :           ; [Ctrl+O] - DOS shell.  
           BEEP 

   ENDSWITCH
         
ENDIF

RETURN ExitCode

ENDPROC
WRITELIB LibName TblHndlrWait     
RELEASE PROCS TblHndlrWait

?? "*"
;=================================================
PROC TblHndlrCleanup()

PRIVATE Dummy

SHOWPULLDOWN ENDMENU 
IF ISASSIGNED(GlobalVars["CurrPullDown"]) THEN
   Dummy = GlobalVars["CurrPullDown"]
   GlobalVars["CurrPullDown"] = GlobalVars["LastPullDown"] 
   GlobalVars["LastPullDown"] = Dummy
ENDIF   

ENDPROC
WRITELIB LibName TblHndlrCleanup
RELEASE PROCS TblHndlrCleanup

?? "*"
;=================================================
PROC TblHndlr(EntityTitle, 
              Dir, 
              Tbl,        ; Master table.
              Frm,        ; Selectable Form.
              HasDetail,  ; YesDetail/NoDetail - Form has linked detail table.
              CanEdit, 
              CanReport)

PRIVATE AccessRights,
        CanDel,
        CanIns,
        CanView,
        Dummy,
        NumRecs,
        TblWinHandle,
        TableMenuItems
       
;--------------------------------------------------
; Define Dynamic Arrays to be used in scope of Table
; Handler.
;--------------------------------------------------
DYNARRAY TableMenuItems[]   
DYNARRAY AccessRights[]

;--------------------------------------------------
; Track the name of both previous and current 
; PullDown Menu Procedures.
;--------------------------------------------------
IF ISASSIGNED(GlobalVars["CurrPullDown"]) THEN
   GlobalVars["LastPullDown"] = GlobalVars["CurrPullDown"] 
   GlobalVars["CurrPullDown"] = "TblHndlrPullDown"
ENDIF

;--------------------------------------------------
; Display table/form pulldown menu.
;--------------------------------------------------
TblHndlrPullDown()        

;--------------------------------------------------
; If form security (level two) has been activated 
; in the system's main procedure then get the users
; appropriate form access rights. One must activate
; Access Control (level one) system security before
; trying to use level two security as GlobalVars["UserId"]
; is set during the initial check to see if a user has 
; access rights to the system.
;--------------------------------------------------
IF ISASSIGNED(GlobalVars["PasswordSecurity"]) AND 
      ISASSIGNED(GlobalVars["FormSecurity"]) THEN
   IF GlobalVars["PasswordSecurity"] = True AND 
         GlobalVars["FormSecurity"] = True THEN
      VIEW "System\\FrmScrty"
      MOVETO FIELD "User Id"
      LOCATE GlobalVars["UserId"], EntityTitle    ; Locate users table rights.
      IF RetVal THEN
         CanView = IIF([CanView] = "N", "NoView", "YesView")
         IF CanEdit = "YesEdit" THEN
            CanEdit = IIF([CanEdit] = "N", "NoEdit", "YesEdit")
         ENDIF   
         CanIns = IIF([CanIns] = "N", "NoIns", "YesIns")
         CanDel = IIF([CanDel] = "N", "NoDel", "YesDel")
         IF CanReport = "YesReport" THEN
            CanReport = IIF([CanReport] = "N", "NoReport", "YesReport")
         ENDIF   
      ENDIF   
   CLEARIMAGE      ; Remove table containing user Form Access Rights.
   ENDIF   
ENDIF   

IF NOT ISASSIGNED(CanView) THEN
   CanView = "YesView"
ENDIF
IF NOT ISASSIGNED(CanIns) THEN
   CanIns = "YesIns"
ENDIF
IF NOT ISASSIGNED(CanDel) THEN
   CanDel = "YesDel"
ENDIF

;-------------------------------------------------
; Determine if table Should be placed on workspace 
;    and if so what Paradox mode should be invoked.
;-------------------------------------------------
IF ISASSIGNED(CanView) THEN
   IF CanView = "NoView" THEN
      SOUND 300 50 SOUND 300 50
      MESSAGE "Table can't be viewed without appropriate access rights"
      SLEEP 3000
      TblHndlrCleanup()
      RETURN
   ENDIF   
ENDIF      
   
NumRecs = NRECORDS(Dir + Tbl)

IF NumRecs = 0 THEN
   IF CanEdit <> "YesEdit" THEN
      SOUND 300 50 SOUND 300 50
      MESSAGE "Can't access table as it's empty and Edit isn't allowed"
      SLEEP 3000
      TblHndlrCleanup()
      RETURN
   ELSE
      MESSAGE "No records found entering edit mode"
      COEDIT (Dir + Tbl)
   ENDIF
ELSE
   VIEW (Dir + Tbl)
ENDIF      
TblWinHandle = GETWINDOW()
FrmWinAttrs()
PICKFORM Frm
FrmWinAttrs()
MsgPrompt("")

;-------------------------------------------------
; Initialize state of menu items.
;-------------------------------------------------
TableMenuItems["EditMenu"]       = IIF(CanEdit <> "YesEdit", False, True)
IF SYSMODE() = "CoEdit" THEN
   TableMenuItems["EditModeOn"]  = False
   TableMenuItems["EditModeOff"] = True
   TableMenuItems["InsRcrd"]     = IIF(CanIns <> "YesIns", False, True)
   TableMenuItems["RecDel"]      = IIF(CanDel <> "YesDel", False, True)
ELSE
   TableMenuItems["EditModeOff"] = False
   TableMenuItems["InsRcrd"]     = False   
   TableMenuItems["RecDel"]      = False  
ENDIF
TableMenuItems["GotoNextImg"]    = IIF(HasDetail <> "YesDetail", False, True)
TableMenuItems["RptsForTbl"]     = IIF(CanReport <> "YesReport", False, True)
IF GlobalVars["CanHelp"] = False THEN
   MENUDISABLE "HelpMenu"
ENDIF   
TableMenuItems["Max/Res"]        = False
MenuItemSetStatus(TableMenuItems)

MESSAGE ""


ECHO NORMAL
WAIT WORKSPACE
   PROC "TblHndlrWait"
   TRIGGER "DEPARTROW",   ;  - Trying to leave a row/record.
           "DEPARTTABLE", ;  - Departing a table (set var for TableLookup). 
           "ARRIVEWINDOW" ;  - Arriving at a new window.
   KEY  -83,    ; [Delete]   - Delete.
        -82,    ; [Insert]   - Insert.
       -112,    ; [Alt-F9]   - CoEdit (Called Edit in application).
        -67,    ; [F9]       - Edit.
       -108,    ; [Alt+F5]   - FieldView.
        -88,    ; [Shift-F5] - Window maximize/minimize.
       -101,    ; [Ctrl-F8]  - Close window.
        -97,    ; [Ctrl+F4]  - WinNext.
        -61,    ; [F3]       - UpImage.
        -62,    ; [F4]       - DownImage.
        -60,    ; [F2]       - DO_IT!.
        -24,    ; [Alt+O]    - DOSBig shell.
         15,    ; [Ctrl+O]   - DOS shell.
         17     ; [Ctrl+Q]   - Fast way to quit workspace loop.
   MESSAGE "MENUSELECT"   ;  - All pulldown menu selections.
ENDWAIT   
ECHO OFF

TblHndlrCleanup()

ENDPROC
WRITELIB LibName TblHndlr     
RELEASE PROCS TblHndlr
