LibName = "Libs\\SysMenu"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   

;===================================================
; Security Demo System Administrator Menu Procedures                
;===================================================

? " Working on ", LibName, " *"
;=================================================
PROC SysAdminPopUp()

SHOWPOPUP " SysAdmin Menu " CENTERED

  "Security Demo" :
     "Invoke main menu for Security Demo Application" :
     "SecurityDemo",

  "User Security" :
     "Maintain User Access Rights":
      SUBMENU
        "Users" :
           "Users given access to system when level 1 security is activated" :
           "Users",
        "Form Rights" :
           "Define user access rights to system forms (level 2 security)" :
           "UserFormRights"
      ENDSUBMENU,

   "E~x~it" : 
      "Exit the System Administrators Menu" : 
       SUBMENU
         "No" : 
            "Do not exit application" : 
            "Exit/No",
         "Yes" : 
            "Exit this application" : 
            "Exit/Yes"
       ENDSUBMENU
     
ENDMENU     
TO MenuItemSel

ENDPROC
WRITELIB LibName SysAdminPopUp     
RELEASE PROCS SysAdminPopUp

?? "*"
;=================================================
PROC SysAdmin()

PRIVATE KeyStateInit,
        KeyPressed, 
        MenuItemSel,
        WinTitle

MESSAGE "One moment..."

DYNARRAY KeyStateInit[]
KeyStateInit["NUM LOCK"]    = False
KeyStateInit["CAPS LOCK"]   = False
KeyStateInit["SCROLL LOCK"] = False
SETKEYBOARDSTATE FROM KeyStateInit

IF NOT ISRUNTIME() THEN
   RELEASE VARS ALL           ; Clear all stray vars from prior session.
   RELEASE PROCS ALL          ; Clear all stray procs from prior session.
   ALTSPACE {Desktop} {Empty} ; Set main mode, revoke passwords, flush buffers
                              ; write changes to disk, and remove locks.
   SHOWPULLDOWN ENDMENU       ; Remove Paradox menu.
   PROMPT ""                  ; Remove Paradox prompt.
   ECHO NORMAL                ; Display the empty desktop.
   ECHO OFF                   ; Turn echo off to freeze the screen display.
ENDIF

WHILE True
   ECHO NORMAL
   ECHO OFF
   AUTOLIB = "Libs\\SysMenu,"  +
             "Libs\\Security," +
             "Libs\\TblHndlr," +
             "Libs\\EdtHndlr," +
             "Libs\\RptProcs," +
             "Libs\\HelpDFN,"  +
             "Libs\\ToolsDFN"
   DYNARRAY GlobalVars[]
   GlobalVars["DebugMode"] = False
   GlobalVars["CanHelp"]   = False
   MESSAGE ""
   SysAdminPopUp()
   GETMENUSELECTION KEYTO KeyPressed TO MenuItemSel
   IF MenuItemSel = "Exit/No" THEN
      LOOP
   ENDIF
   IF MenuItemSel = "Exit/Yes" THEN
      QUITLOOP
   ELSE
      MESSAGE "One moment..."
      
      SWITCH
      
         ;-------------------------------------------
         ; Start demo application.
         ;-------------------------------------------
         CASE MenuItemSel = "SecurityDemo" :
              AUTOLIB = "Libs\\Security"
              IF DIRECTORY() <> SDIR() THEN
                 MESSAGE " Changing Paradox's Working Directory To ", SDIR()
                 SETDIR SDIR()
              ENDIF
              SecurityInit()
              
         ;-------------------------------------------
         ; Pick a User/Security maintenance form.
         ;-------------------------------------------
         CASE MenuItemSel = "Users" :
              TblHndlr("System Users",
                       "System\\", "UsrScrty", "F", 
                       "NoDetail", "YesEdit", "NoReport") 
      
         CASE MenuItemSel = "UserFormRights" :
              TblHndlr("User Form Access Rights", 
                       "System\\", "UsrScrty", "1", 
                       "YesDetail", "YesEdit", "NoReport") 
      
         ;-------------------------------------------
         ; Remaining menu options.
         ;-------------------------------------------
         CASE MenuItemSel = "Esc" :
              LOOP              
      
         OTHERWISE:
              EXECPROC MenuItemSel

      ENDSWITCH
   ENDIF   
ENDWHILE

MESSAGE "Exiting System Administrator's Menu at your request..."
SysCleanUp()

ENDPROC
WRITELIB LibName SysAdmin     
RELEASE PROCS SysAdmin

