LibName = "Libs\\RptProcs"

IF NOT ISFILE(LibName+".Lib") THEN
   CREATELIB LibName
ENDIF   

;==================================================
;                 PROCEDURES
;==================================================

? " Working on ", LibName, " *"
;===========================================================
PROC DoSort(TblSpec, ReportId, SortSpec)

;-------------------------------------------------
; This procedure works interactively with the sort screen
;    of the table that is passed to it. It gets the list
;    of fields to sort by from SortSpec and sorts sequentially
;    starting with the first field listed. SortSpec itself
;    uses the "|" as a separator for each field.
;--------------------------------------------------

PRIVATE CharPos,
        DebugMode,
        FieldLoc,
        i,
        n,
        NumFlds,
        SortFields,
        SortFlds,
        StrLen

;--------------------------------------------------
; Following code is used to switch on/off debugging.
;--------------------------------------------------
DebugMode = False
IF DebugMode OR GlobalVars["DebugMode"] THEN
   DEBUG
ENDIF           
          
MESSAGE "Sorting table..."
  
NumFlds = NRECORDS(TblSpec)
ARRAY SortFields[NumFlds]

{Modify} {Sort} SELECT TblSpec SELECT "Answer"
IF MENUCHOICE() = "Cancel" THEN
   {Replace}
ENDIF   
;-------------------------------------------------
; At this point the prgm is in the sort screen. The
;    following code chops up the sort spec and marks
;    the inidvidual fields on which the table is to 
;    be sorted.
;-------------------------------------------------
i = 0                                      ; Init fld sort seq indicator.
WHILE true
   StrLen  = LEN(SortSpec)                 ; Get length of sort string spec.
   CharPos = SEARCH("|", SortSpec)         ; Get pos of the 1st separator.
   i = i + 1                               ; Increment fld sort seq indic.
   IF CharPos > 0 THEN                     ; If pos separator was found.
      SortFlds = SUBSTR(SortSpec, 1, CharPos - 1) ; Extract curr sort field.
      SortSpec = SUBSTR(SortSpec, CharPos + 1, StrLen) ; Reduce sort spec.
      CTRLHOME                              ; Move to 1st fld in sort scrn.
      FieldLoc = FIELDNO(SortFlds, TblSpec) ; Calc loc of fld in sort scrn.
      n = 1
      WHILE n < FieldLoc                    ; Move to loc of fld.
         DOWN
         n = n + 1
      ENDWHILE
      TYPEIN i                              ; Type in sort seq number.
      LOOP
   ELSE                                     ; No pos separator found.
      SortFlds = SortSpec                   ; See code above to understand
      CTRLHOME                              ; the workings of code below.
      FieldLoc = FIELDNO(SortFlds, TblSpec)
      n = 1
      WHILE n < FieldLoc
         DOWN
         n = n + 1
      ENDWHILE
      TYPEIN i
      QUITLOOP
   ENDIF
ENDWHILE
DO_IT!                                      ; Perform the specified sort.

IF ReportId <> "" THEN
   COPYREPORT TblSpec ReportId "Answer" ReportId
ENDIF
  
MESSAGE ""
  
ENDPROC
WRITELIB LibName DoSort
RELEASE PROCS DoSort

?? "*"
;==========================================================
PROC ReportExec(DevSel, 
                TblSpec, 
                ReportId, 
                FileSpec, 
                Sortedby, 
                FormViewActive)

PRIVATE DOSCmd

SWITCH
    
   ;------------------------------------------------
   ; Ouput report to the screen.
   ;------------------------------------------------
   CASE DevSel = 1 :  ; Screen.
        MESSAGE "Generating requested report..."
        IF ISFILE("TempFile.Rpt") THEN
           DOSCmd = "DEL TempFile.Rpt"
           RUN NOREFRESH DOSCmd
        ENDIF
        MENU {Report} {Output} SELECT TblSpec SELECT ReportId {File}
             {TempFile.Rpt}
        EDITOR OPEN "TempFile.Rpt"
        EditorHndlr("Report", FormViewActive)
        
   ;------------------------------------------------
   ; Ouput report to the file.
   ;------------------------------------------------
   CASE DevSel = 2 :  ; File.
        MESSAGE "Generating requested report..."
        ECHO OFF
        MENU {Report} {Output} SELECT TblSpec SELECT ReportId {File}
             SELECT FileSpec
        IF TABLE() = "Answer" THEN
           CLEARIMAGE
        ENDIF   
        IF FormViewActive THEN
           FORMKEY
        ENDIF   
        ECHO NORMAL
        MESSAGE "Finished report..."
        SLEEP 500
        MESSAGE ""

   ;------------------------------------------------
   ; Ouput report to the printer.
   ;------------------------------------------------
   CASE DevSel = 3 : ; Printer.
        MESSAGE "Sending report to printer..."
        ECHO OFF
        IF IsPrinterOn() THEN
           MENU {Report} {Output} SELECT TblSpec SELECT ReportId {Printer}
        ENDIF
        IF TABLE() = "Answer" THEN
           CLEARIMAGE
        ENDIF   
        IF FormViewActive THEN
           FORMKEY
        ENDIF   
        ECHO NORMAL
        MESSAGE "Finished report..."
        SLEEP 500
        MESSAGE ""
        
ENDSWITCH
    
ENDPROC
WRITELIB LibName ReportExec
RELEASE PROCS ReportExec

?? "*"
;==================================================
PROC ReportDialogWait(TriggerType,TagValue,EventValue,ElementValue)

PRIVATE DirStatus, FileStatus

;--------------------------------------------------
; User modified Direcotur Name Specification. Thus we 
;    need to check the validity of the specification.
;--------------------------------------------------
IF TriggerType = "UPDATE" AND TagValue = "DirName" THEN
   REFRESHDIALOG
   IF EventValue <> DefDirName THEN
      DirStatus = IsDir(EventValue)
      IF DirStatus = False THEN
         SELECTCONTROL "DirTag"
      ENDIF   
      RETURN DirStatus
   ENDIF   
ENDIF

;--------------------------------------------------
; User selected Ok push button. Need to do some final
;    checks before exiting dialog and doing report.
;--------------------------------------------------
IF TriggerType = "UPDATE" AND TagValue = "ACCEPT" THEN

   ;-----------------------------------------------
   ; If selected ouput device is File check to see 
   ;    that it does not already exist.
   ;-----------------------------------------------
   IF DevSel = 2 THEN   ; File.
      REFRESHDIALOG
      IF SUBSTR(DirName, LEN(DirName), 1) <> "\\" THEN
         DirName = DirName + "\\"
      ENDIF   
      IF EventValue <> DefDirName THEN
         DirStatus = IsDir(DirName)
         IF DirStatus = False THEN
            SELECTCONTROL "DirTag"
            RETURN False
         ENDIF   
      ENDIF   
      IF FileName = "" THEN
         MESSAGE "File Name field is blank, enter a value or select Cancel"
         SLEEP 2500
         MESSAGE "" 
         SELECTCONTROL "FileTag"
         RETURN False
      ENDIF
      FileStatus = FileNoExists(DirName + FileName + "." + FileExt)
      IF FileStatus = False THEN
         SELECTCONTROL "FileTag"
         RETURN False
      ENDIF
   ENDIF
   
   ;------------------------------------------------
   ; See if a Sort needs to be performed based on
   ;    users selection.
   ;------------------------------------------------
   IF UPPER(SortChoice) <> UPPER(DefSortChoice) THEN  
      DoSort(MFDirName + Tbl, RptFrms[ReportChoice], Sorts[SortChoice])
      TblSpec = "Answer"
   ENDIF   

   ;-----------------------------------------------
   ; If selected ouput device is Printer check to see 
   ;    that it is ready.
   ;-----------------------------------------------
   IF DevSel = 3 THEN   ; Printer.
      RETURN IIF(IsPrinterOn(),True,False)
   ENDIF
   
ENDIF
            
ENDPROC
WRITELIB LibName ReportDialogWait
RELEASE PROCS ReportDialogWait

?? "*"
;==================================================
PROC ReportDialog(RptCtgy, DirName)

PRIVATE ButtonValue

MESSAGE ""

SHOWDIALOG RptCtgy
   PROC "ReportDialogWait"
   TRIGGER "UPDATE"
   @5,9 HEIGHT 15 WIDTH 63

   ;-------------------------------------------------
   ; Report selection.
   ;-------------------------------------------------
   FRAME SINGLE FROM 1,1 TO 6,29

   LABEL @1,10
      "~R~eport "
      FOR "ReportChoice"
   
   PICKDYNARRAYINDEX
      @2,2 HEIGHT 4 WIDTH 27
      COLUMNS 1
      Reports
      TAG "ReportChoice"
      TO ReportChoice

   ;-------------------------------------------------
   ; Report sort order selection.
   ;-------------------------------------------------
   FRAME SINGLE FROM 1,31 TO 6,59

   LABEL @1,40
      "~S~ort by "
      FOR "OrderChoice"
   
   PICKDYNARRAYINDEX
      @2,32 HEIGHT 4 WIDTH 27
      COLUMNS 1
      Sorts
      TAG "OrderChoice"
      TO SortChoice

   ;-------------------------------------------------
   ; Radio buttons for report device selection.
   ;-------------------------------------------------
   FRAME SINGLE FROM 8,1 TO 12,15

   LABEL @8,3
      "~P~rint to "
      FOR "Device"

   RADIOBUTTONS
      @9,2 HEIGHT 3 WIDTH 12
      "Editor", "File", "Printer"
      TAG "Device"
      TO DevSel

   ;--------------------------------------------------
   ; File and subdirectory name specification for report.
   ;--------------------------------------------------
   LABEL @8,16
      "~F~ile name"
      FOR "FileTag"

   ACCEPT 
      @8,32 WIDTH 11 "A8"
      TAG "FileTag"
      TO FileName

   LABEL @8,43
      "~E~xt"
      FOR "ExtTag"

   ACCEPT 
      @8,48 WIDTH 6 "A3"
      TAG "ExtTag"
      TO FileExt
   
   LABEL @9,16
      "~D~irectory name"
      FOR "DirTag"

   ACCEPT 
      @9,32 WIDTH 27 "A25"
      TAG "DirTag"
      TO DirName

   ;-------------------------------------------------
   ; Ok and Cancel push buttons.
   ;-------------------------------------------------
   PUSHBUTTON @11,25 WIDTH 10
      "~O~k"
      OK
      DEFAULT
      VALUE "Yes"
      TAG "ACCEPT"
      TO ButtonValue

   PUSHBUTTON @11,40 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "No"
      TO ButtonValue
   
ENDDIALOG   

ENDPROC
WRITELIB LibName ReportDialog
RELEASE PROCS ReportDialog

?? "*"
;=================================================
PROC ReportSpecsGet(ReportCategory, FormViewActive)

PRIVATE DefFileName,
        DefFileExt,
        DefDirName, 
        DevSel,
        DefSortChoice,
        DirName,
        Element,
        FileName, 
        FileExt,
        MFDirName,
        ReportChoice,
        Reports,
        RptCtgy, 
        SortChoice,
        Sorts,
        Tbl,
        TblSpec
        
;-------------------------------------------------
; Open the "Reports Form" and get reporting options
;    for the current entity.
;-------------------------------------------------
ECHO OFF
VIEW "Reports\\Rpt_Ctgy"
PICKFORM "F"
MOVETO FIELD "Category Short Descr"
LOCATE PATTERN ReportCategory    ; Case insensitive search for value.
RptCtgy   = [Category Short Descr]
Tbl       = [Master File Name]
MFDirName = [Master File Dir Path]

DYNARRAY Reports[]
DYNARRAY RptFrms[]
DYNARRAY RptProcs[]
MOVETO "Reports\\Rpt_Desc"
MOVETO FIELD "Report Short Descr"
FOR i FROM 1 TO NIMAGERECORDS()
   Element = [Report Short Descr]
   Reports[Element]   = [Report Id] 
   RptFrms[Element]   = [Report Form Id]
   RptProcs[Element]  = [Report Procedure]
   IF [Is Default Report] = "Y" THEN
      ReportChoice = [Report Id]   
   ENDIF
   DOWN
ENDFOR   

DYNARRAY Sorts[]
MOVETO "Reports\\Rpt_Sort"
MOVETO FIELD "Sort Short Descr"
FOR i FROM 1 TO NIMAGERECORDS()
   Element = [Sort Short Descr]
   Sorts[Element] = [Sort Spec]
   IF [Is Default Sort] = "Y" THEN
      DefSortChoice = [Sort Short Descr]   
      SortChoice = DefSortChoice
   ENDIF
   DOWN
ENDFOR   

FORMKEY                               ; Switch back to the Reports Table.
WINDOW CLOSE                          ; Close its associated window.

DefFileName = Tbl
FileName    = DefFileName
DefFileExt  = "RPT"
FileExt     = DefFileExt
DefDirName  = DIRECTORY()
DirName     = DefDirName

;--------------------------------------------------
; Call the generic Report Dialog and run the report
;    the user requested if s/he selects one.
;--------------------------------------------------
ReportDialog(RptCtgy, DirName)
IF RetVal = True THEN
   IF SUBSTR(DirName, LEN(DirName), 1) <> "\\" THEN
      DirName = DirName + "\\"
   ENDIF
   IF RptProcs[ReportChoice] <> "" THEN
      EXECPROC RptProcs[ReportChoice]
      TblSpec = IIF(ISASSIGNED(TblSpec), TblSpec, "Answer")
   ENDIF   
   ReportExec(DevSel, 
              IIF(ISASSIGNED(TblSpec), TblSpec, MFDirName + Tbl),
              RptFrms[ReportChoice], 
              DirName + FileName + "." + FileExt,
              SortChoice,
              FormViewActive)
   MESSAGE "Returning to previous level..."
   ECHO NORMAL
   RETURN 
ELSE
   MESSAGE "Reports canceled as requested..."
   ECHO OFF
   IF FormViewActive THEN
      FORMKEY
   ENDIF
   ECHO NORMAL   
   RETURN
ENDIF                 

ENDPROC
WRITELIB LibName ReportSpecsGet
RELEASE PROCS ReportSpecsGet

