LibName = "Libs\\Security"

IF NOT ISFILE(LibName + ".LIB") THEN
   CREATELIB LibName
ENDIF   


;=================================================
;             Access Procedures                
;=================================================


? " Working on ", LibName, " *"
;=================================================
PROC AccessLogsTransfer()

IF ISEMPTY("Accss\\ADates") THEN
   MESSAGE "There is no access data to archive" 
   SOUND 300 50 SOUND 300 50
   SLEEP 2000
   MESSAGE "Returning to previous level..."
   SLEEP 500
   RETURN
ELSE   
   MESSAGE "Closing access logs..."
   ADD "Accss\\ADates" "Accss\\CDates"
   EMPTY "Accss\\ADates"
   ADD "Accss\\ALogs" "Accss\\CLogs"
   EMPTY "Accss\\ALogs"
   MESSAGE "Returing to previous level..."
   SLEEP 1000
ENDIF

ENDPROC 
WRITELIB LibName AccessLogsTransfer
RELEASE PROCS AccessLogsTransfer


?? "*"
;===================================================
PROC AccessClosedLogsRpt()

PRIVATE Sortedby

IF ISEMPTY("Accss\\CDates") THEN
   MESSAGE "There is no archived access data to print" 
   SOUND 300 50 SOUND 300 50
   SLEEP 2000
   MESSAGE "Returning to previous level..."
   SLEEP 500
   RETURN
ELSE   
   MESSAGE "Working on Closed Logs report: compiling data..."
   QUERY

      Accss\cdates |  Date In  | Facility Id |  Memo  | 
                   | Check _di | Check _fi   | Check  | 

      Accss\clogs | Date In | Facility | Personnel Id | Time In | Time Out | 
                  | _di     | _fi      | Check        | Check   | Check    | 

      Accss\clogs | Area Id | Num Guests In | Num Guests Out | Date Out | 
                  | Check   | Check         | Check          | Check    | 

      Accss\clogs |  Memo  | Access Officer | 
                  | Check  | Check          | 

   ENDQUERY
   DO_IT!
   CLEARIMAGE
   UPIMAGE
   CLEARIMAGE
   UPIMAGE
   CLEARIMAGE
   COPYREPORT "Accss\\CLogsRpt" "R" "Answer" "R"
ENDIF   
   
ENDPROC 
WRITELIB LibName AccessClosedLogsRpt
RELEASE PROCS AccessClosedLogsRpt

