;;  *************************************************************
;;  SEARCH DEMO
;;  *************************************************************
;;  CopyRight (c) 1992 Micro-Phyla Systems  All Rights Reserved
;;
;;  Author: John B. Moore
;;
;;  The following procedure is yours to use or modify as you please, but
;;  you must retain the copyright notice above in all instances that you
;;  use this procedure.
;;
;;  To my knowledge the original incremental search concept was first
;;  uploaded by Steve Dickerson, as found in SDzip.zip in the libraries
;;  This routine uses that concept.  
;;
;;  NO WARRANTIES ARE EXPRESSED OR IMPLIED THAT ANY OF THIS SERVES ANY USEFUL
;;  PURPOSE WHATSOEVER.  If it helps you, great - help someone else in return.
;;
;;  Purpose:
;;     To demonstrate a small flexible search routine.
;;     To demonstrate the interactions between table images and window canvas
;;     To demonstrate how to control window canvases while still interacting
;;        with a table image.
;;
;;   Features:
;;      --a small incremental search window indicating last search string
;;      --automatically places the window farthest from the current cursor
;;        position.
;;      --allows movement of the search window <Ctrl-F5>
;;      --allows movment of the cursor within in the table view
;;      --keeps the cursor off the record number column
;;      --allows a seach next key  <Alt-Z>
;;
;;    Keys:
;;       >> all keys from  39 to 126  can be used to search
;;       >> Window move -- <Ctrl-F5>
;;          Cancel window move <Escape>
;;       >> Cursor move  --  arrow keys
;;       >> Search nexted  -- <Alt-Z>
;;       >> Cancel search -- <Escape>
;;    To use demo:
;;         Load a table on the workspace
;;         Play this procedure
;;
;;  *****************************************************************
;;                         Have fun...!
;;  ****************************************************************

; ============================================================
; 10-03-92
; Produces a mini search window with incremental search
; ------------------------------------------------------------
PROC ZipSearchWindow_n()
   PRIVATE Procname.a,
           cursor_row_n,
           cursor_col_n,
           search_a,
           search_h,
           current_h,
           movechoice_bag,
           attrib_bag,
           keychoice_bag,
           row_n,
           col_n
   Procname.a = "ZipSearchWindow_n"
   ;----first let's find out where the cursor is so that
   ;    we won't cover it up with our search window..
   IF FIELD() = "#" THEN RIGHT ENDIF  ;keep off of the row column..
   ECHO OFF SETCANVAS DEFAULT SYNCCURSOR
   cursor_row_n = ROW()
   cursor_col_n = COL()
   ECHO NORMAL
   ;---next let's save the window handle of the current window
   WINDOW HANDLE IMAGE IMAGENO() to current_h
   ;---now calc the best place for the search window of four possible
   ;   locations
   SWITCH
      CASE cursor_row_n > 12 AND
           cursor_col_n > 40 :
             row_n = 5
             col_n = 2
      CASE cursor_row_n > 12 AND
           cursor_col_n < 40 :
             row_n = 5
             col_n = 45
      CASE cursor_row_n < 12 AND
           cursor_col_n > 40 :
             row_n = 20
             col_n = 2
      CASE cursor_row_n < 12 AND
           cursor_col_n < 40 :
             row_n = 20
             col_n = 45
   ENDSWITCH
   ;---create dynarray attributes to format the window canvas
   DYNARRAY attrib_bag[]
              attrib_bag["CANVASHEIGHT"] = 3
              attrib_bag["CANVASWIDTH"]  = 30
              attrib_bag["CANCLOSE"]     = false
              attrib_bag["CANMAXIMIZE"]  = false
              attrib_bag["CANMOVE"]      = false
              attrib_bag["CANRESIZE"]    = false
              attrib_bag["ECHO"]         = true
              attrib_bag["HASFRAME"]     = false
              attrib_bag["STYLE"]        = 23

   WINDOW CREATE FLOATING @ row_n,col_n
          HEIGHT 3
          WIDTH 30
          ATTRIBUTES attrib_bag TO search_h
   ;---set canvas to canvas window
   SETCANVAS search_h
   ;--create chiseled frame  in the canvas window
   FRAME DOUBLE FROM 0,0 TO 2,29
   PAINTCANVAS ATTRIBUTE 31 0,0,2,0
   PAINTCANVAS ATTRIBUTE 31 0,0,0,28
   ;---place default search text into search var
   search_a  = "?"
   ;---set style and place search text into window
   STYLE  ATTRIBUTE 30
     @ 1,3 ?? "SearchFor:" + "<"+search_a+">" + FILL(" ",(13-LEN(search_a)))
   search_a  = ""
   ;----capture all type aheads...
   WHILE CHARWAITING()
      X = GETCHAR()
   ENDWHILE
   ;---double select is often not needed but if your currsor was above
   ;   the echo layer before you called this proc it will take two
   ;   selects to actually get to the window you want.
   WINDOW SELECT current_h
   WINDOW SELECT current_h
   ;---while loop begins the main working part of the procedure
   WHILE TRUE
      ;---make sure style is reset, I found it can get "cancelled" during
      ;   the window move part of the procedure below.
      STYLE  ATTRIBUTE 30
      GETEVENT KEY "ALL"  TO  keychoice_bag
         SWITCH
            ;---all normal search characters
            CASE keychoice_bag["KEYCODE"]   > 40 AND
               keychoice_bag["KEYCODE"]   < 127:
                  keychoice_a = CHR(keychoice_bag["KEYCODE"])
                  ;---limit the length of the search string
                  IF LEN(search_a) = 13 THEN
                     BEEP BEEP LOOP
                  ENDIF
                  search_a = search_a + keychoice_a
                  @ 1,3 ?? "SearchFor:" + "<"+search_a+">" + FILL(" ",(13-LEN(search_a)))
                  ;--since we don't know if this field has a secondary index we can't
                  ;  use some of the new locate commands, this can be changed if you are
                  ;  using this specifically for an indexed field.  I would use
                  ;  LOCATE INDEXORDER BESTMATCH search_a
                  LOCATE PATTERN  search_a+".."
            CASE keychoice_bag["KEYCODE"] = 8:  ;backspace to clear search value string
                  search_a = "?"
                  @ 1,3 ?? "SearchFor:" + "<"+search_a+">" + FILL(" ",(13-LEN(search_a)))
                  search_a = ""
                  LOOP
            CASE keychoice_bag["KEYCODE"] = 27:  ; Escape  cancel
                     QUITLOOP
            CASE keychoice_bag["KEYCODE"] = -72:  ; UP
                 UP LOOP
            CASE keychoice_bag["KEYCODE"] = -80:  ; DOWN
                 DOWN LOOP
            CASE keychoice_bag["KEYCODE"] = -75:  ; LEFT
                 LEFT
                 ;--locate will crash if it is attempted on the record number field.
                 IF FIELD() = "#" THEN
                    IF ATFIRST() THEN
                        RIGHT BEEP BEEP
                    ELSE LEFT ENDIF
                  ENDIF
                 LOOP
            CASE keychoice_bag["KEYCODE"] = -77:  ; RIGHT
                 RIGHT
                 ;--locate will crash if it is attempted on the record number field.
                 IF FIELD() = "#" THEN RIGHT ENDIF
                 LOOP
            CASE keychoice_bag["KEYCODE"] = -44:  ; search next  Alt-Z
                 IF NOT ATLAST() AND
                    search_a <> "" THEN
                    DOWN
                    LOCATE NEXT PATTERN  search_a+".."
                    IF NOT retval THEN UP ENDIF
                 ELSE BEEP BEEP ENDIF
            CASE keychoice_bag["KEYCODE"] = -98:  ; move window  Ctrl-F5
                  ;--here we begin a new while loop within the main loop to control
                  ;  the movement of the window by changing the window attributes
                  ;  of the Originrow and Origincol indexes
                  WHILE TRUE
                    GETEVENT KEY "ALL"  TO  movechoice_bag
                    SWITCH
                       CASE movechoice_bag["KEYCODE"] = -72: ;UP
                           IF row_n > 5 THEN
                              row_n = row_n  - 1
                           ENDIF
                       CASE movechoice_bag["KEYCODE"] = -77: ;RIGHT
                           IF col_n < 45 THEN
                              col_n = col_n + 1
                           ENDIF
                       CASE movechoice_bag["KEYCODE"] = -75: ;LEFT
                           IF col_n > 2 THEN
                              col_n = col_n - 1
                           ENDIF
                       CASE movechoice_bag["KEYCODE"] = -80: ;DOWN
                           IF row_n < 19 THEN
                              row_n = row_n + 1
                           ENDIF
                       CASE movechoice_bag["KEYCODE"] = 27:  ;ESCAPE cancel window move
                            QUITLOOP
                       ;--beep all other keypresses
                       OTHERWISE: BEEP BEEP
                    ENDSWITCH
                    ;---reset window attributes
                    attrib_bag["ORIGINROW"]  =  row_n
                    attrib_bag["ORIGINCOL"]  =  col_n
                    WINDOW SETATTRIBUTES search_h FROM attrib_bag
                  ENDWHILE
            OTHERWISE:  BEEP BEEP LOOP
         ENDSWITCH
    ENDWHILE
    STYLE
    ;--close floating window
    WINDOW SELECT search_h
    WINDOW CLOSE
    WINDOW SELECT current_h
    WINDOW SELECT current_h
    SETCANVAS DEFAULT
    ;---return 1 so this proc can be used within a wait proc
    RETURN 1
ENDPROC

    ;--sample call  for this demo

    ZipSearchWindow_n()

    ; --sample call in wait proc

    ;Return ZipSearchWindow_n()



