; 
;                                                                          
;              Search procedure names and write procedures to library      
;              ("PROC" must stand on begin of a line)                      
;              December, 22nd 1992                                         
;              Harald Pitro                                                
;                                                                          
; 


; ͻ
;      Define the macros and the temporary names                         
;      this could be done outside (see release vars for this case)       
; ͼ
ARRAY	aMacros[3]		; this is an example, put your own macros here
	aMacros[1]  = "d:\\pdox40\\data\\SC\\DIALOGS"
	aMacros[2]  = "d:\\pdox40\\data\\SC\\EDITTAB"
	aMacros[3]  = "d:\\pdox40\\data\\SC\\TOOLS"

sLibname   = ""			; Name of the library to create

IF  sLibname = ""  THEN
	MESSAGE	"You must fill the vars aMacros and sLibname."
	SLEEP 2000

	RELEASE VARS	aMacros, sLibName
	RETURN
ENDIF


; ͻ
;      bDelete lets you create a (short) descripted macro                
;              FALSE - Output macro contains comments                    
;              TRUE  - Output macro will be deleted after running        
; ͼ
bDelete = False


; ͻ
;      Temporary macro name, you can change it                           
; ͼ
sTempName  = "TempLib"			; Name of temporary macro
sTempMacro = sTempName+".sc"


; ͻ
;      Search procedures within macros                                   
; ͼ
MESSAGE	"Search macros for procedures."
sOutput = ""
nProcs  = 0

FOR i FROM 1 TO ARRAYSIZE(aMacros)
	FILEREAD  aMacros[i]+".SC" TO sInput
	IF  NOT bDelete  THEN
		sOutput = sOutput + "\n; ͻ\n"
		sOutput = sOutput + ";      Procedures from "+aMacros[i]+SPACES(50-LEN(aMacros[i]))+"\n"
		sOutput = sOutput + "; ͼ\n"
	ENDIF

	n = 1
	WHILE  True
; 	Ŀ
; 	   Search "PROC .."                                         
;   
		IF  n = 1  THEN
			IF  UPPER(SUBSTR(sInput, n, 4)) <> "PROC"  THEN
				n = n + 4
				LOOP
			ENDIF
		ELSE
			n = SEARCHFROM("\nPROC", sInput, n)
			IF  n = 0  THEN
				QUITLOOP
			ENDIF

			n = n + 1
		ENDIF

;   Ŀ
;      Search begin of procedure name                           
;   
		n = n + 4
		c = SUBSTR(sInput, n, 1)
		IF  c <> " "  AND  c <> "\n"  AND  c <> "\t"  THEN
			LOOP	        ; no procedure head
		ENDIF

		WHILE c=" "  OR  c="\n"  OR  c="\t"
			n = n + 1
			c = SUBSTR(sInput, n, 1)
		ENDWHILE

		IF  c = "\""  THEN
			LOOP        	; it seems to be a sub-statement
		ENDIF

		c = SUBSTR(sInput, n+6, 1)
		IF  UPPER(SUBSTR(sInput, n, 6)) = "CLOSED"  AND
			(c=" "  OR  c="\n"  OR  c="\t")         THEN
			n = n + 6
			WHILE c=" "  OR  c="\n"  OR  c="\t"
				n = n + 1
				c = SUBSTR(sInput, n, 1)
			ENDWHILE
		ENDIF

;   Ŀ
;      Search end of procedure name                             
;   
		m = n
		c = SUBSTR(sInput, n, 1)
		WHILE c <> "("
			n = n + 1
			c = SUBSTR(sInput, n, 1)
			IF  c = ""  THEN
				QUITLOOP
			ENDIF
		ENDWHILE

;   Ŀ
;      If name was found, append it to output string            
;   
		IF  c <> ""  THEN						; procedure name ?
			nProcs = nProcs + 1
			sOutput = sOutput+"WRITELIB \""+sLibname+"\" "+SUBSTR(sInput, m, n-m)+"\n"
		ENDIF
	ENDWHILE
ENDFOR


; ͻ
;      Write informations to temporary macro                             
; ͼ
MESSAGE "Write temporary macro."
IF  nProcs = 0  THEN
	MESSAGE "No procedures found."
	SLEEP 1000

	RELEASE VARS    aMacros, sLibname, sTempMacro,
					sOutput, sInput, sProcedure,
					nProcs, i, c, n, m

	RETURN
ENDIF

FILEWRITE sTempMacro FROM ""
IF  NOT bDelete  THEN
	sInput  = "Create library \""+sLibname+"\" with "+STRVAL(nProcs)+" procedures."
	FILEWRITE APPEND sTempMacro FROM "; ͻ\n"
	FILEWRITE APPEND sTempMacro FROM ";      "+sInput+SPACES(66-LEN(sInput))+"\n"
	FILEWRITE APPEND sTempMacro FROM "; ͼ\n"
ENDIF
FILEWRITE APPEND sTempMacro FROM "CREATELIB \""+sLibname+"\" SIZE "+STRVAL(MAX(50,nProcs))+"\n\n"

IF  NOT bDelete  THEN
	FILEWRITE APPEND sTempMacro FROM "\n; ͻ\n"
	FILEWRITE APPEND sTempMacro FROM ";      Play macros to read the procedures into memory                    \n"
	FILEWRITE APPEND sTempMacro FROM "; ͼ\n"
ENDIF

FOR i FROM 1 TO ARRAYSIZE(aMacros)
	FILEWRITE APPEND sTempMacro FROM "PLAY \""
	sInput = aMacros[i]
	m = 1
	IF  SUBSTR(sInput, 1, 1) = "\\"  THEN
		FILEWRITE APPEND sTempMacro FROM "\\\\"
		m = 2
	ENDIF

	WHILE True
		n = SEARCHFROM("\\", sInput, m)
		IF  n = 0  THEN
			FILEWRITE APPEND sTempMacro FROM SUBSTR(sInput,m,LEN(sInput)-m+1)+"\"\n"
			QUITLOOP
		ENDIF

		FILEWRITE APPEND sTempMacro FROM SUBSTR(sInput,m,n-m)+"\\\\"
		m = n + 1
	ENDWHILE
ENDFOR
FILEWRITE APPEND sTempMacro FROM "\n"+sOutput


; ͻ
;      Play macro to create the library and delete temporary data        
; ͼ
MESSAGE "Create library."
PLAY	sTempName

IF  bDelete  THEN
	SYSINFO TO aInfo
	IF  aInfo["LANGUAGE"] = "049"  THEN       ; delete macro (??? English ???)
		MENU TYPEIN "TLM"+sTempName ENTER "O" ; {Tools} {Lschen} {Macro}
	ELSE
		MENU TYPEIN "TDM"+sTempName ENTER "O" ; {Tools} {Delete} {Macro}
	ENDIF
ENDIF

MESSAGE ""


RELEASE VARS    aMacros, sLibname, sTempMacro, bDelete, aInfo,
				sOutput, sInput, sProcedure,
				nProcs, i, c, n, m
