;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure ListPersonnel, ListPersonnelScr, GetNameSel 
;Source File     : Scrolbar.SC
;Author          : Jim Schwarz
;                  Paradox Informant
;
;Informant Issue : May 1991
;
;Description     : A routine illustrating one technique in assembling 
;                  scroll bar menus on the PAL canvas. These menus are 
;                  typically employed for use when you want to display
;                  input choices to a user based on values in a field from
;                  a table. The ZIP file contains a sample table and a sample
;                  script (Sample.SC) to illustrate its use and capabilities.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;-----------------------------------------------------------------------------

  CREATELIB "GetPrLib"

  PROC ListPersonnel()
    PRIVATE LineCount,CurrLine,NextLine,TopRec,RecCount

    ViewRec=RecNo()
    CurrRec=1
    LineCount=1
    CurrLine=1
    NextLine=2
    TopRec=1
    RecCount=0

    ListPersonnelScr()

    WHILE True
      RecCount=TopRec
      MOVETO RECORD TopRec
      STYLE ATTRIBUTE 113
      @8,0

      ;fill record display area with justified data
      ;from selected fields
      WHILE RecCount<=TotalRecs AND LineCount<6
         ?"  "+SUBSTR([LAST]+", "+[FIRST]+SPACES(25),1,26)
         ?? SPACES(6-LEN([ID NO]))
         ?? [ID NO]
         ?? SPACES(7-LEN([OFF NO]))
         ?? [OFF NO]
         ?? " "
         RecCount=RecCount+1
         LineCount=LineCount+1
         PGDN
      ENDWHILE
      ;place records remaining indicators (up and
      ;down arrowheads adjacent to first and last
      ;records)
      IF TotalRecs>5
        THEN IF TopRec>1
               THEN @9,32 ??CHR(30)
             ENDIF
             IF LineCount=6
               THEN IF RecCount<TotalRecs
                      THEN @13,32 ??CHR(31)
                    ENDIF
               ELSE @7+LineCount,32
             ENDIF
      ENDIF
      ;clear remaining lines
      WHILE LineCount<6
        ?SPACES(42)
        LineCount=LineCount+1
      ENDWHILE
      LineCount=1

      ;place highlight bar on current record line
      ;and get user input
      WHILE True
        MOVETO RECORD CurrRec
        PAINTCANVAS ATTRIBUTE 23
          8+CurrLine,33,8+CurrLine,73
        CANVAS ON
        c=GETCHAR()
        SWITCH
          CASE c=-80:                  ;Down
            IF CurrRec<TotalRecs
              THEN CurrRec=CurrRec+1
                   NextLine=CurrLine+1
              ELSE BEEP
                   LOOP
            ENDIF
          CASE c=-72:                  ;Up
            IF CurrRec>1
              THEN CurrRec=CurrRec-1
                   NextLine=CurrLine-1
              ELSE BEEP
                   LOOP
            ENDIF
          CASE c=-73:                  ;PgUp
            IF TopRec>5
              THEN TopRec=TopRec-4
              ELSE IF TopRec=1
                     THEN BEEP
                          LOOP
                     ELSE TopRec=1
                   ENDIF
            ENDIF
            CurrRec=TopRec
            CurrLine=1
            QUITLOOP
          CASE c=-81:                  ;PgDn
            IF TotalRecs>TopRec+4
              THEN TopRec=TopRec+4
              ELSE BEEP
                   LOOP
            ENDIF
            CurrRec=TopRec
            CurrLine=1
            QUITLOOP
          CASE c=-71:                  ;Home
            IF TopRec>1
              THEN TopRec=1
              ELSE BEEP
                   LOOP
            ENDIF
            CurrRec=TopRec
            CurrLine=1
            QUITLOOP
          CASE c=-79:                  ;End
            IF TopRec<TotalRecs-4
              THEN TopRec=TotalRecs-4
              ELSE BEEP
                   LOOP
            ENDIF
            CurrRec=TopRec
            CurrLine=1
            QUITLOOP
          CASE c=13:                   ;CR
            SETMARGIN OFF
            RETURN
          CASE c=27:                   ;Esc
            SETMARGIN OFF
            CurrRec=0
            MOVETO RECORD ViewRec
            RETURN
          CASE c>64:                   ;alpha char
            IF GetNameSel()
              THEN QUITLOOP
              ELSE LOOP
            ENDIF
          OTHERWISE:
            BEEP
            LOOP
        ENDSWITCH
        ;adjust TopRec value to reflect any UP or
        ;DOWN movement beyond current display
        IF NextLine<1
          THEN TopRec=TopRec-1
               CurrLine=1
               QUITLOOP
          ELSE IF NextLine>5
                 THEN TopRec=TopRec+1
                      CurrLine=5
                      QUITLOOP
               ENDIF
        ENDIF
        CANVAS OFF
        ;repaint current line to original color
        ;(i.e. erase highlight)
        PAINTCANVAS ATTRIBUTE 113
          8+CurrLine,33,8+CurrLine,73
        CurrLine=NextLine
      ENDWHILE
      CANVAS OFF
    ENDWHILE
  ENDPROC


  PROC ListPersonnelScr()
    CURSOR OFF
    CANVAS OFF
    PAINTCANVAS FILL Chr(177)
      ATTRIBUTE 112
      7,32,18,76
    STYLE ATTRIBUTE 112
    SETMARGIN 31
    @6,31
  TEXT
  Personnelͻ
             Name              ID No  Off No 
  Ķ
                                             
                                             
                                             
                                             
                                             
  Ķ
   Use [Esc] to quit, [Enter] to select or   
   list for names beginning with:            
  ͼ
  ENDTEXT
    ;place pseudo flashing cursor at end of option
    ;input line (i.e. after the ":")
    STYLE ATTRIBUTE 240
    @16,64 ??"_"
    SETMARGIN 32
  ENDPROC


  PROC GetNameSel()
    PRIVATE CharSel

    CharSel=UPPER(Chr(c))
    STYLE ATTRIBUTE 113
    @16,64 ??CharSel
    ;place pseudo flashing cursor after input
    ;character
    STYLE ATTRIBUTE 240
    ??"_"

    WHILE True
      c=GETCHAR()
      IF c=8                           ;Backspace
        THEN @16,64 ??"_ "
             RETURN False
        ELSE IF c<>13                  ;Enter
               THEN BEEP
                    LOOP
               ELSE MOVETO [LAST]
                    LOCATE PATTERN CharSel+".."
                    IF Retval
                      THEN TopRec=[#]
                           CurrRec=TopRec
                           CurrLine=1
                           @16,64 ??"_ "
                           RETURN True
                      ELSE BEEP
                           @16,64 ??"_ "
                    ENDIF
             ENDIF
      ENDIF
    ENDWHILE
  ENDPROC

  WRITELIB "GetPrLib" ListPersonnel,ListPersonnelScr,
                      GetNameSel
