
; SpellBound Services  Paradox Database Applications ͻ
;                                                                          
; NOT Cxpxrxgxt (x) 1990, 1991 by William Steven Caple                     
;                                                                          
;                             SpellBound Services                          
;                             1150 Arcade Boulevard                        
;                             Sacramento, CA  95815                        
;                                                                          
;                             (916) 929-6536                               
;                             Compuserve ID: 72007,2367                    
;                                                                          
;                                                                          
;Ķ
; ======================================================================   
; SCMAKE.SC: PROCEDURE LIBRARY SCRIPT PLAY AND PROC NAME DISPLAY SCRIPT    
;                                                                          
; This script will display the procedure names in an attractive 3-column   
; format as it plays the scripts to create your application library.  It   
; does require that you follow each procedure declaration with a line      
; that includes a single ? command and the name of the proc as a string,   
; lfollowed by a call to the ColumnSet() procedure:                        
;       ...                                                                
;       endproc                                                            
;                                                                          
;       writelib LibName DetailDropMenu                                    
;       release procs DetailDropMenu                                       
;       ? "DetailDropMenu()"                                               
;       ColumnSet()                                                        
;                                                                          
; This is easily done by modifying your procedure template and insert and  
; delete writelib macros in PAL-Edit.                                      
; ======================================================================== 
;                                                                          
; Written for                                             
;                                                    
;                                                        
;                                                                          
; SpellBound Services  Paradox Database Applications ͼ

clear
@ 1,0 ?? "Loading" style blink ?? "..." style
release procs all
reset



; Ŀ
;  LIB SPLASH - splash screen background for library creation display      
; 
proc LibSplash()
  CurrentProc = "LibSplash"

  setmargin off
  @ 0,0
  style attribute Bkgr
  text
  SPELLBOUND  SERVICES  PARADOX DATABASE DESIGN AND CUSTOM PROGRAMMING  

                                                                          
                                                                          




















 Steve Caple   1150 Arcade Blvd    Sacramento, CA 95815  CIS: 72007,2367 
  endtext
                                                        ;Ŀ
  paintcanvas  border  attribute Bord     0,  0, 24, 79 ;blu on gry outer bord 
                                                        ;                      
  paintcanvas          attribute Spel     0,  4,  0, 26 ;yel on gry SpellBound 
  paintcanvas          attribute Spel+128 0, 15,  0, 15 ;red on gry , blinking
  paintcanvas          attribute Spel     0, 16,  0, 16 ;red on gry           
  paintcanvas          attribute Spel+128 0, 17,  0, 17 ;red on gry , blinking
                                                        ;
endproc
; 



; Ŀ
;  COLUMN SET - 3 column formatting for proc library creation script       
; 
proc ColumnSet()
  CurrentProc = "ColumnSet"
  if row() >= 23 then
    if NColumns = 3 then
      beep
      message "Press any key to continue with next screen of procedures"
      retval = getchar()
      paintcanvas  fill ""  attribute Bkgr  4,2,23,78
      NColumns = 1
    else
      NColumns = NColumns + 1
    endif
    @ 3,0  setmargin 3 + (NColumns - 1) * 25
  endif
endproc
; 



    ColorMonitor = monitor() = "Color"
    if ColorMonitor then
      Bkgr  =  16           ;
      Bord  = 113           ;blu on gry outer border
      Spel  = 126           ;yel on gry SpellBound
    else
      Bkgr  = syscolor(2)   ;10
      Bord  = syscolor(8)   ; 2  normal     outer border
      Spel  = syscolor(9)   ; 2  normal     SpellBound
    endif



    LibName = directory() + "CalFresh"
    createlib LibName size 300

    canvas off
    cursor off
    LibSplash()
    setmargin 3
    @ 2,3 ?? "Creating procedure library "+upper(LibName)
    ? fill("",74)   ;draw line across screen
    @ 3,3            ;move cursor back to line 3 so ? can start at line 4
    NColumns = 1
    canvas on

    play "cf_main"    ;each script contains several proc definitions
    play "cf_inv"
    play "cf_detl"
    play "cf_prod"
    play "cf_supp"
    play "cf_cust"
    play "cf_popup"
    play "cfscroll"
    play "cf_utils"

; Ŀ
;                     library definition complete                          
; 

    beep
    message "Procedure library " + upper(LibName) +
            " defined ... press any key to continue"
    retval = getchar()
    release vars LibName, NColumns, ColorMonitor, Bkgr, Bord, Spel

