;SpellBound Services  Paradox Applicationsͻ
;                                                    
; Copyright (c) 1990, 1991 by                        
;                                                    
;               William Steven Caple                 
;               SpellBound Services                  
;               1150 Arcade Boulevard                
;               Sacramento, CA  95815                
;                                                    
;               (916) 929-6536                       
;               Compuserve ID: 72007,2367            
;                                                    
;                                                    
; Permission is granted to use this code in any ap-  
; plication you may create so long as the copyright  
; notice is retained.                                
;                                                    
; This code may not be sold by an individual except  
; as part of a complete application.  User groups    
; may include this code in utility disks provided    
; the charge per disk does not exceed $5.00.         
;Ķ
;                                                    
; SCBBAR.SC: BOUNCE BAR PROCEDURE LIBRARY SOURCE CODE
;                                                    
;SpellBound Services  Paradox Applicationsͼ


libname = "testbbar"
createlib libname



; -----------------------------------------------------
;                        scBBar.SC
; -----------------------------------------------------
;Contents:      procedures BBar(), BBInit(), BBFill(),
;               BBFindLtr(), BBSet(), BBPalette()
;
;Source File:   BBAR.SC
;
;Submitted By:  Steve Caple, SpellBound  Services,
;                            Sacramento, CA
;
;Description:   Procedures for a bounce bar menu that
;displays a box on screen with up to 18 lines of menu
;choices  - optional splash screen call  - optional
;transparent shadow  - up/down arrow key navigation
;with wrap around  - jump to next instance of first
;letter pressed by user
;
;Call Syntax:   BBar(DoSplash,DoShadow,R,C,Title)
;
;Parameters:
;  DoSplash - numeric, 1=splash, 0=no splash
;  DoShadow - numeric, 1 = shadow, 0 = no shadow
;  R, C     - numeric, row and column values, used
;             as entered, or calculated/adjusted in
;             several auto-positioning variations:
;    0,79 -> flush upper right
;   24,79 -> flush lower right
;    0, 0 -> flush upper left
;   24, 0 -> flush lower left
;   99,99 -> centered
;    n,99 -> top @ row n, centered left to right
;   99, n -> left @ col n, centered top to bottom
;
;  Title    - string to center on top line of menu box
;
;Returns Value?: Yes - returns "Esc" if user presses
;[Esc], otherwise returns the menu line selected
;
;Paradox Version:  3 - uses paintcanvas, canvas on/off
;
;Special Notes:    Revision published 10/12/91
;
;This proc requires an array of choices called BBarray,
;declared globally to the BBar() call - should be
;private to the calling procedure.
;
;The new version depends on externally defined
;variables for a number of items.  Most of these
;variables are defined by the BBAR utility procedures
;BBSet() and BBPalette():
;
;BBSet()  - called near top of proc calling BBar(),
;after declaration and assignment of local BBarray
;variable;  - improves performance by offloading
;several calculations to a one time call  - variables
;set must be declared PRIVATE in the proc calling
;BBSet() and BBar():
;
;  NBBNumItems, NBBMaxLen, NBBBoxWidth, NBBCntrAdj,
;  BorderFillString
;
;BBPalette - sets pre-defined numeric color/mono
;attribute variables:
;
;  BBNorm   (main block attribute)
;  BBHiLite (highlighted choice attribute)
;  BBShadow (shadow attribute)
;
; *These variables MAY be set private to the calling
;  proc OR may defined at a higher level; they may be
;  defined to any set of attributes you desire, or set
;  by a procedure of your own, so long as they are
;  defined before BBar() is called
;
;The variable SplashProc is usually defined in the top
;level procedure of the application, but may be changed
;at any level - just re-declare it private.
; -----------------------------------------------------
proc BBar(DoSplash, ;logical 1/0, 1 execs splash proc
          DoShadow, ;logical 1/0, 1 paints shadow
          R,        ;numeric row
          C,        ;numeric row
          Title)    ;title string or string variable

  private x, n, v, NBBtrow, NBBtcol, NBBbrow, NBBbcol
  echo off
  cursor off

  ; ---------------------------------------------------
  ; turn off display until screen is complete
  ; ---------------------------------------------------
  canvas off

  if DoSplash <> 0 then
    execproc SplashProc
  endif

  BBInit()          ; initialize the menu screen
  BBFill()          ; fill in the title, choices

  ; ---------------------------------------------------
  ; all done - turn on the lights - start the show
  ; ---------------------------------------------------
  canvas on

  ; ---------------------------------------------------
  ;         main selection highlighting loop
  ; ---------------------------------------------------
  n = 1
  v = 1
  while true

    ; highlight the current selection
    paintcanvas  attribute BBHiLite
      NBBtrow+1+n, NBBtcol+2+NBBCntrAdj,
      NBBtrow+1+n, NBBtcol+2+NBBCntrAdj+NBBMaxLen-1

    while charwaiting()
      retval = getchar()
    endwhile

    while true
      x = getchar()

      switch
        case x = 27:             ; [Esc]
          style
          return "Esc"
        case x = 13:             ; [Enter]
          style
          return BBarray[n]
        case x = -72:            ; up arrow
          v = -1
          quitloop
        case x = -80:            ; down arrow
          v = 1
          quitloop
        case x = -71:            ; [Home]
          quitloop
        case x = -79:            ; [End]
          quitloop
        otherwise:
          v = BBFindLtr()
          if v = false then
            loop
          else
            quitloop
          endif
      endswitch
    endwhile

    if v = 0 then loop endif  ;don't need to repaint

    ; restore current selection to normal
    paintcanvas  attribute BBNorm
      NBBtrow+1+n, NBBtcol+2+NBBCntrAdj,
      NBBtrow+1+n, NBBtcol+2+NBBCntrAdj+NBBMaxLen-1

    ; set new selection and row offset
    switch
      case x = -71 : n = 1
      case x = -79 : n = NBBNumItems
      otherwise    : n = n+v
    endswitch

    ; handle wraparound
    if n > NBBNumItems then n = 1 endif
    if n < 1 then n = NBBNumItems endif
  endwhile

endproc

writelib LIBNAME BBar
release procs BBar



; -----------------------------------------------------
; initializes bounce bar menu screen location, paints
; box, title and prompt
; -----------------------------------------------------
proc BBInit()
  CurrentProc = "BBInit"

  if R > 24 then R = 99 endif
  if C > 79 then C = 99 endif

  ; ---------------------------------------------------
  ; set box location
  ; ---------------------------------------------------
  switch

    ; -------------------------------------------------
    ; 1. if both R=99 and C=99, center box in screen
    ; -------------------------------------------------
    case R = 99 and C = 99:

      ;*** center the box vertically
      NBBtrow = int((24-NBBNumItems-3)/2)
      NBBbrow = NBBtrow + NBBNumItems +3

      ;*** center the box horizontally
      NBBtcol = int((80-NBBBoxWidth)/2)
      NBBbcol = NBBtcol + NBBBoxWidth-1

    ; -------------------------------------------------
    ; 2. if R=99, center top to bottom w/left edge at C
    ; -------------------------------------------------
    case R = 99:

      ;*** center the box vertically
      NBBtrow = int((24-NBBNumItems-3)/2)
      NBBbrow = NBBtrow + NBBNumItems +3

      ;*** move left if C too low for size
      ;    (allow offset of 2 for shadow)
      NBBtcol = min(C,80-NBBBoxWidth)
      NBBbcol = NBBtcol+NBBBoxWidth-1

    ; -------------------------------------------------
    ; 3. if C=99, center left to right with top at R
    ; -------------------------------------------------
    case C = 99:

      ;*** move up if R too low for size
      NBBtrow = min(R,24-NBBNumItems-3)
      NBBbrow = NBBtrow+NBBNumItems+3

      ;*** center the box horizontally
      ;    (allow offset of 2 for shadow)
      NBBtcol = int((80-NBBBoxWidth)/2)
      NBBbcol = NBBtcol+NBBBoxWidth-1

    ; -------------------------------------------------
    ; 4. all others, try to locate at params passed
    ; -------------------------------------------------
    otherwise:

      ;move up if R too low for size
      NBBtrow = min(R,24-NBBNumItems-3)
      NBBbrow = NBBtrow + NBBNumItems +3

      ;move left if C too low for size
      NBBtcol = min(C,80-NBBBoxWidth)
      NBBbcol = NBBtcol+NBBBoxWidth-1

  endswitch

  ; ---------------------------------------------------
  ; if DoShadow = 1, adjust if needed and paint shadow
  ; ---------------------------------------------------
  if DoShadow = 1 then

    NBBtrow = min(NBBtrow,24-NBBNumItems-4)
    NBBbrow = NBBtrow + NBBNumItems +3

    NBBtcol = max(NBBtcol,2)
    NBBbcol = NBBtcol+NBBBoxWidth-1


    paintcanvas  attribute BBShadow
      NBBtrow+1, NBBtcol-2, NBBbrow+1, NBBbcol-2

  endif

  ; ---------------------------------------------------
  ; paint space filled box
  ; ---------------------------------------------------
  paintcanvas  fill " "  attribute
    BBNorm   NBBtrow, NBBtcol, NBBbrow, NBBbcol

  ; ---------------------------------------------------
  ; paint text box borders
  ;                BorderFillString set by BBSet()
  ; ---------------------------------------------------
  paintcanvas border fill BorderFillString
              attribute BBNorm
              NBBtrow, NBBtcol, NBBbrow, NBBbcol

  ; ---------------------------------------------------
  ; instruction line
  ; ---------------------------------------------------
  style attribute BBNorm
  @ NBBbrow, NBBtcol+int((NBBBoxWidth-24)/2)
  ?? "Enter=select  Esc=cancel"

endproc

writelib LIBNAME BBInit
release procs BBInit



; -----------------------------------------------------
; titles the box and fills in the menu choices
; -----------------------------------------------------
proc BBFill()
  private i
  CurrentProc = "BBFill"
  ; ---------------------------------------------------
  ; check title size, center it on the top line
  ; ---------------------------------------------------
  if len(Title) > NBBBoxWidth-2 then      ;if too long,
    Title = substr(Title,1,NBBBoxWidth-2) ;trim & tell
    beep
    message "Menu title too wide - trimmed to "
            + strval(len(Title))+" characters."
    sleep 500
  endif
  ;say it centered
  @ NBBtrow, NBBtcol+int((NBBBoxWidth-len(Title))/2)
  ?? Title

  ; ---------------------------------------------------
  ; display the choices centered in the box
  ; ---------------------------------------------------
  setmargin NBBtcol+2+NBBCntrAdj   ;set margin for text

  ;*** locate at line above and use ? to display
  ;    (NBBtrow+_1_ because ? offsets down 1)
  @ NBBtrow+1,NBBtcol+2+NBBCntrAdj

  for i from 1 to NBBNumItems
    ;*** ? = display each line below the other
    ? substr(BBarray[i],1,NBBMaxLen)
  endfor
  setmargin off

endproc

writelib LIBNAME BBFill
release procs BBFill



; -----------------------------------------------------
; - x is keycode from getchar() in menu loop
; - returns false if no line found starting with the
;   letter pressed, otherwise returns the offset from
;   current position
; -----------------------------------------------------
proc BBFindLtr()
  private i, Indx, Ltr
  CurrentProc = "BBFindLtr"

  if x > 0 then             ;in valid range for upper()
     Ltr = upper(chr(x))      ;so convert to uppercase
  else
    return false              ;invalid character
  endif

  Indx = n+1                ;start looking at NEXT item

  if Indx > NBBNumItems then   ;if past the end,
    Indx = 1                   ;go back to the top
  endif

  while true

    if Indx = n then        ;we're back to the start,
      return false          ;so no other line starts
    endif                   ;with upper(chr(x))

    if upper(substr(BBarray[Indx],1,1)) = Ltr then
      return Indx - n       ;return the offset from
    endif                   ;where we started

    Indx = Indx + 1         ;increment to next line

    if Indx > NBBNumItems then   ;if at or past end,
      Indx = 1                   ;go back to the top
    endif

  endwhile

endproc

writelib LIBNAME BBFindLtr
release procs BBFindLtr




; -----------------------------------------------------
;                      BB Set
;
; Saves time by doing calcs once per calling proc:
; - assigns values to variables global to BBar calls in
;   the current calling proc
; - must be called AFTER declaration and assignment of
;   local BBarray variable
; - variables assigned (should be declared private in
;   the calling proc):
;      NBBNumItems, NBBMaxLen, NBBBoxWidth, NBBCntrAdj,
;      BorderFillString
; -----------------------------------------------------
proc BBSet()
  private x, n
  CurrentProc = "BBSet"

  ;*** limit choices displayed to 18
  NBBNumItems = arraysize(BBarray)
  if NBBNumItems > 18 then
    beep
    message "BBSet(): limiting menu list to 18 items."
    sleep 500
    NBBNumItems = 18
  endif

  ;*** find the longest line in choice array
  NBBMaxLen = 0
  for n from 1 to NBBNumItems
    NBBMaxLen = max(NBBMaxLen,len(BBarray[n]))
  endfor
  if NBBMaxLen > 74 then    ;74=80-2 col shadow-4 cols
    NBBMaxLen = 74          ;for borders and spaces
    beep
    message "BBSet(): item length limited to 74 chars."
    sleep 500
  endif

  ;*** need minimum 26 wide for instruction line
  if NBBMaxLen <= 22 then
    NBBBoxWidth = 26
    NBBCntrAdj = int((24-NBBMaxLen)/2)
  else
    NBBBoxWidth = NBBMaxLen+4
    NBBCntrAdj = 0
  endif

  ; This technique I picked up on the CIS BORDB forum,
  ; I think from Alan Zenreich - at least I remember
  ; him explaining it: the key is that a border fill
  ; proceeds from up left, going left to right across
  ; the top, and then filling in the sides alternating
  ; left and right until it gets to the bottom which
  ; it fills straight across.

  BorderFillString = "" + fill("",NBBBoxWidth-2) + "" +
                           fill("", 2*(NBBNumItems+2)) +
                     "" + fill("",NBBBoxWidth-2) + ""

endproc

writelib LIBNAME BBSet
release procs BBSet





; -----------------------------------------------------
; BB Palette setting proc - to be used in calling proc
; for easy selection of color palettes instead of
; having to furnish each color attribute.
;
; Feel free to use syscolor-based mono option and/or
; revise color combos to suit.
; -----------------------------------------------------
proc BBPalette(Color)
  CurrentProc = "BBPalette"
  ;if monitor() <> "Color" and
  ;   search(upper(Color),"MONO MREV") = 0 then
  ;  BBNorm =   syscolor(6)             ; 10
  ;  BBHiLite = syscolor(2)             ;112
  ;  BBShadow = syscolor(8)             ;  2
  ;  return "MONO"
  ;endif
  switch
    case upper(Color) = "MONO":
      BBNorm =  10  BBHiLite = 112  BBShadow =  2
    case upper(Color) = "MREV":
      BBNorm = 112  BBHiLite =  10  BBShadow =  2
    case upper(Color) = "BLACK":
      BBNorm =  15  BBHiLite =  79  BBShadow =  8
    case upper(Color) = "BLUE":
      BBNorm =  31  BBHiLite =  12  BBShadow =  1
    case upper(Color) = "BROWN":
      BBNorm = 111  BBHiLite =  14  BBShadow =  6
    case upper(Color) = "RED":
      BBNorm =  79  BBHiLite = 112  BBShadow =  4
    case upper(Color) = "GRAY":
      BBNorm = 112  BBHiLite =  12  BBShadow =  8
    case upper(Color) = "GREEN":
      BBNorm =  47  BBHiLite =  12  BBShadow =  2
    case upper(Color) = "PURPLE":
      BBNorm =  95  BBHiLite =  14  BBShadow =  5
    case upper(Color) = "CYAN":
      BBNorm =  63  BBHiLite =  11  BBShadow =  3
  endswitch
  return upper(Color)
endproc

writelib LIBNAME BBPalette
release procs BBPalette




; ---------------------------------------------------------------------------
;                        SPELLBOUND SPLASH SCREEN
;
; needed for demo below ...
; ---------------------------------------------------------------------------
proc SB_Splash()
  private x
  CurrentProc = "SB_Splash"

  if monitor() <> "Color" then
    style reverse, intense
  else
    style attribute 31
  endif

  @ 0,0 clear eol
  @ 1,0 clear eol
  @ 2,0
text
  SPELLBOUND  SERVICES  PARADOX DATABASE DESIGN AND CUSTOM PROGRAMMING  
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
 Steve Caple   1150 Arcade Blvd    Sacramento, CA 95815   CIS 72007,2367 
endtext
  paintcanvas fill "" attribute 31   3,1,23,78
  paintcanvas border   attribute 113  2,0,24,79
  style
endproc

writelib LIBNAME SB_Splash
release procs SB_Splash





; ---------------------------------------------------------------------------
;                           TEST BBAR DEMO
; -  let's you see how it works as a simple menu
; ---------------------------------------------------------------------------


; you must have BBar() and its associated procs in the autolib path
autolib = LibName


if monitor() = "Color" then
  NNorm = 112
  NRev  = 79
  NInt  = 127
  FInc  = 10
else
  NNorm = 16
  NRev  = 112
  NInt  = 15
  FInc  = 0
endif

array SBColor[9]
      SBColor[1] = "BLACK"
      SBColor[2] = "BLUE"
      SBColor[3] = "GREEN"
      SBColor[4] = "CYAN"
      SBColor[5] = "RED"
      SBColor[6] = "PURPLE"
      SBColor[7] = "BROWN"
      SBColor[8] = "GRAY"
      SBColor[9] = "MONO"

array BBarray[4]
      BBarray[1] = "Data Entry  - add/edit/post/delete"
      BBarray[2] = "Reports     - auction reports menu"
      BBarray[3] = "Auto Demo   - continuous random menus"
      BBarray[4] = "Quit        - leave this application"


BBSet()

SplashProc = "SB_Splash"

SB_Splash()



; ---------------------------------------------------------------------------
; This loop below will let you experiment with the splash, shadow, and location
; features.
; ---------------------------------------------------------------------------
MRow = 0
MCol = 0
DoSplash = 0
DoShadow = 1
MenuColor = "RED"

while true

  @ 0,0 clear eol ?? "Enter row: (0 to 24) "
    accept "S" min 0 max 99 to MRow
    if isblank(MRow) then MRow = 0 endif

  @ 0,0 clear eol ?? "Enter column: (0 to 79) "
    accept "S" min 0 max 99 to MCol
    if isblank(MCol) then MCol = 0 endif

  @ 0,0 clear eol ?? "Enter DoSplash: (1 = on, 0 = off) "
    accept "S" min 0 max 1 to MDoSplash
    if isblank(DoSplash) then DoSplash = 0 endif

  @ 0,0 clear eol ?? "Enter DoShadow: (1 = on, 0 = off) "
    accept "S" min 0 max 1 to MDoShadow
    if isblank(DoShadow) then DoShadow = 1 endif

  @ 0,0 clear eol ?? "Enter Color: (Black Brown Blue Cyan Gray Green Purple Red) "
    accept "A6" picture "B{L{ACK,UE},ROWN},CYAN,GR{AY,EEN},PURPLE,RED"
    to MenuColor
    if isblank(MenuColor) then MenuColor = "RED" endif


  @ 0,0 clear eol

  BBPalette(MenuColor)

  Choice = BBar(MDoSplash,MDoShadow,MRow,MCol,"BBAR() TEST")

  switch
    case substr(Choice,1,4) = "Quit":
      release vars all
      beep
      message "It's a pleasure and a privilege",
              " to be of service to you!  (press any key)"

      retval = getchar()
      quitloop

    case substr(Choice,1,4) = "Auto":
      while true
        R = int(rand()*(24-arraysize(BBarray)-4)) ;random row selection
        C = int(rand()*(80-NBBMaxLen))            ;balanced random column
        MenuColor = SBColor[int(rand()*9)+1]      ;random color selection
        if mod(C,7) = 0 then
          MDoSplash = 1
        endif
        BBPalette(MenuColor)
        Choice = BBar(MDoSplash,MDoShadow,R,C,"AUTO TEST - [Esc] TO QUIT")
        MDoSplash = 0
        if Choice = "Esc" then
          quitloop
        endif
      endwhile

    otherwise:
      beep
      message "Your choice is \""+Choice+ "\" - press any key"
      retval = getchar()

  endswitch

endwhile













;; ---------------------------------------------------------------------------
;;                     WAIT MENU EXAMPLE - NEEDS A TABLE
;;
;; The following code fragments illustrate using NewBBar() as an expanded
;; menu in a wait.  Keeps top 2 lines clean and uncluttered.  As users learn
;; the shortcut keys, they can skip using the menu.
;; ---------------------------------------------------------------------------
;
;; ---------------------------------------------------------------------------
;; Global variables used by NewBBar() should be declared private at the top of
;; the proc calling it - also Ans used in call to NewBBar() if retval = "F10"
;; ---------------------------------------------------------------------------
;
;  array BBarray[6]
;        BBarray[1] = "Insert a new record..............Ins  "
;        BBarray[2] = "Delete current record............Del  "
;        BBarray[3] = "Edit inside current field........CtrlF"
;        BBarray[4] = "Edit key field...................CtrlK"
;        BBarray[5] = "Zoom search current field........CtrlZ"
;        BBarray[6] = "Zoom next in same field..........AltZ "
;
;  MenuTitle        = "WAIT MENU CHOICESHORTCUT"
;
;  BBSet()
;  BBPalette("BROWN")
;
;; ---------------------------------------------------------------------------
;; You need to edit the following lines to declare a table and pick a form
;; ---------------------------------------------------------------------------
;
;  coedit "Yourtabl"       ; <-  edit these
;  pickform YourFormNum    ; <-    lines
;
;
;  while true
;
;    imagerights update
;    wait table    prompt
;      format("w40,al","EDITING "+ upper(table())) +
;      format("w40,ar","F2 when done"),
;      format("w80,ar","F10 for menu")
;    until "F2", "Ins", "Del", 6, 26, -44, "F10",
;          "F2", "Dos", "DosBig", "Rotate"         ; illegal keys
;    imagerights
;
;    if retval = "F10" then
;      Ans = NewBBar(0,1,2,79,MenuTitle)
;      Ans = substr(Ans,len(MenuTitle)-4,5)
;
;      switch
;        case Ans = "Ins  " : retval = "Ins"
;        case Ans = "Del  " : retval = "Del"
;        case Ans = "CtrlF" : retval = 6
;        case Ans = "CtrlK" : retval = 11
;        case Ans = "CtrlZ" : retval = 26
;        case Ans = "AltZ " : retval = -44
;      endswitch
;
;    endif
;
;    switch
;
;      case retval = "F2":         return
;      case retval = "Ins":        beep; InsertRec()
;      case retval = "Del":        beep; DeleteOK()
;      case retval = 6:            beep; FieldEdit()
;      case retval = 11:           beep; KeyEdit()
;      case retval = 26 or
;           retval = -44:          beep; PZoom()
;      case retval = "F1" or
;           retval = "Dos" or
;           retval = "DosBig" or
;           retval = "Rotate":     beep
;    endswitch
;
;  endwhile





; ---------------------------------------------------------------------------
;                   BDYAAA BDYAAA BDYAAA, THAT'S ALL FOLKS
; ---------------------------------------------------------------------------






