PROC RoundNumbers(Value,decimals);-------------------------------------------

;**************************************************************************
;**** Procedure Name: RoundNumbers      Called by: All Scripts         ****
;****     Written by: JOHN R. NELSON         Date: 2/14/92             ****
;****                 NELCO ENGINEERING                                ****
;****                 109 Hickory Hill Lane                            ****
;****                 Greenville, SC  29609                            ****
;****       Voice/FAX/BBS (803) 244-8765                               ****
;****                                                                  ****
;****     Compuserve ID: 70641,3562                                    ****
;****                                                                  ****
;**** Purpose:  A Procedure to round numbers (Bankers Rounding)        ****
;**** Variable's (Private)                                             ****
;****       negflag - Negative number                                  ****
;****          res1 - Temporary var for the value                      ****
;****          res2 - Handles manipulations to res1                    ****
;****                                                                  ****
;**************************************************************************
;            Takes a number and rounds it to the specified
;                 Number of decimals.  On even numbers, the `5' rounds
;                 down.  On odd numbers the `5' rounds up.  This is
;                 at the last decimal before rounding.
;
;                Example:    0.125, 2 places ===>  0.12
;                Example:    0.135, 2 places ===>  0.14
;


Private Negflag, Res1, Res2
 res1=Value                            ;set dummy result variable
 IF res1<0 THEN                        ;is the value negative?
      negflag=-1
   ELSE
     negflag=1
 ENDIF
 res2=INT(res1*(POW(10,decimals)))/(POW(10,decimals)) ;truncate the number
 length=LEN(res2)                           ;how long is the string?
 last=SUBSTR(res2,length,1)                 ;get the last digit in the string
   IF (NUMVAL(last)/2)=INT(NUMVAL(last)/2) THEN ;is the last number even?
      res1=(INT(ABS(res1)*(POW(10,decimals))+.4)/(POW(10,decimals))) ;even number
   ELSE
      res1=(INT(ABS(res1)*(POW(10,decimals))+.5)/(POW(10,decimals))) ;odd number
   ENDIF
   IF negflag=-1 THEN
      res1=-res1
   ENDIF
return res1
Endproc;----------------------------------------------------------


;  The following lines are used as an example.
;  This procedure may be called from anywhere in a program.
;  My most frequent applications of this procedure are:
;            1)  Comparing a result to a specification
;                for a set number of significant figures.
;            2)  Rounding values for Reports and Forms, changing
;                to a string value and using that instead.  The problem
;                with Paradox reports and forms is that the number
;                of decimals is "set", similiar to 1-2-3.  Using
;                an alphanumeric field allows for the correct number of
;                sig figs.  Looks like it was thought through.
;
;                    Hope this is useful!! JRN


Canvas Off
Clear
ClearAll
PaintCanvas Attribute 31 0,0,24,79
Style attribute 31
Canvas On

@10,10
??"Enter the value to round: "
    Accept "N"
    Required
       To value
If Retval = True Then
   @11,10
   ??"Enter the number of decimals: "
     Accept "N"
     Required
        To decimals
   If Retval = True Then
       NewValue=RoundNumbers(value,decimals)
       @15,10
       ??"The rounded value is: "+Strval(NewValue)
       @23,10
       ??"Press any key to continue"
       abc=GetChar()



   EndIF
EndIF
