PROC Demo()
PRIVATE
  ; Globals to the Wait procedure    
  ScrollBar_Array,
  ScrollBar_PrevDownRow,
  ScrollBar_PrevDownCol,
  ScrollBar_ThumbOffset,

  ; Constants
  ScrollBar_TableName,
  ScrollBar_MasterTableName,
  ScrollBar_TopRow,
  ScrollBar_BotRow,
  ScrollBar_Col,
  ScrollBar_ThumbChar,
  ScrollBar_BarChar,
  ScrollBar_RegionHeight        
  
  PLAY "CustTest"
  CLEARALL
  ScrollBar_Init()   ; Set global variables
  COEDIT "Customer"
  PICKFORM "3"
  WINMAX
  
  PROMPT "Running"    
  ECHO NORMAL
  WAIT WORKSPACE PROC "MyWaitProc"
    TRIGGER "ARRIVEROW"
    MOUSE "DOWN"
    KEY "F2"
  ENDWAIT    
  PROMPT ""
  DO_IT!   ; End CoEdit
  CLEARALL
  RETURN
ENDPROC

PROC MyWaitProc(eventType,eventDynArray,cycleID)
; This will always return 0 and leave the desktop as it was
    
  IF (ScrollBar_WaitProc(eventType,eventDynArray,cycleID) <> 0) THEN
    RETURN Retval
  ENDIF
            
  SWITCH
    CASE eventType = "EVENT"           AND
         eventDynArray["TYPE"] = "KEY" AND 
         eventDynArray["KEYCODE"] = ASC("F2") :
      RETURN 2
    OTHERWISE :
      RETURN 0
  ENDSWITCH        

ENDPROC


PROC ScrollBar_WaitProc(eventType,eventDynArray,cycleID)
PRIVATE prevImage,rec,mouseEventDynArray
        
  SWITCH
    CASE eventType = "ARRIVEROW" :
      SWITCH
        CASE (UPPER(Table()) = ScrollBar_MasterTableName):
          ScrollBar_resetThumb(1)
        CASE (UPPER(Table()) = ScrollBar_TableName) :
          ScrollBar_SynchronizeBar()
      ENDSWITCH
      RETURN 0   ; This won't change focus

    CASE eventType = "EVENT"             AND
         eventDynArray["TYPE"] = "MOUSE" AND 
         eventDynArray["ACTION"] = "DOWN" :
      ; Sets ["FormRow"] and ["FormCol"]
      ScrollBar_SetFormRowCol(eventDynArray)

      ; Are we on the vertical scroll-bar?
      IF eventDynArray["FORMCOL"] = ScrollBar_Col      AND
         eventDynArray["FORMROW"] >=  ScrollBar_TopRow AND
         eventDynArray["FORMROW"] <=  ScrollBar_BotRow THEN
        ScrollBar_SaveImageContext()
        ScrollBar_wasOnThumb = (eventDynArray["FORMROW"] = 
          (ScrollBar_TopRow + ScrollBar_ThumbOffset))

        ; Get the next mouse event here until an UP
        WHILE True
          IF ScrollBar_wasOnThumb THEN
            GETEVENT MOUSE "UP","MOVE","AUTO" TO mouseEventDynArray
          ELSE                    
            ; We don't care if they MOVE if it wasn't on the thumb
            GETEVENT MOUSE "UP","AUTO" TO mouseEventDynArray
          ENDIF
          ; Sets ["FormRow"] and ["FormCol"] 
          ScrollBar_SetFormRowCol(mouseEventDynArray)
          IF (mouseEventDynArray["ACTION"] = "MOVE") THEN
            ; We wouldn't be getting a MOVE event if the
            ; original DOWN was not on the thumb
            SWITCH
              CASE mouseEventDynArray["FORMCOL"] <> ScrollBar_Col    OR
                   mouseEventDynArray["FORMROW"] <= ScrollBar_TopRow OR
                   mouseEventDynArray["FORMROW"] >= ScrollBar_BotRow :
              ; Not on bar at all                         
              CASE mouseEventDynArray["FORMROW"] < 
                   (ScrollBar_TopRow + ScrollBar_ThumbOffset) :
                WHILE (mouseEventDynArray["FORMROW"] < 
                      (ScrollBar_TopRow + ScrollBar_ThumbOffset))
                  ScrollBar_MoveRows(INT(-.5 * ScrollBar_RegionHeight))
                ENDWHILE                            
              CASE mouseEventDynArray["FORMROW"] > 
                   (ScrollBar_TopRow + ScrollBar_ThumbOffset) :
                WHILE (mouseEventDynArray["FORMROW"] >
                      (ScrollBar_TopRow + ScrollBar_ThumbOffset))
                  ScrollBar_MoveRows(INT(.5 * ScrollBar_RegionHeight))
                ENDWHILE                    
              OTHERWISE :      ; On thumb
            ENDSWITCH
          ELSE                 ; UP or AUTO events
            SWITCH
              CASE mouseEventDynArray["FORMCOL"] <> ScrollBar_Col    OR
                   mouseEventDynArray["FORMROW"] <  ScrollBar_TopRow OR
                   mouseEventDynArray["FORMROW"] >  ScrollBar_BotRow :
              ; Not on bar at all                         
              CASE mouseEventDynArray["FORMROW"] = ScrollBar_TopRow AND
                   eventDynArray["FORMROW"] = ScrollBar_TopRow :
                ; Down + up (click) on up arrow
                ScrollBar_MoveRows(-1)
              CASE mouseEventDynArray["FORMROW"] = ScrollBar_BotRow AND
                   eventDynArray["FORMROW"] = ScrollBar_BotRow :
                ; Down + up (click) on down arrow
                ScrollBar_MoveRows(1)
              CASE (mouseEventDynArray["FORMROW"] < 
                     (ScrollBar_TopRow + ScrollBar_ThumbOffset)) AND
                   (eventDynArray["FORMROW"] =
                     mouseEventDynArray["FORMROW"]) :
                ; Down + up (click) above thumb
                ScrollBar_MoveRows(-1 * ScrollBar_RegionHeight)
              CASE (eventDynArray["FORMROW"] > 
                     (ScrollBar_TopRow + ScrollBar_ThumbOffset)) AND
                   (eventDynArray["FORMROW"] = 
                     mouseEventDynArray["FORMROW"]) :
                 ; Down + up (click) below thumb
                 ScrollBar_MoveRows(1 * ScrollBar_RegionHeight)
              OTHERWISE :   ; On thumb
            ENDSWITCH
          ENDIF                    
          IF (mouseEventDynArray["ACTION"] = "UP") THEN
            QUITLOOP        ; UP ends this event loop
          ENDIF
        ENDWHILE                

        ScrollBar_RestoreImageContext()

        RETURN 1            ; This mouse click would change focus
      ELSE
        RETURN 0            ; Click somewhere besides scroll-bar
      ENDIF
    OTHERWISE :             ; A trigger that we don't use
    RETURN 0
  ENDSWITCH
ENDPROC

PROC ScrollBar_SaveImageContext()
; USEVARS rec,prevImage

  IF (UPPER(Table()) <> ScrollBar_TableName) THEN
    IF (SysMode() = "CoEdit") THEN
      SWITCH
        CASE RecordStatus("New") :
          COPYTOARRAY rec   ; Save changes
          DEL               ; Remove the record
        CASE RecordStatus("Modified") :
          COPYTOARRAY rec   ; Save changes
          SETBATCH ON
          UNDO
          LOCKRECORD
          SETBATCH OFF
      ENDSWITCH                                                        
    ENDIF
    prevImage = ImageNo()
    MOVETO ScrollBar_TableName
  ELSE
    prevImage = 0
  ENDIF       
ENDPROC

PROC ScrollBar_RestoreImageContext()
; USEVARS rec,prevImage

  IF (prevImage <> 0) THEN
    MOVETO prevImage
    IF IsAssigned(rec) THEN   ; Then we used it
      IF NOT RecordStatus("Locked") THEN
        INS
      ENDIF
      COPYFROMARRAY rec
    ENDIF
  ENDIF
ENDPROC

PROC ScrollBar_MoveRows(Offset)
PRIVATE prevImage
; EXIT   If entry on a different table with a modified record,
;        record will be posted if possible.
;        This behavior could be removed by COPYTOARRAY

  SKIP Offset
  ; We are on the correct table already
  ScrollBar_SynchronizeBar()
ENDPROC

PROC ScrollBar_SynchronizeBar()
PRIVATE prevImage

  IF (RecNo() > ScrollBar_RegionHeight) THEN
    newThumbOffset = INT(((ScrollBar_BotRow-ScrollBar_TopRow)-2)*
                     (RecNo() / NImageRecords())) + 1
  ELSE
    newThumbOffset = 1
  ENDIF                                
  IF (newThumbOffset <> ScrollBar_ThumbOffset) THEN
    ScrollBar_ResetThumb(newThumbOffset)
  ENDIF
ENDPROC

PROC ScrollBar_ResetThumb(newOffset)
; USEVARS ScollBar_ThumbOffset

  ; Reset old
  ScrollBar_Array[ScrollBar_ThumbOffset] = ScrollBar_BarChar
  ScrollBar_Array[newOffset] = ScrollBar_ThumbChar   ;;  set new
  ECHO OFF ECHO NORMAL   ; Refresh the calculated field
  ScrollBar_ThumbOffset = newOffset
ENDPROC

; This procedure conpensates for form windows being
; scrolled and moved.
;
; Note that we can add elements to the dynamic array
; because it is being passed by reference instead of
; by value.
PROC ScrollBar_SetFormRowCol(eventDynArray)
; Sets ["FormRow"] and ["FormCol"]
PRIVATE windowDynArray
    
  IF (WindowAt(eventDynArray["ROW"],eventDynArray["COL"]) <> 0) THEN
    WINDOW GETATTRIBUTES WindowAt(eventDynArray["ROW"],eventDynArray["COL"])
      TO windowDynArray
    eventDynArray["FormRow"] = ((eventDynArray["ROW"] +
                               windowDynArray["SCROLLROW"]) - 
                               windowDynArray["ORIGINROW"])
    eventDynArray["FormCol"] = ((eventDynArray["COL"] +
                               windowDynArray["SCROLLCOL"]) -
                               windowDynArray["ORIGINCOL"])
  ELSE
    eventDynArray["FormRow"] = eventDynArray["ROW"] 
    eventDynArray["FormCol"] = eventDynArray["COL"] 
  ENDIF
ENDPROC

Demo()
