PROC CLOSED MakeScrollBar()
  ScrollBarColor = 19     ;;  cyan on blue

  SHOWDIALOG "Set up Vertical Scroll Bar"
    PROC "SetUpDProc" TRIGGER "UPDATE","ACCEPT"
    @ 3,2 HEIGHT 17 WIDTH 50
    @ 11,02 ?? "Script:"
    PICKTABLE  @ 01,05 HEIGHT 08 WIDTH 40 COLUMNS 3 "."
      TO picktablename
    ACCEPT     @ 11,10 WIDTH 35 "A64" TAG "Script Name" TO scriptname
    PUSHBUTTON @ 13,10 WIDTH 10 "~O~K" OK DEFAULT TO Retval
    PUSHBUTTON @ 13,30 WIDTH 10 "~C~ancel" CANCEL TO Retval
  ENDDIALOG

  IF Retval THEN
    DYNARRAY EmbeddedTableList[]

    ECHO OFF
    MENU {Forms} {Change}
      SELECT PickTableName
      SELECT PickFormName ENTER
    WINMAX
    UP                           ; Wrap to last Row
    CTRLEND                      ; Far right
    maxformCol = ColNo()
    MESSAGE "Scanning form"
    WHILE True
      CTRLHOME                 ; Far left
      WHILE True
        IF MATCH(FieldInfo(),"Embedded .. table using form ..",
                            embeddedtablename,embeddedformname) THEN
          EmbeddedTableList[embeddedtablename + "  Form: " + 
            embeddedformname] = STRVAL(RowNo()) + ":" +
            STRVAL(ColNo())
        ENDIF     
        RIGHT                        
        IF ColNo() = 1 THEN
          QUITLOOP
        ENDIF
      ENDWHILE
      IF RowNo() = 1 THEN
        QUITLOOP
      ELSE
        UP
      ENDIF                        
    ENDWHILE
    MESSAGE ""
    ECHO NORMAL
    SHOWDIALOG "Pick an embedded form"
      @ 6,17 HEIGHT 14 WIDTH 42
      PICKDYNARRAYINDEX @ 01,02 HEIGHT 8 WIDTH 36
        EmbeddedTableList TO PickEmbeddedTableName
        PUSHBUTTON @ 10,05 WIDTH 10 "~O~K" OK DEFAULT TO Retval
        PUSHBUTTON @ 10,25 WIDTH 10 "~C~ancel" CANCEL TO Retval
    ENDDIALOG                
    IF NOT Retval THEN
      CANCELEDIT              ;;      exit designer
      RETURN False
    ENDIF
    ECHO OFF
    
    ; Set default position
    Retval = MATCH(EmbeddedTableList[PickEmbeddedTableName],
               "..:..",VBarRow,VBarCol)
    CTRLEND
    WHILE (ColNo() <> MIN(maxformCol,NUMVAL(VBarCol) + 2))
      LEFT
    ENDWHILE
    END                             ;;      bottom Row
    WHILE (RowNo() <> NUMVAL(VBarRow))
      UP
    ENDWHILE

    ECHO NORMAL
    MESSAGE "Indicate where you want the top of the bar"
    WHILE True
      GETEVENT MOUSE "DOWN" KEY "ESC","ENTER" TO Retval
      SWITCH
        CASE (Retval["TYPE"] = "KEY") AND
             (Retval["KEYCODE"] = ASC("ESC")) :
          CANCELEDIT              ;;      exit designer
          RETURN False
        CASE (Retval["TYPE"] = "KEY") AND
             (Retval["KEYCODE"] = ASC("Enter")) :
        OTHERWISE :
          EXECEVENT Retval        ;;      move to the spot
          IF NOT Retval["DOUBLECLICK"] THEN
            LOOP
          ENDIF
      ENDSWITCH
      QUITLOOP
    ENDWHILE
    VBarRow = RowNo()
    VBarCol = ColNo()

    ECHO OFF
    MENU {Field} {Place} {Calculated} TYPEIN "\"\\030\""
    ENTER ENTER LEFT ENTER LEFT
    ECHO NORMAL
    MESSAGE "Indicate where you want the bottom of the bar"
    WHILE True
      GETEVENT MOUSE "DOWN" KEY "ESC","ENTER" TO Retval
      SWITCH
        CASE (Retval["TYPE"] = "KEY") AND
             (Retval["KEYCODE"] = ASC("ESC")) :
          CANCELEDIT              ;;      exit designer
          RETURN False
        CASE (Retval["TYPE"] = "KEY") AND
             (Retval["KEYCODE"] = ASC("Enter")) :
        OTHERWISE :
          EXECEVENT Retval        ;;      move to the spot
          IF NOT Retval["DOUBLECLICK"] THEN
            LOOP
          ENDIF
      ENDSWITCH
      Retval["Col"] = ColNo()
      Retval["Row"] = RowNo()

      SWITCH
        CASE Retval["Col"] <> VBarCol :
          BEEP
          MESSAGE "Please click in the same Column"
          LOOP
        CASE Retval["Row"] < VBarRow :
          BEEP
          MESSAGE "Please click below the top of the bar"
          LOOP
        CASE ((Retval["Row"] - VBarRow) < 5) :
          BEEP
          MESSAGE "Please click at least five Rows "+
                  "below the top of the bar"
          LOOP
      ENDSWITCH
      QUITLOOP
    ENDWHILE
    
    MESSAGE "Setting vertical scroll-bar"
    yBarRow = RowNo()
    yBarCol = ColNo()
    ECHO OFF
    MENU {Field} {Place} {Calculated} TYPEIN "\"\\031\""
    ENTER ENTER LEFT ENTER LEFT
        
    ECHO OFF
    Retval = MATCH(PickEmbeddedTableName,"..  Form: ..",
               EmbeddedTableName,EmbeddedFormName)
    WHILE (RowNo() > (VBarRow + 1))
      UP
      MENU {Field} {Place} {Calculated} 
      TYPEIN "ScrollBar_Array["+STRVAL(RowNo()-VBarRow)+"]" 
      ENTER ENTER HOME ENTER LEFT
    ENDWHILE
    UP                   ; Color top Row too
    MENU {Style} {Color} {Area} ENTER 
    WHILE (RowNo() < yBarRow)
      DOWN
    ENDWHILE
    ENTER 

    ; Pick Color    
    HOME
    FOR counter FROM 1 TO INT(ScrollBarColor / 16)
      DOWN
    ENDFOR
    FOR counter FROM 1 TO MOD(ScrollBarColor,16)
      RIGHT
    ENDFOR
    ENTER

    DO_IT!          ; Save form

    COEDIT EmbeddedTableName
    FormID = "F"                ;;      default
    IF MATCH(EmbeddedFormName,"F,..",  FormID) OR 
       MATCH(EmbeddedFormName,"F..,..",FormID) OR 
       MATCH(EmbeddedFormName,"F")             OR 
       MATCH(EmbeddedFormName,"F..",   FormID) THEN
    ENDIF
    PICKFORM FormID
    IF FormType("MultiRecord") THEN
      FormHeight = NRows()
    ELSE
      FormHeight = 1
    ENDIF
    DO_IT!
    CLEARIMAGE
    
    IF scriptaction = "Overwrite" THEN
      EDITOR NEW scriptname + ".SC"
      WINCLOSE
    ENDIF

    FILEWRITE APPEND scriptname + ".SC" FROM
      "\nPROC ScrollBar_Init()\n" +
      "    PRIVATE counter\n\n" +
      "    ScrollBar_TableName      =   \""+UPPER(EmbeddedTableName)+
      "\"\n" +
      "    ScrollBar_MasterTableName =   \"" + UPPER(PickTableName) +
      "\"\n" +
      "    ScrollBar_TopRow         =   " + STRVAL(VBarRow) + "\n" +
      "    ScrollBar_BotRow         =   " + STRVAL(YBarRow) + "\n" +
      "    ScrollBar_Col            =   " + STRVAL(VBarCol) + "\n" +
      "    ScrollBar_ThumbChar      =  \"\\254\"\n" +
      "    ScrollBar_BarChar       =   \"\\177\"\n" +
      "    ScrollBar_RegionHeight   = " + STRVAL(FormHeight) + "\n" +
      "    ScrollBar_ThumbOffset    = 1\n" +
      "    ARRAY ScrollBar_Array["+STRVAL((YBarRow-VBarRow)-1)+"]\n" +
      "    ScrollBar_Array[1] = ScrollBar_ThumbChar\n" +
      "    FOR counter FROM 2 TO "+STRVAL((YBarRow-VBarRow)-1)+"\n" +
      "        ScrollBar_Array[counter] = ScrollBar_BarChar\n" +
      "    ENDFOR\n" +
      "ENDPROC\n\n"
  ENDIF

ENDPROC

PROC SetUpDProc(a,b,c,d)
PRIVATE corescriptname

  SWITCH
    CASE a = "ACCEPT":
      scriptaction = "Append"
      IF MATCH(scriptname,"..\".SC\"",corescriptname) THEN
        scriptname = corescriptname
      ENDIF
      SWITCH
        CASE IsBlank(scriptname):
          MESSAGE "Script name required"
          SELECTCONTROL "Script Name"
          RETURN False
        CASE (DirExists(scriptname + ".SC") = -1) OR 
             MATCH(scriptname,"..\\") :
          MESSAGE "Illegal script name"
          SELECTCONTROL "Script Name"
          RETURN False
        CASE IsFile(scriptname + ".SC") :
          SHOWMENU
            "Append" :    "Append to existing script",
            "Overwrite" : "Overwrite existing script",
            "Cancel" : "Do not save script"
            TO scriptaction
          IF (scriptaction <> "Append")    AND
             (scriptaction <> "Overwrite") THEN
            RETURN False
          ENDIF                                
      ENDSWITCH
      TABLEINFO PickTableName FORMS TO bag
      SHOWDIALOG "Pick a form" @ 12,15 HEIGHT 10 WIDTH 30
        PICKDYNARRAYINDEX @ 01,04 
        HEIGHT 03 WIDTH 20 ColUMNS 3 bag 
        TO PickFormName
        PUSHBUTTON @ 06,02 WIDTH 10 "~O~K" OK DEFAULT TO Retval
        PUSHBUTTON @ 06,15 WIDTH 10 "~C~ancel" CANCEL TO Retval
      ENDDIALOG
      RETURN Retval
  ENDSWITCH
ENDPROC

MakeScrollBar()
