;*************************************************************************
; Script Listing
; Date : 02/27/90
; Time : 06:42:46 pm
;
; System : RETK Demo
; Last modified 02/27/90  06:37:46 pm
;*************************************************************************


; File Name : RETKSC.SC
; By : Michael Clifford
; RETK Demo
; does not include:
; all multi-user error checking and error handling
;
; Example of Report Extraction ToolKit
; Copyright (c) 1990  Computer Essentials, Inc.
; For use with attribution
;
; Useage: RETK("tablename")
; Where "tablename" is a RETK specification table
;

PROC setup.codes()
  ; sets up codes for each report
  ; depending upon setting
  ; assumes main mode
  SWITCH
    CASE rs.a["Setup Source"] = "G" AND global.set.l = TRUE :
      MENU {Report} {SetPrinter} {Override} {Setup} CTRLBACKSPACE  TYPEIN global.set.ar["Setup String"]  ENTER
      MENU {Report} {SetPrinter} {Override} {PrinterPort} SELECT global.set.ar["Port"]
    CASE rs.a["Setup Source"] = "T" :
      MENU {Report} {SetPrinter} {Override} {Setup} CTRLBACKSPACE   TYPEIN rs.a["Setup String"] ENTER
      MENU {Report} {SetPrinter} {Override} {PrinterPort} SELECT rs.a["Setup Port"]
    OTHERWISE : MENU {Report} {SetPrinter} {Regular}
  ENDSWITCH
ENDPROC

PROC cmessage(line.n,msgtype.a,ce_message.a)
  PRIVATE mrow.n,mcol.n,att.n,lmes.n
  ; Paints messages on canvas according to codes passed
  ; Parameter Legend:  supply one of three below:
  ;       S - Status Message - Same Color as top two lines
  ;       P - Pending Message - Same Color as above, but blinks
  ;       M - Message         - message color
  ;       W - Warning Message - blinking message

  ; save the original cursor
  mrow.n = ROW()
  mcol.n = COL()
  CURSOR OFF
  SWITCH
    CASE MATCH(msgtype.a,"..S..") : att.n = SYSCOLOR(0)
    CASE MATCH(msgtype.a,"..P..") : att.n = SYSCOLOR(0) + 128
    CASE MATCH(msgtype.a,"..M..") : att.n = SYSCOLOR(3)
    CASE MATCH(msgtype.a,"..W..") : att.n = SYSCOLOR(3) + 128
    OTHERWISE : att.n = SYSCOLOR(0)
  ENDSWITCH
  IF MATCH(msgtype.a,"..E..") THEN ECHO FAST ECHO OFF
  ENDIF
  PAINTCANVAS ATTRIBUTE att.n line.n,0,line.n,79
  STYLE ATTRIBUTE att.n
  lmes.n = LEN(ce_message.a)
  @ line.n,0 ce_message.a = FORMAT("W80,AC",ce_message.a)
  ?? ce_message.a
  STYLE
  @ mrow.n,mcol.n
  CURSOR NORMAL
ENDPROC

PROC c(dc.a,n)
  ; moves over workspace in specified direction and number of times
  PRIVATE dc.a,direct.a,counter.n,n
  dc.a = UPPER(SUBSTR(dc.a,1,1))
  SWITCH
    CASE dc.a = "U" : direct.a = "UP"
    CASE dc.a = "D" : direct.a = "DOWN"
    CASE dc.a = "L" : direct.a = "LEFT"
    CASE dc.a = "R" : direct.a = "RIGHT"
    OTHERWISE       :
      RETURN
  ENDSWITCH
  FOR counter.n FROM 1 TO n   KEYPRESS  direct.a
  ENDFOR
ENDPROC


PROC CLOSED RETK(mtable)
  ; kernel of RETK
  USEVARS AUTOLIB,ERRORPROC
  PRIVATE pull_plug.l,global.set.l,last_rec.n
  pull_plug.l = FALSE
  cmessage(24,"P","LOADING Report Extraction Toolkit (RETK)")
  ; all RETK configuration tables, scripts in Scripts directory
  IF NOT ISTABLE(SDIR() + mtable)
    THEN cmessage(24,"W", "Configuration Table Not Found. Aborting Operation. ")
    BEEP BEEP SLEEP 3000
    RETURN
  ENDIF

  last_rec.n = 1
  global.set.l = FALSE

  IF ISTABLE(SDIR() + "prntstr") ; global configuration setup strings
    THEN
    VIEW SDIR()+ "Prntstr" ; replica of print strings in Paradox3.cfg
    MOVETO FIELD "Name"   ; obtain global default (if any)
    LOCATE PATTERN "..*.."
    IF RETVAL
      THEN global.set.l = TRUE
      COPYTOARRAY global.set.ar ; place string, port in memory
    ENDIF
    CLEARIMAGE
  ENDIF

  WHILE NOT pull_plug.l
    header.a = ""
    CLEAR CLEARALL
    VIEW SDIR()+ mtable       ; RSpec table in Scripts Directory
    MOVETO RECORD last_rec.n  ; move to choice selected last
    FORMKEY

    WHILE TRUE
      ECHO FAST ECHO OFF
      @1,0 CLEAR EOL
      @0,0 CLEAR EOL
      @0,0 ?? "<F2> to Select Report, Esc to Quit"
      SYNCCURSOR
      PAINTCANVAS ATTRIBUTE SYSCOLOR(3) ROW(),10,ROW(),54
      RETVAL =  GETCHAR()
      SWITCH

        CASE RETVAL = -75   : BEEP ; Left
        CASE RETVAL = -60   :      ; F2
          last_rec.n = [#]
          COPYTOARRAY rs.a          ; copy Rspec info to array
          CLEARIMAGE
          IF rs.a["R Category"] < 5 ; one of 4 report events
            THEN setup.codes() gen_rpt()
          ELSE Clear EXECPROC rs.a["UI Proc"] ; execute custom report proc
          ENDIF
          QUITLOOP
        CASE RETVAL = 27    : pull_plug.l = TRUE
          QUITLOOP
        OTHERWISE : KEYPRESS RETVAL
      ENDSWITCH
    ENDWHILE
  ENDWHILE
  RESET
  CLEAR
  cmessage(24,"P", "Exiting Report Extraction Toolkit ")
  MENU {Report} {SetPrinter} {Regular}
  IF ISFILE(PRIVDIR() + "Temp$.Txt") THEN
    RUN NOREFRESH "  DEL " + PRIVDIR() + "Temp$.Txt > NUL "
  ENDIF
ENDPROC


PROC gen_rpt()
  ; Generates report according to previously stored events
  PRIVATE  rptchoice.a,dest.a,printstat.l,hd_choice.a

  WHILE TRUE
    CLEAR
    cmessage(24,"S",rs.a["Description"])
    SHOWMENU
      "Automatic"         : "Print All Possible Entries for " + rs.a["Description"],
      "Design_Yourself"   : "Generate an Ad Hoc Query (At Own Risk!)"
    TO rptchoice.a
    IF rptchoice.a = "Esc" THEN printstat.l = FALSE
      QUITLOOP
    ENDIF
    printstat.l = dest_process.l()

    SWITCH
      CASE NOT printstat.l                 :
        QUITLOOP
      CASE rptchoice.a = "Automatic"
        AND rs.a["R Category"] = 1          : issue_rpt()
        ; issue directly from source table
      OTHERWISE : answer_process() ; process from Answer table
    ENDSWITCH
    QUITLOOP
  ENDWHILE
  CLEARALL CLEAR
  RETURN printstat.l
ENDPROC


PROC hdg_on_fly()
  ; places heading on report
  ; either specified by user or by assignment of header.a from procedure
  PRIVATE x,til.a,mvar.a,tralbs.a,sr.var.n,start.position.n

  IF ISBLANK(header.a)
    THEN header_exist.l = FALSE
  ELSE header_exist.l = TRUE
  ENDIF
  IF NOT header_exist.l
    THEN cmessage(24,"W","No Descriptive Heading Selected") BEEP BEEP SLEEP 1500
    RETURN
  ENDIF
  cmessage(24,"P","Attempting to Add Descriptive Heading to Report")
  MENU {Report} {Change} SELECT "Answer" SELECT rs.a["RSpec - D#"]  ENTER

  ; Move down all rows in Report workspace
  ; Assume only one pagewidth
  FOR x FROM 1 TO NROWS() ; Tilde Variable Method
    CTRLHOME
    ; Method I: Assign to first tilde (~) encounted on workspace
    IF MATCH(CURSORLINE(),"..~..")
      THEN
      WHILE CURSORCHAR()<>"~" RIGHT
      ENDWHILE
      TYPEIN header.a
      RETURN
    ENDIF
    ; Method II: Type centered over the words "Standard Report"
    IF MATCH(CURSORLINE(),"..Standard Report..") ; length of 15
      THEN
      WHILE CURSORCHAR()<>"S" RIGHT
      ENDWHILE
      TYPEIN FORMAT("W40,AL", header.a)
      RETURN
    ENDIF
    DOWN
  ENDFOR
  ; Method III - Last ditch effort
  ; find a place to park heading
  ; find first line of Page header, move down one line
  HOME CTRLHOME
  start.position.n = INT(PAGEWIDTH() - LEN(header.a))/2
  c("R",start.position.n)
  WHILE NOT MATCH(CURSORLINE(),"..page..")
    DOWN
  ENDWHILE
  DOWN
  ; check to see if the header does not obliterate
  ; existing text in report
  line_ck.a = SUBSTR(CURSORLINE(),COLNO(),LEN(header.a))
  IF NOT MATCH(BANDINFO(),"Group..") AND line_ck.a = ""
    THEN TYPEIN header.a
  ENDIF
ENDPROC

PROC answer_process()
  ; manages printing from Answer table
  PRIVATE printstat.l,mhex.l,answer.header.l,ok.copy.l
  printstat.l = FALSE
  IF ISTABLE("Answer") THEN DELETE "Answer"
  ENDIF

  IF rs.a["R Category"] =  1
    THEN {Ask} SELECT rs.a["STable"]
    CHECKPLUS                   ; query directly on source table
  ELSE EXECPROC rs.a["Query Proc"] ; query from provided Query/Endquery
  ENDIF

  ad.hoc.print.l = FALSE
  IF rptchoice.a = "Design_Yourself"
    THEN ad.hoc.print.l = manual_ad_hoc() ; create own query (NOT Run-Time)
  ELSE ; call user-interface routine to prompt for entry
    CLEAR
    IF rs.a["UI Proc"] <> "NA"
      THEN EXECPROC rs.a["UI Proc"]
    ENDIF
  ENDIF

  ; verify that answer table produced by all above procedures, events.
  IF NOT ISTABLE("Answer") THEN cmessage(24,"P","Generating Query.") DO_IT!
  ENDIF
  ; verify that records were produced.
  IF NOT ISEMPTY("Answer") THEN ad.hoc.print.l = TRUE
  ENDIF

  IF NOT ad.hoc.print.l
    THEN cmessage(24,"W","No Records to Report from Query") BEEP SLEEP 2000
    RETURN
  ENDIF

  IF rs.a["RSpec - SDirec"] = "NA"
    THEN rspec.dir.a = ""
  ENDIF

  ; check for critical event - the copying of report spec to final table.
  ok.copy.l = FALSE
  IF rs.a["R Category"] <> 2 ; then must check for comp structures
    THEN ; check for successful transfer of report spec to destination table
    ok.copy.l = comp.stru.l(rspec.dir.a + rs.a["RSpec - STable"],"Answer")
    ; parses to   comp.stru.l(source table,answer) for category 1
    IF ok.copy.l THEN
      cmessage(24,"P","Copying Report")
      COPYREPORT rspec.dir.a + rs.a["RSpec - STable"] rs.a["RSpec - S#"]
      "Answer"  "R"
    ELSE cmessage(24,"P","Issuing Standard Report")
    ENDIF
  ENDIF
  get_header() ; check for existence of header and acquire if necessary.
  hdg_on_fly() ; place on report
  issue_rpt()  ; issue report to screen, printer, file
ENDPROC

PROC manual_ad_hoc()
  ; provides decision support.
  ; allows alteration of query image
  ; works only on interpretive Pdx, NOT Run-time.
  PRIVATE qchoice.a,q2.a,qerr.a,printstat.l
  WHILE TRUE
    MOVETO 1  ; move to top-most query image
    WAIT TABLE
      PROMPT "Enter Condition. " +
      " Press F2 When Done for Options",
      "Ctrl-D Deletes, Copies Checks (For OR Queries)"
      MESSAGE "Developing Query for: " + rs.a["Description"]
    UNTIL "F3","F4","F2","Ditto","Check","CheckPlus"

    ECHO OFF
    IF RETVAL = "Esc"
      THEN printstat.l = FALSE
      RETURN printstat.l
    ENDIF

    SWITCH
      CASE RETVAL = "Check" OR RETVAL = "CheckPlus" : KEYPRESS RETVAL
      CASE RETVAL = "Ditto" : ditto_checks()
      CASE RETVAL = "F3"  OR RETVAL = "F4" : KEYPRESS RETVAL
        IF IMAGETYPE() = "Display" THEN BEEP UPIMAGE
        ENDIF
        LOOP

      CASE RETVAL = "F2"    :
        ECHO FAST ECHO OFF

        SHOWMENU
          "Change"   : "Change Query for "   + rs.a["Description"],
          "Approve"  : "Approve Query for "  + rs.a["Description"],
          "Sample"   : "Generate Sample 2 Page Report to Screen."
        TO qchoice.a

        SWITCH
          CASE qchoice.a = "Approve"  :
            ; if header already provided, then delete
            ; to force end-user to respecify with new query
            header.a = ""
            get_header()
            DO_IT!
            qerr.a = WINDOW() ; check for possible error message
            IF qerr.a <> ""
              THEN BEEP cmessage(24,"WE",qerr.a)
              SLEEP 2000
            ELSE
              IF ISEMPTY("Answer")
                THEN cmessage(24,"WE","Query Too Restrictive") BEEP BEEP
                SHOWMENU
                  "Relax_Query" : "Try Again. Relax Criteria for Query",
                  "Abort_Report": "Do Not Print Report"
                  DEFAULT "Abort_Report"
                TO p.continue.a
                IF p.continue.a <> "Relax_Query"
                  THEN printstat.l = FALSE
                  QUITLOOP
                ENDIF
                CLEARIMAGE
              ELSE printstat.l = TRUE
                QUITLOOP
              ENDIF
            ENDIF

          CASE qchoice.a = "Sample" : ; print sample report (2 pages)
            DO_IT!
            qerr.a = WINDOW()
            IF qerr.a <> ""
              THEN BEEP cmessage(24,"WE",qerr.a)
              SLEEP 2000
            ELSE
              cmessage(24,"P","Generating Sample Report")
              {Report} {RangeOutput} {answer} {R} {Screen} {1} {2}
            ENDIF
            CLEARIMAGE
        ENDSWITCH
        MOVETO 1
        LOOP
    ENDSWITCH
  ENDWHILE
  CLEAR
  RETURN printstat.l
ENDPROC

PROC ditto_checks()
  ; copies checks from one row to another in query image
  PRIVATE mfield.a,x,mc.a
  mfield.a = FIELD()
  CTRLHOME RIGHT
  IF ROWNO() < 2
    THEN cmessage(24,"W", "You Must At Least Be on the Second Line")
    BEEP SLEEP 2000
  ELSE
    FOR x FROM 1 TO NFIELDS(TABLE())
      UP     mc.a = CHECKMARKSTATUS()
      DOWN   KEYPRESS mc.a RIGHT
    ENDFOR
    MOVETO FIELD mfield.a
  ENDIF
ENDPROC

PROC get_header()
  ; acquires header if not already provided
  IF header.a = "" AND rptchoice.a <> "Automatic"
    THEN
    ECHO FAST ECHO OFF
    PAINTCANVAS BORDER ATTRIBUTE SYSCOLOR(3) 17,19,23,68
    PAINTCANVAS ATTRIBUTE SYSCOLOR(0) 18,20,22,67
    @ 19,21 ?? "You Have Selected A Query to Extract Records."
    @ 20,21 ?? "Please Document Query. Enter Heading Below!!!"
    cmessage(24,"S",rs.a["Description"])
    @ 22,62 ?? "<---"
    @ 22,21 ?? ">"
    ACCEPT "A40" PICTURE "*[!]" TO header.a
    IF ISBLANK(header.a) OR header.a = "Esc"
      THEN header.a = "DERIVED FROM QUERY. HEADING NOT ENTERED"
    ENDIF
    CLEAR
  ENDIF
ENDPROC

PROC comp.stru.l(stable.a,dtable.a)
  ; Returns a True
  ; if structures compatible but not same table
  ; Returns false if not compatible or if same table
  ; Circumvents problem of copying table to itself
  ; uses revision of method by A. Zeinreich
  ; rather then menuchoice() method
  PRIVATE comp.stru.a
  IF UPPER(stable.a) = UPPER(dtable.a)
    THEN
    RETURN FALSE
  ENDIF
  MENU {Tools} {Copy} {JustFamily}
  SELECT stable.a
  TYPEIN dtable.a ENTER
  comp.stru.a = WINDOW()
  CTRLBREAK
  IF comp.stru.a = ""
    THEN
    RETURN TRUE
  ELSE
    RETURN FALSE
  ENDIF
ENDPROC

PROC nprint(toggle.a)
  ; checks network printer
  ; and uses OPEN/CLOSE Printer syntax
  IF dest.a = "Printer" THEN
    IF NETTYPE() <> "SingleUser"  AND UPPER(toggle.a) = "ON"
      THEN OPEN PRINTER
    ENDIF
    IF NETTYPE() <> "SingleUser"  AND UPPER(toggle.a) = "OFF"
      THEN CLOSE PRINTER
    ENDIF
  ENDIF
ENDPROC

PROC issue_rpt()
  ; issues report to selected destination
  cmessage(24,"P","Reporting to " + dest.a + ". Please Be Patient. ")
  nprint("ON")
  IF SYSMODE() = "Report" ; issuing report after applying header in
    ; Report Design
    THEN MENU {Output}
  ELSE MENU {Report} {Output} SELECT rs.a["DTable"] SELECT rs.a["RSpec - D#"]
    ; reporting a Category 1 Report Directly from Source Table
  ENDIF

  SWITCH ; check destination
    CASE dest.a = "Screen" : ; report from file to private directory. Use LIST.COM

      rfile.txt.a = PRIVDIR() + "Temp$.Txt"
      SELECT "File"  TYPEIN rfile.txt.a  ENTER ;  "Temp.TXT" Enter
      IF MENUCHOICE() = "Cancel" THEN SELECT "Replace"
      ENDIF
      RUN NOREFRESH SDIR() + "LIST " + rfile.txt.a

    CASE dest.a = "File"  : ; write file also to private directory.
      SELECT "File" TYPEIN rfile.txt.a ENTER
      RUN NOREFRESH SDIR() + "LIST " + rfile.txt.a
    OTHERWISE : SELECT "Printer" nprint("OFF")
  ENDSWITCH
  CLEAR
  IF SYSMODE() = "Report" THEN CANCELEDIT
  ENDIF

  ; now offer option for graph
  ; assumes Graph Proc in autolib and fabricated correctly

  CLEAR
  IF rs.a["Graph Proc"] <> "NA" AND rptchoice.a = "Automatic"
    THEN ; we know the exact structure of destination table
    ; and have a graphics proc available
    CLEAR
    cmessage(24,"S","A Graph Is Available for Viewing")
    SHOWMENU
      "ShowGraph" : "Show the Graph",
      "NoGraph"   : "Do Not Show the Graph"
    TO g.choice.a
    IF g.choice.a = "ShowGraph"
      THEN CLEAR EXECPROC rs.a["Graph Proc"]
    ENDIF
  ENDIF
  CLEAR
  CLEARALL
ENDPROC

PROC ckpr.l()
  ; one of three methods for checking printer
  ; uses the "Classic" method - the PrinterStatus() function
  ; may not reliably work with other than LPT1
  ; other two methods (window() and errorcode())
  PRIVATE temp.a,pchoice.a
  cmessage(24,"P","Checking Printer")
  WHILE CHARWAITING() temp.a = GETCHAR()
  ENDWHILE
  WHILE NOT PRINTERSTATUS()
    BEEP BEEP
    cmessage(24,"W","Printer is not ready. Retrying. Press Key for Options")
    IF NOT CHARWAITING()
      THEN
      LOOP
    ELSE
      SHOWMENU
        "Fix&Retry": "Fix Printer. Select This Option. Print Report",
        "NoPrint"  : "Abort, Do Not Print Report"
      TO pchoice.a
      @  0,0 CLEAR EOL
      @  1,0 CLEAR EOL
      @ 24,0 CLEAR EOL
      IF pchoice.a ="Fix&Retry"
        THEN cmessage(24,"P","Checking Printer Again")
        LOOP
      ELSE
        RETURN FALSE
      ENDIF
    ENDIF
  ENDWHILE
  RETURN TRUE
ENDPROC

PROC dest_process.l()
  PRIVATE printstat.l,r.file.opt.a
  printstat.l = FALSE
  ; add use of LIST.COM
  ; attribute to ver beurg
  CLEAR
  cmessage(24,"S",rs.a["Description"])
  SHOWMENU
    "Printer" : "Report to Printer",
    "Screen"  : "Report to Screen",
    "File"    : "Report to File"
  TO dest.a

  IF dest.a = "Esc"
    THEN
    RETURN printstat.l
  ELSE printstat.l = TRUE
  ENDIF
  IF dest.a = "Printer" THEN printstat.l = ckpr.l()
  ENDIF
  IF dest.a = "File"
    THEN
    WHILE TRUE
      CLEAR
      @ 1,0 ?? "Report is Written in Your Private Directory"
      @ 0,0 ?? "Enter File Name to Write Report: "
      ACCEPT "A12" PICTURE "{&,#,_}*7[&,#,_].*3[&,#,_]" REQUIRED
      TO rfile.txt.a
      CLEAR

      IF NOT RETVAL THEN printstat.l = FALSE
        QUITLOOP
      ENDIF

      rfile.txt.a = PRIVDIR() + rfile.txt.a
      IF ISFILE(rfile.txt.a)
        THEN BEEP BEEP cmessage(24,"W","File Name (" + rfile.txt.a + ") Already Exists")
        SHOWMENU
          "Cancel"  : "Cancel Report",
          "Replace" : "Replace Existing File ("+ rfile.txt.a +")",
          "New_Name": "Use A New Name"
          DEFAULT "New_Name"
        TO r.file.opt.a

        SWITCH
          CASE r.file.opt.a = "New_Name"  :
            LOOP
          CASE r.file.opt.a = "Replace"   : printstat.l = TRUE
            QUITLOOP
          OTHERWISE : printstat.l = FALSE
            QUITLOOP
        ENDSWITCH
      ELSE
        QUITLOOP
      ENDIF
    ENDWHILE
  ENDIF
  RETURN printstat.l
ENDPROC

