; RAPPROCS.SC
; Test script of procedures
; unique to each application
; to produce reports
; drives RETK

CREATELIB "RAPPROCS"

PROC cust_all()
    ; uses all fields in customer
    ; category 4 report
    Menu {Ask} SELECT "Customer" CheckPlus
    MOVETO FIELD "Credit"
    TYPEIN "> 1000000"
ENDPROC


PROC custcred()
 ; Example of Query Proc to
 ; produce customers with credit limit > 1 Mil

   Query

    Customer |  Cust ID   | Last Name  |  Credit            |
             | CheckPlus  | CheckPlus  | CheckPlus >1000000 |

   Endquery

   ; pass header directly to report
   header.a = "CUSTOMERS WITH CREDIT LIMIT > 1 MIL"
   ; note!   Do_It! not here.
ENDPROC

PROC custui()
  ; example of use of UI Proc

  PRIVATE cr.c
   CLEAR
   CMESSAGE(24,"S",rs.a["Description"])
   @ 10,10 ?? "Enter A Credit Limit "
   ACCEPT "$" MIN 0 TO cr.c
   MOVETO FIELD "Credit"
   CtrlBackSpace
   TYPEIN " > " + STRVAL(cr.c)
   header.a = "CUSTOMERS WITH CREDIT LIMIT  > " + FORMAT("W12,E$C",cr.c)
   CLEAR
ENDPROC


PROC custpurc()
  ; produces answer table
  ; from more than one table

   Query

    Customer | Cust ID  | Last Name |
             | Check _c | Check     |

    Bookord |   Cust |
            |     _c |

   Endquery

   header.a = "CUSTOMERS WHO ORDERED BOOKS"
ENDPROC


PROC custgr()
 ; draws customer graph
 ; could be Much more complicated and robust
 MOVETO FIELD "Credit"
 Menu {Image} {Graph} {Load} {custcr}
 GraphKey
 ClearAll Clear
ENDPROC


Proc Median_Calc()
; proc for category 5
; reports Median figure, which cannot be done by Report Generator
ClearAll Clear
CMESSAGE(0,"S","Median Credit Limit for Customers")
CMESSAGE(24,"P","Processing Query")
Menu {Ask} SELECT "customer" MOVETO FIELD "Credit"  Check
DO_IT!
CMESSAGE(24,"S","Press Any Key When Done.")
numrec.n = NRECORDS("Answer")
IF MOD(numrec.n,2) = 0
THEN
 ; even number of records
 MOVETO RECORD numrec.n/2
 @  5,10 ?? "Mean Credit Limit Is"
 @  5,40 ?? FORMAT("W16.2,E$C",[Credit])
ELSE ; uneven number
 MOVETO RECORD (numrec.n-1)/2
 @ 5,10 ?? "Median Credit Limit Between "
 @ 5,40 ?? FORMAT("W16.2,E$C",[Credit])
 SKIP
 @ 5,60 ?? "And ",FORMAT("W16.2,E$C",[Credit])
ENDIF
x=getchar()
ClearAll

ENDPROC


WRITELIB "Rapprocs" custcred,custui,custpurc,custgr,Median_calc,cust_all
RELEASE PROCS ALL

