;---------------------------------------------------------------------
; RENOBMGR.SC - Renaissance (Object Manager and Event Handler)
;---------------------------------------------------------------------


IF NOT ISASSIGNED(LibName) THEN
  Ver = STRVAL(VERSION())
  DotLoc = SEARCH(".", Ver)
  IF DotLoc > 0 THEN
    Ver = SUBSTR(Ver, 1, DotLoc - 1) + SUBSTR(Ver, DotLoc + 1, 2)
  ENDIF
  LibName = SDIR() + "Ren" + Ver
  RELEASE VARS Ver, DotLoc
ENDIF


PROC RenObjectMgr.Create(RenProps)
  PRIVATE si, RenStyle, RenColor

  SETCANVAS DEFAULT
  CURSOR OFF

  DYNARRAY Ren[]
  Ren["OBJECTCOUNT"]     = 0
  Ren["OBJECTLIST"]      = ""
  Ren["CURRENTOBJECT"]   = ""
  Ren["CURRENTWINDOW"]   = 0

  Ren["RECORDSTATUS"]    = ""
  Ren["IMAGERIGHTS"]     = ""
  Ren["WORKSPACEOBJECT"] = ""
  Ren["WORKSPACEWINDOW"] = 0

  Ren["ISFILTER"]        = FALSE
  Ren["FILTEROBJECT"]    = ""
  Ren["FILTERTABLE"]     = ""
  Ren["FILTERWINDOW"]    = 0
  Ren["TABLEWINDOW"]     = 0
  Ren["TABLEOBJECT"]     = ""
  Ren["MAINTABLE"]       = ""

  Ren["TEMPFILENUM"]     = 1
  Ren["TEMPTITLENUM"]    = 1
  Ren["TEMPTAGNUM"]      = 1

  IF ISASSIGNED(RenProps["MESSAGECOLOR"]) THEN
    Ren["MESSAGECOLOR"] = RenProps["MESSAGECOLOR"]
  ELSE
    Ren["MESSAGECOLOR"] = 31
  ENDIF

  IF ISASSIGNED(RenProps["WARNINGCOLOR"]) THEN
    Ren["WARNINGCOLOR"] = RenProps["WARNINGCOLOR"]
  ELSE
    Ren["WARNINGCOLOR"] = 116
  ENDIF

  IF ISASSIGNED(RenProps["INFOCOLOR"]) THEN
    Ren["INFOCOLOR"] = RenProps["INFOCOLOR"]
  ELSE
    Ren["INFOCOLOR"] = 113
  ENDIF

  IF ISASSIGNED(RenProps["YESNOCOLOR"]) THEN
    Ren["YESNOCOLOR"] = RenProps["YESNOCOLOR"]
  ELSE
    Ren["YESNOCOLOR"] = 126
  ENDIF

  IF ISASSIGNED(RenProps["EXITMESSAGE"]) THEN
    Ren["EXITMESSAGE"] = RenProps["EXITMESSAGE"]
  ELSE
    Ren["EXITMESSAGE"] = ""
  ENDIF

  Ren["DISPATCHLIST"]    = ""
  Ren["RUN"]             = TRUE
  Ren["LASTTABLEOBJECT"] = ""
  Ren["LASTTABLE"]       = ""
  Ren["LASTFIELD"]       = ""
  Ren["LASTMODIFIED"]    = FALSE

  Ren["GETEVENTMETHOD"]  = "GETEVENT" ; Options: GETEVENT
                                      ;          WAITWORKSPACE

 ; Ren["DISPATCHMETHOD"]  = "CURRENT"  ; Options: CURRENT
 ;                                     ;          CHILDTOPARENT
 ;                                     ;          PARENTTOCHILD

  Ren["DEPARTFIELD"]     = TRUE
  Ren["DEPARTROW"]       = TRUE
  Ren["DEPARTPAGE"]      = TRUE
  Ren["ARRIVEFIELD"]     = TRUE
  Ren["ARRIVEROW"]       = TRUE
  Ren["ARRIVEPAGE"]      = TRUE
  Ren["TOUCHRECORD"]     = TRUE

  Ren["ADDONERECORD"]    = FALSE
  Ren["QUICKDISPLAY"]    = FALSE
  Ren["SETUP"]           = FALSE
  Ren["EVENTMONITOR"]    = ""

  IF ISASSIGNED(RenProps["ECHO"]) THEN
    Ren["ECHO"] = RenProps["ECHO"]
  ELSE
    Ren["ECHO"] = TRUE
  ENDIF

  IF ISASSIGNED(RenProps["SETUP"]) THEN
    Ren["SETUP"] = RenProps["SETUP"]
  ENDIF

  Ren["SAVEBACKGROUNDCOLOR"] = SYSCOLOR(1000)

  IF NOT ISASSIGNED(RenProps["BACKGROUNDCOLOR"]) THEN
    Ren["BACKGROUNDCOLOR"] = SYSCOLOR(1000)
  ELSE
    RenObjectMgr.SetDesktopColor(RenProps["BACKGROUNDCOLOR"])
  ENDIF

  IF Ren["ECHO"] = TRUE THEN
    ECHO NORMAL
    ECHO OFF
  ENDIF

  Ren["LOOKUPHIGHLIGHT"] = FALSE
  Ren["HIGHLIGHTCOLOR"] = 12

  IF VERSION() >= 4.5 THEN
    IF ISASSIGNED(RenProps["LOOKUPHIGHLIGHT"]) THEN
      Ren["LOOKUPHIGHLIGHT"] = (RenProps["LOOKUPHIGHLIGHT"] = TRUE)
    ENDIF

    IF ISASSIGNED(RenProps["HIGHLIGHTCOLOR"]) THEN
      Ren["HIGHLIGHTCOLOR"] = RenProps["HIGHLIGHTCOLOR"]
    ENDIF
  ENDIF

  IF ISASSIGNED(RenProps["MESSAGECOLOR"]) THEN
    Ren["MESSAGECOLOR"] = RenProps["MESSAGECOLOR"]
  ENDIF

  IF Ren["SETUP"] <> TRUE THEN
    IF ISASSIGNED(RenProps["SETUPMESSAGE"]) AND RenProps["SETUPMESSAGE"] <> "" THEN
      RenMsg(RenProps["SETUPMESSAGE"])
    ENDIF
  ELSE
    Ren["DEFAULTSAVED"] = FALSE
  ENDIF

  IF ISASSIGNED(RenProps["EXITMESSAGE"]) THEN
    Ren["EXITMESSAGE"] = RenProps["EXITMESSAGE"]
  ENDIF

  IF ISASSIGNED(RenProps["WARNINGCOLOR"]) THEN
    Ren["WARNINGCOLOR"] = RenProps["WARNINGCOLOR"]
  ENDIF

  IF ISASSIGNED(RenProps["INFOCOLOR"]) THEN
    Ren["INFOCOLOR"] = RenProps["INFOCOLOR"]
  ENDIF

  IF ISASSIGNED(RenProps["YESNOCOLOR"]) THEN
    Ren["YESNOCOLOR"] = RenProps["YESNOCOLOR"]
  ENDIF

  IF ISASSIGNED(RenProps["MENUSTYLE"]) THEN
    RenStyle = UPPER(RenProps["MENUSTYLE"])
  ELSE
;    RenStyle = "Standard"
    RenStyle = "GUI"
  ENDIF

  IF ISASSIGNED(RenProps["MENUCOLOR"]) THEN
    RenColor = RenProps["MENUCOLOR"]
  ELSE
    RenColor = 112
;    RenColor = 48
  ENDIF

  RenObjectMgr.SetMenuStyle(RenStyle, RenColor)

  DYNARRAY RenTags[]
  DYNARRAY RenWindows[]
  DYNARRAY RenMonitors[]
  DYNARRAY RenIdleWatchers[]
ENDPROC
WRITELIB libname RenObjectMgr.Create
RELEASE PROCS RenObjectMgr.Create


PROC RenObjectMgr.SetMenuStyle(RenStyle, RenColor)
  PRIVATE c1,c2,c3,c4,c5,c6,RenColors

  IF RenColor > 127 THEN
    RenColor = RenColor - 128
  ENDIF

  IF UPPER(RenStyle) = "GUI" THEN
    Ren["MENUSTYLE"] = "GUI"

    IF NOT ISASSIGNED(Ren["SAVEMENUCOLORS"]) THEN
      Ren["SAVEMENUCOLORS"] = STRVAL(SYSCOLOR(1001)) + "," +
                             STRVAL(SYSCOLOR(1002)) + "," +
                             STRVAL(SYSCOLOR(1003)) + "," +
                             STRVAL(SYSCOLOR(1004)) + "," +
                             STRVAL(SYSCOLOR(1005)) + "," +
                             STRVAL(SYSCOLOR(1006))
    ENDIF

    SWITCH
      CASE RenColor < 16 :
        DYNARRAY RenColors[]
        RenColors[1001] = 7       ; Inactive Text
        RenColors[1002] = 8       ; Disabled Text
        RenColors[1003] = 15      ; Inactive Hotkey
        RenColors[1004] = 127     ; Current Text
        RenColors[1005] = 120     ; Current Disabled Text
        RenColors[1006] = 112     ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 32 :
        DYNARRAY RenColors[]
        RenColors[1001] = 19      ; Inactive Text
        RenColors[1002] = 23      ; Disabled Text
        RenColors[1003] = 27      ; Inactive Hotkey
        RenColors[1004] = 59      ; Current Text
        RenColors[1005] = 56      ; Current Disabled Text
        RenColors[1006] = 48      ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 48 :
        DYNARRAY RenColors[]
        RenColors[1001] = 32      ; Inactive Text
        RenColors[1002] = 40      ; Disabled Text
        RenColors[1003] = 42      ; Inactive Hotkey
        RenColors[1004] = 27      ; Current Text
        RenColors[1005] = 23      ; Current Disabled Text
        RenColors[1006] = 19      ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 64 :
        DYNARRAY RenColors[]
        RenColors[1001] = 48      ; Inactive Text
        RenColors[1002] = 56      ; Disabled Text
        RenColors[1003] = 59      ; Inactive Hotkey
        RenColors[1004] = 27      ; Current Text
        RenColors[1005] = 23      ; Current Disabled Text
        RenColors[1006] = 19      ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 80 :
        DYNARRAY RenColors[]
        RenColors[1001] = 64      ; Inactive Text
        RenColors[1002] = 71      ; Disabled Text
        RenColors[1003] = 76      ; Inactive Hotkey
        RenColors[1004] = 27      ; Current Text
        RenColors[1005] = 23      ; Current Disabled Text
        RenColors[1006] = 19      ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 96 :
        DYNARRAY RenColors[]
        RenColors[1001] = 80      ; Inactive Text
        RenColors[1002] = 87      ; Disabled Text
        RenColors[1003] = 93      ; Inactive Hotkey
        RenColors[1004] = 27      ; Current Text
        RenColors[1005] = 23      ; Current Disabled Text
        RenColors[1006] = 19      ; Current Hotkey
        SETCOLORS FROM RenColors

      CASE RenColor < 112 :
        DYNARRAY RenColors[]
        RenColors[1001] = 96      ; Inactive Text
        RenColors[1002] = 103     ; Disabled Text
        RenColors[1003] = 110     ; Inactive Hotkey
        RenColors[1004] = 27      ; Current Text
        RenColors[1005] = 23      ; Current Disabled Text
        RenColors[1006] = 19      ; Current Hotkey
        SETCOLORS FROM RenColors

      OTHERWISE :
        DYNARRAY RenColors[]
        RenColors[1001] = 112     ; Inactive Text
        RenColors[1002] = 120     ; Disabled Text
        RenColors[1003] = 127     ; Inactive Hotkey
        RenColors[1004] = 59      ; Current Text
        RenColors[1005] = 56      ; Current Disabled Text
        RenColors[1006] = 48      ; Current Hotkey
        SETCOLORS FROM RenColors
    ENDSWITCH
  ELSE
    Ren["MENUSTYLE"] = "STANDARD"

    IF ISASSIGNED(Ren["SAVEMENUCOLORS"]) THEN
      IF MATCH(Ren["SAVEMENUCOLORS"], "..,..,..,..,..,..", c1,c2,c3,c4,c5,c6) THEN
        DYNARRAY RenColors[]
        RenColors[1001] = NUMVAL(c1)
        RenColors[1002] = NUMVAL(c2)
        RenColors[1003] = NUMVAL(c3)
        RenColors[1004] = NUMVAL(c4)
        RenColors[1005] = NUMVAL(c5)
        RenColors[1006] = NUMVAL(c6)
        SETCOLORS FROM RenColors
      ENDIF
      RELEASE VARS Ren["SAVEMENUCOLORS"]
    ENDIF
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.SetMenuStyle
RELEASE PROCS RenObjectMgr.SetMenuStyle


PROC RenObjectMgr.Run()
  PRIVATE RenTrigger, RenCycle, RenEvent, RenObjects, RenObject, Win,
          RenMouseDown, RenMouseType, RenMouseObject,
          RenTarget, FirstEvent, si, RenOrigObj, RenRetval,
          RenSaveTrigger

  IF Ren["CURRENTOBJECT"] = "" THEN
    RenObjects = Ren["OBJECTLIST"]
    WHILE MATCH(RenObjects, "..,..", RenObject, RenObjects)
      IF RenDyn.Get(RenObject, "CANSELECT") = TRUE THEN
        RenObject.Select(RenObject)
        QUITLOOP
      ENDIF
    ENDWHILE
    IF Ren["CURRENTOBJECT"] = "" THEN
      RenMsgClose()
      RETURN
    ENDIF
  ENDIF

  RenMsgClose()
  RenCycle = 0

  WHILE TRUE
    IF Ren["OBJECTCOUNT"] = 0 THEN
      QUITLOOP
    ENDIF

    ECHO NORMAL

    IF Ren["GETEVENTMETHOD"] = "WAITWORKSPACE" THEN
      RELEASE VARS RenEvent
      FirstEvent = TRUE
      WAIT WORKSPACE PROC "RenObjectMgr.HandleWaitEvent" ALL
      ENDWAIT
    ELSE
      RenTrigger = "EVENT"
      RenCycle   = RenCycle + 1
      GETEVENT
        ALL
      TO RenEvent
      RenObjectMgr.HandleEvent()
      IF RETVAL = 0 THEN
        ECHO NORMAL
        EXECEVENT RenEvent
      ENDIF
    ENDIF

    IF Ren["RUN"] = FALSE THEN
      ECHO OFF
      SETCANVAS DEFAULT
      CURSOR OFF

      IF Ren["EXITMESSAGE"] <> "" THEN
        ;SYSINFO TO si
        ;PAINTCANVAS FILL "" ATTRIBUTE SYSCOLOR(1000) 0,0,
        ;  si["ScreenHeight"]-1,si["ScreenWidth"]-1
        RenMsg(Ren["EXITMESSAGE"])
      ENDIF

      WHILE Ren["CURRENTOBJECT"] <> ""
        RenObject.Destroy(Ren["CURRENTOBJECT"])
        IF RETVAL = FALSE THEN
          Ren["RUN"] = TRUE
          IF ISASSIGNED(RenGo) THEN
            RenGo = ""
          ENDIF
          QUITLOOP
        ENDIF
      ENDWHILE

      IF Ren["RUN"] = FALSE THEN
        WHILE GETWINDOW() <> 0 AND ISASSIGNED(RenWindows[GETWINDOW()]) AND ISWINDOW(GETWINDOW())
          RenObject = RenWindows[GETWINDOW()]
          RenObject.Destroy(RenObject)
          IF RETVAL = FALSE THEN
            Ren["RUN"] = TRUE
            IF ISASSIGNED(RenGo) THEN
              RenGo = ""
            ENDIF
            RenObject.Select(RenObject)
            QUITLOOP
          ENDIF
        ENDWHILE

        IF Ren["RUN"] = FALSE THEN
          RenObjects = Ren["OBJECTLIST"]

          WHILE MATCH(RenObjects, "..,..", RenObject, RenObjects)
            RenObject.Destroy(RenObject)
            IF RETVAL = FALSE THEN
              Ren["OBJECTLIST"] = RenObject + "," + RenObjects
              Ren["RUN"]        = TRUE
              IF ISASSIGNED(RenGo) THEN
                RenGo = ""
              ENDIF
              RenObject.Select(RenObject)
              QUITLOOP
            ENDIF
          ENDWHILE

          IF Ren["RUN"] = FALSE THEN
            QUITLOOP
          ENDIF
        ENDIF
      ENDIF

      RenMsgClose()
    ENDIF
  ENDWHILE

  SYSINFO TO si
  SETCANVAS DEFAULT
  PAINTCANVAS FILL " " ATTRIBUTE SYSCOLOR(1001) 0,0,
    0,si["ScreenWidth"]-1
  PAINTCANVAS FILL "" ATTRIBUTE SYSCOLOR(1000) 1,0,
    si["ScreenHeight"]-2,si["ScreenWidth"]-1
  PAINTCANVAS FILL " " ATTRIBUTE SYSCOLOR(1063) si["ScreenHeight"]-1,0,
    si["ScreenHeight"]-1,si["ScreenWidth"]-1
  CLEARPULLDOWN
  PROMPT
  RenMsgClose()
ENDPROC
WRITELIB libname RenObjectMgr.Run
RELEASE PROCS RenObjectMgr.Run


PROC RenObjectMgr.HandleWaitEvent(RenTrigger, RenEvent, RenCycle)
  IF NOT ISASSIGNED(RenEvent["TYPE"]) THEN
    RenEvent["TYPE"] = ""
  ENDIF

  IF FirstEvent THEN
    FirstEvent = FALSE

    RenSaveTrigger = RenTrigger

    RenObject  = Ren["CURRENTOBJECT"]
    RenTarget  = RenObject
    RenTrigger = "SETWAITSPEC"
    RETVAL = 0
    EXECPROC RenDyn.Get(Ren["CURRENTOBJECT"], "CLASS") + ".HandleEvent"
    IF RETVAL <> 1 AND RETVAL <> 2 THEN
      NEWWAITSPEC ALL
    ENDIF

    RenTrigger = RenSaveTrigger
  ENDIF

  RenOrigObj = Ren["CURRENTOBJECT"]

  RenObjectMgr.HandleEvent()
  IF Ren["CURRENTOBJECT"] <> RenOrigObj THEN
    RETVAL = 2
  ENDIF

  IF RETVAL = 0 OR RETVAL = 1 THEN
    IF Ren["RUN"] = FALSE THEN
      RETVAL = 2
    ELSE
      ECHO NORMAL
    ENDIF
  ENDIF

  RETURN RETVAL
ENDPROC
WRITELIB libname RenObjectMgr.HandleWaitEvent
RELEASE PROCS RenObjectMgr.HandleWaitEvent


PROC RenObjectMgr.HandleEvent()
  RenMouseDown = "NONE"
  RenMouseType = ""

  IF RenTrigger = "EVENT" AND RenEvent["TYPE"] = "MOUSE" AND
     RenEvent["ACTION"] = "DOWN" THEN

    IF RenEvent["BUTTONS"] = "LEFT" THEN
      RenMouseType = "LEFT"
    ELSE
      IF RenEvent["BUTTONS"] = "RIGHT" THEN
        RenMouseType = "RIGHT"
      ENDIF
    ENDIF

    IF RenMouseType = "" THEN
      RenMouseDown = "UNKOWN"
    ELSE
      Win = WINDOWAT(RenEvent["ROW"], RenEvent["COL"])

      SWITCH
        CASE Win = 0 :
          RenMouseDown = "NONE"

        CASE ISASSIGNED(RenWindows[Win]) = FALSE :
          RenMouseDown = "UNKNOWN"

        CASE Win = Ren["CURRENTWINDOW"] :
          RenMouseDown = "CURRENT"

        OTHERWISE :
          RenMouseDown   = "OBJECT"
          RenMouseObject = RenWindows[Win]
      ENDSWITCH
    ENDIF
  ENDIF

  FOREACH RenObject IN RenMonitors
    IF RenObject <> Ren["CURRENTOBJECT"] THEN
      IF RenMouseDown = "OBJECT" AND RenDyn.Get(RenObject, "WINDOW") = Win THEN
        LOOP
      ELSE
        RenTarget = Ren["CURRENTOBJECT"]
        RETVAL = 0
        EXECPROC RenDyn.Get(RenObject, "CLASS") + ".HandleEvent"
        SWITCH
          CASE RETVAL = -1 AND (RenMouseDown = "NONE" OR RenMouseDown = "CURRENT") :
            RETURN 0
          CASE RETVAL = 1 :
            RETURN 1
          CASE RETVAL = 2 :
            RETURN 2
        ENDSWITCH
      ENDIF
    ENDIF
  ENDFOREACH

  RenObject = Ren["CURRENTOBJECT"]
  IF RenObject <> "" THEN
    RETVAL = 0
    RenObjectMgr.DispatchEvent()
    SWITCH
      CASE RETVAL = -1 AND (RenMouseDown = "NONE" OR RenMouseDown = "CURRENT") :
        RETURN 0
      CASE RETVAL = 1 :
        RETURN 1
      CASE RETVAL = 2 :
        RETURN 2
    ENDSWITCH
  ENDIF

  IF RenMouseDown = "OBJECT" THEN
    RenObject = RenMouseObject

    IF RenDyn.Get(RenObject, "CANSELECT") = FALSE THEN
      RenObjectMgr.SetDispatchList(RenObject)
      RETVAL = 0
      RenObjectMgr.DispatchEvent()
      RenRetval = RETVAL
      RenObjectMgr.SetDispatchList(Ren["CURRENTOBJECT"])
      IF RenRetval = 1 OR RenRetval = 2 THEN
        RETURN RenRetval
      ELSE
;        IF RenMouseType = "RIGHT" AND Ren["SETUP"] = FALSE THEN
;          RenObjectMgr.WindowList()
;          RETURN 2
;        ENDIF
        RETURN 1
      ENDIF
    ENDIF

    RenObject.Select(RenObject)
    IF NOT RETVAL THEN
      RETURN 1
    ENDIF

    IF RenDyn.Get(RenObject, "SELECTONLY") = TRUE THEN
      RETURN 2
    ENDIF

    RETVAL = 0
    RenObjectMgr.DispatchEvent()
    SWITCH
      CASE RETVAL = 1 OR RETVAL = 2 :
        RETURN 2
      OTHERWISE :
;        IF RenMouseType = "RIGHT" AND Ren["SETUP"] = FALSE THEN
;          RenObjectMgr.WindowList()
;          RETURN 2
;        ENDIF
        EXECEVENT RenEvent
        RETURN 2
    ENDSWITCH
  ENDIF

  IF RenTrigger = "EVENT" THEN
    IF RenEvent["TYPE"] = "KEY" THEN
      SWITCH
        CASE RenEvent["KEYCODE"] = -101 : ; Ctrl-F8 WinClose
          RenObject = Ren["CURRENTOBJECT"]
          IF RenDyn.Get(RenObject, "CANCLOSE") = FALSE THEN
            BEEP
            RETURN 1
          ELSE
            RenObject.Destroy(RenObject)
            RETURN 2
          ENDIF

        CASE RenEvent["KEYCODE"] = -97 : ; Ctrl-F4 WinNext
          RenObject.Next()
          RETURN 2

        CASE RenEvent["KEYCODE"] = -96 : ; Ctrl-F3 WinPrev
          RenObject.Prev()
          RETURN 2

        CASE RenEvent["KEYCODE"] = 27 AND RenEvent["CTRL"] = TRUE : ; Ctrl-Esc
          ;IF Ren["SETUP"] = TRUE THEN
          ;  RenSetup.WindowList()
          ;ENDIF
          RETURN 2

        CASE RenEvent["KEYCODE"] = -45 : ; Alt-X
          Ren["RUN"] = FALSE
          RETURN 2

        OTHERWISE :
          RETURN 0
      ENDSWITCH
    ELSE
      IF RenEvent["TYPE"] = "MESSAGE" AND RenEvent["MESSAGE"] = "CLOSE" THEN
        RenObject = Ren["CURRENTOBJECT"]
        IF RenDyn.Get(RenObject, "CANCLOSE") = FALSE THEN
          BEEP
          RETURN 1
        ELSE
          RenObject.Destroy(RenObject)
          RETURN 2
        ENDIF
      ENDIF
    ENDIF
  ENDIF

;  IF RenMouseType = "RIGHT" AND Ren["SETUP"] = FALSE THEN
;    RenObjectMgr.WindowList()
;    RETURN 2
;  ENDIF

  IF RenMouseDown = "UNKNOWN" THEN
    RETURN 1
  ELSE
    RETURN 0
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.HandleEvent
RELEASE PROCS RenObjectMgr.HandleEvent


PROC RenObjectMgr.SetDispatchList(RenObject)
;  Ren["DISPATCHMETHOD"] = RenDyn.Get(RenObject, "DISPATCHMETHOD")
;
;  SWITCH
;    CASE Ren["DISPATCHMETHOD"] = "CHILDTOPARENT" :
;      Ren["DISPATCHLIST"] = ""
;      Parent = RenObject
;      WHILE Parent <> ""
;        Ren["DISPATCHLIST"] = Ren["DISPATCHLIST"] + Parent + ","
;        Parent = RenDyn.Get(Parent, "PARENT")
;      ENDWHILE
;
;    CASE Ren["DISPATCHMETHOD"] = "CHILDTOPARENT" :
;      Ren["DISPATCHLIST"] = ""
;      Parent = RenObject
;      WHILE Parent <> ""
;        Ren["DISPATCHLIST"] = Ren["DISPATCHLIST"] + Parent + ","
;        Parent = RenDyn.Get(Parent, "PARENT")
;      ENDWHILE
;
;    OTHERWISE : ; Ren["DISPATCHMETHOD"] = "CURRENT"
;      Ren["DISPATCHLIST"] = RenObject + ","
;  ENDSWITCH
ENDPROC
WRITELIB libname RenObjectMgr.SetDispatchList
RELEASE PROCS RenObjectMgr.SetDispatchList


PROC RenObjectMgr.DispatchEvent()
  RenTarget = RenObject

;  RenObjects = Ren["DISPATCHLIST"]
;
;  WHILE MATCH(RenObjects, "..,..", RenObject, RenObjects)
;    RETVAL = 0
    EXECPROC RenDyn.Get(RenObject, "CLASS") + ".HandleEvent"
    IF RETVAL = -1 OR RETVAL = 1 OR RETVAL = 2 THEN
      RETURN RETVAL
    ENDIF
;  ENDWHILE

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.DispatchEvent
RELEASE PROCS RenObjectMgr.DispatchEvent


PROC RenObjectMgr.SimTrigger(RenTarget, RenTrigger)
  PRIVATE RenObject, RenIsSim

  RenIsSim = TRUE

  RenObjectMgr.SetDispatchList(RenTarget)

  IF NOT ISASSIGNED(RenEvent) OR TYPE(RenEvent) <> "DY" THEN
    DYNARRAY RenEvent[]
    RenEvent["TYPE"] = ""
  ENDIF

  IF NOT ISASSIGNED(RenCycle) THEN
    RenCycle = 1
  ENDIF

  FOREACH RenObject IN RenMonitors
    IF RenObject <> RenTarget THEN
      RETVAL = 0
      EXECPROC RenDyn.Get(RenObject, "CLASS") + ".HandleEvent"
      IF RETVAL = -1 THEN
        RETURN 0
      ELSE
        IF RETVAL = 1 OR RETVAL = 2 THEN
          RETURN RETVAL
        ENDIF
      ENDIF
    ENDIF
  ENDFOREACH

  RenObject = RenTarget
  RenObjectMgr.DispatchEvent()

  RenObjectMgr.SetDispatchList(Ren["CURRENTOBJECT"])

  IF RETVAL = -1 THEN
    RETURN 0
  ELSE
    RETURN RETVAL
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.SimTrigger
RELEASE PROCS RenObjectMgr.SimTrigger


PROC RenObjectMgr.SimDepartTable(RenObject, Tbl, Fld, Modified)
  PRIVATE SaveWin, RenSaveObj, Win, RenIsSim, RenRetval, RenError,
          RenRetval, RenSaveErrorProc

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  SaveWin = GETWINDOW()
  RenSaveObj = Ren["CURRENTOBJECT"]

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> SaveWin AND Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  IF UPPER(TABLE()) <> UPPER(Tbl) OR UPPER(FIELD()) <> UPPER(fld) THEN
    MOVETO Tbl
    MOVETO FIELD Fld
  ENDIF
  RenUnsetSkipError()

  IF Modified THEN
    RenObjectMgr.SimTrigger(RenObject, "POSTRECORD")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  IF Ren["DEPARTFIELD"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTFIELD")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  IF Ren["DEPARTROW"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTROW")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  IF (Ren["DEPARTPAGE"] OR Ren["EVENTMONITOR"] <> "") AND ISFORMVIEW() THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTPAGE")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  RenObjectMgr.SimTrigger(RenObject, "DEPARTTABLE")
  IF RETVAL = 1 OR RETVAL = 2 THEN
    RenRetval = RETVAL
    IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
      WINDOW SELECT SaveWin
    ENDIF
    RETURN RenRetval
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimDepartTable
RELEASE PROCS RenObjectMgr.SimDepartTable


PROC RenObjectMgr.SimDepartRow(RenObject, Tbl, Fld, Modified)
  PRIVATE SaveWin, RenSaveObj, Win, RenIsSim, RenIsSim, RenError,
          RenRetval, RenSaveErrorProc

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  SaveWin = GETWINDOW()
  RenSaveObj = Ren["CURRENTOBJECT"]

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> SaveWin AND Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  IF UPPER(TABLE()) <> UPPER(Tbl) OR UPPER(FIELD()) <> UPPER(fld) THEN
    MOVETO Tbl
    MOVETO FIELD Fld
  ENDIF
  RenUnsetSkipError()

  IF Modified THEN
    RenObjectMgr.SimTrigger(RenObject, "POSTRECORD")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  IF Ren["DEPARTFIELD"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTFIELD")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  IF Ren["DEPARTROW"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTROW")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimDepartRow
RELEASE PROCS RenObjectMgr.SimDepartRow


PROC RenObjectMgr.SimDepartField(RenObject, Fld)
  PRIVATE SaveWin, RenSaveObj, Win, RenIsSim, RenError, RenRetval,
          RenSaveErrorProc

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  SaveWin = GETWINDOW()
  RenSaveObj = Ren["CURRENTOBJECT"]

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> SaveWin AND Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  IF UPPER(FIELD()) <> UPPER(fld) THEN
    MOVETO FIELD Fld
  ENDIF
  RenUnsetSkipError()

  IF Ren["DEPARTFIELD"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "DEPARTFIELD")
    IF RETVAL = 1 OR RETVAL = 2 THEN
      RenRetval = RETVAL
      IF ISWINDOW(SaveWin) AND Ren["CURRENTOBJECT"] = RenSaveObj THEN
        WINDOW SELECT SaveWin
      ENDIF
      RETURN RenRetval
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimDepartField
RELEASE PROCS RenObjectMgr.SimDepartField


PROC RenObjectMgr.SimArriveTable(RenObject, Tbl, Fld)
  PRIVATE Win, RenIsSim, RenError, RenSaveErrorProc, RenForceTrigs

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  MOVETO Tbl
  MOVETO FIELD Fld
  RenUnsetSkipError()

  RenObjectMgr.SimTrigger(RenObject, "ARRIVETABLE")
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  IF Ren["EVENTMONITOR"] <> "" OR (ISASSIGNED(Ren["INSELECT"]) AND Ren["INSELECT"] = TRUE) THEN
    RenForceTrigs = TRUE
  ELSE
    RenForceTrigs = FALSE
  ENDIF

  IF (Ren["ARRIVEPAGE"] OR RenForceTrigs) AND ISFORMVIEW() THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEPAGE")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  IF Ren["ARRIVEROW"] OR RenForceTrigs THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEROW")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  IF Ren["ARRIVEFIELD"] OR RenForceTrigs THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEFIELD")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimArriveTable
RELEASE PROCS RenObjectMgr.SimArriveTable


PROC RenObjectMgr.SimArriveRow(RenObject, Tbl, Fld)
  PRIVATE Win, RenIsSim, RenError, RenSaveErrorProc

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  MOVETO Tbl
  MOVETO FIELD Fld
  RenUnsetSkipError()

  IF Ren["ARRIVEROW"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEROW")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  IF Ren["ARRIVEFIELD"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEFIELD")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimArriveRow
RELEASE PROCS RenObjectMgr.SimArriveRow


PROC RenObjectMgr.SimArriveField(RenObject, Fld)
  PRIVATE SaveWin, Win, RenIsSim, RenError, RenSaveErrorProc

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  SaveWin = GETWINDOW()

  Win = RenDyn.Get(RenObject, "WINDOW")
  IF Win <> "" AND ISWINDOW(Win) THEN
    WINDOW SELECT Win
  ENDIF

  RenSetSkipError()
  MOVETO FIELD Fld
  RenUnsetSkipError()

  IF Ren["ARRIVEFIELD"] OR Ren["EVENTMONITOR"] <> "" THEN
    RenObjectMgr.SimTrigger(RenObject, "ARRIVEFIELD")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimArriveField
RELEASE PROCS RenObjectMgr.SimArriveField


PROC RenObjectMgr.SimImageRights(RenObject)
  PRIVATE RenIsSim

  IF IMAGETYPE() = "Display" AND ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) <> "M" THEN
    DO_IT!
  ENDIF

  RenIsSim = TRUE

  RenObjectMgr.SimTrigger(RenObject, "IMAGERIGHTS")
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  IF RenRecStat("Locked") = FALSE AND RenRecStat("Modified") = FALSE THEN
    IF Ren["TOUCHRECORD"] THEN
      RenObjectMgr.SimTrigger(RenObject, "TOUCHRECORD")
      IF RETVAL <> 0 THEN
        RETURN RETVAL
      ENDIF
    ENDIF
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname RenObjectMgr.SimImageRights
RELEASE PROCS RenObjectMgr.SimImageRights


PROC RenObjectMgr.WindowList()
  PRIVATE RenObjects, RenObject, ObjectHandle, ObjectDesc, ObjectDesc2, Sys,
          Button, Ctr, x, Ptr, StartRow, StartCol, RenClass, LastEvent, RenWin,
          PaintPAL.OriginalPalette, PaintPAL.ColorDeviations

  DYNARRAY ObjectHandle[]
  DYNARRAY ObjectDesc[]

  RenObjects = Ren["OBJECTLIST"]
  Ctr = 0
  Ptr = 1
  WHILE MATCH(RenObjects, "..,..", RenObject, RenObjects)
    IF RenDyn.Get(RenObject, "PARENT") = "" THEN
      IF RenDyn.Get(RenObject, "CANSELECT") = TRUE AND RenDyn.Get(RenObject, "ONWINDOWLIST") <> FALSE THEN
        Ctr = Ctr + 1
        IF RenObject = Ren["CURRENTOBJECT"] THEN
          Ptr = Ctr
        ENDIF
        ObjectHandle[Ctr] = RenObject
        ObjectDesc[Ctr]   = RenDyn.Get(RenObject, "ALIAS")
        IF ObjectDesc[Ctr] = "" THEN
          ObjectDesc[Ctr] = RenDyn.Get(RenObject, "TITLE")
        ENDIF
        RenClass = RenDyn.Get(RenObject, "CLASS")
        IF ObjectDesc[Ctr] = "" THEN
          ObjectDesc[Ctr] = RenClass + "/" + RenDyn.Get(RenObject, "TAG")
        ENDIF
        SWITCH
          CASE RenClass="RENTABLE"  : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Table)"
          CASE RenClass="RENFORM"   : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Form)"
          CASE RenClass="RENMEMO"   : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Memo)"
          CASE RenClass="RENCANVAS" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Canvas)"
          CASE RenClass="RENEDITOR" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Editor)"
          CASE RenClass="RENFILTER" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Filter)"
        ENDSWITCH
        ;RenObjectMgr.WindowListChildren(RenObject, 2)
        RenObjectMgr.WindowListChildren(RenObject, 0)
      ELSE
        RenObjectMgr.WindowListChildren(RenObject, 0)
      ENDIF
    ENDIF
  ENDWHILE

  IF Ctr = 0 THEN
    RETURN
  ENDIF

  ARRAY ObjectDesc2[Ctr]
  FOR x FROM 1 TO Ctr
    ObjectDesc2[x] = ObjectDesc[x]
  ENDFOR

  Button = ""

  SYSINFO TO Sys
  StartRow = INT((Sys["SCREENHEIGHT"] - 16) / 2)
  StartCol = INT((Sys["SCREENWIDTH"]  - 64) / 2)

  RenWin = GETWINDOW()

  ; PaintPAL_Generated_Code_Begin(Winlist2)

  ; PaintPAL_Color_Setup_Begin
  GETCOLORS TO PaintPAL.OriginalPalette
  DYNARRAY PaintPAL.ColorDeviations[]
  PaintPAL.ColorDeviations[1037] = 127  ;Label Inactive
  PaintPAL.ColorDeviations[1038] = 112  ;Label Selected
  PaintPAL.ColorDeviations[1039] = 112  ;Label Shortcut
  PaintPAL.ColorDeviations[1040] = 112  ;Pushbutton Normal
  PaintPAL.ColorDeviations[1041] = 112  ;Pushbutton Default
  PaintPAL.ColorDeviations[1042] = 127  ;Pushbutton Selected
  PaintPAL.ColorDeviations[1044] = 127  ;Pushbutton Shortcut
  SETCOLORS FROM PaintPAL.ColorDeviations
  RELEASE VARS PaintPAL.ColorDeviations
  ; PaintPAL_Color_Setup_End

  SHOWDIALOG "Window List"
     PROC "RenObjectMgr.WindowListProc"
        MOUSE "DOWN"
        KEY "ESC", "TAB", "REVERSETAB"
        TRIGGER "ARRIVE", "UPDATE", "SELECT"

     @StartRow,StartCol HEIGHT 17 WIDTH 64

     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 0,1 TO 14,46
     PAINTCANVAS ATTRIBUTE 112 0,1,0,46
     PAINTCANVAS ATTRIBUTE 127 14,1,14,46
     PAINTCANVAS ATTRIBUTE 112 0,1,14,1
     PAINTCANVAS ATTRIBUTE 127 0,46,14,46
     ; PaintPAL_Frame_End

     PICKARRAY @1,2 HEIGHT 13 WIDTH 43
        ObjectDesc2
        TAG "ObjectDesc2"
        TO Ptr

     PUSHBUTTON @4,49 WIDTH 11
        "~S~elect"
        OK
        DEFAULT
        VALUE "Select"
        TAG "Select"
        TO Button

     LABEL @3,47
        "~~"
        FOR "Select"

     LABEL @5,47
        "~~"
        FOR "Select"

     LABEL @4,47
        ""
        FOR "Select"

     LABEL @4,59
        "~~"
        FOR "Select"

     PUSHBUTTON @7,49 WIDTH 11
        "C~l~ose"
        OK
        VALUE "Close"
        TAG "Close"
        TO Button

     LABEL @6,47
        "~~"
        FOR "Close"

     LABEL @8,47
        "~~"
        FOR "Close"

     LABEL @7,47
        ""
        FOR "Close"

     LABEL @7,59
        "~~"
        FOR "Close"

     PUSHBUTTON @10,49 WIDTH 11
        "~C~ancel"
        CANCEL
        VALUE "Cancel"
        TAG "Cancel"
        TO Button

     LABEL @9,47
        "~~"
        FOR "Cancel"

     LABEL @11,47
        "~~"
        FOR "Cancel"

     LABEL @10,47
        ""
        FOR "Cancel"

     LABEL @10,59
        "~~"
        FOR "Cancel"
  ENDDIALOG

  ; PaintPAL_Color_Cleanup_Begin
  SETCOLORS FROM PaintPAL.OriginalPalette
  RELEASE VARS PaintPAL.OriginalPalette
  ; PaintPAL_Color_Cleanup_End

  ; PaintPAL_Generated_Code_End(Winlist2)

  IF RETVAL THEN
    GETEVENT ALL TO RETVAL

    IF ISWINDOW(RenWin) THEN
      WINDOW SELECT RenWin
    ENDIF

    SWITCH
      CASE Button = "Select" :
        RenObject.Select(ObjectHandle[Ptr])

      CASE Button = "Close" :
        IF RenDyn.Get(ObjectHandle[Ptr], "CANCLOSE") = FALSE THEN
          BEEP
        ELSE
          RenObject.Destroy(ObjectHandle[Ptr])
        ENDIF

      CASE Button = "Close All" :
        Ren["RUN"] = FALSE
    ENDSWITCH
  ELSE
    GETEVENT ALL TO RETVAL

    IF ISWINDOW(RenWin) THEN
      WINDOW SELECT RenWin
    ENDIF
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.WindowList
RELEASE PROCS RenObjectMgr.WindowList


PROC RenObjectMgr.WindowListProc(RenTrigger, RenTag, RenEvent, RenElement)
  PRIVATE RenWin

  IF NOT ISASSIGNED(LastEvent) THEN
    LastEvent = ""
  ENDIF

  IF RenTrigger = "EVENT" AND RenEvent["TYPE"] <> "IDLE" AND RenEvent["TYPE"] <> "MESSAGE" THEN
    LastEvent = RenEvent["TYPE"]
  ENDIF

  IF RenTrigger = "UPDATE" OR (RenTrigger = "ARRIVE" AND LastEvent = "MOUSE") THEN
    SWITCH
      CASE RenTag = "Select"    : ACCEPTDIALOG Button = "Select"    RETURN FALSE
      CASE RenTag = "Close"     : ACCEPTDIALOG Button = "Close"     RETURN FALSE
      CASE RenTag = "Close All" : ACCEPTDIALOG Button = "Close All" RETURN FALSE
      CASE RenTag = "Cancel"    : CANCELDIALOG RETURN FALSE
    ENDSWITCH
  ENDIF

  SWITCH
    CASE RenTrigger = "EVENT" AND RenEvent["TYPE"] = "MOUSE" :
      WINDOW HANDLE DIALOG TO RenWin
      IF WINDOWAT(RenEvent["ROW"], RenEvent["COL"]) <> RenWin THEN
        CANCELDIALOG
        RETURN FALSE
      ELSE
        RETURN TRUE
      ENDIF

    CASE RenTrigger = "SELECT" AND RenTag = "ObjectDesc2" :
      Button = "Select"
      ACCEPTDIALOG
      RETURN FALSE

    CASE RenTrigger = "EVENT" AND RenEvent["TYPE"] = "KEY" :
      IF RenEvent["KEYCODE"] = 27 THEN
        CANCELDIALOG
        RETURN FALSE
      ENDIF
  ENDSWITCH

  RETURN TRUE
ENDPROC
WRITELIB libname RenObjectMgr.WindowListProc
RELEASE PROCS RenObjectMgr.WindowListProc


PROC RenObjectMgr.WindowListChildren(Parent, Indent)
  PRIVATE Children, Child, RenClass

  Children = RenDyn.Get(Parent, "CHILDREN")

  WHILE MATCH(Children, "..,..", Child, Children)
    IF RenDyn.Get(Child, "CANSELECT") = TRUE AND RenDyn.Get(Child, "ONWINDOWLIST") <> FALSE THEN
      Ctr = Ctr + 1
      IF Child = Ren["CURRENTOBJECT"] THEN
        Ptr = Ctr
      ENDIF
      ObjectHandle[Ctr] = Child
      ObjectDesc[Ctr]   = RenDyn.Get(Child, "ALIAS")
      IF ObjectDesc[Ctr] = "" THEN
        ObjectDesc[Ctr] = RenDyn.Get(Child, "TITLE")
      ENDIF
      RenClass = RenDyn.Get(Child, "CLASS")
      IF ObjectDesc[Ctr] = "" THEN
        ObjectDesc[Ctr] = RenClass + "/" + RenDyn.Get(Child, "TAG")
      ENDIF
      ObjectDesc[Ctr] = SPACES(Indent) + ObjectDesc[Ctr]
      SWITCH
        CASE RenClass="RENTABLE"  : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Table)"
        CASE RenClass="RENFORM"   : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Form)"
        CASE RenClass="RENMEMO"   : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Memo)"
        CASE RenClass="RENCANVAS" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Canvas)"
        CASE RenClass="RENEDITOR" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Editor)"
        CASE RenClass="RENFILTER" : ObjectDesc[Ctr]=ObjectDesc[Ctr]+" (Filter)"
      ENDSWITCH
      ;RenObjectMgr.WindowListChildren(Child, Indent + 2)
      RenObjectMgr.WindowListChildren(Child, Indent)
    ELSE
      RenObjectMgr.WindowListChildren(Child, Indent)
    ENDIF
  ENDWHILE
ENDPROC
WRITELIB libname RenObjectMgr.WindowListChildren
RELEASE PROCS RenObjectMgr.WindowListChildren


PROC RenObjectMgr.IsSystemKey(RenEvent)
  PRIVATE RenKey

  RenKey = RenEvent["KEYCODE"]

  IF RenKey = -101 OR RenKey = -97 OR RenKey = -96 OR RenKey = -45 OR
     RenKey = -98  OR RenKey = -88 THEN
    RETURN TRUE
  ELSE
    IF RenKey = 27 AND RenEvent["CTRL"] = TRUE THEN
      RETURN TRUE
    ELSE
      RETURN FALSE
    ENDIF
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.IsSystemKey
RELEASE PROCS RenObjectMgr.IsSystemKey


PROC RenObjectMgr.SetImageRights(Rights)
  Rights = UPPER(Rights)

  SWITCH
    CASE Rights = "READONLY" :
      IMAGERIGHTS READONLY
      Ren["IMAGERIGHTS"] = "READONLY"

    CASE Rights = "UPDATE" :
      IMAGERIGHTS UPDATE
      Ren["IMAGERIGHTS"] = "UPDATE"

    OTHERWISE :
      IMAGERIGHTS
      Ren["IMAGERIGHTS"] = ""
  ENDSWITCH
ENDPROC
WRITELIB libname RenObjectMgr.SetImageRights
RELEASE PROCS RenObjectMgr.SetImageRights


PROC RenObjectMgr.SetDesktopColor(RenColor)
  PRIVATE RenColors

  DYNARRAY RenColors[]
  RenColors[1000] = RenColor
  SETCOLORS FROM RenColors

  Ren["BACKGROUNDCOLOR"] = RenColor
ENDPROC
WRITELIB libname RenObjectMgr.SetDesktopColor
RELEASE PROCS RenObjectMgr.SetDesktopColor


PROC RenObjectMgr.ResetDesktopColor()
  PRIVATE RenColors

  IF Ren["SAVEBACKGROUNDCOLOR"] <> SYSCOLOR(1000) THEN
    DYNARRAY RenColors[]
    RenColors[1000] = Ren["SAVEBACKGROUNDCOLOR"]
    SETCOLORS FROM RenColors
    Ren["BACKGROUNDCOLOR"] = Ren["SAVEBACKGROUNDCOLOR"]
  ENDIF
ENDPROC
WRITELIB libname RenObjectMgr.ResetDesktopColor
RELEASE PROCS RenObjectMgr.ResetDesktopColor


PROC RenObjectMgr.Destroy()
  RenObjectMgr.ResetDesktopColor()
  RenObjectMgr.SetMenuStyle("STANDARD", 0)
  RELEASE VARS Ren, RenTags, RenWindows, RenMonitors, RenIdleWatchers
  RETURN TRUE
ENDPROC
WRITELIB libname RenObjectMgr.Destroy
RELEASE PROCS RenObjectMgr.Destroy


RELEASE VARS LibName

