;---------------------------------------------------------------------
; RENMEMO.SC - Renaissance (Memo Object)
;---------------------------------------------------------------------


IF NOT ISASSIGNED(LibName) THEN
  Ver = STRVAL(VERSION())
  DotLoc = SEARCH(".", Ver)
  IF DotLoc > 0 THEN
    Ver = SUBSTR(Ver, 1, DotLoc - 1) + SUBSTR(Ver, DotLoc + 1, 2)
  ENDIF
  LibName = SDIR() + "Ren" + Ver
  RELEASE VARS Ver, DotLoc
ENDIF


PROC RenMemo.Create(RenParent, RenProps)
  PRIVATE RenDisp, RenWkspc, RenObject

  IF ISASSIGNED(RenProps["DISPLAYED"]) THEN
    RenDisp = RenProps["DISPLAYED"]
  ELSE
    RenDisp = TRUE
  ENDIF

  IF ISASSIGNED(RenProps["FORMPARENT"]) AND RenProps["FORMPARENT"] <> "" THEN
    RenProps["LASTPARENT"] = RenProps["FORMPARENT"]
  ELSE
    RenProps["LASTPARENT"] = RenParent
  ENDIF

  RenWkspc = RenDyn.Get(RenParent, "WORKSPACE")

  RenProps["CLASS"]  = "RENMEMO"
  RenProps["PARENT"] = RenParent
  RenProps["WINDOW"] = 0

  IF Ren["SETUP"] <> TRUE THEN
    RenProps["TYPE"]           = "MEMO"
    RenProps["GETEVENTMETHOD"] = "WAITWORKSPACE"
    RenProps["SELECTONLY"]     = TRUE
  ELSE
    RenProps["TYPE"]           = ""
    RenProps["GETEVENTMETHOD"] = "GETEVENT"
    RenProps["SELECTONLY"]     = FALSE
  ENDIF

  ;IF ISASSIGNED(RenProps["TAG"]) = FALSE AND Ren["SETUP"] = TRUE THEN
  ;  RenProps["TAG"] = RenSetup.SetTag("MEMO", RenProps["TABLE"] + "," + RenProps["FIELD"])
  ;ENDIF

  RenProps["WORKSPACE"] = RenWkspc

  IF NOT ISASSIGNED(RenProps["TITLE"]) THEN
    RenProps["TITLE"] = RenProps["TABLE"] + "->" + RenProps["FIELD"]
  ENDIF

  IF RenDisp = FALSE THEN
    RenProps["CANSELECT"] = FALSE
  ENDIF

  RenObject.SetMoreMenu(RenProps)

  RenObject = RenObject.Create(RenProps)

  IF RenDisp = FALSE THEN
    RETURN RenObject
  ENDIF

  RenMemo.Display()
  IF NOT RETVAL THEN
    RenContinue("Could not open the " + RenProps["TABLE"] + "->" +
                RenProps["FIELD"] + " memo")
    RenObject.Destroy(RenObject)
    RETURN ""
  ENDIF

  RETURN RenObject
ENDPROC
WRITELIB libname RenMemo.Create
RELEASE PROCS RenMemo.Create


PROC RenMemo.Display()
  PRIVATE RenWin, RenSaveWin, RenEmpty, RenSaveErrorProc, RenError,
          RenTbl, RenFld, RenSaveObj, RenNew, RenMod, RenLock, RenCoedit,
          RenDispPar

;  IF Ren["QUICKDISPLAY"] = TRUE THEN
;    ;
;    ; QuickDisplay is true when the workspace is initially being setup.
;    ;
;    RenWin = RenDyn.Get(RenObject, "WINDOW")
;    IF ISWINDOW(RenWin) THEN
;      WINDOW SELECT RenWin
;    ENDIF
;
;    IF GETWINDOW() <> RenWin THEN
;      RenSaveWin = GETWINDOW()
;
;      RenWin = RenDyn.Get(RenDyn.Get(RenObject, "PARENT"), "WINDOW")
;      WINDOW SELECT RenWin
;
;      IF RECNO() = 0 THEN
;        RenEmpty = TRUE
;        COEDITKEY
;      ELSE
;        RenEmpty = FALSE
;      ENDIF
;
;      RenSetSkipError()
;      MOVETO FIELD RenDyn.Get(RenObject, "FIELD")
;      RenUnsetSkipError()
;
;      IF RenError THEN
;        IF RenEmpty THEN
;          DO_IT!
;        ENDIF
;        RETURN FALSE
;      ENDIF
;
;      FIELDVIEW
;
;      IF NOT ISFIELDVIEW() THEN
;        IF RenEmpty THEN
;          DO_IT!
;        ENDIF
;        RETURN FALSE
;      ENDIF
;
;      RenWin = GETWINDOW()
;      RenObject.SetWindow(RenObject, RenWin)
;
;      IF RenEmpty THEN
;        FIELDVIEW
;        DEL
;        DO_IT!
;      ENDIF
;
;      IF ISWINDOW(RenSaveWin) THEN
;        WINDOW SELECT RenSaveWin
;      ENDIF
;
;      WINDOW SELECT RenWin
;    ENDIF
;
;    IF (RenDyn.Get(RenObject, "FIRSTDISPLAY") <> FALSE) THEN
;      RenSetWinAttr(RenWin, RenObject)
;      RenDyn.Set(RenObject, "FIRSTDISPLAY", FALSE)
;    ENDIF
;
;    RETURN TRUE
;  ENDIF

  ;
  ; Regular display.
  ;
  RenWin = RenDyn.Get(RenObject, "WINDOW")
  IF ISWINDOW(RenWin) THEN
    IF RenWin = GETWINDOW() THEN
      RETURN TRUE
    ENDIF

    WINDOW SELECT RenWin
    IF RenWin = GETWINDOW() THEN
      RETURN TRUE
    ENDIF
  ENDIF

  ECHO OFF

  RenSaveWin = GETWINDOW()
  RenTbl     = UPPER(RenDyn.Get(RenObject, "TABLE"))
  RenFld     = UPPER(RenDyn.Get(RenObject, "FIELD"))
  RenDispPar = FALSE

  IF UPPER(TABLE()) <> RenTbl OR SYSMODE() = "File Editor" OR
    SYSMODE() = "Script" THEN

    RenSaveObj = RenObject
    RenObject = RenDyn.Get(RenSaveObj, "PARENT")
    EXECPROC RenDyn.Get(RenObject, "CLASS") + ".Display"
    RenObject = RenSaveObj

    IF NOT RETVAL THEN
      IF ISWINDOW(RenSaveWin) THEN
        WINDOW SELECT RenSaveWin
      ENDIF
      RETURN FALSE
    ENDIF

    RenDispPar = TRUE
  ELSE
    IF ISFIELDVIEW() AND SUBSTR(FIELDTYPE(),1,1) = "M" THEN
      FIELDVIEW
      RenWin = RenImageWin()
      WINDOW SELECT RenWin
      IF UPPER(FIELD()) = RenFld THEN
        FIELDVIEW
        RenWin = GETWINDOW()
        RenObject.SetWindow(RenObject, RenWin)
        RenSetWinAttr(RenWin, RenObject)
        RETURN TRUE
      ENDIF
    ELSE
      RenWin = RenImageWin()
      WINDOW SELECT RenWin
    ENDIF
  ENDIF

  IF SYSMODE() = "Main" THEN
    COEDITKEY
    RenCoedit = TRUE
  ELSE
    RenCoedit = FALSE
  ENDIF

  IF UPPER(FIELD()) <> RenFld THEN
    RenSetSkipError()
    MOVETO FIELD RenDyn.Get(RenObject, "FIELD")
    RenUnsetSkipError()

    IF RenError THEN
      IF RenDispPar = FALSE THEN
        RenSaveObj = RenObject
        RenObject = RenDyn.Get(RenSaveObj, "PARENT")
        EXECPROC RenDyn.Get(RenObject, "CLASS") + ".Display"
        RenObject = RenSaveObj

        IF NOT RETVAL THEN
          IF RenCoedit AND SYSMODE() = "CoEdit" THEN
            DO_IT!
          ENDIF
          IF ISWINDOW(RenSaveWin) THEN
            WINDOW SELECT RenSaveWin
          ENDIF
          RETURN FALSE
        ENDIF

        RenDispPar = TRUE

        RenSetSkipError()
        MOVETO FIELD RenDyn.Get(RenObject, "FIELD")
        RenUnsetSkipError()

        IF RenError THEN
          IF RenCoedit AND SYSMODE() = "CoEdit" THEN
            DO_IT!
          ENDIF
          IF ISWINDOW(RenSaveWin) THEN
            WINDOW SELECT RenSaveWin
          ENDIF
          RETURN FALSE
        ENDIF
      ELSE
        IF RenCoedit AND SYSMODE() = "CoEdit" THEN
          DO_IT!
        ENDIF
        IF ISWINDOW(RenSaveWin) THEN
          WINDOW SELECT RenSaveWin
        ENDIF
        RETURN FALSE
      ENDIF
    ENDIF
  ENDIF

  IF SUBSTR(FIELDTYPE(), 1, 1) <> "M" THEN
    IF RenCoedit AND SYSMODE() = "CoEdit" THEN
      DO_IT!
    ENDIF
    IF ISWINDOW(RenSaveWin) THEN
      WINDOW SELECT RenSaveWin
    ENDIF
    RETURN FALSE
  ENDIF

  RenNew  = RenRecStat("New")
  RenMod  = RenRecStat("Modified")
  RenLock = RenRecStat("Locked")

  FIELDVIEW
  IF NOT ISFIELDVIEW() THEN
    IF RenCoedit AND SYSMODE() = "CoEdit" THEN
      DO_IT!
    ENDIF
    IF ISWINDOW(RenSaveWin) THEN
      WINDOW SELECT RenSaveWin
    ENDIF
    RETURN FALSE
  ENDIF

  RenWin = GETWINDOW()

  SWITCH
    CASE RenNew = TRUE :
      IF RenMod = FALSE THEN
        FIELDVIEW
        DEL
      ENDIF

    CASE RenLock = FALSE :
      FIELDVIEW
      UNLOCKRECORD

    OTHERWISE :
      FIELDVIEW
  ENDSWITCH

  IF RenCoedit AND SYSMODE() = "CoEdit" THEN
    DO_IT!

    IF NOT ISWINDOW(RenWin) THEN
      ;
      ; Paradox closes the memo window when it is from an embedded detail
      ; table when exiting CoEdit mode. So we need to try to open re-open
      ; the memo outside of CoEdit mode. To do this, the memo must contain
      ; a value.
      ;
      MOVETO RenTbl
      MOVETO FIELD RenFld

      IF NIMAGERECORDS() = 0 OR [] = "" THEN
        COEDITKEY
        [] = "A"
        DO_IT!
        MOVETO RenTbl
        MOVETO FIELD RenFld
      ENDIF

      FIELDVIEW
      RenWin = GETWINDOW()
    ENDIF
  ENDIF

  RenObject.SetWindow(RenObject, RenWin)
  RenSetWinAttr(RenWin, RenObject)

  IF RenDispPar = FALSE AND ISWINDOW(RenSaveWin) THEN
    WINDOW SELECT RenSaveWin
  ENDIF

  WINDOW SELECT RenWin

  RETURN TRUE
ENDPROC
WRITELIB libname RenMemo.Display
RELEASE PROCS RenMemo.Display


PROC RenMemo.HandleEvent()
  Ren.HandleEvent()
  RETURN RETVAL
ENDPROC
WRITELIB libname RenMemo.HandleEvent
RELEASE PROCS RenMemo.HandleEvent


PROC RenMemo.Destroy()
  ECHO OFF
  RenDyn.Destroy(RenDyn.Get(RenObject, "BUTTONS"))
  RenAry.Destroy(RenDyn.Get(RenObject, "ACTIONS"))
  RenAry.Destroy(RenDyn.Get(RenObject, "CUSTOMKEYS"))
  RETURN TRUE
ENDPROC
WRITELIB libname RenMemo.Destroy
RELEASE PROCS RenMemo.Destroy


PROC Ren.OpenMemo()
  PRIVATE RenClass, RenTblObj, RenChildren, RenChild, RenWin, RenProps

  ;
  ; This procedures opens a memo window for the current field. If the
  ; memo is already an object in memory, then select it. Otherwise,
  ; create the memo object.
  ;

  RenObject = Ren["CURRENTOBJECT"]
  RenClass = RenDyn.Get(RenObject, "CLASS")

  IF RenClass = "RENTABLE" THEN
    RenTblObj = RenObject
  ELSE
    ; RenClass = "RENFORM"
    RenTblObj = RenDyn.Get(RenObject, "PARENT")
  ENDIF

  IF TABLE() = RenDyn.Get(RenTblObj, "TABLE") THEN
    RenChildren = RenDyn.Get(RenTblObj, "CHILDREN")
  ELSE
    RenChildren = Ren["OBJECTLIST"]
  ENDIF

  WHILE MATCH(RenChildren, "..,..", RenChild, RenChildren)
    IF RenDyn.Get(RenChild, "CLASS") = "RENMEMO" AND
       RenDyn.Get(RenChild, "TABLE") = TABLE() AND
       RenDyn.Get(RenChild, "FIELD") = FIELD() THEN

      ; Found the memo object... select it and return.
      RenDyn.Set(RenChild, "LASTPARENT", RenObject)
      RenDyn.Set(RenChild, "CANSELECT", TRUE)
      RenObject.Select(RenChild)
      RETURN TRUE
    ENDIF
  ENDWHILE

  ; Did not find the memo object... create it.
  DYNARRAY RenProps[]
  RenProps["TABLE"] = TABLE()
  RenProps["FIELD"] = FIELD()
  IF RenClass = "RENFORM" THEN
    RenProps["MASTERTABLE"] = RenDyn.Get(RenObject, "TABLE")
    RenProps["MASTERFORM"]  = RenDyn.Get(RenObject, "FORM")
    RenProps["FORMPARENT"]  = RenObject
  ELSE
    RenProps["FORMPARENT"]  = ""
  ENDIF
  IF ISFIELDVIEW() THEN
    RenProps["WINDOW"] = GETWINDOW()
  ENDIF
  Ren.DefaultButtons("Memo", RenProps)
  RenMemo.Create(RenTblObj, RenProps)
  IF RETVAL = "" THEN
    RETURN FALSE
  ELSE
    RenObject.Select(RETVAL)
    IF Ren["SETUP"] = TRUE THEN
      Ren["SETUPSAVED"] = FALSE
    ENDIF
    RETURN TRUE
  ENDIF
ENDPROC
WRITELIB libname Ren.OpenMemo
RELEASE PROCS Ren.OpenMemo


PROC Ren.CloseMemo(RenSave)
  PRIVATE RenWin, RenTag, RenAttr, RenAction

  IF Ren["SETUP"] = TRUE THEN
    RenButtonDlg("Close Memo", "Do you want to hide the memo or remove it?",
                 "Hide,Remove,Cancel")
    IF RETVAL = "Cancel" THEN
      RETURN FALSE
    ELSE
      RenAction = RETVAL
    ENDIF
  ELSE
    RenAction = "Hide"
  ENDIF

  ECHO OFF

  RenWin = RenDyn.Get(RenObject, "WINDOW")
  IF RenWin <> "" AND ISWINDOW(RenWin) THEN
    WINDOW GETATTRIBUTES RenWin TO RenAttr

    RenDyn.Set(RenObject, "ORIGINROW", RenAttr["ORIGINROW"])
    RenDyn.Set(RenObject, "ORIGINCOL", RenAttr["ORIGINCOL"])
    RenDyn.Set(RenObject, "HEIGHT",    RenAttr["HEIGHT"])
    RenDyn.Set(RenObject, "WIDTH",     RenAttr["WIDTH"])
    RenDyn.Set(RenObject, "MAXIMIZED", RenAttr["MAXIMIZED"])

    IF GETWINDOW() <> RenWin THEN
      WINDOW SELECT RenWin
    ENDIF

    IF RenSave = TRUE THEN
      DO_IT!
    ELSE
      MENU {CANCEL} {Yes}
    ENDIF
  ENDIF

  RenParent = RenDyn.Get(RenObject, "LASTPARENT")
  IF ISASSIGNED(VARVAL(RenParent)) THEN
    RenObject.Select(RenDyn.Get(RenObject, "LASTPARENT"))
  ELSE
    RenObject.Select(RenDyn.Get(RenObject, "PARENT"))
  ENDIF

  RenDyn.Set(RenObject, "CANSELECT", FALSE)
  RenObject.SetWindow(RenObject, 0)

  IF RenAction = "Remove" THEN
    RenObject.Destroy(RenObject)
  ENDIF

  RETURN TRUE
ENDPROC
WRITELIB libname Ren.CloseMemo
RELEASE PROCS Ren.CloseMemo


RELEASE VARS LibName

