;---------------------------------------------------------------------
; RENWKSPC.SC - Renaissance (Workspace Procedures)
;---------------------------------------------------------------------


IF NOT ISASSIGNED(LibName) THEN
  Ver = STRVAL(VERSION())
  DotLoc = SEARCH(".", Ver)
  IF DotLoc > 0 THEN
    Ver = SUBSTR(Ver, 1, DotLoc - 1) + SUBSTR(Ver, DotLoc + 1, 2)
  ENDIF
  LibName = SDIR() + "Ren" + Ver
  RELEASE VARS Ver, DotLoc
ENDIF


PROC Ren(ObjectList, WkspcProps)
  PRIVATE WorkspaceObject, ObjectHandles, FirstObject, FirstTableObject,
          FirstFormObject, RenObject, Ren, RenWindows, MonitorObjects,
          SaveList, RenStyle, RenColor, RenTables, RenForms, RenNumImg,
          RenBeforeWait, RenAfterQuit, RenWksObj, RenWksKeys, RenObjKeys,
          RenEvent, RenTrigger, RenCycle, RenTag, RenSys, RenGo,
          RenAddOneSave, RenAddOneRowNo, RenLocateRec, RenShowAsCreated,
          RenTypeCtr, RenType, t1, t2, t3, t4, t5, t6, t7,
          RenActionPoint, RenSaveRec, RenSaveAutolib

  IF NOT ISASSIGNED(ERRORPROC) OR ERRORPROC = "" THEN
    ERRORPROC = "RenErrorProc"
  ENDIF

  RenGo = ""

  IF Objectlist = "" THEN
    RenContinue("You must pass a list of objects to Ren()")
    RETURN ""
  ENDIF

  SHOWPULLDOWN
  ENDMENU

  PROMPT ""

  SETCANVAS DEFAULT
  CURSOR OFF
  SYSINFO TO RenSys
  PAINTCANVAS FILL " " ATTRIBUTE SYSCOLOR(1001) 0,0,0, RenSys["SCREENWIDTH"]-1
  PAINTCANVAS FILL " " ATTRIBUTE SYSCOLOR(1071) RenSys["SCREENHEIGHT"]-1, 0,
                              RenSys["SCREENHEIGHT"]-1, RenSys["SCREENWIDTH"]-1
  RELEASE VARS RenSys

  IF TYPE(WkspcProps) <> "DY" THEN
    DYNARRAY WkspcProps[]
  ENDIF

  IF NOT ISASSIGNED(AUTOLIB) THEN
    AUTOLIB = ""
  ENDIF

  RenSaveAutolib = AUTOLIB

  IF ISASSIGNED(WkspcProps["AUTOLIB"]) THEN
    AUTOLIB = AUTOLIB + "," + WkspcProps["AUTOLIB"]
  ENDIF

  IF ISASSIGNED(WkspcProps["BEFORESETUP"]) AND WkspcProps["BEFORESETUP"] <> "" THEN
    Ren.CustomCode2("BEFORESETUP", WkspcProps["BEFORESETUP"])
    IF RETVAL <> 0 THEN
      AUTOLIB = RenSaveAutolib
      RETURN ""
    ENDIF
  ENDIF

  IF NOT ISASSIGNED(WkspcProps["SETUPMESSAGE"]) THEN
    WkspcProps["SETUPMESSAGE"] = "Loading..."
  ENDIF

  IF NOT ISASSIGNED(WkspcProps["EXITMESSAGE"]) THEN
    WkspcProps["EXITMESSAGE"] = "Quitting..."
  ENDIF

  IF ISASSIGNED(WkspcProps["SHOWASCREATED"]) AND WkspcProps["SHOWASCREATED"] = FALSE THEN
    RenShowAsCreated = FALSE
    WkspcProps["ECHO"] = FALSE
  ELSE
    RenShowAsCreated = TRUE
    WkspcProps["ECHO"] = TRUE
  ENDIF

  RenObjectMgr.Create(WkspcProps)

  WorkspaceObject = Ren.Create(WkspcProps)
  Ren["WORKSPACEOBJECT"] = WorkspaceObject

  Ren["QUICKDISPLAY"] = FALSE ;TRUE

  DYNARRAY RenTables[]
  DYNARRAY RenForms[]
  DYNARRAY ObjectHandles[]

  FirstObject      = ""
  FirstTableObject = ""
  FirstFormObject  = ""

  Ren.GetTableWindows(RenTables)

  SaveList = ObjectList

  FOR RenTypeCtr FROM 1 TO 3
    ;
    ; First create table objects, then forms, then others.
    ;
    ObjectList = SaveList + ","

    WHILE MATCH(ObjectList, "..,..", RenObject, ObjectList)
      IF ISASSIGNED(VARVAL(RenObject)) THEN
        RenType = UPPER(RenDyn.Get(RenObject, "TYPE"))

        SWITCH
          CASE RenTypeCtr = 1 :
            IF RenType <> "TABLE" THEN
              LOOP
            ENDIF

          CASE RenTypeCtr = 2 :
            IF RenType <> "FORM" THEN
              LOOP
            ENDIF

          OTHERWISE :
            IF RenType = "TABLE" OR RenType = "FORM" THEN
              LOOP
            ENDIF
        ENDSWITCH

        IF RenDyn.Get(RenObject, "TAG") = "" THEN
          RenDyn.Set(RenObject, "TAG", RenObject)
        ENDIF

        IF NOT ISASSIGNED(VARVAL(RenObject)) THEN
          RenContinue("The " + RenObject + " variable is not assigned")
          RenObject.Destroy(WorkspaceObject)
          RenObjectMgr.Destroy()
          AUTOLIB = RenSaveAutolib
          RETURN ""
        ENDIF

        Ren.CreateObject(VARVAL(RenObject))
        IF NOT RETVAL THEN
          RenObject.Destroy(WorkspaceObject)
          RenObjectMgr.Destroy()
          RETURN ""
        ENDIF

        SWITCH
          CASE FirstFormObject <> ""  : RenObject = FirstFormObject
          CASE FirstTableObject <> "" : RenObject = FirstTableObject
          CASE FirstObject <> ""      : RenObject = FirstObject
        ENDSWITCH

        RenWin = RenDyn.Get(RenObject, "WINDOW")
        IF RenWin <> "" AND ISWINDOW(RenWin) THEN
          WINDOW SELECT RenWin
        ENDIF

        IF RenShowAsCreated = TRUE THEN
          ECHO NORMAL
          ECHO OFF
        ENDIF
      ENDIF
    ENDWHILE
  ENDFOR

  IF ISASSIGNED(WkspcProps["FIRSTOBJECT"]) AND
     ISASSIGNED(ObjectHandles[WkspcProps["FIRSTOBJECT"]]) THEN

    RenObject.Select(WkspcProps["FIRSTOBJECT"])
  ELSE
    SWITCH
      CASE FirstFormObject <> ""  : RenObject.Select(FirstFormObject)
      CASE FirstTableObject <> "" : RenObject.Select(FirstTableObject)
      CASE FirstObject <> ""      : RenObject.Select(FirstObject)
    ENDSWITCH
  ENDIF

  RELEASE VARS ObjectHandles, FirstObject, FirstTableObject,
               FirstFormObject, RenObject, SaveList, ObjectList

  Ren["QUICKDISPLAY"] = FALSE
  Ren["ECHO"]         = TRUE

  RenBeforeWait = RenDyn.Get(WorkspaceObject, "BEFOREWAIT")
  RenAfterQuit  = RenDyn.Get(WorkspaceObject, "AFTERQUIT")

  RenMsgClose()

  IF RenBeforeWait <> "" THEN
    RenActionPoint = "BEFOREWAIT"
    Ren.CustomCode(RenBeforeWait, TRUE, FALSE, FALSE, FALSE)
    RELEASE VARS RenActionPoint
  ELSE
    RETVAL = 0
  ENDIF

  IF RETVAL = 0 THEN
    RenObjectMgr.Run()
  ELSE
    RenObject.Destroy(WorkspaceObject)
  ENDIF

  IF RenAfterQuit <> "" THEN
    Ren.CustomCode2("AFTERQUIT", RenAfterQuit)
  ENDIF

  RenObjectMgr.Destroy()

  IF RenGo <> "" THEN
    Ren.CallDesigner()
  ENDIF

  Ren.CleanupFiles()

  AUTOLIB = RenSaveAutolib

  IF RenGo <> "" THEN
    QUIT
  ELSE
    RETURN ""
  ENDIF
ENDPROC
WRITELIB libname Ren
RELEASE PROCS Ren


PROC Ren.CreateObject(ObjProps)
  PRIVATE ObjectType, RenTag, FormTable, TableObject, ParentTag, Parent,
          RenTbl, FormNum, RenTblProps, MasterTable, MasterForm,
          FormObject, RenObj, MemoObject

  IF TYPE(ObjProps) <> "DY" THEN
    RenContinue("The " + RenObject + " variable is not a dynarray")
    RETURN FALSE
  ENDIF

  IF NOT ISASSIGNED(ObjProps["TYPE"]) THEN
    RenContinue("The \"Type\" property for the " + RenObject + " object is not assigned")
    RETURN FALSE
  ENDIF

  ObjProps["DYNARRAY"] = RenObject

  ObjectType = UPPER(ObjProps["TYPE"])

  SWITCH
    CASE ObjectType = "TABLE" :
      IF NOT ISASSIGNED(ObjProps["TABLE"]) THEN
        RenContinue("The \"Table\" property for the " + RenObject + " object is not assigned")
        RETURN FALSE
      ENDIF
      RenTbl = ObjProps["TABLE"]
      IF ISASSIGNED(RenTables[RenTbl]) THEN
        IF SUBSTR(TYPE(RenTables[RenTbl]), 1, 1) = "A" THEN
          ; Table is already defined as an object
          RenContinue("The " + RenTbl + " table is defined multiple times")
          RETURN FALSE
        ELSE
          ; Table is already viewed in a window
          ObjProps["WINDOW"] = RenTables[RenTbl]
        ENDIF
      ENDIF
      TableObject = RenTable.Create(WorkspaceObject, ObjProps)
      IF TableObject = "" THEN
        RETURN FALSE
      ENDIF
      RenTag = RenDyn.Get(TableObject, "TAG")
      ObjectHandles[RenTag] = TableObject
      RenTables[RenTbl] = TableObject

      IF RenDyn.Get(TableObject, "HIDDEN") = FALSE AND
         RenDyn.Get(TableObject, "EDITRIGHTS,"+RenTbl) <> "NONE" THEN
        IF FirstObject = "" THEN
          FirstObject = TableObject
        ENDIF

        IF FirstTableObject = "" THEN
          FirstTableObject = TableObject
        ENDIF
      ENDIF

    CASE ObjectType = "FORM" :
      IF NOT ISASSIGNED(ObjProps["TABLE"]) THEN
        RenContinue("The \"Table\" property for the " + RenObject + " object is not assigned")
        RETURN FALSE
      ENDIF

      IF NOT ISASSIGNED(ObjProps["FORM"]) THEN
        RenContinue("The \"Form\" property for the " + RenObject + " object is not assigned")
        RETURN FALSE
      ENDIF

      FormTable = UPPER(ObjProps["TABLE"])
      FormNum = UPPER(ObjProps["FORM"])

      ; Find the form's parent table RenObject.
      TableObject = ""
      FOREACH ParentTag IN ObjectHandles
        Parent = ObjectHandles[ParentTag]
        IF RenDyn.Get(Parent, "CLASS") = "RENTABLE" AND
           UPPER(RenDyn.Get(Parent, "TABLE")) = FormTable THEN
          TableObject = Parent
          QUITLOOP
        ENDIF
      ENDFOREACH

      IF TableObject = "" THEN
        DYNARRAY RenTblProps[]
        RenTblProps["TABLE"] = FormTable
        RenTblProps["HIDDEN"] = TRUE
        RenTblProps["TAG"] = RenObject + ".Table"
        TableObject = RenTable.Create(WorkspaceObject, RenTblProps)
        IF TableObject = "" THEN
          RETURN FALSE
        ENDIF
        RenTag = RenDyn.Get(TableObject, "TAG")
        ObjectHandles[RenTag] = TableObject
        RenTables[FormTable] = TableObject
      ENDIF

      IF TableObject <> "" THEN
        IF ISASSIGNED(RenForms[FormTable]) THEN
          ObjProps["DISPLAYNOW"] = FALSE
        ELSE
          RenForms[FormTable] = FormNum
        ENDIF

        FormObject = RenForm.Create(TableObject, ObjProps)
        IF FormObject = "" THEN
          RETURN FALSE
        ENDIF
        RenTag = RenDyn.Get(FormObject, "TAG")
        ObjectHandles[RenTag] =FormObject

        IF FirstObject = "" THEN
          FirstObject = FormObject
        ENDIF

        IF FirstFormObject = "" THEN
          FirstFormObject = FormObject
        ENDIF
      ENDIF

    CASE ObjectType = "MEMO" :
      FormObject  = ""
      TableObject = ""
      MemoTable   = UPPER(ObjProps["TABLE"])

      IF ISASSIGNED(ObjProps["MASTERTABLE"]) AND
         ISASSIGNED(ObjProps["MASTERFORM"]) THEN

        MasterTable = UPPER(ObjProps["MASTERTABLE"])
        MasterForm  = UPPER(ObjProps["MASTERFORM"])

        ; Find the memo's parent form RenObject.
        FormObject = ""
        FOREACH ParentTag IN ObjectHandles
          Parent = ObjectHandles[ParentTag]
          IF RenDyn.Get(Parent, "CLASS") = "RENFORM" AND
             UPPER(RenDyn.Get(Parent, "TABLE")) = MasterTable AND
             UPPER(RenDyn.Get(Parent, "FORM")) = MasterForm THEN
            FormObject  = Parent
            IF MasterTable = MemoTable THEN
              TableObject = RenDyn.Get(FormObject, "PARENT")
            ENDIF
            QUITLOOP
          ENDIF
        ENDFOREACH
      ENDIF

      IF TableObject = "" THEN
        ; Find the memo's parent table RenObject.
        FOREACH ParentTag IN ObjectHandles
          Parent = ObjectHandles[ParentTag]
          IF RenDyn.Get(Parent, "CLASS") = "RENTABLE" AND
             UPPER(RenDyn.Get(Parent, "TABLE")) = MemoTable THEN
            TableObject = Parent
            QUITLOOP
          ENDIF
        ENDFOREACH
      ENDIF

      IF TableObject = "" THEN
        DYNARRAY RenTblProps[]
        RenTblProps["TABLE"]  = MemoTable
        RenTblProps["HIDDEN"] = TRUE
        RenTblProps["TAG"]    = RenObject + ".Table"
        TableObject = RenTable.Create(WorkspaceObject, RenTblProps)
        IF TableObject = "" THEN
          RETURN FALSE
        ENDIF
        RenTag = RenDyn.Get(TableObject, "TAG")
        ObjectHandles[RenTag] = TableObject
        RenTables[MemoTable] = TableObject
      ENDIF

      ObjProps["FORMPARENT"] = FormObject
      MemoObject = RenMemo.Create(TableObject, ObjProps)
      IF MemoObject = "" THEN
        RETURN FALSE
      ENDIF
      RenTag = RenDyn.Get(MemoObject, "TAG")
      ObjectHandles[RenTag] = MemoObject
      IF FirstObject = "" THEN
        FirstObject = MemoObject
      ENDIF

    CASE ObjectType = "EDITOR" :
      RenObj = RenEditor.Create(WorkspaceObject, ObjProps)
      IF RenObj = "" THEN
        RETURN FALSE
      ENDIF
      IF FirstObject = "" THEN
        FirstObject = RenObj
      ENDIF
      RenTag = RenDyn.Get(RenObj, "TAG")
      ObjectHandles[RenTag] = RenObj

    CASE ObjectType = "CANVAS" :
      RenObj = RenCanvas.Create(WorkspaceObject, ObjProps)
      IF RenObj = "" THEN
        RETURN FALSE
      ENDIF
      IF FirstObject = "" THEN
        FirstObject = RenObj
      ENDIF
      RenTag = RenDyn.Get(RenObj, "TAG")
      ObjectHandles[RenTag] = RenObj

    CASE ObjectType = "CLOCK" :
      RenObj = RenClock.Create(WorkspaceObject, ObjProps)
      IF RenObj = "" THEN
        RETURN FALSE
      ENDIF
      IF FirstObject = "" THEN
        FirstObject = RenObj
      ENDIF
      RenTag = RenDyn.Get(RenObj, "TAG")
      ObjectHandles[RenTag] = RenObj

    CASE ObjectType = "CALENDAR" :
      RenObj = RenCalendar.Create(WorkspaceObject, ObjProps)
      IF RenObj = "" THEN
        RETURN FALSE
      ENDIF
      IF FirstObject = "" THEN
        FirstObject = RenObj
      ENDIF
      RenTag = RenDyn.Get(RenObj, "TAG")
      ObjectHandles[RenTag] = RenObj
  ENDSWITCH

  RETURN TRUE
ENDPROC
WRITELIB libname Ren.CreateObject
RELEASE PROCS Ren.CreateObject


PROC Ren.Create(Properties)
  PRIVATE NumMoreOptions, x, RenTag, CustomKeys, RenObject, Buttons, RenAttr, RenWin

  IF TYPE(Properties) <> "DY" THEN
    DYNARRAY Properties[]
  ENDIF

  NumMoreOptions = 0
  FOR x FROM 1 TO 15
    RenTag = "OPTION" + STRVAL(x)
    IF ISASSIGNED(Properties[RenTag]) THEN
      NumMoreOptions = NumMoreOptions + 1
      QUITLOOP ;;;
    ;ELSE
    ;  QUITLOOP
    ENDIF
  ENDFOR
  Properties["NUMOPTIONS"] = NumMoreOptions

  CustomKeys = RenAry.Create(15)
  Properties["CUSTOMKEYS"] = CustomKeys
  Ren.CreateKeys(VARVAL(CustomKeys))

  Properties["CLASS"]     = "REN"
  Properties["CANSELECT"] = FALSE

  DYNARRAY RenAttr[]
  RenAttr["TITLE"]        = "Workspace"
  RenAttr["FLOATING"]     = FALSE
  RenAttr["HEIGHT"]       = 1
  RenAttr["WIDTH"]        = 1
  RenAttr["CANVASHEIGHT"] = 1
  RenAttr["CANVASWIDTH"]  = 1
  WINDOW CREATE @-200,-200 ATTRIBUTES RenAttr TO RenWin
  Properties["WINDOW"] = RenWin
  Properties["TITLE"]  = "Workspace"
  Properties["TAG"]    = "WORKSPACE"

  RenObject = RenObject.Create(Properties)

  RenButtonBar.Create(RenObject, Properties)
  RenDyn.Set(RenObject, "BUTTONBAROBJECT", RETVAL)

  Ren["WORKSPACEOBJECT"] = RenObject
  Ren["WORKSPACEWINDOW"] = RenWin

  RETURN RenObject
ENDPROC
WRITELIB libname Ren.Create
RELEASE PROCS Ren.Create


PROC Ren.CreateKeys(CustomKeys)
  PRIVATE NumKeys, i, RenKeyVal, RenKeyList

  DYNARRAY RenKeyList[]

  NumKeys = 0

  FOREACH RenTag IN Properties
    IF SUBSTR(RenTag, 1, 4) = "KEY," THEN
      RenKeyVal = SUBSTR(RenTag, 5, 4)
      RETVAL = MATCH(RenKeyVal, "..,..", RenKeyVal)

      RenKeyVal = NUMVAL(RenKeyVal)
      IF RenKeyVal = "Error" THEN
        LOOP
      ENDIF

      IF ISASSIGNED(RenKeyList[RenKeyVal]) THEN
        LOOP
      ENDIF

      RenKeyList[RenKeyVal] = TRUE

      NumKeys = NumKeys + 1
      CustomKeys[NumKeys] = RenKeyVal
      IF NumKeys = 15 THEN
        QUITLOOP
      ENDIF
    ENDIF
  ENDFOREACH

  FOR i FROM NumKeys + 1 TO 15
    CustomKeys[i] = 0
  ENDFOR
ENDPROC
WRITELIB libname Ren.CreateKeys
RELEASE PROCS Ren.CreateKeys


PROC Ren.HandleEvent()
  PRIVATE CustomProc, RenWksObj, RenWksKeys,  RenObjKeys, RenActs, RenInfo

  ;IF Ren["SETUP"] = TRUE THEN
  ;  RenSetup.HandleEvent()
  ;  RETURN RETVAL
  ;ENDIF

  SWITCH
    CASE RenTrigger = "ARRIVEFIELD" :
      IF Ren["LOOKUPHIGHLIGHT"] = TRUE AND VERSION() >= 4.5 THEN
        Ren.ArriveField45()
      ENDIF

      Ren.ActionPoint3(RenObject, "ARRIVEFIELD", TRUE, TRUE, FALSE)
      IF RETVAL <> 0 THEN
        RETURN RETVAL
      ENDIF

      RETURN 0

    CASE RenTrigger = "DEPARTFIELD" :
      IF Ren["LOOKUPHIGHLIGHT"] = TRUE AND VERSION() >= 4.5 THEN
        Ren.DepartField45()
      ENDIF

      Ren.ActionPoint3(RenObject, "DEPARTFIELD", TRUE, TRUE, FALSE)
      IF RETVAL <> 0 THEN
        RETURN RETVAL
      ENDIF

      RETURN 0

    CASE RenTrigger = "EVENT" :
      SWITCH
        CASE RenEvent["TYPE"] = "KEY" :
          Ren.Key()
          RETURN RETVAL

        CASE RenEvent["TYPE"] = "MOUSE" :
          Ren.Mouse()
          RETURN RETVAL

        CASE RenEvent["TYPE"] = "MESSAGE" :
          Ren.Message()
          RETURN RETVAL

        CASE RenEvent["TYPE"] = "IDLE" :
          Ren.ActionPoint3(RenObject, "IDLE", FALSE, FALSE, FALSE)
          RETURN RETVAL
      ENDSWITCH

    CASE RenTrigger = "ARRIVEROW" :
      Ren.ArriveRow()
      RETURN RETVAL

    CASE RenTrigger = "DEPARTROW" :
      Ren.DepartRow()
      RETURN RETVAL

    CASE RenTrigger = "IMAGERIGHTS" :
      Ren.ImageRights()
      RETURN RETVAL

    CASE RenTrigger = "POSTRECORD" :
      Ren.PostRecord()
      RETURN RETVAL

    CASE RenTrigger = "ARRIVEOBJECT" :
      Ren.ArriveObject(RenObject, TRUE)
      RETURN RETVAL

    CASE RenTrigger = "DEPARTOBJECT" :
      Ren.DepartObject()
      RETURN RETVAL

    CASE RenTrigger = "ARRIVETABLE" :
      Ren.ArriveTable(TRUE)
      RETURN RETVAL

    CASE RenTrigger = "DEPARTTABLE" :
      Ren.DepartTable()
      RETURN RETVAL

    CASE RenTrigger = "SETWAITSPEC" :
      RenWksObj  = Ren["WORKSPACEOBJECT"]
      RenWksKeys = RenDyn.Get(RenwksObj, "CUSTOMKEYS")

      IF RenDyn.Get(RenObject, "INITWAIT") = "" THEN
        RenObjKeys = RenAry.Create(15)
        RenDyn.Set(RenObject, "CUSTOMKEYS", RenObjKeys)
        Ren.SetObjKeys(VARVAL(RenObject), VARVAL(RenObjKeys))

        RenActs = RenAry.Create(10)
        RenAry.Set(RenObject, "ACTIONS", RenActs)
        Ren.SetObjActs(VARVAL(RenWksObj), VARVAL(RenObject), VARVAL(RenActs))

        RenDyn.Set(RenObject, "INITWAIT", TRUE)
      ELSE
        RenObjKeys = RenDyn.Get(RenObject, "CUSTOMKEYS")
        RenActs    = RenDyn.Get(RenObject, "ACTIONS")
      ENDIF

      Ren.SetWaitSpec(VARVAL(RenWksKeys), VARVAL(RenObjKeys), VARVAL(RenActs))
      RETURN RETVAL

    CASE RenTrigger = "VALCHECK" :
      Ren.ValCheck()
      RETURN RETVAL

    OTHERWISE :
      Ren.ActionPoint(RenObject, RenTrigger)
      RETURN RETVAL
  ENDSWITCH

  RETURN 0
ENDPROC
WRITELIB libname Ren.HandleEvent
RELEASE PROCS Ren.HandleEvent


PROC Ren.SetWaitSpec(RenWksKeys, RenObjKeys, RenActs)
  PRIVATE RenAllKeys, RenIdle, RenDepFld, RenArrFld, RenAllMouse

  IF Ren["EVENTMONITOR"] <> "" THEN
    NEWWAITSPEC ALL
    RETURN 1
  ENDIF

  IF RenActs[9] = TRUE OR DYNARRAYSIZE(RenIdleWatchers) > 0 THEN
    RenIdle = TRUE
  ELSE
    RenIdle = FALSE
  ENDIF

  IF RenActs[10] = TRUE THEN
    RenAllKeys = "ALL"
  ELSE
    RenAllKeys = 0
  ENDIF

  IF RenActs[1] = TRUE THEN
    RenAllMouse = "ALL"
  ELSE
    RenAllMouse = "DOWN"
  ENDIF

  IF Ren["LOOKUPHIGHLIGHT"] = TRUE THEN
    RenArrFld = "ARRIVEFIELD"
    RenDepFld = "DEPARTFIELD"
  ELSE
    RenArrFld = RenActs[4]
    RenDepFld = RenActs[7]
  ENDIF

  IF RenIdle = TRUE THEN
    NEWWAITSPEC
      KEY "F2", "F1", "ZOOM", "ZOOMNEXT", 6, -108, "F7", "INS", "DEL", "UNDO",
        "LOCKKEY", -33, "DOS", "DOSBIG", "TOQPRO", "UPIMAGE", "DOWNIMAGE",
        -101, -97, -96, -45, -98, -88, 27, -48, -104, -108, -113,
        -31, -30, -19, -4, -7,
        RenAllKeys, RenWksKeys[1], RenWksKeys[2],
        RenWksKeys[3], RenWksKeys[4], RenWksKeys[5], RenWksKeys[6],
        RenWksKeys[7], RenWksKeys[8], RenWksKeys[9], RenWksKeys[10],
        RenWksKeys[11], RenWksKeys[12], RenWksKeys[13], RenWksKeys[14],
        RenWksKeys[15], RenObjKeys[1], RenObjKeys[2], RenObjKeys[3],
        RenObjKeys[4], RenObjKeys[5], RenObjKeys[6], RenObjKeys[7], RenObjKeys[8],
        RenObjKeys[9], RenObjKeys[10], RenObjKeys[11], RenObjKeys[12],
        RenObjKeys[13], RenObjKeys[14], RenObjKeys[15]
      MOUSE RenAllMouse, "DOWN", "UP", RenActs[1], RenActs[2], RenActs[3]
      MESSAGE "ALL"
      TRIGGER "DEPARTROW", "DEPARTTABLE", "ARRIVETABLE", "IMAGERIGHTS",
        "POSTRECORD", "TOUCHRECORD", "PASSRIGHTS", "REQUIREDVALUE", "VALCHECK",
        "DISPLAYONLY", "READONLY",
;        "DISPLAYONLY", "READONLY", "ARRIVEFIELD", "DEPARTFIELD",
        RenActs[5], RenActs[6], RenActs[8], RenArrFld, RenDepFld
      IDLE
  ELSE
    NEWWAITSPEC
      KEY "F2", "F1", "ZOOM", "ZOOMNEXT", 6, -108, "F7", "INS", "DEL", "UNDO",
        "LOCKKEY", -33, "DOS", "DOSBIG", "TOQPRO", "UPIMAGE", "DOWNIMAGE",
        -101, -97, -96, -45, -98, -88, 27, -48, -104, -108, -113,
        -31, -30, -19, -4, -7,
        RenAllKeys, RenWksKeys[1], RenWksKeys[2],
        RenWksKeys[3], RenWksKeys[4], RenWksKeys[5], RenWksKeys[6],
        RenWksKeys[7], RenWksKeys[8], RenWksKeys[9], RenWksKeys[10],
        RenWksKeys[11], RenWksKeys[12], RenWksKeys[13], RenWksKeys[14],
        RenWksKeys[15], RenObjKeys[1], RenObjKeys[2], RenObjKeys[3],
        RenObjKeys[4], RenObjKeys[5], RenObjKeys[6], RenObjKeys[7], RenObjKeys[8],
        RenObjKeys[9], RenObjKeys[10], RenObjKeys[11], RenObjKeys[12],
        RenObjKeys[13], RenObjKeys[14], RenObjKeys[15]
      MOUSE RenAllMouse, "DOWN", "UP", RenActs[1], RenActs[2], RenActs[3]
      MESSAGE "ALL"
      TRIGGER "DEPARTROW", "DEPARTTABLE", "ARRIVETABLE", "IMAGERIGHTS",
        "POSTRECORD", "TOUCHRECORD", "PASSRIGHTS", "REQUIREDVALUE", "VALCHECK",
        "DISPLAYONLY", "READONLY",
;        "DISPLAYONLY", "READONLY", "ARRIVEFIELD", "DEPARTFIELD",
        RenActs[5], RenActs[6], RenActs[8], RenArrFld, RenDepFld
  ENDIF

  Ren["ARRIVEFIELD"] = (RenArrFld  = "ARRIVEFIELD")
  Ren["DEPARTFIELD"] = (RenDepFld  = "DEPARTFIELD")

  Ren["ARRIVEROW"]   = (RenActs[6] = "ARRIVEROW")

  Ren["ARRIVEPAGE"]  = (RenActs[5] = "ARRIVEPAGE")
  Ren["DEPARTPAGE"]  = (RenActs[8] = "DEPARTPAGE")

  Ren["DEPARTROW"]   = TRUE
  Ren["TOUCHRECORD"] = TRUE

  RETURN 1 ; Tell object manager not to set waitspec to all.
ENDPROC
WRITELIB libname Ren.SetWaitSpec
RELEASE PROCS Ren.SetWaitSpec


PROC Ren.ArriveObject(RenObject, RenDoTrig)
  PRIVATE RenWksObj, RenClass, SaveObject, RenKey, RenOk,
          RenTblObj, RenRights, RenSaveObj, RenLastTbl, Children, Child,
          RenHide, ButtonObj, RenIsImage, TblObj, RenTbl, RenSaveObj


  ECHO OFF

  RenClass = RenDyn.Get(RenObject, "CLASS")

  IF RenClass = "REN" THEN
    RETURN 0
  ENDIF

  ;
  ; Okay to arrive on the object. Setup variables, prompt, menu, & buttons.
  ;
  RenWksObj = RenDyn.Get(RenObject, "WORKSPACE")
  Ren["WORKSPACEOBJECT"] = RenWksObj

  RenIsImage = (RenClass="RENTABLE" OR RenClass="RENFORM" OR
                RenClass="RENMEMO"  OR RenClass="RENFILTER")

  EXECPROC RenClass + ".Display"
  IF RETVAL = TRUE AND RenIsImage THEN
    IF SYSMODE() <> "CoEdit" THEN
      COEDITKEY
    ENDIF
  ENDIF

  ;
  ; Make sure user has rights to arrive on the object if it is a table
  ; or a form.
  ;
  IF (RenClass = "RENFORM" OR RenClass = "RENTABLE") AND
     Ren.CheckRights("NONE") = TRUE THEN

    RenOk = FALSE

    IF RenClass = "RENFORM" THEN
      ;
      ; See if user has rights for any embedded tables on the form.
      ;
      IF RenDyn.Get(RenObject, "NUMEMBED") > 0 THEN
        MOVETO RenDyn.Get(RenObject, "TABLE")
        NumPg = NPAGES()
        StartPg = PAGENO()
        CurPg = StartPg
        FOR Pg FROM 1 TO NumPg
          RenTbl = TABLE()
          WHILE TRUE
            DOWNIMAGE
            IF TABLE() = RenTbl THEN
              QUITLOOP
            ENDIF
            IF Ren.CheckRights("NONE") = FALSE THEN
              RenOk = TRUE
              QUITLOOP
            ENDIF
          ENDWHILE
          IF RenOk THEN
            QUITLOOP
          ENDIF
          IF CurPg = NumPg THEN
            WHILE PAGENO() > 1
              PGUP
            ENDWHILE
          ELSE
            PGDN
          ENDIF
          CurPg = PAGENO()
        ENDFOR
      ENDIF
    ELSE
      ;
      ; Table view object... If user used the F3 or F4 keys to move to the
      ; next table... keep pressing F3 or F4 until we find a table they
      ; have rights to.
      ;
      IF ISASSIGNED(RenEvent["KEYCODE"]) THEN
        RenKey = RenEvent["KEYCODE"]
      ELSE
        RenKey = 0
      ENDIF

      IF RenKey = -61 OR RenKey = -62 THEN ; F3/F4
        WHILE TRUE
          RenLastTbl = TABLE()
          KEYPRESS RenKey
          IF TABLE() = RenLastTbl THEN
            QUITLOOP
          ENDIF
          RenTblObj = Ren.GetObject()
          IF RenTblObj <> "" THEN
            RenSaveObj = RenObject
            RenRights = Ren.CheckRights("NONE")
            RenObject = RenSaveObj
            IF RenRight = FALSE THEN
              RenObject.Select(RenTblObj)
            ENDIF
          ENDIF
        ENDWHILE
      ENDIF
    ENDIF

    IF NOT RenOk THEN
      ;
      ; Could not find a table the user has rights to... Attempt to
      ; move back to the last table object, or select the first object
      ; that can be selected. If still can't select any objects, then
      ; display a message and quit.
      ;
      IF Ren["LASTTABLEOBJECT"] <> "" AND
         RenObject.Select(Ren["LASTTABLEOBJECT"]) THEN
        RETURN 1
      ENDIF

      IF Ren["WORKSPACEOBJECT"] <> "" THEN
        Children = RenDyn.Get(Ren["WORKSPACEOBJECT"], "CHILDREN")
        WHILE MATCH(Children, "..,..", Child, Children)
          IF Child <> RenObject AND
             RenDyn.Get(Child, "CANSELECT") <> FALSE AND
             RenDyn.Get(Child, "HIDDEN") <> TRUE AND
             RenObject.Select(Child)
          THEN
            RETURN 1
          ENDIF
        ENDWHILE

        RenContinue("Problem:\n\nNo objects that can be\nselected were defined")
        QUIT
      ENDIF
    ENDIF
  ENDIF

  IF Ren["ECHO"] <> FALSE THEN
    ECHO NORMAL
  ENDIF

  SWITCH
    CASE RenClass = "RENTABLE"  : TblObj = RenObject
    CASE RenClass = "RENFORM"   : TblObj = RenDyn.Get(RenObject, "PARENT")
    CASE RenClass = "RENFILTER" : TblObj = RenDyn.Get(RenObject, "PARENT")
    OTHERWISE                   : TblObj = ""
  ENDSWITCH

  IF TblObj <> "" AND RenDyn.Get(TblObj, "ISFILTER") = TRUE THEN
    Ren["ISFILTER"]     = TRUE
    Ren["FILTEROBJECT"] = RenDyn.Get(TblObj, "FILTEROBJECT")
    Ren["FILTERTABLE"]  = RenDyn.Get(Ren["FILTEROBJECT"], "TABLE")
    Ren["FILTERWINDOW"] = RenDyn.Get(Ren["FILTEROBJECT"], "WINDOW")
    Ren["TABLEWINDOW"]  = RenDyn.Get(TblObj, "WINDOW")
    Ren["TABLEOBJECT"]  = TblObj
    Ren["MAINTABLE"]    = RenDyn.Get(TblObj, "TABLE")
    RenFilter.Locate()
  ELSE
    IF Ren["ISFILTER"] = TRUE THEN
      Ren["ISFILTER"]     = FALSE
      Ren["FILTEROBJECT"] = ""
      Ren["FILTERTABLE"]  = ""
      Ren["FILTERWINDOW"] = 0
      Ren["TABLEWINDOW"]  = 0
      Ren["TABLEOBJECT"]  = ""
      Ren["MAINTABLE"]    = ""
    ENDIF
  ENDIF

  IF RenDyn.Get(RenObject, "INITBUTTONS") = "" THEN
    Ren.SetObjButs(VARVAL(RenWksObj), VARVAL(RenObject))
    RenDyn.Set(RenObject, "INITBUTTONS", TRUE)
  ENDIF

  ButtonObj = RenDyn.Get(RenWksObj, "BUTTONBAROBJECT")
  IF ButtonObj <> "" AND ISASSIGNED(VARVAL(ButtonObj)) THEN
    RenButtonBar.Update(ButtonObj, VARVAL(RenObject))
  ENDIF

  PROMPT ""
  RenSaveObj = Ren["CURRENTOBJECT"]
  Ren.ShowPulldown()
  IF RETVAL <> 0 AND RenSaveObj <> Ren["CURRENTOBJECT"] THEN
    RETURN RETVAL
  ENDIF

  IF RenDoTrig THEN
    Ren.ActionPoint3(RenObject, "ARRIVEWINDOW", FALSE, FALSE, FALSE)
    RETURN RETVAL
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname Ren.ArriveObject
RELEASE PROCS Ren.ArriveObject


PROC Ren.ArriveObject2(RenActions)
  Ren["ARRIVEFIELD"] = (RenActions[4] = "ARRIVEFIELD")
  Ren["ARRIVEPAGE"]  = (RenActions[5] = "ARRIVEPAGE")
  Ren["ARRIVEROW"]   = (RenActions[6] = "ARRIVEROW")
  Ren["DEPARTFIELD"] = (RenActions[7] = "DEPARTFIELD")
  Ren["DEPARTPAGE"]  = (RenActions[8] = "DEPARTPAGE")
  Ren["DEPARTROW"]   = TRUE
  Ren["TOUCHRECORD"] = TRUE
ENDPROC
WRITELIB libname Ren.ArriveObject2
RELEASE PROCS Ren.ArriveObject2


PROC Ren.SetObjActs(RenW, RenO, RenA)
  RenA[1] =IIF(ISASSIGNED(RenW["MOUSEALL"])    OR ISASSIGNED(RenO["MOUSEALL"]),   "ALL",        "DOWN")
  RenA[2] =IIF(ISASSIGNED(RenW["MOUSEMOVE"])   OR ISASSIGNED(RenO["MOUSEMOVE"]),  "MOVE",       "DOWN")
  RenA[3] =IIF(ISASSIGNED(RenW["MOUSEAUTO"])   OR ISASSIGNED(RenO["MOUSEAUTO"]),  "AUTO",       "DOWN")
  RenA[4] =IIF(ISASSIGNED(RenW["ARRIVEFIELD"]) OR ISASSIGNED(RenO["ARRIVEFIELD"]),"ARRIVEFIELD","IMAGERIGHTS")
  RenA[5] =IIF(ISASSIGNED(RenW["ARRIVEPAGE"])  OR ISASSIGNED(RenO["ARRIVEPAGE"]), "ARRIVEPAGE", "IMAGERIGHTS")
  RenA[6] =IIF(ISASSIGNED(RenW["ARRIVEROW"])   OR ISASSIGNED(RenO["ARRIVEROW"]),  "ARRIVEROW",  "IMAGERIGHTS")
  RenA[7] =IIF(ISASSIGNED(RenW["DEPARTFIELD"]) OR ISASSIGNED(RenO["DEPARTFIELD"]),"DEPARTFIELD","IMAGERIGHTS")
  RenA[8] =IIF(ISASSIGNED(RenW["DEPARTPAGE"])  OR ISASSIGNED(RenO["DEPARTPAGE"]), "DEPARTPAGE", "IMAGERIGHTS")
  RenA[9] =IIF(ISASSIGNED(RenW["IDLE"])        OR ISASSIGNED(RenO["IDLE"]),       TRUE,         FALSE)
  RenA[10]=IIF(ISASSIGNED(RenW["KEYALL"])      OR ISASSIGNED(RenO["KEYALL"]),     TRUE,         FALSE)

  IF ISASSIGNED(RenO["1MM1"]) THEN
    RenA[6] = "ARRIVEROW"
  ENDIF
ENDPROC
WRITELIB libname Ren.SetObjActs
RELEASE PROCS Ren.SetObjActs


PROC Ren.SetObjKeys(RenObjPtr, RenObjKeys)
  PRIVATE RenTaken, RenCtr, RenTag, RenKey, i

  DYNARRAY RenTaken[]

  RenCtr = 0

  FOREACH RenTag IN RenObjPtr
    IF SUBSTR(RenTag, 1, 4) = "KEY," THEN
      RenKey = SUBSTR(RenTag, 5, 4)

      IF MATCH(RenKey, "..,..", RenKey) THEN
        ; Removed table/field after keycode
      ENDIF

      RenKey = NUMVAL(RenKey)
      IF RenKey <> "Error" AND NOT ISASSIGNED(RenTaken[RenKey]) THEN
        RenTaken[RenKey] = TRUE
        RenCtr = RenCtr + 1
        RenObjKeys[RenCtr] = RenKey
        IF RenCtr = 15 THEN
          QUITLOOP
        ENDIF
      ENDIF
    ENDIF
  ENDFOREACH

  FOR i FROM RenCtr + 1 TO 15
    RenObjKeys[i] = 0
  ENDFOR
ENDPROC
WRITELIB libname Ren.SetObjKeys
RELEASE PROCS Ren.SetObjKeys


PROC Ren.SetObjButs(RenWksProps, RenProps)
  PRIVATE RenClass, i, si, RenButTag, RenActTag

  IF Ren["SETUP"] = TRUE THEN
    RETURN
  ENDIF

  FOR i FROM 1 TO 15
    si = STRVAL(i)
    RenButTag = "BUTTON" + si

    IF ISASSIGNED(RenProps[RenButTag]) THEN
      LOOP
    ENDIF

    RenActTag = "BUTTONACTION" + si

    IF ISASSIGNED(RenWksProps[RenButTag]) THEN
      RenProps[RenButTag] = RenWksProps[RenButTag]
      IF ISASSIGNED(RenWksProps[RenActTag]) THEN
        RenProps[RenActTag] = RenWksProps[RenActTag]
      ELSE
        RELEASE VARS RenProps[RenActTag]
      ENDIF
      LOOP
    ENDIF
  ENDFOR
ENDPROC
WRITELIB libname Ren.SetObjButs
RELEASE PROCS Ren.SetObjButs


PROC Ren.DepartObject()
  PRIVATE RenClass

  RenClass = RenDyn.Get(RenObject, "CLASS")

  IF RenClass = "RENTABLE" OR RenClass = "RENFORM" THEN
    IF ISFIELDVIEW() THEN
      DO_IT!
    ENDIF
  ENDIF

  Ren.SaveWinAttr(RenObject)

  Ren.ActionPoint3(RenObject, "DEPARTWINDOW", FALSE, FALSE, FALSE)
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  RETURN 0
ENDPROC
WRITELIB libname Ren.DepartObject
RELEASE PROCS Ren.DepartObject


PROC Ren.SaveWinAttr(RenObject)
  PRIVATE Win, WinAttr

  Win = RenDyn.Get(RenObject, "WINDOW")

  IF Win <> "" AND ISWINDOW(Win) THEN
    WINDOW GETATTRIBUTES Win TO WinAttr
    RenDyn.Set(RenObject, "ORIGINROW", WinAttr["ORIGINROW"])
    RenDyn.Set(RenObject, "ORIGINCOL", WinAttr["ORIGINCOL"])
    RenDyn.Set(RenObject, "HEIGHT",    WinAttr["HEIGHT"])
    RenDyn.Set(RenObject, "WIDTH",     WinAttr["WIDTH"])
    RenDyn.Set(RenObject, "MAXIMIZED", WinAttr["MAXIMIZED"])
  ENDIF
ENDPROC
WRITELIB libname Ren.SaveWinAttr
RELEASE PROCS Ren.SaveWinAttr


PROC Ren.ArriveTable(RenDoTrig)
  PRIVATE RenStartTbl, RenKey, RenTbl, RenLastTbl, RenOk, Win

  RenStartTbl = TABLE()

  IF RenDyn.Get(RenObject, "CLASS") <> "RENMEMO" THEN
    IF ISFORMVIEW() AND Ren.CheckRights("NONE") THEN
      IF ISASSIGNED(RenEvent["KEYCODE"]) THEN
        RenKey = RenEvent["KEYCODE"]
      ELSE
        RenKey = 0
      ENDIF

      RenOk = FALSE

      IF RenKey = -61 OR RenKey = -62 THEN ; F3/F4
        ECHO OFF
        RenTbl = TABLE()
        WHILE TRUE
          KEYPRESS RenKey
          IF TABLE() = RenTbl THEN
            QUITLOOP
          ENDIF
          IF NOT Ren.CheckRights("NONE") THEN
            RenOk = TRUE
            QUITLOOP
            ;RenObjectMgr.SimTrigger(RenObject, "ARRIVETABLE")
            ;RETURN 0
          ENDIF
        ENDWHILE
      ENDIF

      IF NOT RenOk THEN
        IF NOT ISASSIGNED(RenIsSim) THEN
          BEEP
        ENDIF
        RenLastTbl = RenDyn.Get(RenObject, "LASTTABLE")
        IF RenLastTbl <> "" THEN
          MOVETO RenLastTbl
        ELSE
          MOVETO RenDyn.Get(RenObject, "TABLE")
        ENDIF
        RenObjectMgr.SetImageRights("READONLY")
        IF RenDoTrig THEN
          Ren.ActionPoint(RenObject, "ARRIVETABLE")
          IF RETVAL <> 0 THEN
            RETURN RETVAL
          ENDIF
        ENDIF
        RETURN 1
      ENDIF
    ENDIF

    IF RenDoTrig THEN
      IF UPPER(RenDyn.Get(RenObject, "TABLE")) = UPPER(TABLE()) AND SYSMODE() = "CoEdit" THEN
        IF Ren["RECORDSTATUS"] = "" AND RenRecStat("Locked") AND
           RenRecStat("New") = FALSE AND ISVALID() = TRUE THEN
          MOVETO FIELD FIELD()
          UNLOCKRECORD
        ENDIF
      ENDIF
    ENDIF
  ENDIF

  RenDyn.Set(RenObject, "LASTTABLE", TABLE())

;  IF RenDoTrig OR TABLE() <> RenStartTbl THEN
  IF Ren["RECORDSTATUS"] = "" THEN
    RenObjectMgr.SetImageRights("READONLY")
  ELSE
    Ren.SetRecStat(Ren["RECORDSTATUS"])
  ENDIF
;  ENDIF

  IF RenDoTrig THEN
    Ren.ActionPoint(RenObject, "ARRIVETABLE")
    RETURN RETVAL
  ELSE
    RETURN 0
  ENDIF
ENDPROC
WRITELIB libname Ren.ArriveTable
RELEASE PROCS Ren.ArriveTable


PROC Ren.DepartTable()
  Ren.ActionPoint(RenObject, "DEPARTTABLE")
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  RenObjectMgr.SetImageRights("")

  Ren["LASTTABLEOBJECT"] = RenObject
  Ren["LASTTABLE"]       = TABLE()
  Ren["LASTFIELD"]       = FIELD()
  Ren["LASTMODIFIED"]    = FALSE
ENDPROC
WRITELIB libname Ren.DepartTable
RELEASE PROCS Ren.DepartTable


PROC Ren.ArriveRow()
  IF Ren["RECORDSTATUS"] = "" THEN
    Ren.1mm()
  ENDIF

  Ren.ActionPoint(RenObject, "ARRIVEROW")
  RETURN RETVAL
ENDPROC
WRITELIB libname Ren.ArriveRow
RELEASE PROCS Ren.ArriveRow


PROC Ren.1mm()
  PRIVATE RenVal, i, RenTbl, RenMst, RenDet1, RenDet2, ST, ET

  RenVal = RenDyn.Get(RenObject, "1MM1")
  IF RenVal <> "" THEN
;    ST = TICKS()
    ECHO OFF
    RenTbl = UPPER(TABLE())
    RenMst = UPPER(RenDyn.Get(RenObject, "TABLE"))
    FOR i FROM 1 TO 15
      IF i > 1 THEN
        RenVal = RenDyn.Get(RenObject, "1MM" + STRVAL(i))
        IF RenVal = "" THEN
          QUITLOOP
        ENDIF
      ENDIF
      IF MATCH(RenVal, "..,..,..", RenDet1, RenDet2, RenVal) THEN
        RenDet1 = UPPER(RenDet1)
        IF RenTbl = RenMst THEN
          Ren.1mmLink(RenMst, RenDet1, RenVal, TRUE)
        ELSE
          IF RenTbl = RenDet1 THEN
            Ren.1mmLink(RenMst, RenDet1, RenVal, FALSE)
          ENDIF
        ENDIF
      ENDIF
    ENDFOR
    ECHO NORMAL
;    ET = TICKS()
;    MESSAGE "Update 1mm Link (Regular): ", FORMAT("W8.2", (ET - ST) / 1000), " seconds"
  ENDIF
ENDPROC
WRITELIB libname Ren.1mm
RELEASE PROCS Ren.1mm


PROC Ren.1mmLink(RenMst, RenDet, RenVal, RenOnMst)
  PRIVATE RenLnkFld, RenError, RenErrorProc,
          RenNum, RenRec, RenFld, RenSaveLock, RenLock

  IF NOT RenOnMst THEN
    RenNum = ROWNO()
    RenRec = RECNO()
    RenFld = FIELD()
    MOVETO RenMst
  ENDIF

  RenSaveLock = RenRecStat("Locked")
  RenLock = RenSaveLock
  IMAGERIGHTS

  RenVal   = RenVal + ","
  RenBlank = FALSE

  RenSetSkipError()

  WHILE MATCH(RenVal, "[..],..", RenLnkFld, RenVal)
    IF NOT RenBlank THEN
      RenError = FALSE
      EXECUTE "RenDetVal = [" + RenDet + "->" + RenLnkFld + "]" +
              "IF RenError = FALSE AND [" + RenLnkFld + "] <> RenDetVal THEN\n" +
              "  Ren.1mmLinkLock()\n" +
              "  IF RenLock THEN\n" +
              "    [" + RenLnkFld + "] = RenDetVal\n" +
              "  ENDIF\n" +
              "ENDIF"
    ENDIF

    IF RenError OR RenBlank THEN
      RenBlank = TRUE
      Ren.1mmLinkLock()
      IF RenLock THEN
        RenError = FALSE
        EXECUTE "[" + RenLnkFld + "] = \"\"\n" +
                "IF RenError THEN\n" +
                "  RenError = FALSE\n" +
                "  [" + RenLnkFld + "] = BLANKNUM()\n" +
                "  IF RenError THEN\n" +
                "    RenError = FALSE\n" +
                "    [" + RenLnkFld + "] = BLANKDATE()\n" +
                "  ENDIF\n" +
                "ENDIF"
      ENDIF
    ENDIF
  ENDWHILE

  RenUnsetSkipError()

  IF RenLock THEN
    IF NOT RenSaveLock THEN
      UNLOCKRECORD
    ELSE
      RESYNCKEY
    ENDIF
  ENDIF

  SWITCH
    CASE Ren["IMAGERIGHTS"] = "READONLY" : IMAGERIGHTS READONLY
    CASE Ren["IMAGERIGHTS"] = "UPDATE"   : IMAGERIGHTS UPDATE
  ENDSWITCH

  IF NOT RenOnMst THEN
    MOVETO RenDet
    IF RECNO() <> RenRec THEN
      SETRECORDPOSITION RenRec RenNum
    ENDIF
    MOVETO FIELD RenFld
  ELSE
    MOVETO FIELD FIELD()
  ENDIF
ENDPROC
WRITELIB libname Ren.1mmLink
RELEASE PROCS Ren.1mmLink


PROC Ren.1mmLinkLock()
  IF NOT RenLock THEN
    LOCKRECORD
    IF NOT RETVAL AND ERRORCODE() <> 55 THEN
      RETURN
    ENDIF
    RenLock = TRUE
  ENDIF
ENDPROC
WRITELIB libname Ren.1mmLinkLock
RELEASE PROCS Ren.1mmLinkLock


PROC Ren.1mmNewDet1(RenMst, RenDet, RenVal)
  PRIVATE RenStr, RenVal, RenType, RenNum, RenRec, RenFld, RenLnkFld,
          RenError, RenSaveErrorProc

  RenVal = RenVal + ","

  RenStr = ""

  WHILE MATCH(RenVal, "[..],..", RenLnkFld, RenVal)
    EXECUTE "RenVal = [" + RenLnkFld + "]"

    RenType = SUBSTR(TYPE(RenVal), 1, 1)

    SWITCH
      CASE RenType = "A" OR RenType = "M" :
        RenStr = RenStr + "[" + RenLnkFld + "]=\"\"\n"

      CASE RenType = "$" OR RenType = "N" OR RenType = "S" :
        RenStr = RenStr + "[" + RenLnkFld + "]=BLANKNUM()\n"

      CASE RenType = "D" :
        RenStr = RenStr + "[" + RenLnkFld + "]=BLANKDATE()\n"
    ENDSWITCH
  ENDWHILE

  IF RenStr = "" THEN
    RETURN
  ENDIF

  RenNum = ROWNO()
  RenRec = RECNO()
  RenFld = FIELD()

  MOVETO RenMst

  RenSetSkipError()
  EXECUTE RenStr
  RenUnsetSkipError()

  RESYNCKEY

  MOVETO RenDet
  IF RECNO() <> RenRec THEN
    SETRECORDPOSITION RenRec RenNum
  ENDIF
  MOVETO FIELD RenFld
ENDPROC
WRITELIB libname Ren.1mmNewDet1
RELEASE PROCS Ren.1mmNewDet1


PROC Ren.DepartRow()
  PRIVATE RenKey, RenRetval

  IF (ISASSIGNED(RenIsSim) = FALSE OR RenIsSim <> TRUE) AND
     Ren["RECORDSTATUS"] <> "" THEN

    RenObjectMgr.SimTrigger(RenObject, "POSTRECORD")
    IF RETVAL <> 0 THEN
      RETURN RETVAL
    ENDIF
  ENDIF

  Ren.ActionPoint(RenObject, "DEPARTROW")
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  IF NOT ISASSIGNED(RenEvent["KEYCODE"]) THEN
    RETURN 0
  ENDIF

  IF ISASSIGNED(RenIsSim) AND RenIsSim = TRUE AND
    ISASSIGNED(RenEvent["FROMNEXTRECORD"]) = FALSE AND
    ISASSIGNED(RenEvent["FROMPREVRECORD"]) = FALSE THEN
    RETURN 0
  ENDIF

  IF Ren["ISFILTER"] AND TABLE() = Ren["MAINTABLE"] THEN
    Ren.FilterDepartRow()
    IF NOT RETVAL THEN
      RETURN 0
    ELSE
      RETURN 1
    ENDIF
  ENDIF

  IF NOT ATLAST() THEN
    RETURN 0
  ENDIF

  RenKey = RenEvent["KEYCODE"]

  IF RenKey = 13 OR RenKey = 9 OR RenKey = -77 OR
     RenKey = -80 OR RenKey = -81 OR RenKey = -118 THEN

    WHILE CHARWAITING()
      RETVAL = GETCHAR()
    ENDWHILE

    IF Ren.CheckRights("INSERT") = FALSE THEN
      BEEP
      RETURN 1
    ENDIF

    IF ISASSIGNED(RenEvent["FROMNEXTRECORD"]) THEN
      BEEP
      RETURN 1
    ENDIF

    RenDyn.Get(RenObject, "INSERTPASTEND," + TABLE())
    IF RETVAL <> TRUE THEN
      BEEP
      RETURN 1
    ENDIF

    ; User is trying to depart past the last record to a new blank record.
    ECHO OFF

    IF Ren["RECORDSTATUS"] <> "" THEN
      RenObjectMgr.SimTrigger(RenObject, "POSTRECORD")
      IF RETVAL <> 0 THEN
        RETURN RETVAL
      ENDIF
    ENDIF

    IMAGERIGHTS
    KEYPRESS RenKey
    IF RenRecStat("New") THEN
      ; Let the ImageRights trigger know it is being called from this
      ; DepartRow trigger.
      RenEvent["FROMDEPARTROW"] = TRUE
      RenObjectMgr.SimImageRights(RenObject)
      RenRetval = RETVAL
      RELEASE VARS RenEvent["FROMDEPARTROW"]
      IF RenRetval <> 0 THEN
        RETURN RenRetval
      ENDIF
    ELSE
      Ren["RECORDSTATUS"] = ""
      RenObjectMgr.SetImageRights("READONLY")
      RenObjectMgr.SimArriveRow(RenObject, TABLE(), FIELD())
      IF RETVAL <> 0 THEN
        RETURN RETVAL
      ENDIF
    ENDIF

    WHILE CHARWAITING()
      RETVAL = GETCHAR()
    ENDWHILE

    RETURN 1
  ELSE
    RETURN 0
  ENDIF
ENDPROC
WRITELIB libname Ren.DepartRow
RELEASE PROCS Ren.DepartRow


PROC Ren.ShowPulldown()
  PRIVATE RenMoreTitle, RenClass, b1, b2, t, s, RenHide, RenButtons,
          RenButtonOpts, i, RenButtonWid, NumOpts, RenNext, RenPrev,
          NumOpts

  Ren.ActionPoint3(RenObject, "SHOWPULLDOWN", TRUE, FALSE, FALSE)
  IF RETVAL <> 0 THEN
    RETURN RETVAL
  ENDIF

  RenMoreTitle = RenDyn.Get(RenObject, "OPTIONSTITLE")
  IF RenMoreTitle = "" THEN
    RenMoreTitle = RenDyn.Get(Ren["WORKSPACEOBJECT"], "OPTIONSTITLE")
    IF RenMoreTitle = "" THEN
      RenMoreTitle = "Options"
    ENDIF
  ENDIF

  RenClass = RenDyn.Get(RenObject, "CLASS")

  IF Ren["MENUSTYLE"] = "GUI" THEN
    ;b1 = "~<~> "
    b1 = ""
    b2 = "~<~> "
    t  = ""
    ;s  = "~<~>"
    s  = ""
  ELSE
    b1 = ""
    b2 = ""
    t  = "~"
    s  = ""
  ENDIF

  SWITCH
    CASE RenClass = "RENTABLE" OR RenClass = "RENFORM" OR RenClass = "RENFILTER" :
      IF RenClass = "RENTABLE" THEN
        RenNext = "[" + CHR(25) + "]"
        RenPrev = "[" + CHR(24) + "]"
      ELSE
        RenNext = "[Ctrl-PgDn]"
        RenPrev = "[Ctrl-PgUp]"
      ENDIF

      SHOWPULLDOWN
        s : "" : ""
          SUBMENU
            b2+"Window List      [Ctrl-Esc]" : "" : "WindowList",
            b2+"Next Window      [Ctrl-F4]" : "" : "NextWindow",
            b2+"Previous Window  [Ctrl-F3]" : "" : "PrevWindow",
            b2+"Clock" : "" : "Clock",
            b2+"Ca"+t+"l"+t+"endar" : "" : "Calendar",
            b2+"Video" : "" : ""
              SUBMENU
                b2+"25 Line Mode" : "" : "Video25",
                b2+"50 Line Mode" : "" : "Video50"
              ENDSUBMENU
          ENDSUBMENU,
        b1+"Edit" : "" : ""
          SUBMENU
            b2+"Insert         [Ins]" : "" : "Insert",
            b2+"Delete         [Del]" : "" : "Delete",
            b2+"Save           [F2]"  : "" : "PostRecord",
            b2+"Undo           [Ctrl-U]" : "" : "Undo",
            b2+"Lookup         [F1]" : "" : "Lookup"
          ENDSUBMENU,
        b1+"Image" : "" : ""
          SUBMENU
            b2+"Filter           [Alt-F]" : "" : "Filter",
            b2+"Browse           [Alt-B]" : "" : "Browse",
            b2+"Form "+t+"T"+t+"oggle      [F7]" : "" : "FormToggle",
            b2+"Order Table      [Alt-S]" : "" : "OrderTable",
            SEPARATOR,
            b2+"Down Image       [F4]" : "" : "DownImage",
            b2+"Up Image         [F3]" : "" : "UpImage",
            SEPARATOR,
            b2+"Next Record      " + RenNext : "" : "NextRecord",
            b2+"Previous Record  " + RenPrev : "" : "PrevRecord",
            b2+"Last Record      [End]" : "" : "LastRecord",
            b2+"F"+t+"i"+t+"rst Record     [Home]" : "" : "FirstRecord"
          ENDSUBMENU,
        b1+"Search" : "" : ""
          SUBMENU
            b2+"Find "+t+"F"+t+"irst  [Ctrl-Z]" : "" : "Zoom",
            b2+"Find "+t+"N"+t+"ext   [Alt-Z]" : "" : "ZoomNext"
          ENDSUBMENU,
;        b1+"Buttons" : "" : "Buttons",
        b1+RenMoreTitle : "" : "Options",
        b1+"Help" : "" : ""
          SUBMENU
            b2+"Help  [Alt-F1]" : "" : "Help"
          ENDSUBMENU,
        b1+"Quit" : "" : ""
          SUBMENU
            b2+"No" : "" : "",
            b2+"Yes" : "" : "Quit"
          ENDSUBMENU
      ENDMENU

      IF RenDyn.Get(RenObject, "CANFILTER") = FALSE THEN
        MENUDISABLE "Filter"
      ENDIF

    CASE RenClass = "RENMEMO" OR RenClass = "RENEDITOR" :
      SHOWPULLDOWN
        s : "" : ""
          SUBMENU
            b2+"Window List      [Ctrl-Esc]" : "" : "WindowList",
            b2+"Next Window      [Ctrl-F4]" : "" : "NextWindow",
            b2+"Previous Window  [Ctrl-F3]" : "" : "PrevWindow",
            b2+"Clock" : "" : "Clock",
            b2+"Ca"+t+"l"+t+"endar" : "" : "Calendar",
            b2+"Video" : "" : ""
              SUBMENU
                b2+"25 Line Mode" : "" : "Video25",
                b2+"50 Line Mode" : "" : "Video50"
              ENDSUBMENU
          ENDSUBMENU,
        b1+"Edit" : "" : ""
          SUBMENU
            b2+"Copy   [Ctrl-Ins]" : "" : "Copy",
            b2+"Paste  [Shift-Ins]" : "" : "Paste",
            b2+"XCut   [Shift-Del]" : "" : "XCut",
            b2+"Erase  " : "" : "Erase"
          ENDSUBMENU,
        b1+"Search" : "" : ""
          SUBMENU
            b2+"Find "+t+"F"+t+"irst  [Ctrl-Z]" : "" : "Zoom",
            b2+"Find "+t+"N"+t+"ext   [Alt-Z]" : "" : "ZoomNext"
          ENDSUBMENU,
        b1+"Do-It"   : "" : "PostRecord",
        b1+"Cancel" : "" : ""
          SUBMENU
            b2+"No" : "" : "",
            b2+"Yes" : "" : "Cancel"
          ENDSUBMENU,
;        b1+"Buttons" : "" : "Buttons",
        b1+RenMoreTitle : "" : "Options",
        b1+"Help" : "" : ""
          SUBMENU
            b2+"Help  [Alt-F1]" : "" : "Help"
          ENDSUBMENU,
        b1+"Quit" : "" : ""
          SUBMENU
            b2+"No" : "" : "",
            b2+"Yes" : "" : "Quit"
          ENDSUBMENU
      ENDMENU

    OTHERWISE :
      SHOWPULLDOWN
        s : "" : ""
          SUBMENU
            b2+"Window List      [Ctrl-Esc]" : "" : "WindowList",
            b2+"Next Window      [Ctrl-F4]" : "" : "NextWindow",
            b2+"Previous Window  [Ctrl-F3]" : "" : "PrevWindow",
            b2+"Clock" : "" : "Clock",
            b2+"Ca"+t+"l"+t+"endar" : "" : "Calendar",
            b2+"Video" : "" : ""
              SUBMENU
                b2+"25 Line Mode" : "" : "Video25",
                b2+"50 Line Mode" : "" : "Video50"
              ENDSUBMENU
          ENDSUBMENU,
;        b1+"Buttons" : "" : "Buttons",
        b1+RenMoreTitle : "" : "Options",
        b1+"Help" : "" : ""
          SUBMENU
            b2+"Help  [Alt-F1]" : "" : "Help"
          ENDSUBMENU,
        b1+"Quit" : "" : ""
          SUBMENU
            b2+"No" : "" : "",
            b2+"Yes" : "" : "Quit"
          ENDSUBMENU
      ENDMENU
  ENDSWITCH

  NumOpts = RenDyn.Get(RenObject, "NUMOPTIONS")
  IF NumOpts = 0 OR NumOpts = "" THEN
    NumOpts = RenDyn.Get(Ren["WORKSPACEOBJECT"], "NUMOPTIONS")
  ENDIF
  IF NumOpts = 0 OR NumOpts = "" THEN
    MENUDISABLE "Options"
  ENDIF

  ;RenHide = RenDyn.Get(RenObject, "HIDEBUTTONS")
  ;IF RenHide <> TRUE AND RenHide <> FALSE THEN
  ;  RenHide = RenDyn.Get(Ren["WORKSPACEOBJECT"], "HIDEBUTTONS")
  ;ENDIF
  ;IF RenHide = TRUE THEN
  ;  MENUDISABLE "Buttons"
  ;ENDIF

  RETURN 0
ENDPROC
WRITELIB libname Ren.ShowPulldown
RELEASE PROCS Ren.ShowPulldown


PROC Ren.CallDesigner()
  PRIVATE ComFile, ComStr

  FILEWRITE PRIVDIR() + "_Renlast.txt" FROM RenGo

  WHILE CHARWAITING()
    RETVAL = GETCHAR()
  ENDWHILE

  IF VERSION() >= 4.5 THEN
    EXECUTE "PUSHKEYS DOS -19, -86" ; Alt-R (Start Ren), Shift-F3 (Load Last)
  ELSE
    ComFile = PRIVDIR() + "_Rentemp.com"

    ComStr =
      "\180\005"+      ;mov ah 05h
      "\185\000\019"+  ;mov cx 2c1ah ; Alt-R
      "\205\022"+      ;int 22

      "\180\005"+      ;mov ah 05h
      "\185\000\086"+  ;mov cx 2c1ah ; Shift-F3
      "\205\022"+      ;int 22

      "\180\076"+      ;mov ah 4c
      "\205\033"       ;int 21

    FILEWRITE ComFile FROM ""

    PRINT FILE ComFile ComStr

    RUN NOREFRESH NOSHELL ComFile
  ENDIF
ENDPROC
WRITELIB libname Ren.CallDesigner
RELEASE PROCS Ren.CallDesigner


PROC Ren.Destroy()
  PRIVATE color.s, sys.y, wid.s, hgt.s

  ECHO OFF

  SETCANVAS DEFAULT
  SYSINFO TO sys.y
  wid.s = sys.y["SCREENWIDTH"] - 1
  hgt.s = sys.y["SCREENHEIGHT"] - 1
  color.s = SYSCOLOR(1001)
  PAINTCANVAS FILL " " ATTRIBUTE color.s 0,0,0,wid.s
  color.s = SYSCOLOR(1071)
  PAINTCANVAS FILL " " ATTRIBUTE color.s hgt.s,0,hgt.s,wid.s

  RenDyn.Destroy(RenDyn.Get(RenObject, "BUTTONS"))
  RenAry.Destroy(RenDyn.Get(RenObject, "CUSTOMKEYS"))
  RETURN TRUE
ENDPROC
WRITELIB libname Ren.Destroy
RELEASE PROCS Ren.Destroy


PROC Ren.CleanupFiles()
  PRIVATE i, RenFile

  IF SYSMODE() = "Main" THEN
    ECHO OFF

    IF ISFILE(PRIVDIR() + "_Renwork.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Renwork" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Renprop.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Renprop" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Rendoc.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Rendoc" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Rentemp.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Rentemp" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Rentmp1.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Rentmp1" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Rentmp2.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Rentmp2" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Renflfx.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Renflfx" ENTER {OK}
    ENDIF

    IF ISFILE(PRIVDIR() + "_Rencode.sc") THEN
      MENU {Tools} {DELETE} {Script} TYPEIN PRIVDIR() + "_Rencode" ENTER {OK}
    ENDIF

    FOR i FROM 1 TO 999
      RenFile = "_Rent" + STRVAL(i)
      IF ISFILE(RenFile + ".sc") THEN
        MENU {Tools} {DELETE} {Script} TYPEIN RenFile ENTER {OK}
      ELSE
        QUITLOOP
      ENDIF
    ENDFOR
  ENDIF
ENDPROC
WRITELIB LibName Ren.CleanupFiles
RELEASE PROCS  Ren.CleanupFiles


RELEASE VARS LibName

