; Quick Tip
; ----------------------------------------------------------------------
; By Dan Morgan, Morgan Information Systems, 76164,2640
;
; Many of my applications contain multi-table forms which depend upon their key
; structures to work properly.  Too many times (and once is too many times) I
; get a call from a client because a Paradox table has lost its indexes.
;
; I developed the following procedure to allow my client's to test and rebuild
; indexes without my having to drive to their location.  The procedure depends
; upon a table "Rebuild" which contains a master listing of the key fields for
; every keyed table in the application.
;
; Row 20: Obtains the largest number of key fields in a single table and uses
; that number to dynamically size the arrays for field names and field keys
;
; Row 23: Is used to test for BOT (bottom of table) condition in Rebuild
;
; Rows 29-47: This part of the code places the field names into FldArray and
; the correct key values into KeyArray
;
; Row 48: Tools Info Structure is used to create a table with the structure
; of the table being tested
;
; Rows 54-58:  Test the Structure table to see if the table being tested is
; keyed correctly.  If it finds a discrepancy in field names it gives the user
; a message (Row 73-77) and quits.  If it finds a discrepancy in key values it
; repairs all keys for the table (Rows 59-70)
;
; Row 80: Clears the test table from the workspace and rows 81-83 quit the
; processing loop if there are no more tables to test.
;
;=============================================================== Rebuild()
PROC Rebuild()                                                              ;  1
PRIVATE  FldArray,     ; Array of field names                               ;  2
         KeyArray,     ; Array of key values                                ;  3
         Recno.s,      ; Record number in Rebuild Table                     ;  4
         Fldno.s,      ; Record number in table being checked               ;  5
         Tabname.s,    ; Name of table being checked                        ;  6
         TotlTabs.s    ; Total records in Rebuild table                     ;  7
                                                                            ;  8
Clear                                                                       ;  9
Cursor OFF                                                                  ; 10
Recno.s = 1                                                                 ; 11
                                                                            ; 12
STYLE ATTRIBUTE 95                                                          ; 13
@8,0 ?? FORMAT("W80,AC","VERIFYING AND REPAIRING KEYS IN DATA TABLES")      ; 14
                                                                            ; 15
; SETDIR (path & directory of data tables)                                  ; 16
                                                                            ; 17
VIEW "Rebuild"                                                              ; 18
MOVETO FIELD "REC #"                                                        ; 29
x = ImageCMax()                                                             ; 20
ARRAY FldArray[x]                                                           ; 21
ARRAY KeyArray[x]                                                           ; 22
TotlTabs.s = NRecords(Table())                                              ; 23
                                                                            ; 24
While True                                                                  ; 25
   MOVETO FIELD "TABLE NAME"                                                ; 26
   MOVETO RECORD Recno.s                                                    ; 27
   Tabname.a = []                                                           ; 28
   While True                                                               ; 29
      MOVETO FIELD "REC #"                                                  ; 30
      Fldno.s = []                                                          ; 31
      MOVETO FIELD "KEY FIELD"                                              ; 32
      FldArray[Fldno.s] = []                                                ; 33
      MOVETO FIELD "KEY"                                                    ; 34
      KeyArray[Fldno.s] = []                                                ; 35
      If Recno() < TotlTabs.s Then                                          ; 36
         Down                                                               ; 37
      Else                                                                  ; 38
         Recno.s = Recno()                                                  ; 39
         QuitLoop                                                           ; 40
      EndIf                                                                 ; 41
      MOVETO FIELD "TABLE NAME"                                             ; 42
      If Tabname.a <> [] Then                                               ; 43
         Recno.s = Recno()                                                  ; 44
         QuitLoop                                                           ; 45
      EndIf                                                                 ; 46
   EndWhile                                                                 ; 47
   Menu {Tools} {Info} {Structure} SELECT Tabname.a                         ; 48
   MOVETO FIELD "Field Name"                                                ; 49
   FOR i FROM 1 TO Fldno.s                                                  ; 50
      Canvas ON                                                             ; 51
      MESSAGE "Verifying "+Tabname.a+" "+FldArray[i]+" "+KeyArray[i]        ; 52
      Canvas OFF                                                            ; 53
      MOVETO RECORD i                                                       ; 54
      MOVETO FIELD "Field Name"                                             ; 55
      If [] = FldArray[i] Then                                              ; 56
         MOVETO FIELD "Field Type"                                          ; 57
         If [] <> KeyArray[i] Then                                          ; 58
            Canvas ON                                                       ; 59
            MESSAGE "Repairing "+Tabname.a+" "+FldArray[i]+" "+ KeyArray[i] ; 60
            Canvas OFF                                                      ; 61
            Menu {Modify} {Restructure} SELECT Tabname.a                    ; 62
            MOVETO FIELD  "Field Type"                                      ; 63
            FOR counter FROM 1 TO Fldno.s                                   ; 64
               MOVETO RECORD counter                                        ; 65
               CtrlBackspace                                                ; 66
               Typein KeyArray[counter]                                     ; 67
            ENDFOR                                                          ; 68
            Do_It!                                                          ; 69
            QuitLoop                                                        ; 70
         EndIf                                                              ; 71
      Else                                                                  ; 72
         Canvas ON                                                          ; 73
         BEEP SLEEP 100 BEEP SLEEP 100 BEEP                                 ; 74
         MESSAGE "Terminating Procedure:  A Serious Table Structure Error Exists"
         dump = GetChar()                                                   ; 76
         Return False                                                       ; 77
      EndIf                                                                 ; 78
   ENDFOR                                                                   ; 79
   ClearImage                                                               ; 80
   If Recno.s = TotlTabs.s Then                                             ; 81
      QuitLoop                                                              ; 82
   EndIf                                                                    ; 83
EndWhile                                                                    ; 84

ClearAll
Canvas ON

;ENDPROC
;WRITELIB "WaitLib" Rebuild
;Release Procs Rebuild
;@5,40 ?? "\004"
