; First, we do Query1
Query

  Pledges |   ID  |       Date        |        Pledge       |
          | Check | >=1/1/90, <1/1/93 | calc average as avg |

Endquery
Do_it!    ; This executes the query
RENAME "Answer" "Avg"
CLEARALL

; Clearall is necessary. It clears the screen. If we don't clear
; the screen, the next query will produce a run-time error since
; the Query1 form will still be on the workspace.

; Now we do Query2
Query

  AVG | ID    |              AVG                          |
      | Check | Check <100, calc 150 as Request           |
      | Check | Check >=100, <300, calc 500 as Request    |
      | Check | Check >=300, _abc, calc _abc*4 as Request |

Endquery
Do_it!
RENAME "ANSWER" "Request"
CLEARALL

; Next we ask for information.  Since the condition for the
; WHILE loop involves the variable x, we must give it an
; initial value; otherwise Paradox will flash an error message
;" Variable x has not been assigned a value" when it reaches
; WHILE x <> "y" (a run-time  error) 
x = ""
WHILE x <> "y"
  CLEAR   ; Clear the canvas for next message
  @5,6??"Please enter amount to request from small donors.  "
  ??
  ACCEPT "N" TO smallgifts

  CLEAR
  @5,6??"Please enter amount to request from medium donors.  "
  ??
  ACCEPT "N" TO mediumgifts

  CLEAR
  @5,6??"Please enter multiplier for large donors.  "
  ??
  ACCEPT "N" TO largegifts
  CLEAR

  ; Now present the values provided by the user and
  ; ask for confirmation.

  @5,6??"The request for small donors will be ", smallgifts
  ?"      The request for medium donors will be ", mediumgifts
  ?"      The multiplier for large donors will be ", largegifts
  ?
  ?"     Are these numbers correct? Y/N  "
  ??
  x = GETCHAR()
  x = LOWER(CHR(x)) 
ENDWHILE
CLEAR

; Next we use the values provided by the user in our Changeto Query.

; Query3
Query

  REQUEST |    AVG     |         REQUEST                 | 
          |   <=100    | changeto ~smallgifts            |
          | >100, <300 | changeto ~mediumgifts           | 
          | >=600      | _abc, changeto _abc*~largegifts |

Endquery
Do_it!
CLEARALL

; Finally, we calculate the sums for each group and
; present the Answer.

Query

  REQUEST |               AVG                  |      REQUEST      |
          | <=100, calc "Small  " as Group     | calc sum as Total |
          | >100, <300, calc "Medium "as Group | calc sum as Total |
          | >=300, calc "Large  " as Group     | calc sum as Total |
          | calc "Overall" as Group            | calc sum as Total |

Endquery
Do_it!
CLEARALL

VIEW "Answer"


