; pxtools.sc
;
; ATT's general PXtools-procedures
; pre-release 0,92
;
; (c)      Ajan Tietotekniikka ATT Oy 1992
; Author:  Tapani Isoranta (Compuserve ID: 100021,3453)
;
; Address: Itlahdenkatu 21 A
;          00210 Helsinki
;          Finland
;
; Tel:     358-0-671699     in Finland (90)-671699
; Fax:     358-0-671761                (90)-671761
;
; ATT Oy is specialized in Paradox ja FoxPro developing
;
; General notes:
;
;         These Pxtools-routines are at Paradox 3.5 -level
;
;        Ŀ
;        Ŀ 
;         As You know, Paradox is excellent for little applications   
;                                 and                                 
;         with these routines a simple Paradox-application is a snap  
;                   take a look at ASKII-application                  
;         
;        
;         PXtools contains generic procedures for functions, which
;         exist in nearly all systems
;
;         - variables, doing a multilingual system is easy
;         - error handling, you can trap errors
;         - table protection
;         - environment control in networks
;         - popup menu system at two level, menus gerarates from a table
;         - popups, also multi-select popup
;         - help system, context sensitive, references (=See Also features)
;         - messages
;         - dialogs
;         - key-handling
;         - search
;         - filtering
;         - output
;         - query by form, no more  Query |||| Endquery
;
;
; Special notes:
;
;         Database filtering in Paradox is not rightforward,
;         here g_filtermode puts filter on through a filter table
;
;         Paradox 3.5 does't know any memo field. In Pxtools
;         memo-field is implemented by a linked table,
;         controlled with g_memotbl, row-number is recno()
;
;         Look reference help-system, where shadow-key technic glamours
;
;         With shadow-key technic you can prevent form lock
;         (use a link-field, that isn't a key field)
;

;----------------------------------------------- create library
;

if isfile("pxtools.lib") then
  run "del pxtools.lib"
endif

libname = "pxtools"

createlib libname size 100


;----------------------------------------------- var.pxvariables ()
; Global variables of PXsystem
;
; Parameters:
;
; Globals:
;
; Return:
;
; Notes:      g_ ... means global variable
;


proc var.pxvariables ()

  g_errfile      = "pxerr.lis"     ; errorfile
  g_error        = 1               ; return from error procedure

  g_screenproc   = ""

  ; variables for general browser
  g_mode         = True            ; browse mode
  g_normalmode   = True            ; normal browse mode
  g_filtermode   = False           ; browse mode with filter table selections
  g_update       = False           ; update status
  g_mastertbl    = ""              ; master table in browse mode
  g_masterfrm    = ""              ; master form
  g_memotbl      = ""              ; memo table
  g_filtertbl    = ""              ; filter table contains selected items
  g_mkeyfld      = ""              ; master key field
  g_fkeyfld      = ""              ; filter key field
  g_mnutbl       = ""              ; menu table contains menu selections
  g_rowfld       = ""              ; memo row field

  ; variables for help system
  g_hlptopic     = ""              ; context sensitive help topic
  g_shlptopic    = ""              ; sub help topic
  g_hlptbl       = ""              ; help topic table
  g_hlptxttbl    = ""              ; help text table
  g_hlpreftbl    = ""              ; help reference table
  g_topicfld     = ""              ; help topic field
  g_stopicfld    = ""              ; sub help topic field
  g_topictmpfld  = ""              ; help topic temporary field
  g_stopictmpfld = ""              ; sub help topic temporary field

  ; variables for query system
  g_condtbl      = ""              ; QBF condition table
  g_searchtbl    = ""              ; dummy answer table
  g_mstsrchtbl   = ""              ; master search table
  g_evtsrchtbl   = ""              ; event table
  g_persrchtbl   = ""              ; person table
  g_pertmptbl    = ""              ; temporary person table
  g_oth1srchtbl  = ""              ; other search table 1
  g_oth2srchtbl  = ""              ; other search table 2
  g_mstkeyfld    = ""              ; master key field
  g_othkeyfld    = ""              ; other key field  (ex. person number)

  g_outersearch  = 1               ; outer join search
  g_linearsearch = 2               ; normal search
  g_eventsearch  = 3               ; event search

  ; general time variables
  g_worldend     = today()+1000000 ; later in the future
  g_second       = 1000            ; one second
  g_moment       = 2000            ; two seconds

  ; general keys
  g_space        = 32              ; space bar character
  g_ctrlpgdn     = -118            ; ctrl pgdn, next master record at detail level
  g_ctrlpgup     = -132            ; ctrl pgup, previous master record at detail level

  ; popup variables
  array g_popitem[1]               ; popup items
  array g_popval[1]                ; popup values when value differs from item
  array g_popsel[1]                ; selected popup items
  g_popwidth     = 0               ; popup width
  g_popind       = 0               ; count of popup items

  ; output variables
  g_output       = ""              ; output device
  g_copycount    = 0               ; count of copies
  g_file         = ""              ; print file

endproc

writelib libname var.pxvariables


;----------------------------------------------- var.finmessages ()
; PXsystem general messages in finnish
;
; Parameters:
;
; Globals:
;
; Return:
;


proc var.finmessages ()

  g_welcome      = "Tervetuloa"
  g_waiting      = "Odota..."
  g_waitblank    = "        "

  g_anykey       = "  ...      "
  g_escape       = "Esc=Paluu  "
  g_enter        = "<Enter>    "
  g_help         = "F1=Opastus "
  g_save         = "F2=Talleta "
  g_select       = "F2=Valinta "
  g_change       = "F2=Muutos  "
  g_print        = "F3=Tulosta "
  g_search       = "F5=Haku    "
  g_zoom         = "F6=Laajenn "
  g_topic        = "F7=Aiheet  "
  g_swifrm       = "F7=LomTaul "
  g_codesrch     = "F8=Koodi   "
  g_memo         = "F9=Memo    "
  g_menu         = "F10=Menu   "
  g_popselect    = "=Valitse "
  g_insert       = "Ins=Lisys "
  g_delete       = "Del=Poisto "
  g_nxtwin       = "Tab=Siirto "

  g_givepassw    = "Anna salasana taululle "
  g_invpassw     = "Vr salasana - yrit uudelleen, Esc peru"
  g_directory    = "Hakemisto: "
  g_quitprogram  = "Lopetus K/E "
  g_lookup       = "Aputaulu"
  g_lookupdef    = "Aputaulu koodeille"
  g_edit         = "Muokkaus"
  g_editdef      = "Aputaulun muokkaus"
  g_helpsys      = "Opastus"
  g_helpdef      = "Opasteiden katselu"
  g_topic        = "F7=Aihe    "
  g_looktopic    = "F7=Katso   "
  g_areyousure   = "Oletko varma K/E "
  g_cancel       = "Peru"
  g_canceldef    = "Paluu ohjelmaan"
  g_dos          = "Dos"
  g_dosdef       = "Dos kyttjrjestelmn"
  g_movetorec    = "Etsi tietue nro: "
  g_filtercond   = "Hakuehto: "
  g_notfound     = "Haku ei lyd!"
  g_srchprompt   = "Haku: "
  g_outselect    = "Kirjoitin, Nytt, Tiedosto K/N/T: "
  g_filename     = "Tiedosto: "
  g_copies       = "Kopioiden mr: "
  g_dupkey       = "Duplikaatti avain!"
  g_printoffline = "Kirjoitin ei ole pll!"

  g_continue     = "Jatka"
  g_tryagain     = "Yrit uudelleen"
  g_debug        = "Debug"

  g_yes          = "K"
  g_no           = "E"
  g_printer      = "K"
  g_screen       = "N"
  g_file         = "T"

endproc

writelib libname var.finmessages


;----------------------------------------------- var.engmessages ()
; PXsystem general messages in english
;
; Parameters:
;
; Globals:
;
; Return:
;


proc var.engmessages ()

  g_welcome      = "Welcome!"
  g_waiting      = "Wait..."
  g_waitblank    = "       "

  g_anykey       = "  ...      "
  g_escape       = "Esc=Quit   "
  g_enter        = "<Enter>    "
  g_help         = "F1=Help    "
  g_save         = "F2=Save    "
  g_select       = "F2=Select  "
  g_change       = "F2=Edit    "
  g_print        = "F3=Print   "
  g_search       = "F5=Search  "
  g_zoom         = "F6=Zoom    "
  g_topic        = "F7=Topics  "
  g_swifrm       = "F7=Formkey "
  g_codesrch     = "F8=Code    "
  g_memo         = "F9=Memo    "
  g_menu         = "F10=Menu   "
  g_popselect    = "=Select  "
  g_insert       = "Ins=Insert "
  g_delete       = "Del=Delete "
  g_nxtwin       = "Tab=Nxtwin "

  g_givepassw    = "Enter password for "
  g_invpassw     = "Invalid password - try again, Esc to quit"
  g_directory    = "Directory: "
  g_quitprogram  = "Quit program Y/N "
  g_lookup       = "Lookup"
  g_lookupdef    = "Lookup codes"
  g_edit         = "Edit"
  g_editdef      = "Edit codetable"
  g_helpsys      = "Help"
  g_helpdef      = "Look help"
  g_topic        = "F7=Topic   "
  g_looktopic    = "F7=Look    "
  g_areyousure   = "Are You Sure Y/N "
  g_cancel       = "Cancel"
  g_canceldef    = "Goto program"
  g_dos          = "Dos"
  g_dosdef       = "To Dos"
  g_movetorec    = "Moveto record: "
  g_filtercond   = "Filter condition: "
  g_notfound     = "Not found!"
  g_srchprompt   = "Search: "
  g_outselect    = "Printer, Screen, File P/S/F: "
  g_filename     = "Filename: "
  g_copies       = "Copies: "
  g_dupkey       = "Duplicate key!"
  g_printoffline = "Printer is offline!"

  g_continue     = "Continue"
  g_tryagain     = "Try Again"
  g_debug        = "Debug"

  g_yes          = "Y"
  g_no           = "N"
  g_printer      = "P"
  g_screen       = "S"
  g_file         = "F"

endproc

writelib libname var.engmessages


;------------------------------------------------ err.handler ()
; General error procedure
;
; Parameters:
;
; Globals:    g_errfile
;             g_continue
;             g_tryagain
;             g_debug
;
; Return:     0   - try again
;             1   - continue
;             2   - debug
;
; Notes:      errors go to the errofile (g_errfile)
;


proc err.handler ()

  private errorproc,
          errmes,
          choice

  errmes = errormessage()

  retval = match(errmes, "Run error: .."   , errmes)
  retval = match(errmes, "Syntax error: ..", errmes)

  beep

  print file g_errfile
  format("d3", today())+"  "+format("w10",time())+format("w20",username ())+"\n"
  +"  "+format("w78", errmes)+"\n"

  showmenu
    g_continue   : errormessage() ,
    g_tryagain   : errormessage() ,
    g_debug      : errormessage()
  to choice

  switch
    case choice = g_tryagain :
      return 0
    case choice = g_continue :
      return 1
    case choice = g_debug :
      return 2
  endswitch

endproc

writelib libname err.handler


;----------------------------------------------- err.keyviol ()
; Check key violation situation
;
; Parameters:
;
; Globals:    g_dupkey
;             g_moment
;             g_update
;
; Return:     True  - no key violation
;             False - key violation exists
;


proc err.keyviol ()

  if g_update and sysmode() = "CoEdit" then
    if isformview () then
      if formtype("DisplayOnly") then
        return True
      endif
    endif
    unlockrecord
    if recordstatus("Keyviol") then
      beep message g_dupkey sleep g_moment
      return False
    endif
  endif
  return True

endproc

writelib libname err.keyviol


;----------------------------------------------- pro.password ()
; Get protected table's password
;
; Parameters: tbl (A), checked table
;
; Globals:
;
; Return:     True (L),  table not encrypted or password ok
;             False (L), invalid password
;


proc pro.password (tbl)

  private passw

  if not isencrypted(tbl) then
    return True
  endif

  while True
    msg.dialog (g_givepassw+upper(tbl)+": ","A31","","","")
    if isblank(retval) then
      return False
    else
      passw = retval
    endif
    password passw
    if tablerights(tbl,"Insdel") then
      return True
    endif
    unpassword passw
    message g_invpassw sleep tim_hetki
  endwhile

endproc

writelib libname pro.password



;----------------------------------------------- env.checkdir ()
; Check and/or create a directory
;
; Parameters: dir (A), checked directory
;
; Globals:    g_directory
;
; Return:     directory or blank (A)
;


proc env.checkdir (dir)

  while True
    if match(dir,"\\..") then
      dir = substr(sdir(),1,2) + dir
    endif
    if not match(dir,"@:\\..") and not isblank(dir) then
      dir = sdir() + dir
    endif
    if not match(dir,"..\\") and not isblank(dir) then
      dir = dir + "\\"
    endif
    env.createdir (dir)
    if retval then
      return dir
    endif
    msg.dialog (g_directory,"A40","","","")
    if isblank(retval) then
      return ""
    else
      dir = retval
      return dir
    endif
  endwhile

endproc

writelib libname env.checkdir


;----------------------------------------------- env.createdir ()
; Create a directory
;
; Parameters: dir (A), checked directory
;
; Globals:
;
; Return:     True (L),  dir exists
;             False (L), dir does not exists
;


proc env.createdir (dir)

  if direxists(dir)  <> 1 then
   switch
    case not match(dir,"..\\") :
     execute "run norefresh \"md \"+dir+\"\""
    otherwise :
     execute "run norefresh \"md \"+substr(dir,1,len(dir)-1)+\"\""
   endswitch
  endif

  if direxists(dir) = 1 and not isblank(dir) then
    return True
  else
    return False
  endif

endproc

writelib libname env.createdir


;----------------------------------------------- prg.copyright ()
; About-screen (c)
;
; Parameters:
;
; Globals:    g_flashtbl
;
; Return:
;
; Notes:
;


proc prg.copyright ()

  view  g_flashtbl
  pickform "1"

  prompt  g_escape,
          spaces (79)

  wait table until "Esc","Enter"
  clearimage

endproc

writelib libname prg.copyright


;------------------------------------------------ mnu.system1 ()
; Main level menubuilder
;
; Parameters: mainmnu (A), located in g_mnutbl
;
; Globals:    g_sreenproc, background procedure
;             g_cont
;             g_popselect
;             g_help
;             g_escape
;
; Return:
;
; Notes:      max 5 levels and 20 selections
;             you can change arraysizes
;
;             menu-entries are read from g_mnutbl
;


proc mnu.system1 (mainmnu)

  private g_popitem,
          g_popwidth,
          g_popind,
          g_hlptopic,
          g_shlptopic,
          g_cont,
          prompt1,
          prompt2,
          poppros,
          popnewmnu,
          mnulevel,
          level

  array g_popitem[20]
  array poppros[20]
  array popnewmnu[20]
  array mnulevel[5]

  newmnu      = mainmnu
  oldmnu      = mainmnu
  level       = 1
  mnulevel[1] = 1
  prompt1     = g_popselect
  g_cont      = True
  g_shlptopic = "mnu"

  if sysmode() <> "Main" then
    do_it!
  endif

  execproc g_screenproc

  mnu.set (newmnu,level)

  while g_cont
    if level = 1 then
      prompt2 = g_help
    else
      prompt2 = g_help+g_escape
    endif
    pop.menupopup(poprow,popcol,mnulevel[level],prompt1,prompt2)
    if not isblank(retval) and type(retval) <> "N" then          ; F1 help
      mnulevel[level] = numval(substr(retval,2,len(retval)))
      execproc g_screenproc
      loop
    endif
    if isblank(retval) then
      newmnu = oldmnu
      if level > 1 then
        level = level - 1
      endif
      mnu.set (newmnu,level)
      oldmnu = mainmnu
      execproc g_screenproc
      loop
    endif
    if isblank(poppros[retval]) then
      oldmnu          = newmnu
      newmnu          = popnewmnu[retval]
      mnulevel[level] = retval
      level           = level + 1
      mnulevel[level] = 1
      mnu.set (newmnu,level)
      loop
    else
      mnulevel[level] = retval
      g_hlptopic = g_popitem[retval]
      execute poppros[retval]
    endif
    execproc g_screenproc
  endwhile

endproc

writelib libname mnu.system1


;------------------------------------------------ mnu.system2 ()
; Form level menubuilder
;
; Parameters: mainmnu (A), located in g_mnutbl
;
; Globals:    g_cont
;             g_popselect
;             g_help
;             g_escape
;
; Return:
;
; Notes:      recursive use of menu system
;             max 5 levels and 20 selections
;             you can change arraysizes
;
;             menu-entries are read from g_mnutbl
;


proc mnu.system2 (mainmnu)

  private g_cont,
          g_hlptopic,
          g_shlptopic,
          g_popitem,
          g_popind,
          g_popwidth,
          prompt1,
          prompt2,
          poppros,
          popnewmnu,
          mnulevel,
          oldmnu,
          level,
          mnupros

  array g_popitem[20]
  array poppros[20]
  array popnewmnu[20]
  array mnulevel[5]

  newmnu      = mainmnu
  oldmnu      = mainmnu
  level       = 1
  mnulevel[1] = 1
  g_cont      = True
  g_shlptopic = "mnu"

  prompt1     = g_popselect
  prompt2     = g_help+g_escape

  if sysmode() <> "Main" then
    do_it!
  endif

  mnu.set (newmnu,level)

  while g_cont
    pop.menupopup(poprow,popcol,mnulevel[level],prompt1,prompt2)
    if not isblank(retval) and type(retval) <> "N" then          ; F1 help
      mnulevel[level] = numval(substr(retval,2,len(retval)))
      clear
      loop
    endif
    if isblank(retval) then
      newmnu = oldmnu
      if level > 1 then
        level = level - 1
      else
        return
      endif
      mnu.set (newmnu,level)
      oldmnu = mainmnu
      loop
    endif
    if isblank(poppros[retval]) then
      oldmnu          = newmnu
      newmnu          = popnewmnu[retval]
      mnulevel[level] = retval
      level           = level + 1
      mnulevel[level] = 1
      mnu.set (newmnu,level)
      loop
    else
      mnulevel[level] = retval
      g_hlptopic = g_popitem[retval]
      execute poppros[retval]
    endif
  endwhile

endproc

writelib libname mnu.system2


;----------------------------------------------- mnu.set ()
; Read menutable to popup-array
;
; Parameters: newmnu (A), newmenu located in g_mnutbl
;             level (N),  menu level (1 to 5)
;
; Globals:    g_mnutbl
;             g_popitem
;             g_popind
;             g_popwidth
;
; Return:     array g_popitem (A)
;             array popnewmnu (A)
;             array poppros (A)
;             g_popwidth (N)
;             g_popind (N)
;             poprow (N)
;             popcol (N)
;
; Notes:      max 5 levels and 20 selections
;             you can change arraysizes
;


proc mnu.set (newmnu,level)

  private r

  switch
   case level  = 1 :
     poprow    = 2
     popcol    = 0
   case level  = 2 :
     poprow    = 3
     popcol    = 5
   case level  = 3 :
     poprow    = 4
     popcol    = 10
   case level  = 4 :
     poprow    = 5
     popcol    = 15
   case level  = 5 :
     poprow    = 6
     popcol    = 20
  endswitch

  g_popwidth = 1
  g_popind   = 0

  view g_mnutbl
  moveto [Menu]
  locate newmnu

  scan for [] = newmnu
    g_popind            = g_popind + 1
    g_popwidth          = max(g_popwidth,len([Mnurow]))
    g_popitem[g_popind] = [Mnurow]
    popnewmnu[g_popind] = [Newmnu]
    poppros[g_popind]   = [Pros]
  endscan

  clearimage

endproc

writelib libname mnu.set


;----------------------------------------------- mnu.end ()
; Check end status
;
; Parameters:
;
; Globals:    g_quitprogram
;             g_yes
;             g_no
;             g_cont
;
; Return:     g_cont (L), False quits, True does not quit
;


proc mnu.end ()

  msg.dialog (g_quitprogram,"A1","!","","")

  switch
    case retval = g_yes :
      g_cont = False
    otherwise :
      g_cont = True
  endswitch

endproc

writelib libname mnu.end


;----------------------------------------------- pop.setpopup ()
; Create popup-arrays from a table
;
; Parameters: poptbl (A),  scanning table
;             popitem (A), field for popup items
;             popval (A),  field for popup values
;
; Globals:
;
; Return:     array g_popitem (A), popup items
;             array g_popval (A),  popup values
;             g_popind       (N),  number of popup selections
;             g_popwidth     (N),  popup width
;


proc pop.setpopup (poptbl,popitem,popval)

   array g_popitem[nrecords(poptbl)]
   array g_popval[nrecords(poptbl)]

   g_popind     = 0
   g_popwidth = 1

   view poptbl
   moveto field popitem

   switch
     case popval = "" :
       scan
         g_popind            = g_popind + 1
         g_popwidth          = max(g_popwidth,len([]))
         g_popitem[g_popind] = []
       endscan
     case popval <> "" :
       scan
         g_popind                    = g_popind + 1
         g_popwidth                  = max(g_popwidth,len([]))
         g_popitem[g_popind]         = []
         execute "g_popval[g_popind] = ["+popval+"]"
       endscan
   endswitch

   clearimage

endproc

writelib libname pop.setpopup


;----------------------------------------------- pop.popup ()
; General popup routine
;
; Parameters: prow (N),     popup's first row
;             pcol (N),     popup's left corner column
;             firstrow (N), cursor row at beginning
;
; Globals:    array g_popitem  popup items
;             g_popind         index to popitem array
;             g_popwidth       max width of popitems
;
; Return:     mnuselect (N),   index to selected popup item
;


proc pop.popup (prow,pcol,firstrow)

  private popsize,
          beginrow,
          mnurow,
          mnuselect,
          popupcolor,
          popselcolor,
          dimcolor,
          shadowcolor

  popupcolor  = syscolor(0)   ;  63
  popselcolor = syscolor(2)   ;  31
  dimcolor    = 127
  shadowcolor = 8

  if arraysize(g_popitem) = 0 then
    return ""
  endif

  popsize  = min(g_popind,24 - prow - 2)

  beginrow = max (1,firstrow - popsize + 1)

  pop.prompt (g_popselect,g_escape)

  cursor off
  canvas off

  paintcanvas
    attribute shadowcolor
    prow + 1, pcol + 1, prow + 2 + popsize, pcol + 1 + g_popwidth + 4

  style attribute popupcolor

  setmargin pcol

  @ prow, pcol

  ?? "",fill("",g_popwidth + 2),""

  for ind from beginrow to beginrow + popsize - 1
     ? " ",substr(strval(g_popitem[ind]) +
            spaces(g_popwidth+4),1,g_popwidth + 1),""
  endfor

  ?  "",fill("",g_popwidth + 2),""

  setmargin off
  canvas on
  mnuselect  = firstrow
  mnurow = firstrow - beginrow + 1

  while True

    style attribute popselcolor
    pop.popdraw()
    style attribute popupcolor
    char = getchar()
    switch
      case char = asc("Enter") :
         cursor normal
         paintcanvas attribute dimcolor
                     prow,pcol,prow + popsize + 1,pcol + g_popwidth + 3
         style attribute popselcolor
         pop.popdraw ()
         return mnuselect
      case char = asc("Esc") :
         cursor normal
         paintcanvas attribute dimcolor
                     prow,pcol,prow + popsize + 1,pcol + g_popwidth + 3
         return ""
      otherwise:
         pop.movekey (char)
    endswitch

  endwhile

endproc

writelib libname pop.popup


;----------------------------------------------- pop.menupopup ()
; Menu popup routine
;
; Parameters: prow (N),     popup's first row
;             pcol (N),     popup's left corner column
;             firstrow (N), cursor row at beginning
;             prompt1 (A),  first prompt row
;             prompt2 (A),  second prompt row
;
; Globals:    array g_popitem  popup items
;             g_popind         index to popitem array
;             g_popwidth       max width of popitems
;
; Return:     mnuselect (N),   index to selected popup item
;


proc pop.menupopup (prow,pcol,firstrow,prompt1,prompt2)

  private popsize,
          beginrow,
          mnurow,
          mnuselect,
          popupcolor,
          popselcolor,
          dimcolor,
          shadowcolor

  popupcolor  = syscolor(0)   ;  63
  popselcolor = syscolor(2)   ;  31
  dimcolor    = 127
  shadowcolor = 8

  if arraysize(g_popitem) = 0 then
    return ""
  endif

  popsize  = min(g_popind,24 - prow - 2)

  beginrow = max (1,firstrow - popsize + 1)

  pop.prompt (prompt1,prompt2)

  cursor off
  canvas off

  paintcanvas
    attribute shadowcolor
    prow + 1, pcol + 1, prow + 2 + popsize, pcol + 1 + g_popwidth + 4

  style attribute popupcolor

  setmargin pcol

  @ prow, pcol

  ?? "",fill("",g_popwidth + 2),""

  for ind from beginrow to beginrow + popsize - 1
     ? " ",substr(strval(g_popitem[ind]) +
            spaces(g_popwidth+4),1,g_popwidth + 1),""
  endfor

  ?  "",fill("",g_popwidth + 2),""

  setmargin off
  canvas on
  mnuselect  = firstrow
  mnurow = firstrow - beginrow + 1

  while True

    style attribute popselcolor
    pop.popdraw()
    style attribute popupcolor
    char = getchar()
    switch
      case char = -59 :
        hlp.lookhelptext(g_popitem[mnuselect],g_shlptopic)
        return "H"+strval(mnuselect)
      case char = asc("Enter") :
        cursor normal
        paintcanvas attribute dimcolor
                    prow,pcol,prow + popsize + 1,pcol + g_popwidth + 3
        style attribute popselcolor
        pop.popdraw ()
        return mnuselect
      case char = asc("Esc") :
        cursor normal
        paintcanvas attribute dimcolor
                    prow,pcol,prow + popsize + 1,pcol + g_popwidth + 3
        return ""
      otherwise:
         pop.movekey (char)
    endswitch

  endwhile

endproc

writelib libname pop.menupopup


;----------------------------------------------- pop.popupsel ()
; Popup with several selections
;
; This is MUST for every paradox-developer !
;
; Parameters: prow (N), popup's first row
;             pcol (N), popup's left corner column
;             tag (N),  search-character position
;
; Globals:    array g_popitem        popup items
;             g_popind               index to popitem array
;             g_popwidth             max width of popitems
;
; Return:     array g_popsel (N),    indexes to the selected popup items
;             popselind (N) = retval number of selections
;


proc pop.popupsel (prow,pcol,tag)

  private ind,
          ind2,
          ind3,
          popselind,
          popsize,
          beginrow,
          mnurow,
          mnuselect,
          ind,
          popupcolor,
          popselcolor,
          dimcolor,
          shadowcolor

  popupcolor  = syscolor(0)   ;  63
  popselcolor = syscolor(2)   ;  31
  dimcolor    = 127
  shadowcolor = 8

  if arraysize(g_popitem) = 0 then
    return ""
  endif

  g_popwidth = g_popwidth + 2
  popsize  = min(g_popind,24 - prow - 2)

  array g_popsel[arraysize(g_popitem)]
  popselind = 0

  cursor off
  canvas off

  pop.prompt (g_popselect,g_escape)

  paintcanvas
    attribute shadowcolor
    prow + 1, pcol + 1, prow + 2 + popsize, pcol + 1 + g_popwidth + 4

  style attribute popupcolor

  setmargin pcol
  @prow,pcol
  ?? "",fill("",g_popwidth + 2),""
  for ind from 1 to popsize
     ? " ",substr(strval(g_popitem[ind])+
            spaces(g_popwidth+4),1,g_popwidth + 1),""
  endfor
  ?  "",fill("",g_popwidth + 2),""
  setmargin off
  canvas on
  mnurow = 1
  mnuselect = 1

  while True
    style attribute popselcolor
    pop.popdraw ()
    style attribute popupcolor
    char = getchar ()
    switch
      case char = asc("Enter") :
         m = match(g_popitem[mnuselect]," ..")
         if m then
           ind2 = 0
           for ind3 from 1 to popselind - 1
             ind2 = ind2 + 1
             if g_popsel[ind3] = mnuselect then
               ind2 = ind2 + 1
             endif
             g_popsel[ind3] = g_popsel[ind2]
           endfor
           popselind = popselind - 1
           g_popitem[mnuselect] = substr(g_popitem[mnuselect],3,g_popwidth)
         else
            popselind = popselind + 1
            g_popsel[popselind] = mnuselect
            g_popitem[mnuselect] = " "+g_popitem[mnuselect]
         endif
         if mnuselect = g_popind then
           beep
         else
           if mnurow < popsize then
             pop.popdraw ()
             mnurow = mnurow + 1
           else
             pop.popredraw(mnuselect - popsize + 1)
           endif
           mnuselect = mnuselect + 1
         endif
      case char = asc("Esc") :
         cursor normal
         paintcanvas attribute dimcolor
                     prow,pcol,prow+popsize+1,pcol+g_popwidth + 3
         return popselind
      otherwise:
         pop.movekey (char)
    endswitch
  endwhile

endproc

writelib libname pop.popupsel


;---------------------------------------------- pop.movekey ()
; Move inside popup
;
; Parameters: char (N), pressed key
;
; Globals:    check pop.popup
;
; Return:
;
; Notes:      called from pop.popup and pop.popupsel
;

proc pop.movekey (char)

  private ind

  switch
    case char > g_space :
      ind = mnuselect + 1
      while True
        if ind > g_popind then
          ind = 1
        endif
        if upper(substr(g_popitem[ind],1,1)) = upper(chr(char)) or
          ind = mnuselect then
          quitloop
        endif
        ind = ind + 1
      endwhile
      pop.popdraw ()
      switch
        case ind < popsize :
          pop.popredraw (0)
          mnurow = ind
        case ind > g_popind - popsize :
          pop.popredraw (g_popind - popsize)
          mnurow = ind - g_popind + popsize
        otherwise :
          pop.popredraw (ind - 1)
          mnurow = 1
      endswitch
      mnuselect = ind
    case char = asc("Up") :
      if mnuselect = 1 then
        if mnuselect + popsize - mnurow = g_popind then
          pop.popdraw()
        else
          pop.popredraw(g_popind - popsize)
        endif
        mnurow = popsize
        mnuselect = g_popind
      else
        if mnurow > 1 then
          pop.popdraw()
          mnurow = mnurow - 1
        else
          pop.popredraw (mnuselect - 2)
        endif
        mnuselect = mnuselect - 1
      endif
    case char = asc("Down") :
      if mnuselect = g_popind then
        if mnurow = mnuselect then
          pop.popdraw()
        else
          pop.popredraw(0)
        endif
        mnurow = 1
        mnuselect = 1
      else
        if mnurow < popsize then
          pop.popdraw()
          mnurow = mnurow + 1
        else
          pop.popredraw (mnuselect - popsize + 1)
        endif
        mnuselect = mnuselect + 1
      endif
    case char = asc("Home"):
      if mnurow = mnuselect then
        pop.popdraw()
      else
        pop.popredraw (0)
      endif
      mnurow = 1
      mnuselect = 1
    case char = asc("End") :
      if mnuselect + popsize - mnurow = g_popind then
        pop.popdraw()
      else
        pop.popredraw (g_popind - popsize)
      endif
      mnurow = popsize
      mnuselect = g_popind
    case char = asc("PgUp") :
      if mnurow = mnuselect then
        beep
      else
        if mnuselect - mnurow - popsize > 0 then
          mnuselect = mnuselect - mnurow - popsize + 1
        else
          mnuselect = 1
        endif
        pop.popredraw (mnuselect - 1)
        mnurow = 1
      endif
    case char = asc("PgDn") :
      if mnuselect + popsize - mnurow = g_popind then
        beep
      else
        if g_popind - popsize < mnuselect + popsize - mnurow then
          mnuselect = g_popind - popsize + 1
        else
          mnuselect = mnuselect + popsize - mnurow + 1
        endif
        pop.popredraw (mnuselect - 1)
        mnurow = 1
      endif
    otherwise:
      beep
  endswitch

endproc

writelib libname pop.movekey


;---------------------------------------------- pop.popdraw ()
; Draw selection row
;
; Parameters:
;
; Globals: mnurow
;          prow
;          pcol
;          g_popwidth
;          g_popitem
;          mnuselect
;
; Return:
;


proc pop.popdraw ()

  @mnurow+prow,pcol + 2
  ?? spaces(g_popwidth)
  @mnurow+prow,pcol + 2
  ?? g_popitem[mnuselect]

endproc

writelib libname pop.popdraw


;---------------------------------------------- pop.popredraw ()
; Draw popup again
;
; Parameters: beginrow (N), index to start popup selection
;
; Globals:    g_popitem
;             g_popwidth
;             prow
;             pcol
;
; Return:
;

proc pop.popredraw (beginrow)

  canvas off
  setmargin pcol + 2
  @ prow,pcol + 2

  for z from 1 to popsize
    ? substr(strval(g_popitem[beginrow + z])+
      spaces(g_popwidth+4),1,g_popwidth + 1)
  endfor

  setmargin off
  canvas on

endproc

writelib libname pop.popredraw


;---------------------------------------------- pop.prompt ()
; Popup prompt
;
; Parameters: firstrow (A),  text to first row on screen
;             secondrow (A), text to second row on screen
;
; Globals:
;
; Return:


proc pop.prompt (firstrow,secondrow)

  style attribute syscolor(0)
  @ 0,0
  ?? spaces(80)+secondrow+spaces(80-len(secondrow))
  @ 0,0
  ?? firstrow
  style

endproc

writelib libname pop.prompt


;----------------------------------------------- hlp.hlpsystem ()
; Help-system to code field or normal field,
; return to ordinary position
;
; Parameters:
;
; Globals: g_mode
;          g_filtermode
;          g_filtertbl
;          g_mastertbl
;          g_tbl
;          g_fld
;          g_hlptopic
;          g_update
;
; Return:
;


proc hlp.hlpsystem ()

  private tbl,
          fld,
          frm,
          mde,
          dta,
          looktbl,
          lookvalue

  lookvalue = ""
  tbl       = table()
  fld       = field()
  dta       = []
  mde       = sysmode()
  frm       = form()

  help

  if helpmode () = "LookupHelp" then
    looktbl = table()
    esc
    hlp.codefld (looktbl,dta)
    if not isblank(retval) then
      lookvalue = retval
    else
      retval = ""
    endif
   else
    esc
    err.keyviol ()
    if not retval then
      return
    endif
    hlp.lookhelptext (g_hlptopic,g_shlptopic)
    lookvalue = ""
  endif

  if mde <> sysmode() then
    coeditkey
  endif

  if g_mode = g_filtermode and frm <> "None" then
    moveto g_mastertbl
  endif

  if  frm <> "None" and not isformview () then
    formkey
  endif

  moveto tbl
  moveto field fld
  if not isblank(lookvalue) and g_update then
    [] = lookvalue
  endif

endproc

writelib libname hlp.hlpsystem


;----------------------------------------------- hlp.codefld ()
; Help-menu to code field
;
; Parameters: looktbl (A), lookup table
;             dta (A,N,D), data in the current field to locate
;
; Globals:    g_lookup
;             g_lookupdef
;             g_edit
;             g_editdef
;             g_helpsys
;             g_helpdef
;             g_hlptopic
;
; Return:
;


proc hlp.codefld (looktbl,dta)

  private choice

  showmenu
    g_lookup  : g_lookupdef,
    g_helpsys : g_helpdef
  to choice

  switch
    case choice = g_lookup :
      err.keyviol ()
      if not retval then
        return ""
      endif
      hlp.updatelookuptbl (looktbl,dta)
      return retval
    case choice = g_helpsys :
      err.keyviol ()
      if not retval then
        return True
      endif
      hlp.lookhelptext (g_hlptopic,g_shlptopic)
  endswitch

  return ""

endproc

writelib libname hlp.codefld


;----------------------------------------------- hlp.lookhelptext ()
; Look and/or edit the helptexts
;
; Parameters: g_hlptopic (A), context sensitive help topic
;             g_shlptopic (A), sub help topic
;
; Globals:    g_normalmode
;             g_hlptbl
;             g_hlptxttbl
;             g_hlpreftbl
;             g_topicfld
;             g_stopicfld
;             g_topictmpfld
;             g_stopictmpfld
;             g_change
;             g_print
;             g_topic
;             g_nxtwin
;             g_insert
;             g_delete
;             g_escape
;
; Return:
;
; Notes:      imagerights  controlled by g_update
;
;             ELEGANT reference-help created by shadow-key technique
;


proc hlp.lookhelptext (g_hlptopic,g_shlptopic)

  private g_mode,
          g_mastertbl,
          g_masterfrm,
          g_memotbl,
          tbl,
          topic,
          stopic,
          anykey,
          g_update

  g_mode      = g_normalmode
  g_mastertbl = g_hlptbl
  g_masterfrm = "1"
  g_memotbl   = g_hlptxttbl

  g_update    = false

  if sysmode() <> "Main" then
    do_it!
  endif

  coedit g_mastertbl
  pickform g_masterfrm
  locate g_hlptopic,g_shlptopic
  imagerights
  if not retval then
    ins
    execute "["+g_topicfld+"]   = g_hlptopic"
    execute "["+g_stopicfld+"]  = g_shlptopic"
    unlockrecord
    locate g_hlptopic,g_shlptopic
  endif
  execute "["+g_topictmpfld+"]   = g_hlptopic"
  execute "["+g_stopictmpfld+"]  = g_shlptopic"
  unlockrecord

  moveto g_hlptxttbl
  imagerights readonly
  moveto g_hlpreftbl
  imagerights readonly
  moveto g_hlptbl
  imagerights readonly


  while True
    switch
      case isformview () :
        prompt g_change + g_print  + g_topic + g_nxtwin,
               g_insert + g_delete + g_escape
      otherwise :
        firstshow
        prompt g_print + g_swifrm,
               g_escape
    endswitch

    key.wait ()
    anykey = retval
    tbl = table()

    if tbl = g_mastertbl and isformview() and g_update then
      execute "["+g_topictmpfld+"]  = ["+g_topicfld+"]"
      execute "["+g_stopictmpfld+"]  = ["+g_stopicfld+"]"
    endif

    switch
      case anykey = "Esc"  :
        err.keyviol ()
        if not retval then
          loop
        endif
        do_it!
        clearimage
        quitloop
      case anykey = "FieldView" :
        key.fldedit ()
      case anykey = "Del"  :
        key.delrec ()
      case anykey = "Ins"  :
        err.keyviol ()
        if not retval then
          loop
        endif
        key.insrec ()
      case anykey = "PgDn" :
        key.nextrec ()
      case anykey = g_ctrlpgdn :
        key.nextrec ()
      case anykey = "PgUp" :
        key.prevrec ()
      case anykey = g_ctrlpgup :
        key.prevrec ()
      case anykey = "F1"   :
      case anykey = "F2"   :
        err.keyviol ()
        if not retval then
          loop
        endif
        if g_update then
          g_update = False
          moveto g_hlptbl
          imagerights readonly
          moveto g_hlptxttbl
          imagerights readonly
          moveto g_hlpreftbl
          imagerights readonly
        else
          g_update = True
          moveto g_hlptbl
          imagerights
          moveto g_hlptxttbl
          imagerights
          moveto g_hlpreftbl
          imagerights
        endif
        moveto tbl
      case anykey = "F3"   :
        err.keyviol ()
        if not retval then
          loop
        endif
        do_it!
        out.selectdevice ()
        if isblank(retval) then
          loop
        else
          out.print (g_hlptxttbl,"1")
        endif
        coeditkey
      case anykey = "F4"   :
      case anykey = "F5"   :
      case anykey = "F6"   :
      case anykey = "F7"   :
        err.keyviol ()
        if not retval then
          loop
        endif
        key.codesearch (g_hlptbl,g_topicfld,g_stopicfld,g_topicfld)
        if not isblank(retval) then
          execute "moveto ["+g_hlptbl+"->"+g_topicfld+"]"
          locate retval
        endif
        if not isformview() then
          formkey
        endif
        coeditkey
      case anykey = "F9"   :
      case anykey = "F10"  :
      case anykey = "ReverseTab" :
        key.prevtbl ()
      case anykey = "Tab"  :
        key.nexttbl ()
      otherwise :
        key.anykey (anykey)
    endswitch

    switch
      case table() = g_mastertbl and isformview() :
        imagerights
        execute "topic  = ["+g_topicfld+"]"
        execute "stopic = ["+g_stopicfld+"]"
        execute "["+g_topictmpfld+"]  = topic"
        execute "["+g_stopictmpfld+"] = stopic"
        unlockrecord
        locate topic,stopic
        if not g_update then
          imagerights readonly
        endif
      case table() = g_hlpreftbl :
        execute "topic  = ["+g_topictmpfld+"]"
        execute "stopic = ["+g_stopictmpfld+"]"
        if not isblank(topic) and not isblank(stopic) then
          moveto g_mastertbl
          imagerights
          execute "["+g_topictmpfld+"]  = topic"
          execute "["+g_stopictmpfld+"] = stopic"
          unlockrecord
          if not g_update then
            imagerights readonly
          endif
          moveto g_hlpreftbl
        endif
    endswitch

  endwhile

  return True

endproc

writelib libname hlp.lookhelptext


;----------------------------------------------- hlp.getlookuptbl ()
; Take a value from lookuptbl
;
; Parameters: dta (A,N,D), current data in the field to locate lookup table
;
; Globals:    g_select
;             g_escape
;
; Return:     F2  sets lookup value to ordinary field
;             Esc do nothing
;
; Notes:      This procedure requires toolkit.lib
;             lookupselect() is in Borland's toolkit-library
;

proc hlp.getlookuptbl (dta)

   help
   if not isblank(dta) then
     locate dta
   endif

   prompt g_select,
          g_escape


   while True
     lookupselect ()
     switch
       case retval = asc("Esc") :
         esc
         quitloop
       case retval = asc("F2") :
         do_it!
         quitloop
      otherwise:
         loop
     endswitch
   endwhile

endproc

writelib libname hlp.getlookuptbl


;----------------------------------------------- hlp.updatelookuptbl ()
; Update the lookuptable and/or select a value
;
; Parameters: looktbl (A), lookup table
;             dta (A,N,),  possible field data to locate
;
; Globals:
;             g_normalmode
;             g_insert
;             g_delete
;             g_escape
;
; Return:     lookvalue, <F2> pressed
;


proc hlp.updatelookuptbl (looktbl,dta)

  private g_mode,
          g_mastertbl,
          prompt1,
          prompt2,
          g_update,
          lookvalue

  g_mode        = g_normalmode
  g_mastertbl   = looktbl
  g_update      = True

  do_it!

  coedit looktbl
  if not isblank(dta) then
    ctrlhome right
    locate dta
  endif

  prompt1 = g_select  + g_insert
  prompt2 = g_delete  + g_escape

  while True

    prompt prompt1,
           prompt2

    key.wait ()

    switch
      case retval  = "Esc" :
        do_it!
        clearimage
        return ""
      case retval = "FieldView"  :
        key.fldedit ()
      case retval = "Ins" :
        ins
      case retval = "Del" :
        msg.areyousure ()
        if retval then
          del
        endif
      case retval = "F1"  :
      case retval = "F2"  :
        ctrlhome right
        lookvalue = []
        do_it!
        clearimage
        return lookvalue
      case retval = "F3"  :
      case retval = "F4"  :
      case retval = "F5"  :
        key.searchrec ()
      case retval = "F6"  :
        zoomnext
      case retval = "F7"  :
      case retval = "F9"  :
      case retval = "F10" :
      otherwise :
        key.anykey (retval)
    endswitch

  endwhile

endproc

writelib libname hlp.updatelookuptbl


;------------------------------------------------ msg.message ()
; A message with tail, piip and sleeptime
;
; Parameters: msgtxt (A),    message text
;             piip (N),      how many beeps
;             sleeptime (N), sleep time after message
;
; Globals:
;
; Return:
;


proc msg.message (msgtxt,piip,sleeptime)

  private ind,
          msglen,
          msgcolor

  msgcolor = 63

  if not isblank(piip) then
    for ind from 1 to piip
      beep
    endfor
  endif

  msglen         = len(msgtxt)

  style attribute msgcolor

  paintcanvas fill " " 24,0,24,79

  @ 24, int((80 - msglen)/2) ?? msgtxt

  style

  if not isblank(sleeptime) then
    sleep sleeptime
  endif

endproc

writelib libname msg.message


;----------------------------------------------- msg.waiting
; A blinking message
;
; Parameters: txt (A), blinking text
;
; Globals:
;
; Return:
;


proc msg.waiting (txt)

  style blink
  @24,80-len(txt) ?? txt
  style

endproc

writelib libname msg.waiting


;---------------------------------------------- msg.areyousure ()
; Really, are you sure
;
; Parameters:
;
; Globals:    g_areyousure
;             g_yes
;
; Return:     Yes (L) True
;             No  (L) False
;


proc msg.areyousure ()

  private char

  beep
  message g_areyousure
  char = max(getchar (),1)

  switch
    case upper(chr(char) ) = g_yes :
      return True
    otherwise:
      return False
  endswitch

endproc

writelib libname msg.areyousure


;----------------------------------------------- msg.dialog ()
; Dynamic dialog-box to ask anything
;
; Parameters: msgprompt (A),  question
;             msgtype (A),    datatype to answer
;             msgpic (A),     picture to answer
;             msglookup (A),  lookup table to answer
;             msgdef (A,N,D), default value to answer
;
; Globals:
;
; Return:     msganswer (A,N,D)
;             blank
;


proc msg.dialog(msgprompt,msgtype,msgpic,msglookup,msgdef)

  private char,
          msgrow,
          msgcol,
          msglen,
          msgwidth,
          msganswer,
          dimcolor,
          shadowcolor,
          answercolor

  dimcolor     = 127
  shadowcolor  = 8
  answercolor  = syscolor(2) ; 15
  msgcolor     = syscolor(0) ; 63
  retval       = True

  switch
    case msgtype = "D" :
      msglen = 11
    case msgtype = "$" :
      msglen = 15
    case msgtype = "S" :
      msglen = 16
    case msgtype = "N" :
      msglen = 23
    otherwise:
      msglen = numval(substr(msgtype,2,2))
      msglen = min(msglen,79-len(msgprompt)-5)
      msgtype = "A"+strval(msglen)
  endswitch

  if msgpic <> "" then
    msgpic = "picture "+"\""+msgpic+"\""
  endif
  if msglookup <> "" then
    msglookup = "lookup "+"\""+msglookup+"\""
  endif
  if msgdef <> "" then
    switch
      case msgtype = "D" or msgtype = "$" or msgtype = "N" or msgtype = "S" :
        msgdef = "default "+strval(msgdef)
      otherwise :
        msgdef = "default "+"\""+msgdef+"\""
    endswitch
  endif

  msgrow = 11
  msgcol = int ((79-len(msgprompt)-msglen-4)/2)

  msgwidth = len(msgprompt)+msglen+4

  paintcanvas
   attribute shadowcolor
   msgrow+1, msgcol+1, msgrow+3,msgcol+msgwidth

  setmargin msgcol
  style attribute msgcolor
  @msgrow,msgcol
  ?? "",fill("",msgwidth-2),""
     ? " ",substr(msgprompt+ spaces(msgwidth),1,msgwidth-3),""
  ?  "",fill("",msgwidth-2),""
  setmargin off

  @12,msgcol+2+len(msgprompt)

  style attribute answercolor

  switch
    case msgtype = "A1" :
      @msgrow+1,msgcol+len(msgprompt)+2 ?? " "
      @msgrow+1,msgcol+len(msgprompt)+2
      char = getchar ()
      if char > 0 and char <> 27 then
        return upper(chr( max(char, 1)))
      else
        return ""
      endif
    otherwise :
      execute "accept \""+msgtype+"\" "+msgpic+" "+msglookup+
      " "+msgdef+" to msganswer"
  endswitch

  paintcanvas attribute dimcolor
              msgrow,msgcol,msgrow+2,msgcol+msgwidth-1
  style

  if retval then
    return msganswer
  else
    return ""
  endif

endproc

writelib libname msg.dialog


;----------------------------------------------- key.wait ()
; The keys in wait table or wait record
;
; Parameters:
;
; Globals: g_ctrlpgdn
;          g_ctrlpgup
;
; Return:  retval (N), selected key
;

proc key.wait ()

  firstshow

  switch

    case isformview () and not formtype("Detail") :
      wait record
      until "Esc","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10",
            "PgDn","PgUp","Del","Tab","ReverseTab","Ins","Home","End",
            "Zoom","ZoomNext","Dos","Dosbig","Rotate",g_ctrlpgdn,
            g_ctrlpgup,"FieldView"
    otherwise:
      wait table
      until "Esc","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10",
            "Del","Tab","ReverseTab","Ins","Home","End",
            "Zoom","ZoomNext","Enter","Up","Down","Right","Left","Dos",
            "Dosbig","Rotate",g_ctrlpgdn,g_ctrlpgup,"FieldView"

  endswitch

  return retval

endproc

writelib libname key.wait


;----------------------------------------------- key.escape ()
; End browsing
;
; Parameters:
;
; Globals: g_mode
;          g_normalmode
;          g_filtermode
;          g_mastertbl
;          g_filtertbl
;
; Return:
;


proc key.escape ()

  msg.dialog (g_areyousure,"A1","*!","","")
  if retval <> g_yes then
    return False
  endif

  switch
    case g_mode = g_normalmode :
      do_it!
      clearimage
    case g_mode = g_filtermode :
      do_it!
      moveto g_mastertbl
      clearimage
      moveto g_filtertbl
      clearimage
      g_mode = g_normalmode
  endswitch

  return True

endproc

writelib libname key.escape


;----------------------------------------------- key.anykey ()
; General key handling
;
; Parameters: anykey (N),     key value
;
; Globals:    g_memotbl
;             g_rowfld
;             g_cancel,
;             g_canceldef,
;             g_dos,
;             g_dosdef,
;             g_update
;
; Return:
;

proc key.anykey (anykey)

  private choice

  if anykey = "Dos" or anykey = "Dosbig" then
    showmenu
      g_cancel : g_canceldef,
      g_dos    : g_dosdef
    to choice

    if choice <> g_dos then
      return
    endif
  endif

  keypress anykey

  if table() = g_memotbl and sysmode() <> "Main" and g_update then
    execute "["+g_rowfld+"] = recno()"
  endif

endproc

writelib libname key.anykey


;----------------------------------------------- key.fldedit ()
; Field edit
;
; Parameters:
;
; Globals:    g_enter
;
; Return
;


proc key.fldedit ()

  prompt g_enter,""

  fieldview
  wait field
  until "Enter"

endproc

writelib libname key.fldedit


;----------------------------------------------- key.search ()
; General search routine, uses filter table
;
; Parameters:
;
; Globals: g_movetorec
;          g_filtercond
;          g_mode
;          g_normalmode
;          g_filtermode
;          g_filtertbl
;          g_mastertbl
;          g_fkeyfld
;          g_mkeyfld
;
; Return:  g_mode
;          g_fkeyfld
;
; Notes:   procedure changes g_mode from g_normalmode to g_filtermode
;          isblank(retval) returns g_normalmode
;

proc key.search ()

  private mde,
          tbl,
          qtbl,
          fld,
          frm,
          str

  mde = sysmode()
  tbl = table()
  fld = field()
  frm = form()

  if frm = "None" then
    beep return
  endif

  err.keyviol ()
  if not retval then
    return
  endif

  if field() = "#" then
   msg.dialog (g_movetorec,"N","","","")
    if not isblank(retval) then
      moveto record retval
    endif
    return
  endif

  msg.dialog (g_filtercond,"A40","","","")
  if isblank(retval) then
    if g_mode = g_filtermode then
      do_it!
      g_mode = g_normalmode
      formkey
      moveto g_filtertbl clearimage
      moveto g_mastertbl
      key.switchfrm ()
      ctrlhome
    endif
    return
  else
    str = retval
  endif

  do_it!

  if g_mode = g_filtermode then
    {Ask} select g_filtertbl
    moveto field g_fkeyfld
    example typein "_x"
  endif

  {Ask} select tbl
  moveto field g_mkeyfld check
  example typein "_x"
  moveto field fld
  typein str

  do_it!
  reset

  if isempty("Answer") then
    beep message g_notfound sleep g_moment
    g_mode = g_normalmode
    view g_mastertbl
  else
    g_mode      = g_filtermode
    g_fkeyfld   = g_mkeyfld
    g_filtertbl = "Answer"
    view g_mastertbl
    view g_filtertbl
  endif
  key.switchfrm ()

endproc

writelib libname key.search


;----------------------------------------------- key.codesearch ()
; Search code from the table
;
; Parameters: tbl (A), table to search
;             retfield (A), field to return
;             searchfield (A), field to search
;             descfield (A), description field
;
; Globals:    g_searchprompt
;
; Return:     code (A,N,D), return code
;


proc key.codesearch (tbl,retfield,searchfield,descfield)

  private str,
          qimage,
          arrsize,
          g_popitem,
          g_popval,
          g_popind,
          g_popwidth

  err.keyviol ()
  if not retval then
    return
  endif

  msg.dialog (g_srchprompt,"A20","","","")
  if isblank(retval) then
    return ""
  else
    str = retval+".."
  endif

  if sysmode() <> "Main" then
    do_it!
  endif

  {Ask} select tbl
  qimage = imageno()
  moveto field retfield Check
  moveto field searchfield
  [] = str
  moveto field descfield
  if isblank(checkmarkstatus()) then
    Check
  endif
  do_it!

  moveto qimage clearimage
  if isempty("Answer") then
    moveto "Answer"
    clearimage
    beep message g_notfound sleep g_moment
    return ""
  else
    moveto "Answer"
    arrsize = nrecords("Answer")
  endif

  array g_popval[arrsize]
  array g_popitem[arrsize]

  g_popind   = 0
  g_popwidth = 0
  moveto field descfield
  scan
    g_popwidth = max(g_popwidth,len([]))
    g_popind   = g_popind + 1
    execute "g_popval[g_popind] = ["+retfield+"]"
    g_popitem[g_popind] = []
  endscan
  clearimage

  pop.popup (2,0,1)
  if isblank(retval) then
    return ""
  else
    return g_popval[retval]
  endif

endproc

writelib libname key.codesearch


;----------------------------------------------- key.locaterec ()
; Locate a record
;
; Parameters:
;
; Globals:    g_srchprompt
;
; Return:
;


proc key.locaterec ()

  private fldtype
  fldtype = fieldtype ()

  err.keyviol ()
  if not retval then
    return
  endif

  msg.dialog (g_srchprompt,fldtype,"","","")
  if isblank(retval) then
    return
  else
    zoom select retval
  endif

endproc

writelib libname key.locaterec


;----------------------------------------------- key.nexttbl
; Move to next table
;
; Parameters:
;
; Globals:    g_mastertbl
;             g_memotbl
;             g_rowfld
;
; Return:
;


proc key.nexttbl ()

  private rec,
          tbl

  tbl = table()
  if not isformview() then
    return
  endif

  if not formtype("Detail") then
    copytoarray rec
    if isblank(rec[2]) then
      beep return
    endif
  endif

  switch
    case npages() = 1 :
      downimage
    otherwise:
      downimage
      if table() =g_mastertbl and pageno() < npages() then
        pgdn
        downimage
      endif
  endswitch

  ctrlhome

  ; check paradox bug (?) one table on form change to table
  if not isformview() then
    moveto tbl
    formkey
  endif

endproc

writelib libname key.nexttbl


;----------------------------------------------- key.prevtbl ()
; Move to previous table
;
; Parameters:
;
; Globals:    g_mastertbl
;             g_memotbl
;             g_rowfld
;
; Return:
;


proc key.prevtbl ()

  private rec,
          tbl


  tbl = table()
  if not isformview() then
    return
  endif

  if not formtype("Detail") then
    copytoarray rec
    if isblank(rec[2]) then
      beep return
    endif
  endif

  switch
    case npages() = 1 :
      upimage
    case pageno() = 1 :
      if table() = g_mastertbl then
        ctrlend
      endif
      upimage
    otherwise:
      upimage
      if table() = g_mastertbl then
        pgup
        upimage
      endif
  endswitch

  ctrlhome

  ; check paradox bug (?) one table on form change to table
  if not isformview() then
    moveto tbl
    formkey
  endif

endproc

writelib libname key.prevtbl


;----------------------------------------------- key.switchfrm ()
; Switch form to table or vice versa
;
; Parameters:
;
; Globals:    g_mode
;             g_normalmode
;             g_filtermode
;             g_masterfrm
;             g_mastertbl
;             g_filtertbl
;             g_mkeyfld
;             g_fkeyfld
;             g_update
;
; Return:
;
; Notes:      CoEdit mode in form
;             Main   mode in table, prevets form lock
;


proc key.switchfrm ()

  private key

  err.keyviol ()
  if not retval then
    return
  endif

  switch
    case g_mode = g_normalmode :
      switch
        case isformview () :
          do_it!
          formkey
        case not isformview () :
          pickform g_masterfrm
          if g_update then
            coeditkey
          endif
      endswitch
    case g_mode = g_filtermode :
      switch
        case isformview () :
          do_it!
          formkey
          coeditkey
          moveto g_filtertbl
        case not isformview () :
          moveto field g_fkeyfld
          key = []
          do_it!
          moveto g_mastertbl
          moveto field g_mkeyfld
          locate key
          coeditkey
          pickform g_masterfrm
      endswitch
  endswitch

endproc

writelib libname key.switchfrm


;----------------------------------------------- key.nextrec ()
; Move to next record
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_filtertbl
;             g_mkeyfld
;             g_fkeyfld
;
; Return:
;
; Notes:      procedure can operate in multipage-forms
;


proc key.nextrec ()

  private tbl,
          fld,
          key

  fld = field()
  tbl = table()

  err.keyviol ()
  if not retval then
    return
  endif

  switch
    case g_mode = g_filtermode and isformview() :
      unlockrecord
      formkey
      moveto g_filtertbl
      moveto field g_fkeyfld
      key = []
      while key = [] and not atlast()
        skip
      endwhile
      key = []
      moveto g_mastertbl
      moveto field g_mkeyfld
      locate key
      formkey
    otherwise :
      moveto g_mastertbl
      if not atlast() then
        pgdn
        while pageno() <> 1
          pgdn
        endwhile
      endif
  endswitch

  moveto tbl
  moveto field fld

endproc

writelib libname key.nextrec


;----------------------------------------------- key.prevrec ()
; Moveto previous record
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_filtertbl
;             g_mkeyfld
;             g_fkeyfld
;
; Return:
;
; Notes:      procedure can operate in multipage-forms
;


proc key.prevrec ()

  private tbl,
          fld,
          key

  fld = field()
  tbl = table()

  err.keyviol ()
  if not retval then
    return
  endif

  switch
    case g_mode = g_filtermode and isformview() :
      unlockrecord
      formkey
      moveto g_filtertbl
      moveto field g_fkeyfld
      key = []
      while key = [] and not atfirst()
        skip -1
      endwhile
      key = []
      moveto g_mastertbl
      moveto field g_mkeyfld
      locate key
      formkey
    otherwise :
      moveto g_mastertbl
      if not atfirst() then
        pgup
        while pageno() <> 1
          pgup
        endwhile
      endif
  endswitch

  moveto tbl
  moveto field fld

endproc

writelib libname key.prevrec


;----------------------------------------------- key.endrec ()
; Move to the end of table
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_filtertbl
;             g_mkeyfld
;             g_fkeyfld
;
; Return:
;


proc key.endrec ()

  private fld,
          key

  fld = field()

  err.keyviol ()
  if not retval then
    return
  endif

  switch
    case g_mode = g_filtermode and isformview () :
      fld = field()
      do_it!
      formkey
      coeditkey
      moveto g_filtertbl
      moveto field g_fkeyfld
      end
      key = []
      moveto g_mastertbl
      moveto field g_mkeyfld
      locate key
      formkey
    otherwise :
      end
  endswitch

  moveto field fld

endproc

writelib libname key.endrec


;----------------------------------------------- key.homerec ()
; Move to the beginning of table
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_filtertbl
;             g_mkeyfld
;             g_fkeyfld
;
; Return:
;


proc key.homerec ()

  private fld,
          key

  err.keyviol ()
  if not retval then
    return
  endif

  fld = field()
  switch
    case g_mode = g_filtermode and isformview () :
      do_it!
      formkey
      coeditkey
      moveto g_filtertbl
      moveto field g_fkeyfld
      home
      key = []
      moveto g_mastertbl
      moveto field g_mkeyfld
      locate key
      formkey
    otherwise :
      home
  endswitch

  moveto field fld

endproc

writelib libname key.homerec


;----------------------------------------------- key.insrec ()
; Insert a record
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_filtertbl
;             g_memotbl
;             g_rowfld
;             g_update
;
; Return:
;


proc key.insrec ()

  private rec

  if sysmode() = "Main" or not g_update then
    return
  endif

  err.keyviol ()
  if not retval then
    return
  endif

  switch
    case table() = g_memotbl :
      rec = recno()
      end
      while recno() > rec
        execute "["+g_rowfld+"] = recno() + 1"
        skip -1
      endwhile
      execute "["+g_rowfld+"] = recno() + 1"
      ins
      execute "["+g_rowfld+"] = recno()"
    case table() = g_mastertbl and g_mode = g_filtermode :
      beep
    otherwise :
      ins
  endswitch

endproc

writelib libname key.insrec


;----------------------------------------------- key.delrec ()
; Delete a record
;
; Parameters:
;
; Globals:   g_mode
;            g_filtermode
;            g_normalmode
;            g_mastertbl
;            g_filtertbl
;            g_memotbl
;            g_rowfld
;            g_mkeyfld
;            g_fkeyfld
;            g_update
;
; Return:
;


proc key.delrec ()

  private rec,
          fld,
          key,
          newimage

  if sysmode() = "Main" or not g_update then
    return
  endif

  msg.areyousure ()
  if not retval then
    return
  endif

  frm = isformview()

  switch
    case table() = g_mastertbl and g_mode = g_filtermode :
      key.delfilterrec ()
    case table() = g_mastertbl and g_mode = g_normalmode :
      copytoarray rec
      if isblank(rec[2]) then
        del
        return
      endif
      while True
        downimage
        if table() =g_mastertbl  and
                    isformview() and
                    pageno() < npages() then
          pgdn
          downimage
        endif
        if table() = g_mastertbl then
          quitloop
        endif
        if formtype("Linked") and not formtype("DisplayOnly") then
          while nimagerecords () > 1
            del
          endwhile
          del
        endif
      endwhile
      del
      ctrlhome
    case table() = g_memotbl :
      del
      rec = recno()
      while not eot()
        execute "["+g_rowfld+"] = recno()"
        skip
      endwhile
      moveto record rec
    otherwise:
      del
  endswitch

  if frm <> isformview() then
    formkey
  endif

endproc

writelib libname key.delrec


;----------------------------------------------- key.delfilterrec ()
; filter mode del operation
;
; Parameters:
;
; Globals:   g_mode
;            g_filtermode
;            g_normalmode
;            g_mastertbl
;            g_filtertbl
;            g_memotbl
;            g_rowfld
;            g_mkeyfld
;            g_fkeyfld
;
; Return:
;
; Notes:     Called by key.delrec-procedure
;


proc key.delfilterrec ()

  private fld,
          rec,
          key

  fld = field()
  copytoarray rec
  if isblank(rec[2]) then
    del
    return False
  endif
  while True
    downimage
    if table() =g_mastertbl and pageno() < npages() then
      pgdn
      downimage
    endif
    if table() = g_mastertbl then
      quitloop
    endif
    if formtype("Linked") and not formtype("DisplayOnly") then
      while nimagerecords () > 1
        del
      endwhile
      del
    endif
  endwhile
  del
  formkey
  moveto g_filtertbl
  moveto field g_fkeyfld
  key = []
  while key = [] and not atlast()
    del
  endwhile
  key = []
  moveto g_mastertbl
  moveto field g_mkeyfld
  locate key
  formkey
  moveto field fld

endproc

writelib libname key.delfilterrec


;----------------------------------------------- key.deldetails ()
; Delete detail records
;
; Parameters:
;
; Globals:    g_update
;
; Return
;


proc key.deldetails ()

  if isformview()            = False  or
     formtype("Linked")      = False  or
     formtype("DisplayOnly") = False  or
     sysmode()               = "Main" or
     g_update                = False
    then
    return
  endif

  msg.areyousure ()
  if not retval then
    return
  endif

  while nimagerecords () > 1
    del
  endwhile

  del

endproc

writelib libname key.deldetails


;----------------------------------------------- key.zoomdetails ()
; Zoom detail records to popup-view
;
; Parameters:
;
; Globals:
;
; Return:
;


proc key.zoomdetails ()

  private g_popitem,
          g_popind,
          g_popwidth,
          rec

  if not isformview() or not formtype("Linked") then
    beep return
  endif

  err.keyviol ()
  if not retval then
    return
  endif

  array g_popitem[nimagerecords()]
  rec = recno()
  home

  g_popind   = 0
  g_popwidth = 1

  scan
    g_popind            = g_popind + 1
    g_popwidth          = max(g_popwidth,len([]))
    g_popitem[g_popind] = []
  endscan

  pop.popup (2,0,1)

  if not isblank(retval) then
    moveto record retval
  else
    moveto record rec
  endif

endproc

writelib libname key.zoomdetails


;----------------------------------------------- del.emptytbl ()
; Empty a table
;
; Parameters: tbl (A), table name
;
; Globals:
;
; Return:
;


proc del.emptytbl (tbl)

  pro.password (tbl)
  if retval= False then
    return False
  endif

  msg.areyousure ()
  if not retval then
    return False
  endif

  empty tbl

endproc

writelib libname del.emptytbl


;----------------------------------------------- prg.tblupdate ()
; General browser-routine
;
; Parameters: tbl (A),     table name
;             frm (A),     table form
;             keyfld (A),  key field name
;             memotbl (A), memo table name
;             rowfld (A),  memo table's row name
;
; Globals:    g_normalmode
;             g_swifrm
;             g_nxtwin
;             g_insert
;             g_delete
;             g_escape
;
; Return:
;
; Notes:      basis routine for modifications
;


proc prg.tblupdate (tbl,frm,keyfld,memotbl,rowfld)

  private g_mode,
          g_mastertbl,
          g_masterfrm,
          g_mkeyfld,
          g_memotbl,
          g_rowfld,
          g_update

  pro.password (tbl)
  if retval= False then
    return False
  endif

  g_mode      = g_normalmode
  g_mastertbl = tbl
  g_masterfrm = frm
  g_mkeyfld   = keyfld
  g_memotbl   = memotbl
  g_rowfld    = rowfld

  g_update    = False

  view g_mastertbl
  pickform frm

  while True
    switch
      case isformview () :
        prompt g_help   + g_change + g_search + g_swifrm ,
               g_nxtwin + g_insert + g_escape
      otherwise :
        prompt g_swifrm,
               g_escape
    endswitch

    key.wait ()

    switch
      case retval = "Esc"  :
        do_it!
        clearimage
        quitloop
      case retval = "FieldView" :
        key.fldedit ()
      case retval = "Del"  :
        key.delrec ()
      case retval = "Ins"  :
        key.insrec ()
      case retval = "PgDn" :
        key.nextrec ()
      case retval = g_ctrlpgdn :
        key.nextrec ()
      case retval = "PgUp" :
        key.prevrec ()
      case retval = g_ctrlpgup :
        key.prevrec ()
      case retval = "F1"   :
        hlp.hlpsystem ()
      case retval = "F2"   :
        if sysmode() = "Main" then
          coeditkey
          g_update = True
        else
          do_it!
          g_update = False
        endif
      case retval = "F3"   :
      case retval = "F4"   :
      case retval = "F5"   :
        key.search ()
      case retval = "F6"   :
      case retval = "F7"   :
        key.switchfrm ()
      case retval = "F8"   :
      case retval = "F9"   :
      case retval = "F10"  :
      case retval = "ReverseTab" :
        key.prevtbl ()
      case retval = "Tab"  :
        key.nexttbl ()
      otherwise :
        key.anykey (retval)
    endswitch
  endwhile

  return True

endproc

writelib libname prg.tblupdate


;----------------------------------------------- prg.copylinktbl ()
; Copy linked multiform-structure to other
; link-key value
;
;
; Parameters:  keyfld (A),         mastertable's key field
;              keyval (A,N,D),     mastertable's key value
;              newkeyval (A,N,D),  mastertable's new key value
;              shadowfld1 (A),     shadow key field1
;              shadowfld1 (A,N,D), shadow key value1
;
; Globals:     autolib
;              errorproc
;              g_error
;              g_errfile
;              g_mastertbl
;              g_continue
;              g_tryagain
;              g_debug
;              autolib
;
;
; Return:
;
; Notes:       closed procedure
;

proc closed prg.copylinktbl (keyfld,keyval,newkeyval,shadowfld1,shadowval1)

  usevars autolib,    errorproc,  g_errfile, g_error,
          g_continue, g_tryagain, g_debug,   g_mastertbl

  moveto g_mastertbl
  copytoarray mstrec1

  ins
  copyfromarray mstrec1
  execute "["+keyfld+"]=newkeyval"
  if not isblank(shadowfld1) then
    execute "["+shadowfld1+"]=shadowval1"
  endif
  copytoarray mstrec2
  unlockrecord
  image = imageno()

  while True
    locate mstrec1[2],mstrec1[3]
    moveto image
    downimage
    if table() =g_mastertbl and pageno() < npages() then
      pgdn
      downimage
    endif
    if table() = g_mastertbl then
      quitloop
    endif
    image = imageno()
    if not formtype("Linked") or formtype("DisplayOnly") then
      moveto g_mastertbl
      loop
    endif
    drow = 0
    scan
      drow = drow + 1
      execute "copytoarray imagerow"+strval(drow)+""
      execute "imagerow"+strval(drow)+"[2]=newkeyval"
    endscan
    moveto g_mastertbl
    locate mstrec2[2],mstrec2[3]
    moveto image
    for ind from 1 to drow
      execute "copyfromarray imagerow"+strval(ind)+""
      down
    endfor
    del
    moveto g_mastertbl
  endwhile

  ctrlhome
  locate mstrec2[2],mstrec2[3]

endproc

writelib libname prg.copylinktbl


;----------------------------------------------- out.output ()
; Select output device and print out
;
; Parameters: tbl (A), report table
;             rpt (A), report number (R - R14)
;
; Globals:
;
; Return:
;


proc out.output (tbl,rpt)

  out.selectdevice ()
  if isblank(retval) then
    return
  endif

  out.print (tbl,rpt)

endproc

writelib libname out.output


;----------------------------------------------- out.selectdevice ()
; Select outputdevice
;
; Parameters:
;
; Globals: g_outselect
;          g_printer
;          g_screen
;          g_filename
;          g_copies
;
; Return:  g_output (A),    output device
;          g_copycount (N), count of copies
;          g_file (A),      print file
;


proc out.selectdevice ()

  msg.dialog (g_outselect ,"A2","!","","")
  if not isassigned(retval) or isblank(retval) then
    return ""
  else
    switch
      case retval = g_printer :
        g_output = "Printer"
      case retval = g_screen :
        g_output = "Screen"
      case retval = g_file :
        g_output = "File"
    endswitch
  endif

  if g_output = "File" then
    msg.dialog(g_filename,"A40","","","")
    if not isassigned(retval) or isblank(retval) then
      return ""
    endif
    g_file = retval
  endif

  if g_output = "Printer" then
   msg.dialog(g_copies,"S","","",1)
    if isblank(retval) then
      return ""
    else
      g_copycount = retval
    endif
  endif

  return g_output

endproc

writelib libname out.selectdevice


;------------------------------------------------ out.print ()
; Print out
;
; Parameters: tbl (A), report table
;             rpt (A), report number
;
; Globals:    g_output
;             g_copycount
;             g_printoffline
;             g_moment
;             g_file
;
; Return:
;


proc out.print (tbl,rpt)

  switch
    case g_output = "Printer" :
      if printerstatus() then
        for i from 1 to g_copycount
          report tbl rpt
        endfor
      else
        beep message g_printoffline sleep g_moment
        return
      endif
    case g_output = "Screen" :
      {Report} {Output} select tbl
      select rpt {Screen}
    case g_output = "File" :
      {Report} {Output} select tbl
      select rpt {File}
      typein g_file enter
      if menuchoice()="Cancel" then {replace} endif
  endswitch

endproc

writelib libname out.print


;-------------------------------------------------- out.printsetup ()
; Setup code to report
;
; Parameters: setup (A), setup code for printer
;
; Globals:
;
; Return:
;


proc out.printsetup (setup)

  {Report} {SetPrinter} {Override} {Setup}
  ctrlbackspace typein setup enter

endproc

writelib libname out.printsetup


;----------------------------------------------- out.grafreport ()
; Print graphics
;
; Parameters: reptbl (A),  graph table
;             repfld (A),  graph field
;             reptype (A), graph file
;
; Globals:    g_output
;             g_printoffline
;             g_file
;             g_moment
;
; Return:
;

proc out.grafreport (reptbl,repfld,reptype)

  if isblank (reptype) then
    Menu {Image} {Graph} {Reset} {Ok}
  else
    Menu {Image} {Graph} {Load} select reptype
  endif

  view reptbl moveto field repfld

  Menu {Image} {Graph} {ViewGraph}

  switch
    case g_output = "Printer" :
      if printerstatus() then
        {Printer}
      else
        beep message g_printoffline sleep g_moment
        return False
      endif
    case g_output = "Screen" :
      {Screen}
    case g_output = "File" :
      {File}
      typein g_file enter
      if menuchoice()="Cancel" then {replace} endif
  endswitch

endproc

writelib libname out.grafreport


;----------------------------------------------- qry.beginsearch ()
; Main routine for QueryByForm procedures
;
; These procedures eliminate most  Query | | | EndQuery routines
;
; Parameters: searchmode (A), outer, linear or event search
;             recurse (L),    recursive search True or False
;             delrec (L),     delete search    True or False
;
; Globals:
;
; Return:     g_searchtbl, table with searched records
;
; Notes:      a good example of using these routines is in askii-application
;             To ConditionXX fields, you can write QBE clauses
;

;
;g_condtbl-----                      g_searchtbl-- 
;                                                  
;Structure Of: SRCHCOND               Structure Of: SRCHGRP
;       table.field                          table.field
;ͻ ͻ
;   1  Customer.Country     A3        1  Customer.CustNo     N     
;   2  Condition1           A40       2  Customer.Customer   A40   
;   3  Customer.PostCode    A7        3  Customer.PostCode   A7    
;   4  Condition2           A40       4  Customer.Country    A3    
;   5  Customer.CustClass   A2        5  Customer.CustClass  A2    
;   6  Condition3           A40       6  Customer.Contpers   A2    
;   7  Customer.ContPerson  A2        7  Personal.PersNo     S     
;   8  Condition4           A40       8  Personal.Title      A20   
;   9  Events.Date          D         9  Personal.Name       A30   
;  10  Condition5           A40   
;  11  Events.Event         A3    
;  12  Condition6           A40   
;  13  Events.Descr         A20   
;  14  Condition7           A40   
;  15  Personal.PersClass   A2    
;  16  Condition8           A40   
;  17  Personal.Title       A20   
;  18  Condition9           A40   
;  19  Personal.Name        A20   
;  20  Condition10          A40      g_mstsrchtbl   g_evtsrchtbl
;  21  Sales.Date           D                       
;  22  Condition11          A40      customer   --- events
;  23  Sales.ProdCode       A3              |         |
;  24  Condition12          A40      personal ---------  g_persrchtbl
;  25  Sales.Product        A20             |
;  26  Condition13          A40           sales  g_oth1srchtbl
;  27  Sales.Maker          A3    
;  28  Condition14          A40   
;  29  Sales.Price          $     
;  30  Condition15          A40   
;
;
;  g_mstsrchtbl    master search table
;  g_evtsrchtbl    event table
;  g_persrchtbl    person table
;  g_pertmptbl     temporary person table for outer join queries
;  g_oth1srchtbl   other search table 1
;  g_oth2srchtbl   other search table 2
;  g_mstkeyfld     master key field
;  g_othkeyfld     other key field  (ex. person number)
;


proc qry.beginsearch (searchmode,recurse,delrec)

  private condcount,
          searchcount,
          searchmode,
          sfldname,          ; search field names
          stblname,          ; search table names
          cfldname,          ; condition field names
          ctblname           ; condition search names


  qry.dosearch1 ()
  release procs dosearch1
  if not retval then
    return
  endif

  qry.dosearch2 (searchmode)
  release procs dosearch2

  qry.dosearch3 (condcount,searchcount)
  release procs dosearch3

  do_it!
  clearall

  qry.dosearch4 (recurse,delrec)
  release procs dosearch4

endproc

writelib libname qry.beginsearch


;----------------------------------------------- qry.dosearch1 ()
; Start search routine, compile conditions
;
; Parameters:
;
; Globals:    g_irrcond
;             g_moment
;             g_condtbl
;             g_searchtbl
;             g_waiting
;
; Return:     condcount (N)
;             searchcount (N)
;             array sfldname          ; search field names
;             array stblname          ; search table names
;             array cfldname          ; condition field names
;             array ctblname          ; condition search names
;


proc qry.dosearch1 ()

  private ind

  if istable("Answer") then
    delete "Answer"
  endif

  if istable("Deleted") then
    delete "Deleted"
  endif

  condcount   = nfields(g_condtbl)/2
  searchcount = nfields(g_searchtbl)

  if isempty (g_condtbl) then
    beep message g_irrcond  sleep g_moment
    return False
  endif

  msg.waiting (g_waiting)

  array stblname[searchcount]
  array sfldname[searchcount]
  coedit g_searchtbl ctrlhome
  ind = 0
  while ind < searchcount
    right
    ind = ind + 1
    stblname[ind] = substr(field(),1,search(".",field())-1)
    sfldname[ind] = substr(field(),search(".",field())+1,len(field()))
  endwhile

  do_it!
  clearimage

  coedit g_condtbl ctrlhome
  array cfldname[condcount]
  array ctblname[condcount]
  ind = 0
  while ind < condcount
    ind = ind + 1
    if ind = 1 then
      right
    else
      right right                               ; don't care QBE-fields
    endif
    ctblname[ind] = substr(field(),1,search(".",field())-1)
    cfldname[ind] = substr(field(),search(".",field())+1,len(field()))
    if not isblank([]) then
      execute "cond"+strval(ind)+" = strval([])"
    else
      right
      execute "cond"+strval(ind)+" = strval([])"
      left
    endif
  endwhile

  do_it!
  clearimage

  return True

endproc

writelib libname qry.dosearch1


;----------------------------------------------- qry.dosearch2 ()
; Constructs table query
;
; Parameters: searchmode (A), outer linear or event search
;
; Globals:    g_outersearch
;             g_eventsearch
;             g_linearsearch
;             g_mstsrchtbl
;             g_persrchtbl
;             g_evtsrchtbl
;             g_oth1srchtbl
;             g_oth2srchtbl
;             g_mstkeyfld
;             g_othkeyfld
;
; Return:
;


proc qry.dosearch2 (searchmode)

  switch
    case searchmode = g_outersearch :
      if not isblank(g_mstsrchtbl) then
        {Ask} select g_mstsrchtbl moveto field g_mstkeyfld
        []="_a,_ax!"
      endif
      if not isblank(g_evtsrchtbl) then
        {Ask} select g_evtsrchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_oth1srchtbl) then
        {Ask} select g_oth1srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_oth2srchtbl) then
        {Ask} select g_oth2srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_persrchtbl) then
        {Ask} select g_persrchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_pertmptbl) then
        {Ask} select g_pertmptbl  moveto field g_mstkeyfld
        []="_ax"
      endif
    case searchmode = g_linearsearch :
      if not isblank(g_mstsrchtbl) then
        {Ask} select g_mstsrchtbl moveto field g_mstkeyfld
        []="_a,_ax!"
      endif
      if not isblank(g_evtsrchtbl) then
        {Ask} select g_evtsrchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_oth1srchtbl) then
        {Ask} select g_oth1srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_oth2srchtbl) then
        {Ask} select g_oth2srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_persrchtbl) then
        {Ask} select g_persrchtbl    moveto field g_mstkeyfld
        []="_ax"
      endif
    case searchmode = g_eventsearch :
      if not isblank(g_evtsrchtbl) then
        {Ask} select g_evtsrchtbl  moveto field g_mstkeyfld
        []="_a"
        if not isblank(g_othkeyfld) then
          moveto field g_othkeyfld
            []="_h!"
        endif
      endif
      if not isblank(g_mstsrchtbl) then
        {Ask} select g_mstsrchtbl moveto field g_mstkeyfld
        []="_a,_ax!"
      endif
      if not isblank(g_oth1srchtbl) then
        {Ask} select g_oth1srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_oth2srchtbl) then
        {Ask} select g_oth2srchtbl  moveto field g_mstkeyfld
        []="_a"
      endif
      if not isblank(g_persrchtbl) then
        {Ask} select g_persrchtbl    moveto field g_mstkeyfld
        []="_ax"
        if not isblank(g_othkeyfld) then
          moveto field g_othkeyfld
          []="_h"
        endif
      endif

  endswitch

endproc

writelib libname qry.dosearch2


;----------------------------------------------- qry.dosearch3 ()
; Continue query construction
;
; Parameters: condcount (N),   count of conditions
;             searchcount (N), count of fields in answer table
;
;
; Globals:    g_outersearch
;             g_eventsearch
;             g_linearsearch
;             g_mstsrchtbl
;             g_persrchtbl
;             g_pertmptbl
;             g_evtsrchtbl
;             g_oth1srchtbl
;             g_oth2srchtbl
;             g_mstkeyfld
;             g_othkeyfld
;             condcount
;             searchcount
;             array ctblname
;             array cfldname
;             array stblname
;             array sfldname
;
; Return:
;


proc qry.dosearch3 (condcount,searchcount)

  private ind,
          ind2,
          oper,
          tmptblname

  for ind from 1 to condcount
    {Ask} select ctblname[ind]
    moveto field cfldname[ind]
    execute "[] = cond"+strval(ind)+""
    if table() = g_persrchtbl and not isblank([]) then
      moveto field g_mstkeyfld
      []="_a"
      if not isblank(g_evtsrchtbl) then
        moveto g_evtsrchtbl
        if not isblank(g_othkeyfld) then
          moveto field g_othkeyfld
            []="_h"
        endif
      endif
    endif
  endfor

  for ind from 1 to searchcount
    if searchmode = g_outersearch and stblname[ind] = g_persrchtbl then
      tmptblname = g_pertmptbl
    else
      tmptblname = stblname[ind]
    endif
    {Ask} select tmptblname
    moveto field sfldname[ind]
    Check
  endfor

  for ind from 1 to nimages()
    moveto ind ctrlhome
    oper = False
    for ind2 from 1 to nfields(table())
      right
      if checkmarkstatus() <> "" or
         (not isblank([]) and search("_",strval([]))=0) then
        oper = True
        quitloop
      endif
    endfor
    if not oper then
      ind = ind - 1
      clearimage
      loop
    endif
  endfor

endproc

writelib libname qry.dosearch3


;----------------------------------------------- qry.dosearch4 ()
; Perform recursive and delete queries
;
; Parameters: recurse (L),    recursive search logical True or False
;             delrec (L),     delete search    logical True or False
;
; Globals:    g_mstkeyfld
;             g_othkeyfld
;             g_searchtbl
;             g_mstsrchtbl
;             g_mstkeyfld
;             g_othkeyfld
;             g_srchprompt
;             g_notfound
;             g_moment
;             g_waitblank
; Return:
;


proc qry.dosearch4 (recurse,delrec)

  if istable("Answer") and nrecords("Answer") > 0 then
    switch
      case recurse or delrec :
        {Ask} select "Answer"
        moveto field g_mstkeyfld
        [] = "_a"
        if not isblank(g_othkeyfld) then
          moveto field g_othkeyfld
          []="_h"
        endif
        {Ask} select g_searchtbl
        if recurse then
          check
        else
          typein "Delete"
        endif
        moveto field g_mstsrchtbl+"."+g_mstkeyfld
        [] = "_a"
        if not isblank(g_othkeyfld) then
          moveto field g_persrchtbl+"."+g_othkeyfld
          []="_h"
        endif

        do_it!

        if recurse then
          empty g_searchtbl
          add "Answer" g_searchtbl
        endif
      otherwise:
        add "Answer" g_searchtbl
    endswitch
    message  g_srchprompt, nrecords(g_searchtbl) sleep g_moment
  else
    beep message g_notfound sleep g_moment
  endif

  msg.waiting (g_waitblank)
  clearall

endproc

writelib libname qry.dosearch4
