; askii.sc
;
; Askii is ATT's data based marketing system
; pre-release
;
; (c)      Ajan Tietotekniikka ATT Oy 1992
; Author:  Tapani Isoranta (Compuserve ID: 100021,3453)
;
; Address: Itlahdenkatu 21 A
;          00210 Helsinki
;          Finland
;
; Tel:     358-0-671699     in Finland (90)-671699
; Fax:     358-0-671761                (90)-671761
;
; ATT Oy is specialized in Paradox ja FoxPro developing
;
; NOTES:
;
; There is an example of using shadow-key technic, prevent form lock
;

;----------------------------------------------- create library
;


if isfile("askii.lib") then
  run "del askii.lib"
endif

libname = "askii"

createlib libname size 100


;----------------------------------------------- prg.variables ()
; General program variables
;
; Parameters:
;
; Globals:
;
; Return
;


proc prg.variables ()

  g_flashtbl     = "Pxlogo"
  g_envtbl       = "Environ"
  g_prttbl       = "Setucode"
  g_mnutbl       = "Askiimnu"
  g_hlptbl       = "Askiihlp"
  g_hlptxttbl    = "Ashlptxt"
  g_hlpreftbl    = "Ashlpref"
  g_topicfld     = "Topic"
  g_stopicfld    = "SubTopic"
  g_topictmpfld  = "TopicTmp"
  g_stopictmpfld = "SubTopictmp"
  g_rowfld       = "Row"

  g_mstsrchtbl   = "Customer"
  g_evtsrchtbl   = "Events"
  g_persrchtbl   = "Personal"
  g_pertmptbl    = "Perstmp"
  g_oth1srchtbl  = "Sales"
  g_oth2srchtbl  = ""
  g_mstkeyfld    = "CustNo"
  g_othkeyfld    = "PersNo"

  ; Entry000 - Entry999 tables behave like private tables
  if nettype ()  <> "SingleUser" then
    g_searchtbl     = "Entry998"
    g_condtbl       = "Entry999"
    copy "Srchgrp"  g_searchtbl
    copy "Srchcond" g_condtbl
  else
    g_searchtbl     = "Srchgrp"
    g_condtbl       = "Srchcond"
  endif

  g_screenproc      = "prg.background"

endproc

writelib libname prg.variables


;----------------------------------------------- prg.finmessages ()
; Program messages in finnish
;
; Parameters:
;
; Globals:
;
; Return
;


proc prg.finmessages ()

  g_username        = "Kyttj: "
  g_directory       = "Hakemisto: "
  g_copy            = "F3=Kopio   "
  g_addcust         = "F4=Pkahaku "
  g_noticeno        = "Tiedotteen numero: "
  g_wrongno         = "Vr numero!"
  g_event           = "Tapahtumakoodi: "
  g_description     = "Kuvaus: "
  g_date            = "Pivmr: "
  g_beginday        = "Alkupvm: "
  g_lastday         = "Loppupvm:"
  g_emptytbl        = "Taulu on tyhj!"
  g_dupkey          = "Duplikaatti avain!"
  g_irrcond         = "Mieletn hakuehto!"
  g_norecfound      = "Haku ei lytnyt!"
  g_duplicates      = "Duplikaatit: "
  g_recfound        = "Haku: "
  g_pressakey       = "OK, paina nppint"
  g_ok              = "OK..."

endproc

writelib libname prg.finmessages


;----------------------------------------------- prg.engmessages ()
; Program messages in english
;
; Parameters:
;
; Globals:
;
; Return
;


proc prg.engmessages ()

  g_username        = "Username: "
  g_directory       = "Directory: "
  g_copy            = "F3=Copy    "
  g_addcust         = "F4=AddCust "
  g_noticeno        = "Notice no: "
  g_wrongno         = "Wrong number!"
  g_event           = "Event code: "
  g_description     = "Description: "
  g_date            = "Date: "
  g_beginday        = "Begin day: "
  g_lastday         = "Last day:"
  g_emptytbl        = "Empty table!"
  g_dupkey          = "Duplicate key!"
  g_irrcond         = "Irrational conditions!"
  g_norecfound      = "No records found"
  g_duplicates      = "Duplicates: "
  g_recfound        = "Search: "
  g_pressakey       = "OK, press a key"
  g_ok              = "OK..."

endproc

writelib libname prg.engmessages


;----------------------------------------------- prg.background ()
; Background screen for system
; Screen is created by snipper
;
; Parameters:
;
; Globals:
;
; Return
;


proc prg.background ()

  private titlecolor,
          backcolor

  titlecolor = 95
  backcolor  = 23

  canvas off
  @2,0
  clear eos

  setmargin off
  @2,0
text
                              Marketing database                 (c) ATT Oy 1992
CustomerĿ DatePnEveDescriptionĿ
CustNo   Cl  Cont  Ctr ۳ ۳۳۳۳
Customer۳ ۳۳۳۳
Address       ۳۳۳۳
              ۳۳۳۳
               ۳۳۳۳
Tel        Fax       ۳۳۳۳
MemoĴ ۳۳۳۳
۳ ۳۳۳۳
۳ ۳۳۳۳
 
PnClTitleNameTelĿ
۳۳۳۳۳
۳۳۳۳۳
۳۳۳۳۳

DatePrCodeProductCntMakePriceĿ
۳۳۳۳۳۳
۳۳۳۳۳۳
۳۳۳۳۳۳
۳۳۳۳۳۳

endtext


  paintcanvas attribute titlecolor   2,0,2,79
  paintcanvas attribute backcolor    3,0,24,79

  canvas on

endproc

writelib libname prg.background


;----------------------------------------------- prg.flash ()
; Program flash-screen at the beginning
;
; Parameters:
;
; Globals:    g_flashtbl
;
; Return:
;
; Notes:
;


proc prg.flash ()

  view  g_flashtbl
  pickform "1"

  prompt  g_escape,
          spaces (79)

  wait table until "Esc","Enter"
  clearimage

endproc

writelib libname prg.flash


;----------------------------------------------- prg.envupdate ()
; Update environment table
;
; Parameters:
;
; Globals:    g_normalmode
;             g_envtbl
;             g_help
;             g_save
;             g_delete
;             g_nxtwin
;             g_escape
;
; Return:
;


proc prg.envupdate()

  private g_mode,
          g_mastertbl,
          g_masterfrm,
          oldenv,
          g_update

  g_mode      = g_normalmode
  g_mastertbl = g_envtbl
  g_masterfrm = "1"
  g_update    = True

  coedit g_mastertbl

  moveto [User]
  locate g_user

  copytoarray oldenv

  pickform g_masterfrm

  while True
    switch
      case table() = g_mastertbl :
        prompt  g_help   + g_save,
                g_nxtwin + g_escape
      otherwise :
        prompt  g_help   + g_save + g_delete,
                g_nxtwin + g_escape
    endswitch

    key.wait ()

    switch
      case retval = "Esc" :
        msg.dialog (g_areyousure,"A1","*!","","")
        if retval <> g_yes then
          loop
        endif
        moveto g_mastertbl
        copyfromarray oldenv
        do_it!
        clearimage
        quitloop
      case retval = "FieldView"  :
        key.fldedit ()
      case retval = "Ins" :
      case retval = "Del" :
        key.delrec ()
      case retval = "F1"  :
        hlp.hlpsystem ()
      case retval = "F2"  :
        do_it!
        clearimage
        prg.envdef ()
        quitloop
      case retval = "F3"  :
      case retval = "F4"  :
      case retval = "F5"  :
      case retval = "F6"  :
      case retval = "F7"  :
      case retval = "F8"  :
      case retval = "F9"  :
      case retval = "F10" :
      case retval = "ReverseTab" :
        key.prevtbl ()
      case retval = "Tab" :
        key.nexttbl ()
      otherwise :
        key.anykey (retval)
    endswitch
  endwhile

endproc

writelib libname prg.envupdate


;---------------------------------------------- prg.envdef ()
; Get environment variables
;
; Parameters:
;
; Globals:    g_envtbl
;             g_username
;             g_user
;             g_dir
;             g_command
;             g_port
;             g_setup
;
; Return:
;


proc prg.envdef ()

  coedit g_envtbl
  moveto field "User"

  if nettype () = "SingleUser" then
    g_user = []
    if isblank(g_user) then
     msg.dialog (g_username,"A40","","","")
      g_user = retval
      [] = g_user
    endif

  else
    g_user = username ()
    locate g_user
    if not retval then
      ins
      [] = g_user
    endif

  endif

  g_dir     = [Directory]
  g_command = [Command]
  g_port    = [Port]
  if isblank(g_port) then
    g_port = "Lpt1"
  endif
  g_setup   = [SetupCode]

  env.checkdir (g_dir)
  g_dir = retval
  [Directory] = g_dir

  do_it!
  clearimage

  setprinter g_port

  out.printsetup (g_setup)

endproc

writelib libname prg.envdef


;----------------------------------------------- prg.custupdate ()
; Update cust tables
;
; Parameters: ftbl,    filter table name
;             fkeyfld, filter key name
;
; Globals:    g_normalmode
;             g_help
;             g_addcust
;             g_search
;             g_zoom
;             g_nxtwin
;             g_swifrm
;             g_memo
;             g_delete
;             g_insert
;             g_escape
;             g_ctrlpgdn
;             g_ctrlpgup
;
; Return:
;


proc prg.custupdate (ftbl,fkeyfld)

  private g_mastertbl,
          g_masterfrm,
          g_mkeyfld,
          g_memotbl,
          g_update

  g_mode      = g_normalmode
  g_mastertbl = "Customer"
  g_masterfrm = 1
  g_mkeyfld   = "CustNo"
  g_fkeyfld   = "CustNo"
  g_memotbl   = "Custmemo"
  g_update    = True

  reset

  switch
    case isblank(ftbl) :
      g_mode = g_normalmode
      coedit g_mastertbl
      pickform g_masterfrm
    otherwise :
      g_mode      = g_filtermode
      g_filtertbl = ftbl
      g_fkeyfld   = fkeyfld
      view g_mastertbl
      coedit g_filtertbl
  endswitch

  while true
    switch
      case isformview () :
        prompt g_help   + g_addcust + g_search + g_zoom  + g_swifrm + g_memo,
               g_nxtwin + g_delete  + g_insert + g_escape
      otherwise:
        prompt g_help   + g_addcust,
               g_swifrm + g_escape
    endswitch

    key.wait ()

    switch
      case retval = "Esc" :
        key.escape ()
        if not retval then
          loop
        else
          quitloop
        endif
      case retval = "FieldView"  :
        key.fldedit ()
      case retval = "Ins" :
        prg.addcustrec ()
      case retval = "Del" :
        key.delrec ()
      case retval = "Home" :
        key.homerec ()
      case retval = "End" :
        key.endrec ()
      case retval = "PgDn" :
        key.nextrec ()
      case retval = "PgUp" :
        key.prevrec ()
      case retval = g_ctrlpgdn :
        key.nextrec ()
      case retval = g_ctrlpgup :
        key.prevrec ()
      case retval = "F1"  :
        hlp.hlpsystem ()
      case retval = "F2"  :
      case retval = "F3"  :
      case retval = "F4"  :
        prg.addcust ()
      case retval = "F5"  :
        key.search ()
      case retval = "F6"  :
        key.zoomdetails ()
      case retval = "F7"  :
        key.switchfrm ()
      case retval = "F8"  :
      case retval = "F9"  :
        prg.creatememo ()
      case retval = "F10" :
      case retval = "ReverseTab" :
        key.prevtbl ()
      case retval = "Tab" :
        key.nexttbl ()
      case retval = "Zoom" :
        key.locaterec ()
      otherwise :
        key.anykey (retval)
    endswitch

  endwhile

endproc

writelib libname  prg.custupdate


;----------------------------------------------- prg.addcustrec ()
; Add a record to cust tables
;
; Parameters:
;
; Globals:
;
; Return:
;


proc prg.addcustrec ()

  if sysmode () = "Main" then
    beep
    return
  endif

  switch
    case table () = "Customer" :
      end
      oldno = [CustNo]
      pgdn
      [CustNo]     = oldno + 1
      [CustNoLink] = oldno + 1                   ; shadow key
    otherwise :
      key.insrec ()
  endswitch

endproc

writelib libname prg.addcustrec


;----------------------------------------------- prg.addcust ()
; Add current record to search table
;
; Parameters:
;
; Globals:    g_mode
;             g_filtermode
;             g_mastertbl
;             g_searchtbl
;
; Return:
;


proc prg.addcust ()

  private frm,
          rec,
          tbl,
          fld,
          pers,
          persearch,
          cust

  ; recursive search not allowed
  if g_mode = g_filtermode then
    beep
    return
  endif

  frm    = form()
  tbl    = table()
  fld    = field()
  rec    = recno ()

  if table () = "Personal" then
    copytoarray pers
    persearch = True
  else
    persearch = False
  endif

  moveto "Customer"
  copytoarray cust
  do_it!

  coedit g_searchtbl
  end down

  [Customer.CustNo]     = cust["CustNo"]
  [Customer.Customer]   = cust["Customer"]
  [Customer.PostCode]   = cust["PostCode"]
  [Customer.CustClass]  = cust["CustClass"]
  [Customer.Contperson] = cust["ContPerson"]
  if persearch then
    [Personal.PersNo]   = pers["PersNo"]
    [Personal.Title]    = pers["Title"]
    [Personal.Name]     = pers["Name"]
  endif

  do_it!
  clearimage

  moveto g_mastertbl

  if frm <> "None" then
    coeditkey
    formkey
  endif

  moveto tbl
  moveto field fld
  moveto record rec

endproc

writelib libname prg.addcust


;----------------------------------------------- prg.custsearch ()
; General search state
;
; Parameters:
;
; Globals:    g_normalmode
;             g_condtbl
;             g_help
;             g_menu
;             g_delete
;             g_escape
;             g_update
;
; Return:
;


proc prg.custsearch ()

  private g_mode,
          g_mastertbl,
          g_masterfrm,
          g_mkeyfld,
          g_memotbl

  g_mode      = g_normalmode
  g_mastertbl = g_condtbl
  g_masterfrm = "1"
  g_mkeyfld   = ""
  g_memotbl   = ""
  g_update    = true

  coedit g_mastertbl
  pickform g_masterfrm

  while true
    prompt g_help   + g_menu,
           g_delete + g_escape
    key.wait ()

    switch
      case retval = "Esc" :
        key.escape ()
        if not retval then
          loop
        else
          quitloop
        endif
      case retval = "FieldView"  :
        key.fldedit ()
      case retval = "PgDn" :
      case retval = "PgUp" :
      case retval = "Ins" :
      case retval = "Del" :
        msg.areyousure ()
        if retval then
          del
        endif
      case retval = "F1"  :
        hlp.hlpsystem ()
      case retval = "F2"  :
      case retval = "F3"  :
      case retval = "F4"  :
      case retval = "F5"  :
      case retval = "F6"  :
      case retval = "F7"  :
      case retval = "F8"  :
      case retval = "F9"  :
      case retval = "F10" :
        do_it!
        clearimage
        mnu.system2 ("Search")              ; recursive popupmenu
        coedit g_mastertbl
        pickform g_masterfrm
      case retval = "ReverseTab" :
      case retval = "Tab" :
      otherwise :
        key.anykey (retval)
    endswitch
  endwhile

endproc

writelib libname prg.custsearch


;----------------------------------------------- prg.createevent ()
; Create events based on search table
;
; Parameters:
;
; Globals:    g_searchtbl
;             g_emptytbl
;             g_moment
;             g_event
;             g_description
;             g_date
;             g_waiting
;             g_waitblank
;             g_dupkey
;             g_ok
;
; Return:
;
; Notes:      form lock prevent table insert in network
;


proc prg.createevent ()

  private event,
          description,
          eventdate,
          cust

  if isempty(g_searchtbl) then
    beep message g_emptytbl sleep g_moment
    return
  endif

  msg.dialog (g_event,"A3","*@","Event","")
  if isblank(retval) then
    return
  endif
  event = retval

  msg.dialog (g_description,"A20","","","")
  if isblank(retval) then
    return
  endif
  description = retval

  msg.dialog (g_date,"D","","",today ())
  if isblank(retval) then
    return
  else
    eventdate = retval
  endif

  msg.waiting (g_waiting)

  view "Events"

  view g_searchtbl
  coeditkey

  scan
    copytoarray cust
    moveto "Events"
    ins
    [CustNo]    = cust["Customer.CustNo"]
    [Date]      = eventdate
    [PersNo]    = cust["Personal.PersNo"]
    [Event]     = event
    [Descr]     = description
    unlockrecord
    if recordstatus("Keyviol") then
      del
      beep message g_dupkey sleep g_second
    endif
    moveto g_searchtbl
  endscan

  do_it!
  clearall

  beep message g_ok sleep g_moment
  msg.waiting (g_waitblank)

endproc

writelib libname prg.createevent


;---------------------------------------------- prg.duplcust ()
; Remove duplicate custs from search table
;
; Parameters:
;
; Globals:    g_searchtbl
;             g_waiting
;             g_waitblank
;             g_moment
;             g_duplicates
;
; Return:
;


proc prg.duplcust ()

  private recs,
          custno,
          duplrow

  recs = nrecords(g_searchtbl)

  msg.waiting (g_waiting)

  sort g_searchtbl on "Customer.CustNo"
  clearall

  coedit g_searchtbl

  custno  = 0
  duplrow = 1

  while not eot ()
    while [Customer.CustNo] = custno and recno () > duplrow
      del
    endwhile
    custno  = [Customer.CustNo]
    duplrow = recno ()
    skip
  endwhile

  do_it!
  clearall

  beep message g_duplicates ,recs - nrecords(g_searchtbl) sleep g_moment
  msg.waiting (g_waitblank)

endproc

writelib libname prg.duplcust


;---------------------------------------------- prg.duplperson ()
; Remove duplicate persons from search table
;
; Parameters:
;
; Globals:    g_searchtbl
;             g_waiting
;             g_waitblank
;             g_moment
;             g_duplicates
;
; Return:
;


proc prg.duplperson ()

  private recs,
          name,
          duplrow

  recs = nrecords(g_searchtbl)

  msg.waiting (g_waiting)

  sort g_searchtbl on "Personal.Name","Customer.PostCode"
  clearall

  coedit g_searchtbl

  name     = ""
  duplrow  = 1

  while not eot ()
    while [Personal.Name] = name and not isblank([Personal.Name]) and
          recno () > duplrow
      del
    endwhile
    name     = [Personal.Name]
    duplrow  = recno ()
    skip
  endwhile

  do_it!
  clearall

  beep message g_duplicates ,recs - nrecords(g_searchtbl) sleep g_moment
  msg.waiting (g_waitblank)

endproc

writelib libname prg.duplperson


;----------------------------------------------- prg.todiskette ()
; Save system to diskette
;
; Parameters: Dos batfile name
;
; Globals:    g_pressakey
;
; Return:
;


proc prg.todiskette (batfile)

  msg.dialog (g_pressakey,"A1","","","")
  if isblank(retval) then
    return
  endif

  savetables
  clear
  run norefresh batfile

endproc

writelib libname prg.todiskette


;----------------------------------------------- prg.creatememo ()
; Create a memo from a field
;
; Parameters:
;
; Globals:    g_command
;             g_dir
;
; Return:
;


proc prg.creatememo ()

  private memo

  if substr(fieldtype(),1,1) <> "A" then
    beep return
  else
    memo = []
  endif

  execute "run norefresh \"\"+g_command+\"  \" + g_dir + memo"

endproc

writelib libname prg.creatememo


;---------------------------------------------- prg.rememberevent ()
; Seach a list from given event in a timeperiod
;
; Parameters:
;
; Globals:    g_event
;             g_beginday
;             g_lastday
;
; Return:
;


proc prg.rememberevent ()

  private event

  msg.dialog (g_event,"A3","","Event","")
  if isblank(retval) then
    return
  else
    event = retval
  endif

  msg.dialog (g_beginday,"D","","",today())
  if isblank(retval) then
    return
  else
    pvm1 = retval
  endif

  msg.dialog (g_lastday,"D","","",today()+7)
  if isblank(retval) then
    return
  else
    pvm2 = retval
  endif

  out.selectdevice ()
  if isblank(retval) then
    return
  endif

  Query

   Events | CustNo |        Date           | Event  | Descr |
          |  _a    | Check >=~pvm1,<=~pvm2 | ~event | Check  |

   Customer | CustNo | Customer | Tel   | Fax   |
            |  _a    | Check    | Check | Check |

  Endquery

  do_it!
  clearall

  copyreport "Remember" "1" "Answer" "1"

  out.print ("Answer","1")

endproc

writelib libname prg.rememberevent


;----------------------------------------------- prg.noticeupdate ()
; Update notices
;
; Parameters:
;
; Globals     g_normalmode
;             g_help
;             g_copy
;             g_search
;             g_swifrm
;             g_nxtwin
;             g_delete
;             g_insert
;             g_escape
;
; Return:
;


proc prg.noticeupdate ()

  private g_mode,
          g_mastertbl,
          g_masterfrm,
          g_mkeyfld,
          g_memotbl,
          g_update

  g_mode      = g_normalmode
  g_mastertbl = "Notice"
  g_masterfrm = "1"
  g_mkeyfld   = "NoticeNo"
  g_memotbl   = "Notitxt"
  g_copy      = "F3=Copy   "
  g_update    = True

  coedit g_mastertbl
  pickform g_masterfrm

  while true
    switch
      case isformview () :
        prompt g_help   + g_copy   + g_search + g_swifrm,
               g_nxtwin + g_delete + g_insert + g_escape
      otherwise:
        prompt g_help   + g_copy  + g_search + g_swifrm,
               g_delete + g_escape
    endswitch

    key.wait ()

    switch
      case retval = "Esc" :
        key.escape ()
        if not retval then
          loop
        else
          quitloop
        endif
      case retval = "FieldView"  :
        key.fldedit ()
      case retval = "PgDn" :
        key.nextrec ()
      case retval = "PgUp" :
        key.prevrec ()
      case retval = g_ctrlpgdn :
        key.nextrec ()
      case retval = g_ctrlpgup :
        key.prevrec ()
      case retval = "Ins" :
        prg.addnoticerec ()
      case retval = "Del" :
        key.delrec ()
      case retval = "F1"  :
        hlp.hlpsystem ()
      case retval = "F2"  :
      case retval = "F3"  :
        prg.noticecopy ()
      case retval = "F4"  :
      case retval = "F5"  :
        key.search ()
      case retval = "F6"  :
      case retval = "F7"  :
        key.switchfrm ()
      case retval = "F8"  :
      case retval = "F9"  :
      case retval = "F10" :
      case retval = "ReverseTab" :
        key.prevtbl ()
      case retval = "Tab" :
        key.nexttbl ()
      otherwise :
        key.anykey (retval)
    endswitch
  endwhile

endproc

writelib libname prg.noticeupdate


;----------------------------------------------- prg.addnoticerec ()
; Create new notice or insert a record
;
; Parameters:
;
; Globals:    g_memotbl
;             g_mastertbl
;
; Return:
;


proc prg.addnoticerec ()

  if sysmode () = "Main" then
    beep
    return
  endif

  switch
    case table () = g_memotbl :
      key.insrec ()
    case table () = g_mastertbl :
      end  oldno = [NoticeNo]
      pgdn [NoticeNo] = oldno + 1
  endswitch

endproc

writelib libname prg.addnoticerec


;----------------------------------------------- prg.noticecopy ()
; Copy a notice to other number (last number + 1)
;
; Parameters:
;
; Globals:    g_mastertbl
;             g_mkeyfld
;
;

proc prg.noticecopy ()

  private  r,
           oldno,
           newno

  if not isformview () then
    coeditkey
    formkey
  endif

  moveto g_mastertbl
  copytoarray r
  end
  newno = [NoticeNo]+1
  oldno = r[2]

  locate  r[2],r[3]
  ; routine in pxtools-library
  prg.copylinktbl (g_mkeyfld,oldno,newno,"","")

endproc

writelib libname prg.noticecopy


;----------------------------------------------- prg.printnotice ()
; Print notice
;
; Parameters:
;
; Globals:    g_noticeno
;             g_waiting
;             g_wrongno
;             g_searchtbl
;             g_waitblank


proc prg.printnotice ()

  private noticeno

  msg.dialog (g_noticeno,"S","","Notice","")
  if isblank(retval) then
    return
  endif
  noticeno = retval

  out.selectdevice ()

  view "Notice"
  moveto [NoticeNo]
  locate noticeno

  if retval then
    if not retval then
      clearimage
      return
    endif
    msg.waiting (g_waiting)
    prg.readnoticetxt (noticeno)
  else
    beep message g_wrongno sleep g_moment
    clearimage
    return
  endif

  out.print (g_searchtbl,5)

  msg.waiting (g_waitblank)

endproc

writelib libname prg.printnotice


;----------------------------------------------- prg.readnoticetxt ()
; Read notice rows to variables
;
; Parameters: noticeno, notice number
;
; Globals:
;
; Return: Row1 ... Row(n)
;


proc prg.readnoticetxt (noticeno)

  private nr

  Row1 = [Row1]
  Row2 = [Row2]
  Row3 = [Row3]
  Row4 = [Row4]
  Row5 = [Row5]

  clearimage

  view   "Notitxt"
  moveto [NoticeNo]
  locate noticeno

  nr = 5

  while [] = noticeno
    nr = nr + 1
    execute "Row"+strval(nr)+" = [Text]"
    if atlast () then
      quitloop
    endif
    skip
  endwhile

  clearimage

endproc

writelib libname prg.readnoticetxt


;----------------------------------------------- prg.printall ()
; Print all customer data
;
; Parameters: prsout, print person table logical True or False
;             eveout, print evet table   logical True or False
;             mrcout, print sales table  logical True or False
;             mmoout, print memo table   logical True or false
;
; Globals:    g_waiting
;             g_searchtbl
;
; Return:
;
; Notes:      Entry001-Entry999 tables can be used as private tables
;


proc prg.printall (prsout,eveout,mrcout,mmoout)

  private i,
          prs,
          eve,
          mrc,
          txt,
          custno,
          firsttime

  out.selectdevice ()
  if isblank(retval) then
    return
  endif

  msg.waiting (g_waiting)

  {Ask} select g_searchtbl
  moveto [Customer.CustNo] Check Do_It!
  rename "Answer" "List"
  clearall

  Query

   List | Customer.CustNo |
        | Check _a!       |

   Personal |  CustNo  | PersNo | Title |  Name  |  Tel   |
            | Check _a | Check  | Check | Check  | Check  |

  Endquery

  do_it!
  clearall
  rename "Answer" "Entry001"

  if eveout then

    Query

     List | Customer.CustNo |
          | Check _a!       |


    Events | CustNo | Date   | PersNo  | Event | Descr |
           | _a     | Check  |  Check  | Check | Check |

    Endquery

    do_it!
    clearall
    rename "Answer" "Entry002"

  endif

  if mrcout then

    Query

     List | Customer.CustNo |
          | Check _a!       |

     Sales  | CustNo | Date   | ProdCode | Product | Cnt   | Maker | Price |
            | _a     | Check  | Check    | Check   | Check | Check | Check |

    Endquery

    do_it!
    clearall
    rename "Answer" "Entry003"

  endif


  if mmoout then

    Query

     List | Customer.CustNo |
          | Check _a!       |

     Custmemo | CustNo |  Row   | Text  |
              | _a     | Check  | Check |

    Endquery

    do_it!
    clearall
    rename "Answer" "Entry004"

  endif


  create "Entry005" like "Allsrch"
  copyreport "Allsrch" 1 "Entry005" 1

  view   "Entry005"

  if mmoout then
    view   "Entry004"
  endif

  if mrcout then
    view   "Entry003"
  endif

  if eveout then
    view   "Entry002"
  endif

  coedit "Entry001"

  i = 0

  while True

    custno = [Customer.CustNo]

    moveto "Entry005"
    i = i + 1
    down
    [Customer.CustNo] = custno
    [Row]  = i
    moveto "Entry001"

    while custno = [Customer.CustNo]
      if prsout then
        copytoarray prs
        if not isblank(prs["Name"]) then
          moveto "Entry005"
          i = i + 1
          down
          [Customer.CustNo]  = prs["Customer.CustNo"]
          [Row]   = i
          [Text] =   prs["Title"] + spaces(33-len(prs["Title"])) +
                     prs["Name"]  + spaces(max(1,22-len(prs["Name"]))) +
                     prs["Tel"]
          moveto "Entry001"
        endif
      endif
      if atlast () then quitloop endif
      skip
    endwhile

    if eveout then
      moveto "Entry002"
      firsttime = True
      while custno = [Customer.CustNo]
        copytoarray eve
        if not isblank(eve["Date"]) then
          moveto "Entry005"
          if firsttime then
            firsttime = False
            i = i + 1
            down
            [Customer.CustNo]  = eve["Customer.CustNo"]
            [Row]   = i
          endif
          i = i + 1
          down
          [Customer.CustNo]  = eve["Customer.CustNo"]
          [Row]   = i
          [Text]  = strval(eve["Date"]) + spaces(max(1,33-len(eve["Date"]))) +
                    eve["Event"]        + spaces(max(1,22-len(eve["Event"]))) +
                    eve["Descr"]

          moveto "Entry002"
        endif
        if atlast () then quitloop endif
        skip
      endwhile
    endif


    if mrcout then
      moveto "Entry003"
      firsttime = True
      while custno = [Customer.CustNo]
        copytoarray mrc
        if not isblank(mrc["Product"]) then
          moveto "Entry005"
          if firsttime then
            firsttime = False
            i = i + 1
            down
            [Customer.CustNo]  = mrc["Customer.CustNo"]
            [Row]   = i
          endif
          i = i + 1
          down
          [Customer.CustNo]  = mrc["Customer.CustNo"]
          [Row]   = i
          [Text] = substr(mrc["Product"],1,32) + spaces(max(1,33-len(mrc["Product"]))) +
                     strval(mrc["Date"])   + spaces(max(1,22-len(mrc["Date"]))) +
                     strval(mrc["Price"])

          moveto "Entry003"
        endif
        if atlast () then quitloop endif
        skip
      endwhile
    endif

    if mmoout then
      moveto "Entry004"
      firsttime = True
      while custno = [Customer.CustNo]
        copytoarray mmo
        if not isblank(mmo["Text"]) then
          moveto "Entry005"
          if firsttime then
            firsttime = False
            i = i + 1
            down
            [Customer.CustNo]  = mmo["Customer.CustNo"]
            [Row]   = i
          endif
          i = i + 1
          down
          [Customer.CustNo]  = mmo["Customer.CustNo"]
          [Row]   = i
          [Text] = mmo["Text"]
          moveto "Entry004"
        endif
        if atlast () then quitloop endif
        skip
      endwhile
    endif

    moveto "Entry001"

    if [Customer.CustNo] = custno and atlast () then
      quitloop
    endif

  endwhile

  do_it!
  clearall

  msg.waiting (g_waitblank)

  out.print ("Entry005",1)

endproc

writelib libname prg.printall
