;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;       Forms Dictionary system, selection and miscellaneous procedures   ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; --------------------------------------------------------------------------
; Procedure   : SelectDirectory()
; Description : Get the directory to be documented
; --------------------------------------------------------------------------

proc SelectDirectory()
   private workdir

if DirectoryBox() = False then
   controls["Dictionary"] = "None"
   return
endif
if dbox["value1"] = "" then
   warning("No directory was specified")
   controls["Dictionary"] = "None"
   return
endif

workdir = dbox["value1"]
if direxists(workdir) = 0 then
   warning("Directory " + workdir + " does not exist")
   return
endif
if substr(workdir, len(workdir), 1) = "\\" then
   controls["Workdir"] = workdir
else
   controls["Workdir"] = workdir + "\\"
endif

Edit "Formdir"
   [Directory] = controls["Workdir"]
Do_It!
clearimage

GetFormList()
if EditFormList() then
   controls["Dictionary"] = "Analyse"
endif
echo normal
echo off

if isempty("Formlist") then
   warning("No forms selected")
   controls["Dictionary"] = "None"
else
   CheckAccess()
endif

endproc
WriteLib AppLib SelectDirectory
Release procs SelectDirectory

; --------------------------------------------------------------------------
; Procedure   : GetFormList()
; Description : Get the list of forms to document
; --------------------------------------------------------------------------

proc GetFormList()
   private m, tabname, formnum, workdir

if nrecords("Formlist") > 0 then
   if ConfirmationBox("Form list contains data.",
      "Empty and re-use?") then
      message "Initialising dictionary tables"
      empty "Formlist"
      empty "Frmlinks"
      empty "Frmimage"
      empty "Frmfield"
      controls["Dictionary"] = "None"
   else
      return
   endif
endif

message "Building form list"
clearpulldown
controls["Menustate"] = "None"
workdir = controls["Workdir"]
{Tools} {Info} {Inventory} {Files} select workdir + "*.F*"
clearall

view "Formlist"
view "List"
editkey
scan
   m = match([Name], "..\".\"..", tabname, formnum)
   moveto "Formlist"
   if [Table] <> "" then
      ins
   endif
   [Table] = tabname
   [Form] = upper(formnum)
   moveto "List"
endscan
Do_It!
clearall
message ""

endproc
WriteLib AppLib GetFormList
Release procs GetFormList

; --------------------------------------------------------------------------
; Procedure   : EditFormList()
; Description : Edit the list of forms to document
;     Returns : True if user accepts edited form list, False if not
; --------------------------------------------------------------------------

proc EditFormList()
   private ewin, epwin, editdoit

edit "Formlist"
ewin = getwindow()
window setattributes ewin from stdwindow
DisplayMenu("Edit")
epwin = SetPrompt(
"Use the delete key to remove forms you don't want included",
   "Press Ctrl-U to undo deletions, F2 to accept list, Escape to cancel")
window select ewin
echo normal
echo off
wait workspace
   proc "EditFormListWait"
   key "Esc",  "F2"
   message "Menuselect"
endwait

if editdoit then
   Do_It!
else
   canceledit
endif
ClearPrompt(epwin)
clearall
return editdoit

endproc
WriteLib AppLib EditFormList
Release procs EditFormList

; --------------------------------------------------------------------------
; Procedure   : EditFormListWait()
; Description : Actions triggered by user when defining a query
;   Arguments - trigger, event data, cycle number
; --------------------------------------------------------------------------

proc EditFormListWait(ttype, edata, cnum)

      switch
         case edata["type"] = "MESSAGE" and edata["Menutag"] = "Do_It!" or
            edata["type"] = "KEY" and edata["Keycode"] = -60:             ;F2
            editdoit = True
            return 2
         case edata["type"] = "MESSAGE" and edata["Menutag"] = "Cancel" or
            edata["type"] = "KEY" and edata["Keycode"] = 27:              ;Esc
            editdoit = False
            return 2
         case edata["type"] = "MESSAGE" and edata["Menutag"] = "Undo" or
            edata["type"] = "KEY" and edata["Keycode"] = 4:            ;Ctrl-U
            undo
            return 1
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;     case edata["type"] = "MESSAGE" and edata["Menutag"] = "Help" or      ;
    ;        edata["type"] = "KEY" and edata["Keycode"] = -59:             ;F1 ;
    ;        ShowHelp("CeditHelp", 2)                                          ;
    ;        DisplayMenu("Edit")                                               ;
    ;        return 1                                                          ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   endswitch

endproc
WriteLib AppLib EditFormListWait
Release procs EditFormListWait
