/*Ŀ
                                                                         
     Module:  PXGEN.CPP                                                  
     Author:  Rick Kligman                                               
     Purpose: This program will generate the code for a table class      
                                                                         
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Version 1.00                                                        
   */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
extern "C" {
  #include <pxengine.h>
}

TABLEHANDLE   pdxtbl_struct;
RECORDHANDLE  pdxrec_struct;
FILE          *cfile;
FILE          *hfile;

char          tblnameslsh [80];         // table name w\full path and slashes
char          tblname [80];             // table name with full path
char          dbname  [10];             // table name w/o path
char          cppfile [80];             // .cpp output file
char          hppfile [80];             // .h output file
char          outfile [10];             // output file w/o . extension
char          fldnames [255] [26];      // converted fieldnames
char          fldtypes [255];           // fieldtypes
char          act_fldnames [255] [26];  // actual, untouched fieldnames

int           nflds;                    // number of fields in table

void    get_struct();
void    public_h_funct();
void    private_h_funct();
void    convert_fieldname(char *, int);
void    cpp_header(void);
void    init_flds(void);


//    ķ
//                               Main function                         
//    ͼ

void main(int argc, char **argv)
{
  int   i = 0, x = 0;

  if (argc != 4) {
      printf("Usage: pxgen <pdxtable w/path> <8 char output file w/o extension (.cpp/.h)> <dbname>\n");
      exit(1);
  }

  // PXNetInit("f:\\pdx\\pdoxdata",NOVELLNET,NULL);  // change this line for net
  PXInit();

  strcpy(tblname, argv[1]);
  while ( *(tblname + x) != NULL ) {
    if (*(tblname + x) == '\\') {
        *(tblnameslsh + i)  = '\\';
        i++;
    }
    *(tblnameslsh + i) = *(tblname + x);
    i++;
    x++;
  }

  strcpy(outfile, argv[2]);
  strcpy(cppfile, argv[2]);
  strcat(cppfile, ".cpp");
  strcpy(hppfile, argv[2]);
  strcat(hppfile, ".h");
  strcpy(dbname, argv[3]);

  get_struct();                   // get all the info for structure
  public_h_funct();               // write public .h functions
  private_h_funct();              // write private .h functions
  cpp_header();
  init_flds();

  fclose(hfile);
  fclose(cfile);
  PXExit();

}

//    ķ
//                        Get Structure of a table                     
//    ͼ

void get_struct()
{
  int i;
  char fldname[26], fldtype[5];

  PXTblOpen(tblname, &pdxtbl_struct, 0, 1);
  PXRecBufOpen(pdxtbl_struct, &pdxrec_struct);
  PXRecNFlds(pdxtbl_struct, &nflds);

  cfile = fopen(cppfile, "w+");       // open up .cpp file to write to
  hfile = fopen(hppfile, "w+");       // open up .h file to write to

  fprintf(hfile, "/**********************************************************\n");
  fprintf(hfile, " *                                                        *\n");
  fprintf(hfile, " * %s \n", hppfile);
  fprintf(hfile, " * Header file for: %s \n", tblname);
  fprintf(hfile, " *                                                        *\n");
  fprintf(hfile, " **********************************************************/\n\n");

  fprintf(hfile, "#ifndef RKPDXTBL_H \n");
  fprintf(hfile, "  #include \"pdxtbl.h\" \n");
  fprintf(hfile, "#endif \n\n");

  fprintf(hfile, "class %s : public pxtable \n", dbname);
  fprintf(hfile, "{ \n");

  fprintf(hfile, "public:\n\n");
  for (i=1; i <= nflds; i++) {          /* get each field info    */
      PXFldName(pdxtbl_struct, i, 26, fldname);
      PXFldType(pdxtbl_struct, i,  5, fldtype);
      strcpy(act_fldnames [i], fldname);
      fldtypes [i] = *fldtype;

      convert_fieldname(fldname, i);    // convert fieldname to usable form

      switch ( *fldtype ) {
        case 'A':
            fprintf(hfile,"  CharFld   %s;\n", fldnames [i]);
            break;
        case 'S':
            fprintf(hfile,"  ShortFld  %s;\n", fldnames [i]);
            break;
        case 'N':
        case '$':
            fprintf(hfile,"  DblFld    %s;\n", fldnames [i]);
            break;
        case 'D':
            fprintf(hfile,"  DateFld   %s;\n", fldnames [i]);
            break;
      }
   }

  fprintf(hfile, "\n");
  PXTblClose(pdxtbl_struct);
}

//    ķ
//                         Public .h functions                      
//    ͼ

void public_h_funct()
{
  fprintf(hfile, "  %s() \n", dbname);
  fprintf(hfile, "      { strcpy(tblname, \"%s\"); }\n\n", tblnameslsh);

  fprintf(hfile, "  int   init_flds();\n");
}

//    ķ
//                         Private .h functions                     
//    ͼ

void private_h_funct()
{
  fprintf(hfile, "\nprivate: \n\n");
  fprintf(hfile, "};\n");
}

//    ķ
//       Convert fieldnames to lower case and special char checking     
//    ͼ

void convert_fieldname(char *fldname, int i)
{
  int     x = 0, origlen;
  char    *token;
  char    temploc [26];

  strlwr(fldname);
  strcpy(fldnames [i], fldname);
  origlen = strlen(fldnames [i]);

  token = strtok(fldnames [i], " !@#$%^&*()+-=/'");
  *temploc = NULL;

  while ( token != NULL ) {
      if (x > 0)
          strcat(temploc, "_");
      x++;
      strcat(temploc, token);
      token = strtok(NULL, " !@#$%^&*()+-=/'");
  }

  strcpy(fldnames [i], temploc);
  if ( strlen(fldnames [i]) != origlen )
      strcat(fldnames [i], "_");

  if ( strcmp(fldnames [i], "void") == 0 )
      strcpy(fldnames [i], "avoid");

  if ( strcmp(fldnames [i], "class") == 0 )
      strcpy(fldnames [i], "aclass");

  if ( strcmp(fldnames [i], "short") == 0 )
      strcpy(fldnames [i], "ashort");

  if ( strcmp(fldnames [i], "double") == 0 )
      strcpy(fldnames [i], "adouble");

  if ( strcmp(fldnames [i], "long") == 0 )
      strcpy(fldnames [i], "along");

  if ( strcmp(fldnames [i], "char") == 0 )
      strcpy(fldnames [i], "achar");
}

//    ķ
//                     Write out .cpp file header                  
//    ͼ

void cpp_header()
{
  fprintf(cfile, "/**********************************************************\n");
  fprintf(cfile, " *                                                        *\n");
  fprintf(cfile, " * %s \n", cppfile);
  fprintf(cfile, " * Header file for: %s \n", tblname);
  fprintf(cfile, " *                                                        *\n");
  fprintf(cfile, " **********************************************************/\n\n");

  fprintf(cfile, "#include \"%s\"\n", hppfile);
  fprintf(cfile, "\n");
}

//    ķ
//                         init_flds function                      
//    ͼ

void init_flds()
{
  int   i;

  fprintf(cfile, "int %s::init_flds() \n", dbname);
  fprintf(cfile, "{ \n");
  fprintf(cfile, "  int   i = 0; \n\n");

  for (i = 1; i <= nflds; i++) {
      fprintf(cfile, "  fldptr [i++] = &%s;\n", fldnames [i]);
  }

  fprintf(cfile, "  fldptr [i]   = NULL;\n\n");

  for (i = 1; i <= nflds; i++)
      fprintf(cfile, "  %s.setinfo(*this, \"%s\");\n",
                        fldnames [i], act_fldnames [i]);

  fprintf(cfile, "\n");
  fprintf(cfile, "  return (PXSUCCESS);\n");
  fprintf(cfile, "}\n\n");
}

