/*Ŀ
                                                                         
     Module:  PXBUD.CPP                                                  
     Author:  Rick Kligman                                               
     Purpose: To illustrate the syntax of PX_Buddy++                     
                                                                         
     Last Modified: 04-26-91 11:21am                                     
   */

#include <stdio.h>
#include <iostream.h>
#include <conio.h>
#include "cust.h"

void  exit_program(void);


Customer      cust;     // This will instatiate the Customer class and make
                        // references to cust global

int   err;              // I like to use err to check for error codes

void main()
{
  int   i;
  char  enterid [15];

  err = PXInit();
  if ( err )
      pdxerr(err, "Initializing Engine", TRUE);

  err = cust.open();    // open the customer table
  if ( err )
      pdxerr(err, "cust.open", TRUE);

  for (i = 0; i < 10; i++) {
      cust.read_rec();      // this will read record and ALL fields

      // Next I will show you how to reference fields in the record
      // buffer.

      cout << cust.custid << " " << cust.phone << " " << cust.date << "\n";

      // I will now move to the next record. The return value however
      // from this function will only return an error when a REAL error
      // occurs. By this I mean, PXRecNext() returns an error code for
      // End/Beginning of table. I do not consider this an error and
      // will return a 0 in this case. To find out whether the End/Beginning
      // of table was reached, use the class variable tblmarker. This
      // will be set to 1 if EOT/BOT has been reached, 0 otherwise.

      err = cust.recnext();     // get next record
      if ( err )
          pdxerr(err, "cust.recnext");

      if ( cust.tblmarker )     // if EOT was reached
          break;                // break out of for loop
  }

  // Next we will use the search function. Currently search is only
  // provided for Alphanumeric fields but you have the source and
  // can add the appropriate functions. I just haven't ever had to
  // search by date or number yet!

  while (1) {       // put in a while loop so you can break out on bad search
      cout << "\nEnter an ID to search for from above list: ";
      cin >> enterid;

      // Due to the nature of C++, I have defaulted the last parameter
      // of the search() function to use SEARCHFIRST. For this reason,
      // all you need to do is the following call. If you wanted CLOSESTRECORD
      // cust.custid.search(enterid, CLOSESTRECORD) would be the syntax.

      err = cust.custid.search(enterid);
      if ( err ) {
          pdxerr(err, "cust.custid.search");
          break;
      }

      // Previously you saw how to use read_rec(). That function will
      // do a PXRecGet() and then do the appropriate PXGet..()'s.
      // Sometimes, you only want to read a field or 2. If speed is a
      // concern then use the method shown below because you don't
      // have to read uneccessary fields.

      cust.recget();      // just read record, not any fields

      cust.custid.get();  // read custid field
      cust.name1.get();   // read name field

      cout << cust.custid << " " << cust.name1 << "\n";
      break;
  };

  cust.close();   // close the table and free memory allocated
  PXExit();
}

/*    Ŀ
 *                             Error Handler                          
 *      */

// This is the standard error handler for PX_Buddy++. You can make it 
// as involved as you like. Since I usually program with Vermont Views
// I have a pdxerr() that has windows that flash errors and have sounds
// etc. Since I don't know what you have, I just made a real generic
// model. pdxerr() does use the C++ property of default parameters.
// What this means is that you can ignore the 3rd (last) parameter
// if you use the prototype:
// void pdxerr(int, char *, int = 0);
// By using this, you never have to specify the 3rd parameter unless
// the error is fatal, which means either the problem must be corrected
// or the program will stop. You can see how I use this in the 
// if (fatal) line.

void pdxerr(int err, char *action, int fatal)
{
  char  temp [50];

  if (err) {
    gotoxy(0, 23);
    cout << "FATAL ERROR\n";
    cout << err << ": " << action;

    cin >> temp;
    if (fatal)
        exit_program();
    return;
  }
}


// ķ
//                       If error occurs, we are here                       
// ͼ

void exit_program()
{
  PXExit();
  exit(1);
}

