/*Ŀ
                                                                         
     Module:  PDXTBLGE.CPP                                               
     Author:  Rick Kligman                                               
     Purpose: Source code for Paradox Table Generic Class                
                                                                         
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Copyright 1991 Rick Kligman                                         
     This code may be freely used and distributed in commercial apps     
     provided some mention of PXBuddy++ is made in the documentation.    
                                                                         
     Version 1.00                                                        
   */

#include "pdxtblge.h"

//    ķ
//                  Constructor for GenericTbl class                 
//    ͼ

GenericTbl::GenericTbl()
{
}

//    ķ
//                   Destructor for GenericTbl class                 
//    ͼ

GenericTbl::~GenericTbl()
{
}


//    ķ
//                       Search for CHAR value                       
//    ͼ

int GenericTbl::search(char *fld, char *srchvar, int mode)
{
  FIELDHANDLE   fh;
  int           err;

  err = PXFldHandle(th, fld, &fh);
  CKERR;

  err = PXPutAlpha(rh, fh, srchvar);
  CKERR;

  err = search_fld(fh, mode);

  return (err);       // if no error then PXSUCCESS will be returned
}


//    ķ
//                       Actually Search Field                       
//    ͼ

int GenericTbl::search_fld(FIELDHANDLE fh, int mode)
{
  int   err;

  //  extra if on CLOSESTRECORD is done because even if it finds something
  //  it will return RECNOTFOUND since it is an inexact match

  err = PXSrchFld(th, rh, fh, mode);
  if (mode == CLOSESTRECORD && err == PXERR_RECNOTFOUND)
      err = PXSUCCESS;

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                   Test a char field to see if its blank          
//    ͼ

int GenericTbl::getfld(FIELDHANDLE fh, int fldlen, char *field)
{
  int   blank;
  int   err;

  err = PXFldBlank(rh, fh, &blank);
  CKERR;

  if (blank)                          // char field was blank
      field [0] = NULL;
  else
      if ((err = PXGetAlpha(rh, fh, fldlen, field)) != 0)
          if (err == PXERR_BUFTOOSMALL)
              err = PXSUCCESS;


  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                Test a short field to see if its blank            
//    ͼ

int GenericTbl::getfld(FIELDHANDLE fh, short &field)
{
  int   blank;
  int   err;

  err = PXFldBlank(rh, fh, &blank);
  CKERR;

  if (blank)                          // short was blank
      field = 0;
  else
      err = PXGetShort(rh, fh, &field);

  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                Test a double field to see if its blank           
//    ͼ

int GenericTbl::getfld(FIELDHANDLE fh, double &field)
{
  int   blank;
  int   err;

  err = PXFldBlank(rh, fh, &blank);
  CKERR;

  if (blank)                          // double was blank
      field = 0;
  else
      err = PXGetDoub(rh, fh, &field);

  return err;     // will be PXSUCCESS if everything went OK
}


//    ķ
//                Test a date field to see if its blank             
//    ͼ

int GenericTbl::getfld(FIELDHANDLE fh, char *field)
{
  int   blank;
  int   err;
  long  date;

  err = PXFldBlank(rh, fh, &blank);
  CKERR;

  if (blank)                          // date was blank
      field [0] = NULL;
  else {
    err = PXGetDate(rh, fh, &date);
    CKERR;
    date_decode(field, date);
  }

  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                   Test a char field to see if its blank          
//    ͼ

int GenericTbl::putfld(FIELDHANDLE fh, char *field)
{
  int   err;

  err = PXPutAlpha(rh, fh, field);

  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                Test a short field to see if its blank            
//    ͼ

int GenericTbl::putfld(FIELDHANDLE fh, short &field)
{
  int   err;

  if ( field == 0 && (! blanks_as_zeros) )
      err = PXPutBlank(rh, fh);
  else
      err = PXPutShort(rh, fh, field);

  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                Test a double field to see if its blank           
//    ͼ

int GenericTbl::putfld(FIELDHANDLE fh, double &field)
{
  int   err;

  if ( field == 0 && (! blanks_as_zeros) )
      err = PXPutBlank(rh, fh);
  else
      err = PXPutDoub(rh, fh, field);

  return err;     // will be PXSUCCESS if everything went OK
}


//    ķ
//                Test a date field to see if its blank             
//    ͼ

int GenericTbl::putfld(FIELDHANDLE fh, char *field, int)
{
  int   err;

  //  if the date is blank it can be one of two things. If the user never
  //  enters the field then it will be NULL. If the user does go through
  //  the field and leaves it blank, Vermont converts the date to 00/00/00

  if ( (field [0] == NULL || (field [0] == '0' && field [1] == '0')) &&
        (! blanks_as_zeros) )
          err = PXPutBlank(rh, fh);
  else
          err = date_encode(rh, fh, field);

  return err;     // will be PXSUCCESS if everything went OK
}

//    ķ
//                     Make a Date into a string                    
//    ͼ

void GenericTbl::date_decode(char *newdate, long date)
{
  int         month, day, year;
  char        mm [3], dd [3], yy [5], inter [3];
  char        s [12];

  PXDateDecode(date, &month, &day, &year);

  itoa(month, mm, 10);        // here we want to format the date
  itoa(day, dd, 10);          // so that it appears as 05/03/90
  itoa(year, yy, 10);

  inter [2] = NULL;           // only need to NULL once

  if (strlen(mm) == 1) {
    inter [0] = '0';
    inter [1] = mm [0];
    strcpy(mm, inter);
  }

  if (strlen(dd) == 1) {
    inter [0] = '0';
    inter [1] = dd [0];
    strcpy(dd, inter);
  }

  inter [0] = yy [2];
  inter [1] = yy [3];
  strcpy(yy, inter);

  strcpy(s, mm);
  strcat(s, "/");
  strcat(s, dd);
  strcat(s, "/");
  strcat(s, yy);

  strcpy(newdate, s);
}

//    ķ
//                     Make a String into a Date                    
//    ͼ

int GenericTbl::date_encode(RECORDHANDLE rh, FIELDHANDLE fh, char *olddate)
{
  long        date;
  int         month, day, year;
  int         err;
  char        inter [3];

  inter [0] = olddate [0];
  inter [1] = olddate [1];
  inter [2] = NULL;
  month = atoi(inter);

  inter [0] = olddate [3];
  inter [1] = olddate [4];
  day = atoi(inter);

  inter [0] = olddate [6];
  inter [1] = olddate [7];
  year = atoi(inter);

  err = PXDateEncode(month, day, year, &date);
  CKERR;

  err = PXPutDate(rh, fh, date);

  return err;
}

