/*Ŀ
                                                                         
     Module:  PDXTBL.H                                                   
     Author:  Rick Kligman                                               
     Purpose: Paradox Table Base Class Header                            
                                                                         
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Copyright 1991 Rick Kligman                                         
     This code may be freely used and distributed in commercial apps     
     provided some mention of PXBuddy++ is made in the documentation.    
                                                                         
     Version 1.00                                                        
   */

#ifndef RKPDXTBL_H
#define RKPDXTBL_H

#ifndef   __STRING_H
  #include <string.h>
#endif

#ifndef   PXENGINE_H
  extern "C" {
       #include <pxengine.h>
  }
#endif

#ifndef   RKPDXFLD_H
  #include "pdxfld.h"
#endif

//    ķ
//                         Base class for Tables                       
//    ͼ

class pxtable
{
protected:

  int     first_open;         // table opened flag
  absfld  **fldptr;           // array of pointers to abstract field class
  int     blanks_as_zeros;    // flag for zeros being written or blanks
  int     numflds;            // number of fields in the table
  int     tbl_open;           // tells whether table is open or not

  virtual int init_flds()   { return PXSUCCESS; }

public:

  TABLEHANDLE   th;
  RECORDHANDLE  rh;
  LOCKHANDLE    lh;
  char          tblname [60];
  int           tblmarker;        // flag for EOT or BOT
  int           keyed;            // is this table keyed?

  pxtable();
  ~pxtable();

  int   open(char *tablename = "", FIELDHANDLE fh = 0);
  int   read_rec();
  int   read_flds();
  int   put_recappend();
  int   put_recinsert();
  int   put_recupdate();
  int   put_flds();
  int   close();
  int   recget()                  { return( PXRecGet(th, rh) ); }
  int   recupdate()               { return( PXRecUpdate(th, rh) ); }
  int   recinsert()               { return( PXRecInsert(th, rh) ); }
  int   recappend()               { return( PXRecAppend(th, rh) ); }
  int   recnext();
  int   recprev();
};

#endif
