;
; PASSWORD SCRIPT FOR TABLE OR MENU ACCESS
; Author : Glenn Pence 
; Written: April 21, 1994
;
CLEAR
CLEARALL
SHOWPULLDOWN ENDMENU
X=3                                     ; sets the # of attempts
IF X<1 THEN                             ; must be at least 1 attempt...
  BEEP
  MESSAGE " Error -- less than 1 login attempt specified -- quitting program. "
  SLEEP 3500
  MESSAGE ""
  QUIT
ENDIF
IF X=1                                  ; change wording if only 1 attempt
 THEN
  MESSAGE " You have only 1 attempt to enter the correct password. "
 ELSE
  MESSAGE " You have ", X," attempts to enter the correct password. "
ENDIF  
FOR i FROM 1 TO X                       ; loop for X attempts
CLEARIMAGE
PWORD=""
SHOWDIALOG "ENTER YOUR PASSWORD" @ 9,20 HEIGHT 5 WIDTH 40 
ACCEPT @1,4 WIDTH 20 
 "A20" REQUIRED HIDDEN          ; allows up to 20 chars.
 TAG "PWNAME"
 TO PWORD
PUSHBUTTON @ 1,27 WIDTH 8       ; inserts an OK button in the dialog box.                
"OK"
OK
DEFAULT
VALUE "SAY YES"
TAG "OkTag"
TO BUTTONVAL
ENDDIALOG
IF PWORD = "IMOK"                ; IMOK is the password in this example.
 THEN
   CLEAR                         
   CURSOR OFF                    
   STYLE ATTRIBUTE 31 @ 10,32 ?? "Please wait"
   STYLE ATTRIBUTE 159 @ 10,43 ?? "..."
   MESSAGE " Valid password confirmed. " 
;-----------------------------------------------------------------------
;
; the following PAL code plays reveille -- it is in no way needed
; for the script to work. In fact, I merely added it to impress my
; co-workers who requested this script  :-)
;
   BEAT=100
   SOUND 195 1*BEAT SLEEP 100
   SOUND 261 1*BEAT SLEEP 100
   SOUND 329 1*BEAT
   SOUND 261 1*BEAT 
   SOUND 195 1*BEAT SLEEP 100
   SOUND 329 1*BEAT SLEEP 100
   SOUND 261 1*BEAT SLEEP 100
   SOUND 329 1*BEAT
   SOUND 261 1*BEAT
   SOUND 195 1*BEAT SLEEP 100
   SOUND 329 1*BEAT SLEEP 100
   SOUND 261 1*BEAT SLEEP 100
   SOUND 329 1*BEAT
   SOUND 261 1*BEAT
   SOUND 195 1*BEAT SLEEP 100
   SOUND 195 1*BEAT SLEEP 100
   SOUND 261 6*BEAT
;
; this is the end of the PAL code for reveille
;-----------------------------------------------------------------------
   MESSAGE ""
   QUIT
 ELSE                   ; show message re: remaining attempts
   CLEARALL
   IF (X-i)=0 THEN      ; if only 1 attempt, exit now
     QUITLOOP
   ENDIF  
   IF (X-i)=1 THEN      ; show this on last attempt
    BEEP
    MESSAGE " Incorrect password -- this is your last chance! "
   ELSE                 ; show this on all but the last attempt
   IF (X<>i) THEN
    BEEP
    MESSAGE " Incorrect password -- you have ",(X-i)," attempts left... "
   ENDIF 
   ENDIF
ENDIF
CLEARALL
ENDFOR
; BEEP   add back in if you remove the dragnet portion of code
CLEAR
CURSOR OFF
STYLE ATTRIBUTE 78  @ 9,28 ?? " UAAAAAAAAAAAAAAAAAAAA? " 
STYLE ATTRIBUTE 78 @ 10,28 ?? " 3  "  
STYLE ATTRIBUTE 207 @ 10,32 ?? "ACCESS DENIED...  "
STYLE ATTRIBUTE 78 @ 10,50 ?? "3 "  
STYLE ATTRIBUTE 78 @ 11,28 ?? " AAAAAAAAAAAAAAAAAAAAAU " 
IF (X)=1 THEN
  MESSAGE " You have used your 1 attempt -- program terminated. "
ELSE  
  MESSAGE " You have used your ",X," attempts -- program terminated. "
ENDIF  
;-----------------------------------------------------------------------
;
; the following PAL code plays the theme from dragnet when the user fails
; to supply the correct password.
;
  BEAT=100
  SOUND 130 5*BEAT SLEEP 200
  SOUND 146 1*BEAT
  SOUND 155 2*BEAT SLEEP 200
  SOUND 130 2*BEAT SLEEP 1000
  SOUND 130 5*BEAT SLEEP 200
  SOUND 146 1*BEAT
  SOUND 155 2*BEAT SLEEP 200
  SOUND 130 2*BEAT SLEEP 200
  SOUND 184 8*BEAT
;
;-----------------------------------------------------------------------
; SLEEP 3500  add back in if you remove the dragnet portion of code
MESSAGE ""
CLEARALL
QUIT    ; or EXIT to leave Paradox when the script is finished.
;
;
;------------------------- NOTES ON USAGE ------------------------------
;
; The X variable at the top represents the number of attempts you allow
; the user to have before denying access (ie- getting kicked out).
;
; You can rename the dialog box by changing "ENTER YOUR PASSWORD" after the
; SHOWDIALOG command with another title -- remember to include the quotes!
;
; "A20" REQUIRED HIDDEN means the password (input) is 20 Alphanumeric 
; characters long, that the input is required (you cannot ESCAPE out) and
; that the results should be hidden by ****'s.
;
; Change the password from IMOK to whatever you want.  You can also use
; two passwords by modifying the IF command to:
;               IF (PWORD="IMOK") OR (PWORD="UROK")
; assuming you want IMOK and UROK to be the passwords.  Remember, each of
; these passwords has the same level of access in this example.
;
; PWORD is the variable you test to see if the user input the proper
; password. Remember, you could have 10 (or 100!) correct passwords 
; (and different actions associated with each password) just by adding 
; more IF-THEN loops to test if the variable PWORD contains the correct
; answer.  You can limit access rights by choosing the TOOLS-MORE-PROTECT-
; PASSWORD-TABLE from the menu.  Be sure to read about assigning the various
; levels of access rights.  I like to give one group read-only rights (to
; VIEW the table), another EDIT and DATA-ENTRY rights and keep the MASTER
; rights for myself. In order to do that you will need to modify this script.
; I set up scripts for each level of access and then, in the IF-THEN loops, I
; use the PLAY command to play the corresponding script.
;
; In this example I have the script display a simple "Valid password
; confirmed" message and play reveille.  You will want to use the PLAY command,
; or another command such as EDIT, to actually do something productive. I
; also have the theme from Dragnet play if no successful attempts were made.
; If you remove the Dragnet code, please re-insert the BEEP and SLEEP commands
; which I "commented-out", otherwise the script will not notify the user and
; it will exit too quickly for the user to read the messages.
;
; You can change the ACCESS DENIED... color scheme to suit your needs. The
; commands to do so are the STYLE ATTRIBUTE commands towards the bottom of 
; the script. The value 78 is for a red background with a yellow box. The 207
; value is for blinking white letters on a red background. You may wish to
; use a more subdued color scheme such as 31 & 159, which is a white box on 
; the same blue background (159 makes the words ACCESS DENIED blink), or you
; can create your own combination by looking in Appendix F in the PAL 
; Reference Manual which came with your Paradox 4.5 for DOS software.
;
; I have added a couple of error handling routines which modify the code 
; slightly from the inital script. You can no longer specify the number of
; attempts as less than 1. The script no longer displays "You have 1
; attempts remaining" on the last attempt and it will not display "You will
; have 1 attempts..." if you choose to have only one attempt.
;
; You can use the EXIT command at the end to leave Paradox or the QUIT command
; to leave the script, whichever you feel is more appropriate.  Hint: while
; you're debugging your script use QUIT -- it saves alot of time & frustration.
;
; Please feel free to use and adapt this script however you like. You should 
; remember to password protect this script so that it can't be read. If you
; are going to use password protection in many instances, or with many users,
; you should probably convert this script into a procedure. It's not very
; hard to do. You can read more about creating procedures in Chapter 6 of the
; PAL Programmers Guide which came with Paradox 4.5 for DOS.
;
; Good Luck and Enjoy!
;
;
