;PL200
; ----------------------------
;  Print_One_Record Routine
; ----------------------------
;  Written By:
;	Jon C. Krueger
;	248 Adams Road
;	Greenfield, MA.  01301
;	CIS MailBox 76067,3242
; ----------------------------
;
;	Works with any current table in the workspace.
;	Code for MEMO fields can be removed if using Ver. 3/3.5
;	Prints a nicely formated single record output for any record
;	on the current workspace.  Works in FormView or Regular Mode
;	or edit mode.
;	I have assigned this code to the ALT-P key to have instant access
;	to a single record print-out.
;		Setkey -25 Play "c:\\pdox40\\tables\\prntone"
;	Can't live without it now.
; ----------------------------
;Revision History
;January 12, 1989 Original Code
;JCK 10/26/90	Cosmetics
;JCK 09/28/91   DOTS lead to field data - Turned Canvas OFF
;               Added Header (Table-Rec#-Date-Time)
;JCK 05/19/92   FormView() Fix
;JCK 01/01/93	Rewritten to accomodate MEMO fields in any record




;===================
;==== Main PROC ====
;===================
PROC PrntOne()

;==== Check for Valid Table ====
If imagetype() <> "Display" then        ;Is there a TABLE Loaded?
        Beep
        message " No valid TABLE is present "
        sleep 2000
        QUIT                            ;If NOT then quit
EndIf

;==== Check Printer Status ====
While printerstatus() = false  
      beep beep  @ 1,0
      beep beep
      ?? " Printer is NOT READY  -  Press  ENTER  to Retry..."
      beep beep
      Accept "A1" to X
      loop
EndWhile

;==== Setup Variables ====
   F=FIELD()                        ;Save current field position for return
   R=RECNO()			    ;Save current record #
   N=NFIELDS(TABLE())               ;How many fields in current table?
   CtrlHome                         ;Put cursor at first field
   Max.Width = 45		    ;Max width of Memo Line
   Max.Lines = 30		    ;Max # of Lines to print
   PL = 25			    ;Prefix Length

   If NOT ISFORMVIEW()              ; Skip Record # field if
      THEN Right                    ; not in formview mode
   EndIf



;==== Begin Printing of Data ====
MESSAGE  "Single Record Report is being formmatted for Printing...."
OPEN PRINTER                             ; Turn printer output ON

L1="Single Record Printout of "+TABLE()+" Table - Record #"+Strval(RECNO())
   +" of "+Strval(NRECORDS(TABLE()))
Print L1+"\n"

L2="Date: "+Strval(TODAY())+"            Time:"+Strval(TIME())
Print L2+"\n"

Print "\n"                           ; adjust printed output
Print "\n"



CopytoArray Cur.Rec		    ;Create an Array for Current Record

For Cntr from 2 to ArraySize(Cur.Rec)
	SPS=PL-Len(Field())                 ;   Space to suit your taste
	DOTS=FILL(".",SPS)                  ;   Replace spaces with dots
	Prefix=Field()+DOTS	            ;   Load Prefix Header
	Print Prefix			    ;   then Print it.

	If Len(Cur.Rec[cntr]) <= Max.Width
	then
	   Print StrVal(Cur.Rec[cntr])+"\n" ;   Print Record Data
	Else				    ;=|   must be a memo field
					    ;P|
	   Dynarray Memo.A[]		    ;D| Declair dynarray Memo lines
					    ;X| get # of lines to word wraped
	   X=WordWrapThis4(Cur.Rec[cntr]    ;4| Cur Field
               		  ,Max.lines   	    ;0| Max lines to word wrap on to
               		  ,Max.width	    ; | Max width of a line (< 255)
               		  ,Memo.A)  	    ;O| Dynarray for word wrap lines
					    ;N|
		Print Memo.A[1]+"\n"	    ;L| First Memo line Data
	   For cntr2 from 2 to X            ;Y| Print remaining Memo line Data
Print Fill(" ",PL)+Memo.A[cntr2]+"\n"	    ; |	
					    ; | remove this code if using 
	   EndFor			    ;=| Ver. 3
	EndIf
	Right
EndFor

print "\F"                              ; Eject page from printer
Close PRINTER                           ; Turn printer output off

;==== HouseKeeping ====
CLEAR @ 0,0                             ; Erase Work Area
MOVETO RECORD R                         ; Return to original record
MOVETO FIELD F                          ; Go back to original field

ENDPROC    ;PrntOne()                   ; End of Procedure PrntOne()




;==========================
;==== WordWrap Routine ====
;==========================
;==== Obtained from Borland Forum - Brian Bushay (TeamB)
;==== to parse MEMO fields into printable lines Dec-92
;==== Remove this Procedure if using Ver 3/3.5
PROC WordWrapThis4(text.a  ;text var to wordwrap
                   ,lns.n  ; Max lines to word wrap on to
                           ;if you want it to wrap until
                           ;finished make this a large number
                   ,wid.n  ; Max width (can't exceed 255) of a line
                   ,ww.y)  ;Dynarray to place word wrap lines into
	;This4 procedure wordwraps a sting to Dynarray
	;with elements "1" - number of lines
	;works only with version 4.0 last revised 12/24/92
	;This procedure was sent to me by CIS TeamB Member Brian Bushay

  private ret,procname.a,
              cntr,        ;counter for FOR loop
              startchr.n,  ;starting character of a wrap line
              takeChrs.n,  ;number of characters to put into a wrap line
              spacePos.n,  ;keeps track of space possition
              trimChr.n    ;number of characters to trim from end of a line

  procname.a = "WordWrapThis4"
     text.a = " "+text.a ;if this is a memo var this line will reset its
                         ;character index this was a problem in
                         ;the original release of 40
     startchr.n = 1         ;starting character possition
     wid.n = Min(wid.n,255) ;width can not exceed 255
  For cntr from 1 To lns.n
    ww.y[cntr] = ""     ;init dynarray element
    takeChrs.n = 0      ;Initialize at 0
    trimChr.n = 0       ;Initialize at 0
    Switch
      Case SearchFrom("\n",text.a,startchr.n) > 0 And ;look for carrige return
           SearchFrom("\n",text.a,startchr.n) < (startChr.n+wid.n):
           takeChrs.n = SearchFrom("\n",text.a,startchr.n)- (startchr.n-1)
           trimChr.n =  1
      Case (startChr.n + wid.n) > Len(text.a): ;no more word wrap needed
           takeChrs.n = wid.n
      OtherWise:  ;need to find next space to break at
        While true
          spacePos.n =  SearchFrom(" ",text.a,startChr.n+takeChrs.n)
          Switch
            Case (spacePos.n - (startchr.n-1)) > wid.n :
              If takeChrs.n <= 0 then
                 takeChrs.n = wid.n ;this section can not be broken at a space
              Endif
            Quitloop
          OtherWise:
            takeChrs.n = spacePos.n - (startchr.n-1)
          EndSwitch
        EndWhile
    EndSwitch
          ww.y[cntr] = Substr(text.a,startChr.n,takeChrs.n-trimChr.n)
          startChr.n = startChr.n +takeChrs.n   ;rest var
          If startChr.n > Len(text.a) then Quitloop Endif  ;all wrap lines set
  Endfor
  Return cntr
EndProc   ;WordWrapThis4()






;------------------------
;---- Call Procedure ----
;------------------------
PrntOne()
