//----------------------------------------------------------------------------
// DBDirUnlock()
// Description.: Unlocks a directory (such as the private dir) which has
//               been locked by Paradox.  As of Paradox Engine v2.0, the
//               private directory is not available to the engine, so we
//               must unlock it before use.  CAUTION: be sure to call
//               DBDirLock() when you are finished!
// Inputs......: None
// Globals.....: Privatedir - private directory
// Return Value: 0 - success
//               nonzero - failure
//----------------------------------------------------------------------------

int DBDirUnlock()
{
  int  Err = 0;
  char Newpath[80], Oldpath[80], Path[80];

  if (strlen(Privatedir) > 0)
  {
    strcpy(Path, Privatedir);
    if (Path[strlen(Path) - 1] != '\\')
      strcat(Path, "\\");

    strcpy(Newpath, Path);
    strcat(Newpath, "PARADOX.XXX");

    strcpy(Oldpath, Path);
    strcat(Oldpath, "PARADOX.LCK");

    unlink(Newpath);
    Err = rename(Oldpath, Newpath);
  }
  return (Err);
}

//----------------------------------------------------------------------------
// DBDirLock()
// Description.: Locks a directory (such as the private directory) which
//               has been locked by paradox previously, by a call to
//               DBDirUnlock().  This function MUST be called to relock the
//               directory before exiting a C program that uses the engine
//               and accesses the private directory.
// Globals.....: PrivateDir - private directory
// Outputs.....: 0 - success
//               nonzero - error code
// Return Value: None
//----------------------------------------------------------------------------

int DBDirLock()
{
  int  Err = 0;
  char Newpath[80], Path[80];

  if (strlen(Privatedir) > 0)
  {
    if (Privatedir[strlen(Privatedir) - 1] != '\\')
      strcat(Privatedir, "\\");
    strcpy(Path, Privatedir);
    strcat(Path, "PARADOX.LCK");
    strcpy(Newpath, Privatedir);
    strcat(Newpath, "PARADOX.XXX");

    if (access(Newpath, 0) == 0)        /* Is PARADOX.XXX out there?         */
    {
      unlink(Path);
      Err = rename(Newpath, Path);
    }
  }
  return (Err);
}
