;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure
;Source File     : Print1.SC
;Author          : Daniel J. Paolini II
;                  DataStar International
;                  dp Solutions
;                  (609) 461-5103
;
;Informant Issue : October 1992
;
;Description     : Generic Report Dialog Box Utility
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

; ===========================================================================
;      AUTHOR: CopyRight (c) 1992 - Daniel J. Paolini II
;                                   DataStar International
;                                   dp Solutions
;     CREATED: 08-01-92 04:00 am    Version 4.00
; ===========================================================================
;       TITLE: ioSelectOutput.u
;     RETURNS: No Value
; DESCRIPTION: Generic Output Loop
; ---------------------------------------------------------------------------
PROC ioSelectOutput.u(           ; Generic Report Output Loop
         title.a,                ; Report Title
         table.a,                ; Table to report on
         report.a,               ; Report number
         default.a,              ; default printer port for Local
         custom.a,               ; Custom Printer Select routine or ""
         pause.l,                ; Pause before Printing?
         save.l)                 ; Save Report to File?
Private  proc.a,                 ; Procedure name
         file.a,                 ; name for saved report file
         file.l,                 ; Is Report already in file?
         destination.a,          ; Report destination
         screenfile.a,           ; Name of file for Screen Viewer
         highlight.n,            ; Color of bright outline edge
         lowlight.n,             ; Color of dull outline edge
         titlelength.n,          ; Length of the report title
         titleleft.n,            ; Column to begin title
         screen.l,               ; Has report been shown on Screen yet?
         pbutton.a,              ; Pushbutton variable
         tag.a,                  ; Control element variable
         setup.a,                ; Setup string variable
         destination.n           ; Destination pushbutton variable

   msWorking.u("W",49,0,0)
   PROC ioSelectOutputDBWait.n(type.a,event.y,cycle.n)
      Return 2                            ; Cancels Wait
   ENDPROC

   setup.a = ""
   file.l = false
   screen.l = false
   screenfile.a = PrivDir() + StrVal(Ticks())+".sc"
   file.a = "Filesave.rpt"
   destination.n = 1
   pbutton.a = "CANCEL"
   highlight.n = 127
   lowlight.n = 112
   tag.a = "OUTPUT"
   titlelength.n = Min(54,Len(table.a+".R"+report.a+" - "+title.a)+2)
   titleleft.n = 29 - Int(titlelength.n/2)
   Message ""

   SHOWDIALOG "Select Report Destination for"
      PROC "ioSelectOutputDB.u" TRIGGER "UPDATE", "ARRIVE", "DEPART"
      @ 3,10 Height 16 Width 60

      Frame Single From 3,1 To 5,56
         PaintCanvas Border
                     Attribute IIF(tag.a="OUTPUT",highlight.n,lowlight.n)
                     3,1,5,56
         PaintCanvas Border
                     Attribute IIF(tag.a="OUTPUT",lowlight.n,highlight.n)
                     3,1,3,55
         PaintCanvas Border
                     Attribute IIF(tag.a="OUTPUT",lowlight.n,highlight.n)
                     3,1,5, 1
      Frame Single From 6,7 To 9,50
         PaintCanvas Border
                     Attribute IIF(tag.a="OK" OR tag.a = "CANCEL",
                     highlight.n,lowlight.n)
                     6,7,9,50
         PaintCanvas Border
                     Attribute IIF(tag.a="OK" OR tag.a = "CANCEL",
                     lowlight.n,highlight.n)
                     6,7,6,49
         PaintCanvas Border
                     Attribute IIF(tag.a="OK" OR tag.a = "CANCEL",
                     lowlight.n,highlight.n)
                     6,7,9, 7

      @ 1,titleleft.n ?? Format("w"+StrVal(titlelength.n)+",ac",
                                 table.a+".R"+report.a+" - "+title.a)
         PaintCanvas Attribute 95
                     1,titleleft.n,1,titleleft.n+titlelength.n-1
      @ 2,titleleft.n+1 ?? Fill("",titlelength.n)
         PaintCanvas Attribute 112
                     2,titleleft.n+1,2,titleleft.n+titlelength.n
      @ 1,titleleft.n+titlelength.n ?? ""
         PaintCanvas Attribute 112
                     1,titleleft.n+titlelength.n,1,titleleft.n+titlelength.n
      @ 10,2 ?? " Printer String:"
         PaintCanvas Attribute 113 10,2,10,17
      @ 12,2 ?? "      File Name:"
         PaintCanvas Attribute 113 12,2,12,17


      RadioButtons @ 4,2 Height 1 Width 54
         "Screen", "Printer", "Alternate", "DiskFile"
         Tag "OUTPUT"
      To destination.n

      PushButton @ 7,8 Width 19
         "~O~utput Report"
         Default Value "OK" Tag "OK"
      To pbutton.a

      PushButton @ 7,31 Width 19
         "~F~inished Output"
         Cancel Value "CANCEL" Tag "CANCEL"
      To pbutton.a

      Accept @ 10,18 Width 38
         "A36" Tag "SETUP"
      To setup.a

      Accept @ 12,18 Width 38
         "A36" Picture "*!" Tag "FILE"
      To file.a

   ENDDIALOG

   msWorking.u("W",79,0,0)
   {Report} {SetPrinter} {Regular}
   {Report} {SetPrinter} {Override} {EndOfPage} {FormFeed}

   IF file.l THEN
      IF save.l THEN
         IF NOT IsAssigned(g.reports.y) THEN
            DynArray g.reports.y[]
         ENDIF
         g.reports.y[title.a] = screenfile.a
      ELSE
         Run NOREFRESH "Del " + screenfile.a + " > NUL"
      ENDIF
   ENDIF
   Message ""
   Release PROCS ioSelectOutputDBWait.n
   Return
ENDPROC
; ===========================================================================
;       TITLE: ioSelectOutputDB.u
;     RETURNS: No Value
; DESCRIPTION: Generic Output Dialog Box Proc
; ---------------------------------------------------------------------------
PROC ioSelectOutputDB.u(         ; Generic Report Output Loop
         type.a,                 ; EVENT or TRIGGER
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null
Private  file.v,                 ; Returned value of FileName Accept
         dbox.w,                 ; DialogBox Window handle
         dbox.y,                 ; DialogBox Window attributes
         viewer.w,               ; Report Window handle
         viewer.y,               ; Report Window attributes
         print.l,                ; Print report?
         v, y, m, n,             ; Transient variables
         printfile.l             ; Should report be printed to File
;Global  screenfile.a,           ; Name of report file in PrivDir
;        destination.n,          ; Destination PushButton variable

   print.l = false
   IF type.a = "UPDATE" AND tag.a = "OK" THEN
      SWITCH
         CASE destination.n = 1  :  ; ViewScreen()
            Window Handle Dialog to dbox.w
            Window GetAttributes dbox.w to dbox.y
            SetCanvas dbox.w
            ShowPullDown EndMenu
            Prompt "Press <Esc> or Click on Close [] when Finished Viewing..."
            ; Set any report formatting variables to Null here, such as:
            ; pica.a = ""
            ; boldon.a = ""
            ; boldoff.a = ""
            ; reset.a = ""
            IF NOT file.l THEN
               ioReportToFile.u(table.a,report.a,screenfile.a,true)
               file.l = true
            ENDIF
            IF NOT screen.l THEN
               Create "Entry086" "Report" : "M1"
               FileRead screenfile.a To m
               Edit "Entry086"
               [Report] = m
               Do_It!
               MoveTo [Report]
               screen.l = true
            ELSE
               View "Entry086"
               MoveTo [Report]
            ENDIF
            utWindowPark.u(dbox.w)
            FieldView
            WinMax
            viewer.w = GetWindow()
            Window Getattributes viewer.w to viewer.y
               viewer.y["Title"]=Title.a
               viewer.y["CANRESIZE"]=False
               viewer.y["CANMOVE"]=False
               viewer.y["CANCLOSE"]=True
               viewer.y["CANMAXIMIZE"]=False
               viewer.y["Style"]=112
            Window Setattributes viewer.w From viewer.y

            Message ""
            {Options} {WordWrap} {Clear}
            Echo Normal
            WAIT Field
               Proc "ioSelectOutputDBWait.n"
                  Key "Esc"
                  Message "CLOSE"
            ENDWAIT
            Canvas OFF
            WinClose ClearImage
            Echo Off
            Prompt ""
            Window Move dbox.w To dbox.y["OriginRow"],dbox.y["OriginCol"]
            Canvas ON
         CASE destination.n = 2   : ; PrintReport()
            ; Call routine to set printer control variables, such as:
            ; pica.a = [Pica]
            ; boldon.a = [Bold ON]
            ; boldoff.a = [Bold OFF]
            ; reset.a = [Reset]
            print.l = true
         CASE destination.n = 3 :
            SWITCH
               CASE NOT IsBlank(custom.a) :
                  ExecProc custom.a    ; Must assign variables, true/false
                  v = retval           ; True = go ahead and print
                  IF Type(v) = "L" AND v THEN
                     print.l = true
                  ENDIF
               OTHERWISE :
                  msContinue.u("No Alternate Printers are Available",79,"",1)
            ENDSWITCH
         CASE destination.n = 4  : ; SaveFile()
            printfile.l = true
            RefreshControl "OUTPUT"
            file.v = ioAcceptDialog.v(10,18,"Enter Full Path and File Name",
                                       "File Name","A36","",file.a,false,"")
            IF file.v <> false THEN
               file.a = file.v
               RefreshControl "FILE"
               IF IsFile(file.a) THEN        ; Whoops!
                  mnConfirm.l(3, 21, "That Filename Exists - Overwrite?",
                           "NO", "YES",
                           "Do NOT Overwrite - Try again",
                           "Overwrite the existing File",
                              32, 47, 15, false)
                  IF NOT retval THEN
                     printfile.l = false
                  ENDIF
               ENDIF
               IF printfile.l THEN
                  IF NOT file.l THEN
                     msWorking.u("One Moment - Preparing Report",49,0,0)
                     ioReportToFile.u(table.a,report.a,PrivDir()+screenfile.a)
                     file.l = true
                  ENDIF
                  msWorking.u("Saving Report as "+PrivDir()+file.a,49,0,0)
                  Run NOREFRESH "Copy " + PrivDir() + screenfile.a + " " +
                                          PrivDir() + file.a
               ENDIF
            ENDIF
      ENDSWITCH
   ENDIF
   IF print.l THEN
      IF pause.l THEN
         msContinue.u("Make sure Printer is Ready with the proper paper",79,"",2)
      ENDIF
      ioPrinterStatus.l()                ; Check printer status
      IF retval THEN
         {Report} {SetPrinter} {Override} {Setup} Select setup.a
         Report table.a report.a
      ENDIF
   ENDIF
   Canvas OFF
   Message ""
   RepaintDialog
   Canvas ON
   Return
ENDPROC
; ===========================================================================
;       TITLE: ioPrinterStatus.l
;     RETURNS: logical true or false if printer available
; DESCRIPTION: Generic printer status, Can be called from ErrorProc
; ---------------------------------------------------------------------------
PROC ioPrinterStatus.l()         ; Generic printer status
Private  retval.l                ; Value to return
   retval.l = true
   msWorking.u("Checking to see if the printer is ready",49,0,0)
   WHILE NOT PrinterStatus()
      msWorking.u("The Printer is NOT Responding!",79,0,0)
      retval.l = msConfirm.l("Correct the Problem, or <Cancel>",79,
                             "",3,"~R~eady","~C~ancel",true)
      IF NOT retval.l THEN
         QUITLOOP
      ENDIF
   ENDWHILE
   IF retval.l THEN
      msWorking.u("P",79,0,0)
   ELSE
      msWorking.u("R",79,3,0)
   ENDIF
   Return retval.l
ENDPROC
; ===========================================================================
;       TITLE: ioReportToFile.u
;     RETURNS: No Value
; DESCRIPTION: Prints a Report to a designated File Name
; ---------------------------------------------------------------------------
PROC ioReportToFile.u(           ; Generic report to file
         table.a,                ; Table to Report on
         report.a,               ; Report to Output
         file.a,                 ; Name of File to Output to
         screen.l)               ; Preparing for screen view?
   IF screen.l THEN
      msWorking.u("Preparing Report for Screen - This may take a few minutes",31,0,0)
   ELSE
      msWorking.u("Sending Report to File - This may take a few minutes",49,0,0)
   ENDIF
   {Report} {Change} Select table.a Select report.a Enter
   {Setting} {Setup} {Custom} Enter Select "" Do_It!
   {Report} {Output} Select table.a Select report.a {File}
                     Select file.a          ; Outputs to File
      IF MenuChoice() = "Cancel" THEN
         {Replace}
      ENDIF
   Return
ENDPROC
; ===========================================================================
;       TITLE: ioAcceptDialog.v
;     RETURNS: Value Entered, or false if Cancelled
; DESCRIPTION: Generic routine for accepting data from user, with or without
;              a Picture or Default value, Hidden or unhidden.
; ---------------------------------------------------------------------------
PROC ioAcceptDialog.v(           ; One value DialogBox Accept
         top.n,                  ; Top Row for Box (999 = Centered)
         left.n,                 ; Left Column (999 = Centered)
         title.a,                ; Title for dBox
         prompt.a,               ; Data Input Prompt
         type.a,                 ; Type of Data Input
         picture.a,              ; Additional validity string
         default.v,              ; Any Default for the Accept Value?
         hidden.l,               ; Hidden, or not?
         colors.y)               ; DynArray of Colors
Private  width.n,                ; Width of Dialog Box
         length.n,               ; Length of Input
         right.n,                ; Right edge of Box
         input.v,                ; Value entered by user
         oldcolors.y,            ; Previous Color Set
         accept.v,               ; Variable to capture Accept
         spot.n,                 ; Where to begin Prompt
         pbutton.a               ; Pushbutton variable
;Global  g.sysinfo.y
   IF Len(prompt.a) > 50 THEN          ; Must keep to a reasonable length
      accept.v = false
      Message "ERROR - Prompt is too Long!!!"
      Beep Beep Beep
      Sleep 5000
   ELSE
      IF Type(colors.y) = "DY" THEN    ; Must be a DynArray, or else ignore
         GetColors To oldcolors.y
         SetColors From colors.y
      ENDIF
      SWITCH                           ; Determine length of Accept Datatype
         CASE type.a = "D" :           ; Set Default value to passed value
            length.n = 11              ;  or a blank value if none passed
            accept.v = IIF(IsBlank(default.v),BlankDate(),default.v)
         CASE type.a = "N" OR type.a = "$"   :
            length.n = 20
            accept.v = IIF(IsBlank(default.v),BlankNum(),default.v)
         CASE type.a = "S" :
            length.n = 8
            accept.v = IIF(IsBlank(default.v),BlankNum(),default.v)
         OTHERWISE         :
            length.n = NumVal(SubStr(type.a,2,3)) + 3
            accept.v = default.v
      ENDSWITCH                        ; Are we beyond 80 column screen width?
      IF length.n + Len(prompt.a) > 69 THEN
         length.n = 69 - Len(prompt.a)
         spot.n = 1
      ENDIF
      width.n = Min(74,Max(32,Max(Len(title.a)+10,length.n+Len(prompt.a)+5)))
      IF NOT IsAssigned(spot.n) THEN   ; Calculate starting spot if needed
         spot.n = Int((width.n - 3 - length.n - Len(prompt.a))/2)
      ENDIF
      IF IsBlank(picture.a) THEN       ; Set "global" Picture if none passed
         IF type.a = "D" THEN          ; Dates are tricky!
            picture.a = "{"+StrVal(Month(Today()))+",#[#]}"+"/"+
                        "{"+StrVal(Day(Today()))+",#[#]}"+"/"+
                        "{"+SubStr(StrVal(Year(Today())),3,2)+",#[#[#[#]]]}"
         ELSE
            picture.a = "*@"
         ENDIF
      ENDIF
      IF NOT IsAssigned(g.sysinfo.y) THEN
         SysInfo To g.sysinfo.y             ; Determine Screen Size
      ENDIF
      top.n = IIF(top.n = 999, Int((g.sysinfo.y["ScreenHeight"]-8)/2), top.n)
      top.n = IIF(top.n < 0 OR top.n > g.sysinfo.y["ScreenHeight"]-8, 8, top.n)
      left.n = IIF(left.n = 999 OR left.n < 0 OR
                  left.n > g.sysinfo.y["ScreenWidth"]-width.n-3,
                  Int((g.sysinfo.y["ScreenWidth"]-width.n)/2), left.n)
      IF hidden.l THEN
         accept.v = ioAcceptDialogHidden.v(top.n, left.n, title.a,
                                           prompt.a, type.a, picture.a,
                                           width.n, spot.n, "CANCEL")
      ELSE
         accept.v = ioAcceptDialogValue.v(top.n, left.n, title.a,
                                          prompt.a, type.a, picture.a,
                                          width.n, spot.n, "CANCEL")
      ENDIF
   ENDIF
   IF IsAssigned(oldcolors.y) THEN
      SetColors From oldcolors.y
   ENDIF
   Return accept.v                     ; Return entered value or FALSE
ENDPROC
; ===========================================================================
;       TITLE: ioAcceptDialogHidden.v
;     RETURNS: Value Entered, or false if Cancelled
; DESCRIPTION: Dialog Box definition to accept a Hidden Value
; ---------------------------------------------------------------------------
PROC ioAcceptDialogHidden.v(     ; Accepts value, using HIDDEN parameter
         top.n,                  ; Top Row for Box
         left.n,                 ; Left Column
         title.a,                ; Title for dBox
         prompt.a,               ; Data Input Prompt
         type.a,                 ; Type of Data Input
         picture.a,              ; Additional validity string
         width.a,                ; Width of dialog box
         spot.a,                 ; Where to begin prompt
         pbutton.a)              ; Pushbutton variable
Private  accept.v                ; Variable to capture Accept
   SHOWDIALOG title.a                  ; Begin DialogBox definition
      @ top.n,left.n Height 7 Width width.n
      @ 1,spot.n ?? prompt.a+":"
      Accept @ 1,spot.n+Len(prompt.a)+1 Width length.n type.a
         Picture picture.a
         Required
         Hidden
         Tag "ACCEPT"
      To accept.v
      PushButton @3,3 Width 10 "~O~K"
         Ok
         Default
         Value "OK"
         Tag "OK"
      To pbutton.a
      PushButton @3,width.n-15 Width 10 "~C~ancel"
         Cancel
         Value "CANCEL"
         Tag "CANCEL"
      To pbutton.a
   EndDialog                           ; Now evaluate results
   IF NOT retval OR pbutton.a = "CANCEL" THEN
      accept.v = false
   ENDIF
   Return accept.v                     ; Return entered value or FALSE
ENDPROC
; ===========================================================================
;       TITLE: ioAcceptDialogValue.v
;     RETURNS: Value Entered, or false if Cancelled
; DESCRIPTION: Generic routine for accepting data from user, with or without
;              a Picture or Default value.  Use ioAcceptHidden.v for hidden.
; ---------------------------------------------------------------------------
PROC ioAcceptDialogValue.v(      ; Accepts value from user
         top.n,                  ; Top Row for Box
         left.n,                 ; Left Column
         title.a,                ; Title for dBox
         prompt.a,               ; Data Input Prompt
         type.a,                 ; Type of Data Input
         picture.a,              ; Additional validity string
         width.a,                ; Width of dialog box
         spot.a,                 ; Where to begin prompt
         pbutton.a)              ; Pushbutton variable
Private  accept.v                ; Variable to capture Accept
   SHOWDIALOG title.a                  ; Begin DialogBox definition
      @ top.n,left.n Height 7 Width width.n
      @ 1,spot.n ?? prompt.a+":"
      Accept @ 1,spot.n+Len(prompt.a)+1 Width length.n type.a
         Picture picture.a
         ;Required
         Tag "ACCEPT"
      To accept.v
      PushButton @3,3 Width 10 "~O~K"
         Ok
         Default
         Value "OK"
         Tag "OK"
      To pbutton.a
      PushButton @3,width.n-15 Width 10 "~C~ancel"
         Cancel
         Value "CANCEL"
         Tag "CANCEL"
      To pbutton.a
   EndDialog                           ; Now evaluate results
   IF NOT retval OR pbutton.a = "CANCEL" THEN
      accept.v = false
   ENDIF
   Return accept.v                     ; Return entered value or FALSE
ENDPROC
; ===========================================================================
;       TITLE: msAlertDialog.u
;     RETURNS: No Value
; DESCRIPTION: Dialog PROC for IDLE events in Messages
; ---------------------------------------------------------------------------
PROC msAlertDialog.u(            ; Alert Siren in Idle Dialog Box
         type.a,                 ; EVENT or TRIGGER
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null
;Global  alert.n                 ; Alert Value from dBox (0 - 4)
   SWITCH
      CASE alert.n = 2  :
         Beep Sleep 50 Beep Sleep 300
      CASE alert.n = 3  :
         Sound 300 50 Sleep 100
         Sound 300 50 Sleep 100
         Sound 150 50 Sleep 100
         Sound 150 50 Sleep 100
         Sleep 200
      CASE alert.n = 4  :
         Sound 770 150
         Sound 440 150
      OTHERWISE         : Sleep 200     ; Cut down on flicker?
   ENDSWITCH
ENDPROC
; ===========================================================================
;       TITLE: msConfirm.l
;     RETURNS: Logical true/false if User Confirmed/Canceled
; DESCRIPTION: Generic Continue-or-Cancel Message routine
; ---------------------------------------------------------------------------
PROC msConfirm.l(                ; Confirmation DialogBox
         msg.a,                  ; Message to display (< 70 chars)
         att.n,                  ; Color for message (not DialogBox!)
         colors.y,               ; Dynarray of custom colors
         alert.n,                ; Sound level of Alert (0 - 4)
         pbok.a,                 ; Label of CONTINUE Pushbutton
         pbcxl.a,                ; Label of CANCEL Pushbutton
         confirm.l)              ; Should Confirm be default?
Private  width.n,                ; Width of Dialog Box
         a1, a2,                 ; Match variables
         n1, n2,                 ; Button length comparisons
         pblen.n,                ; Width of Pushbuttons
         pbutton.a,              ; Value of selected Pushbutton
         oldcolors.y,            ; Previous Color Set
         retval.l                ; Value to return
   SetCanvas DEFAULT
   IF Type(colors.y) = "DY" THEN    ; Must be a DynArray, or else ignore
      GetColors To oldcolors.y
      SetColors From colors.y
   ENDIF
   IF alert.n = 1 THEN                 ; Lowest Alert - 3 Beeps
      Beep Sleep 50 Beep Sleep 50 Beep
   ENDIF
   width.n = Max(Len(msg.a) + 4,Len(pbok.a) + Len(pbcxl.a) + 24)
   a1 = ""
   a2 = pbok.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n1 = Len(a1+a2)
   a1 = ""
   a2 = pbcxl.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n2 = Len(a1+a2)
   pblen.n = Max(n1,n2)+4
   IF confirm.l THEN                   ; Confirm button is DEFAULT
      SHOWDIALOG "Press <Enter> to Confirm"
                  PROC "msAlertDialog.u" IDLE
                  @ 7,Int((80-width.n)/2)
                  HEIGHT 7 WIDTH width.n
                  Style ATTRIBUTE att.n
                  @ 1, 1 ?? Format("w"+StrVal(width.n-4)+",ac",msg.a)
                  PUSHBUTTON  @ 3,5
                              WIDTH pblen.n pbok.a OK DEFAULT
                              VALUE "OK" TAG "OK" TO pbutton.a
                  PUSHBUTTON  @ 3,width.n-pblen.n-7
                              WIDTH pblen.n pbcxl.a CANCEL
                              VALUE "Cancel" TAG "Cancel" To pbutton.a
      ENDDIALOG
   ELSE                                ; Cancel button is DEFAULT
      SHOWDIALOG "Press <Enter> to Cancel"
                  PROC "msAlertDialog.u" IDLE
                  @ 7,Int((80-width.n)/2)
                  HEIGHT 7 WIDTH width.n
                  Style ATTRIBUTE att.n
                  @ 1, 1 ?? Format("w"+StrVal(width.n-4)+",ac",msg.a)
                  PUSHBUTTON  @ 3,5
                              WIDTH pblen.n pbcxl.a CANCEL DEFAULT
                              VALUE "Cancel" TAG "Cancel" To pbutton.a
                  PUSHBUTTON  @ 3,width.n-pblen.n-7
                              WIDTH pblen.n pbok.a OK
                              VALUE "OK" TAG "OK" TO pbutton.a
      ENDDIALOG
   ENDIF
   retval.l = retval
   IF IsAssigned(oldcolors.y) THEN
      SetColors From oldcolors.y
   ENDIF
   Return retval.l
ENDPROC
; ===========================================================================
;       TITLE: msContinue.u
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
; ---------------------------------------------------------------------------
PROC msContinue.u(               ; Generic Continue DialogBox
         msg.a,                  ; Message to display
         att.n,                  ; Color for Message (not DialogBox!)
         colors.y,               ; Dynarray of custom colors
         alert.n)                ; Sound level of Alert (0 - 4)
Private  width.n,                ; Width of Dialog Box
         pbutton.a,              ; Value of selected Pushbutton
         oldcolors.y             ; Previous Color Set
   SetCanvas DEFAULT
   IF Type(colors.y) = "DY" THEN    ; Must be a DynArray, or else ignore
      GetColors To oldcolors.y
      SetColors From colors.y
   ENDIF
   IF alert.n = 1 THEN                 ; Lowest Alert - 3 Beeps
      Beep Sleep 50 Beep Sleep 50 Beep
   ENDIF
   width.n = Max(Len(msg.a) + 4, 35)
   SHOWDIALOG "Press <Enter> to Continue"
               PROC "msAlertDialog.u" IDLE   ; Wait for Key Beeper proc
               @ 7,Int((80-width.n)/2)
               HEIGHT 7 WIDTH width.n
               Style ATTRIBUTE att.n
               @ 1, 1 ?? Format("w"+StrVal(width.n-4)+",ac",msg.a)
               PUSHBUTTON @ 3,Int(width.n/2)-7
                          WIDTH 12 "~C~ontinue" OK DEFAULT
                          VALUE "OK" TAG "OK" To pbutton.a
   ENDDIALOG
   IF IsAssigned(oldcolors.y) THEN
      SetColors From oldcolors.y
   ENDIF
   Return
ENDPROC
; ===========================================================================
;       TITLE: msWorking.u
;     RETURNS: No value
; DESCRIPTION: Generic Information Message Window.  Unfortunately, the
;              Message command is NOT center-able!!!  Note that the Message
;              command sets RETVAL.  In case you called this between some
;              action that sets RETVAL, and the point that you need RETVAL,
;              don't do this!
; ---------------------------------------------------------------------------
PROC msWorking.u(
         msg.a,                  ; Message to display (<ScreenWidth
         color.n,                ; Color for message window
         beep.n,                 ; Number of beeps
         sleep.n)                ; # of Seconds to pause
   IF Len(msg.a) = 1 THEN
      msg.a = msShortcuts.a(msg.a)
   ENDIF

   DynArray y[]
      y[3] = color.n
   SetColors From y

   IF NOT IsAssigned(g.sysinfo.y) THEN
      SysInfo To g.sysinfo.y             ; Determine Screen Size
   ENDIF

   Message  Format("W"+StrVal(g.sysinfo.y["ScreenWidth"]-10)+",ac",msg.a+"...")
   FOR n from 1 to Min(5,beep.n)
      Beep Sleep 100                   ; Beep for desired # of Beeps
   ENDFOR

   Sleep sleep.n * 1000                ; Sleep for desired # of seconds
   Return
ENDPROC                          ; msWorking.u()

; ===========================================================================
;       TITLE: msShortcuts.a
;     RETURNS: Expanded Message Value
; DESCRIPTION: Shortcuts for Generic Information Messages
; ---------------------------------------------------------------------------
PROC msShortcuts.a(              ; Shortcuts for Messages
         msg.a)                  ; Message Code
   SWITCH                                 ; shortcuts
      CASE msg.a = "C": msg.a = "Operation Canceled - Returning"
      CASE msg.a = "M": msg.a = "One Moment - Returning to MENU"
      CASE msg.a = "P": msg.a = "P R I N T I N G  -  This will take a few moments"
      CASE msg.a = "Q": msg.a = "Q U E R Y I N G  -  This will take a few moments"
      CASE msg.a = "R": msg.a = "Report NOT Printed - Returning"
      CASE msg.a = "W": msg.a = "W O R K I N G  -  One Moment"
   ENDSWITCH
   Return msg.a
ENDPROC
; ===========================================================================
;       TITLE: utWindowPark.u
;     RETURNS: No value
; DESCRIPTION: GenericWindow Parking Routine (hides windows)
; ---------------------------------------------------------------------------
PROC utWindowPark.u(w)           ; Parks indicated Window, if valid
   IF IsWindow(w) THEN                 ; Make sure it still exists
      Window MOVE w To -200,-200       ; Park it in left field
   ENDIF
ENDPROC
; ---------------------------------------------------------------------------
ShowPullDown EndMenu
Prompt ""
ioSelectOutput.u("Burlington County Fire Departments","Apparati",
         "1",
         "LPT1",
         "",
         false,
         true)

