;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure SelectObjectDialog()
;                            SelectFormOrReport()
;                            SelectFormOrReport2()
;
;Source File     : PPRPT.SC
;Author          : David Faulkner
;                  Silver Software
;                  (808) 878-2714
;
;Informant Issue : November 1992
;
;Description     : Form Report Selection
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

PROC SelectObjectDialog(Objects,Description)
Private ButtonValue,  ; True if Ok selected, False if Cancel selected
        SelectedObject; Index of Array choice user selects

ButtonValue=False
SHOWDIALOG ""
  @2,1 HEIGHT 15 WIDTH 77
  PICKARRAY @2,3 HEIGHT 8 WIDTH 69
    COLUMNS 2
    Objects
    TAG "ObjectSelectionTag"
    TO SelectedObject
  LABEL @1,1
    Description
    FOR "ObjectSelectionTag"
  PUSHBUTTON @11,15 WIDTH 6
    "Ok"
    OK
    DEFAULT
    VALUE TRUE
    TAG "OkButton"
    TO ButtonValue
  PUSHBUTTON @11,46 WIDTH 9
    "Cancel"
    CANCEL
    VALUE FALSE
    TAG "CancelButton"
    TO ButtonValue
ENDDIALOG
RETURN IIF(ButtonValue,Objects[SelectedObject],"")

ENDPROC

;*******************************************************************
PROC SelectFormOrReport(TableName,ForR)
PRIVATE ;TableName      ; Name of tables to pick form or report from
        ;ForR           ; "F" for forms, "R" for reports
        Objects,        ; Array of Form or Reports descriptions
        ObjectId,       ; R,F,1..14, if of object
        x               ; Loop counter

MENU SELECT IIF(ForR="F","Forms","Report")
{Change} SELECT TableName

ARRAY Objects[15]
FOR x FROM 1 TO 15
  ObjectId=strval(x-1)
  IF x=1 THEN
    ObjectId=ForR
  ENDIF
  IF ObjectId=MENUCHOICE() THEN
    ENTER              ; Select current object
    ObjectDescription=MENUCHOICE()
    ESC                ; Go back to object selection dialog
    DOWN               ; Go down to next object
  ELSE
    ObjectDescription="Unused "+IIF(ForR="F","Form","Report")
  ENDIF
  Objects[x]=Format("W3,AL",ObjectId)+"- "+ObjectDescription
ENDFOR
MENU                   ; Restore the Paradox Main Menu

RETURN SelectObjectDialog(Objects,"Select "+IIF(ForR="F","Form","Report"))

ENDPROC

PROC SelectFormOrReport2(TableName,ForR)
PRIVATE ;TableName     ; Name of tables to pick form or report from
        ;ForR          ; "F" for forms, "R" for reports
        PP_FRUnused_a  ; String used to describe non-existant objects

ForR=IIF(ForR="F","Form","Report")
PP_FRUnused_a="Unused "+ForR
RUN NOREFRESH NOSHELL "PPRPT "+
                       PRIVDIR()+"SAVEVARS "+
                       TableName+" "+
                       ForR+
                       " D"
PLAY "SAVEVARS"
RETURN SelectObjectDialog(PPO_LIST,"Select "+ForR)

ENDPROC








