;This file is copyright (c) 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : Procedures GetPntrStr(), JulianToReg()
;Source File     : POTPOURI.SC
;Author          : Jim Schwarz
;                  
;Informant Issue : April 1992
;
;Description     : A left/right scrollable window and a procedure to convert
;                  a Julian date to a regular Paradox date.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740



; GetPntrStr() manages the viewing and editing
; of strings longer than the display area by
; allowing the string to be scrolled horizontally;
; this implementation is written specifically for
; addition to RptCheck, PAL Tech, Jan '91 but can
; be readily adapted to any like situation
;
PROC GetPntrStr()
  PRIVATE c,Pos,First,Last,MaxLen,NextItem,
          TempStr,TempFirst,TempLast,
          TempPos,TempStrLen
  ;
  ; set maximum string length
  ;
  MaxLen   = 100
  ;
  ; NextItem is returned to the calling
  ; procedure for field depart direction
  ;
  NextItem = 0

  Last   = LEN(Set[6])
  StrLen = Last
  Pos    = Last+1
  First  = 1
  IF Last>24
    THEN First = Last-23
         Pos   = 25
  ENDIF
  ;
  ; temporary variables used to undo changes
  ;
  TempStr    = Set[6]
  TempFirst  = First
  TempLast   = Last
  TempPos    = Pos
  TempStrLen = StrLen

  CURSOR NORMAL

  WHILE NextItem=0
    ;
    ; display field length indicators; left
    ; and right arrow heads indicating text
    ; beyond that currently in view
    ;
    STYLE ATTRIBUTE 31
    @ 11,33
    IF First>1
      THEN ?? CHR(17)
      ELSE ?? " "
    ENDIF
    @ 11,59
    IF Last<StrLen
      THEN ?? CHR(16)
      ELSE ?? " "
    ENDIF
    ;
    ; highlight current field, display
    ; last 24 characters of string and
    ; leave cursor at end
    ;
    STYLE ATTRIBUTE 113
    @11,34 ?? SUBSTR(Set[6],First,24)
    CANVAS ON

    WHILE True
      @11,33+Pos
      ;
      ; get user input
      ;
      c=GETCHAR()
      SWITCH
        CASE c>31 AND c<127:                ;printable chr
          IF StrLen=MaxLen
            THEN BEEP
                 LOOP
          ENDIF
          Len1=First+Pos-2
          Len2=StrLen-Len1-1
          Set[6]=SUBSTR(Set[6],1,Len1)+
                 CHR(c)+
                 SUBSTR(Set[6],Len1+2,Len2)
          IF Pos=25
            THEN StrLen=StrLen+1
                 First=First+1
                 Last=Last+1
                 CANVAS OFF
                 QUITLOOP
            ELSE ?? CHR(c)
                 Pos=Pos+1
          ENDIF
          LOOP
        CASE c=8 AND Pos>(Last-First+1):    ;Backspace
          IF Pos>1
            THEN Pos=Pos-1
            ELSE IF First>1
                   THEN First=First-1
                   ELSE BEEP
                        LOOP
                 ENDIF
          ENDIF
          Last=Last-1
          StrLen=StrLen-1
          Set[6]=SUBSTR(Set[6],1,StrLen)
          @11,33+Pos ??" "
          LOOP
        CASE c=-83 AND Pos<=(Last-First+1): ;Del
          StrLen=StrLen-1
          Len1=First+Pos-2
          Len2=StrLen-Len1
          Set[6]=SUBSTR(Set[6],1,Len1)+
                 SUBSTR(Set[6],Len1+2,Len2)
          IF StrLen<Last
            THEN Last=StrLen
          ENDIF
          CANVAS OFF
          @11,34 ?? SPACES(24)
          QUITLOOP
        CASE c=-75:                         ;Left
          IF Pos>1
            THEN Pos=Pos-1
            ELSE IF First>1
                   THEN First=First-1
                        IF (Last-First)>23
                          THEN Last=Last-1
                        ENDIF
                        CANVAS OFF
                        QUITLOOP
                   ELSE BEEP
                 ENDIF
          ENDIF
          LOOP
        CASE c=-77:                         ;Right
          IF Pos<=(Last-First+1)
            THEN Pos=Pos+1
            ELSE IF Last<StrLen
                   THEN First=First+1
                        Last=Last+1
                        CANVAS OFF
                        @11,34 ?? SPACES(24)
                        QUITLOOP
                   ELSE BEEP
                 ENDIF
          ENDIF
          LOOP
        CASE c=-72:                         ;Up
          NextItem=5
          QUITLOOP
        CASE c=13 OR c=-80:                 ;Enter or Down
          ;
          ; cannot use Range output if
          ; in Report generator
          ;
          IF Mode="Report"
            THEN BEEP
                 LOOP
            ELSE NextItem=7
                 QUITLOOP
          ENDIF
        CASE c=27:                          ;Esc
          ;
          ; undo changes
          ;
          Set[6] = TempStr
          First  = TempFirst
          Last   = TempLast
          StrLen = TempStrLen
          Pos    = TempPos
          CANVAS OFF
          @11,34 ?? SPACES(24)
          QUITLOOP
        OTHERWISE:
          BEEP
      ENDSWITCH
    ENDWHILE
  ENDWHILE
  CANVAS OFF
  STYLE ATTRIBUTE 31
  ;
  ; display from beginning of string
  ;
  @11,33 ?? " "+FORMAT("w24",Set[6])+" "
  RETURN NextItem
ENDPROC

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; JulianToReg() accepts a five-character Julian
; date string and returns a regular date string
; (e.g. JDate="91036" returns "02/05/1991")
;
PROC JulianToReg(JDate)
  PRIVATE Reg,Leap,Days,Dy,Mo,Yr,CalcYr,MoNum

  ARRAY Reg[13]
  ARRAY Leap[13]

  Reg[1] =31
  Reg[2] =59
  Reg[3] =90
  Reg[4] =120
  Reg[5] =151
  Reg[6] =181
  Reg[7] =212
  Reg[8] =243
  Reg[9] =273
  Reg[10]=304
  Reg[11]=334
  Reg[12]=365
  Reg[13]=0

  Leap[1] =31
  Leap[2] =60
  Leap[3] =91
  Leap[4] =121
  Leap[5] =152
  Leap[6] =182
  Leap[7] =213
  Leap[8] =244
  Leap[9] =274
  Leap[10]=305
  Leap[11]=335
  Leap[12]=366
  Leap[13]=0

  MoNum = 1
  ;
  ; pad Julian date string with leading zeros
  ; for a total length of 5 characters
  ;
  JDate = "00000" + JDate
  JDate = SUBSTR(JDate,LEN(JDate)-4,5)
  ;
  ; get numeric value of year and days
  ; from the Julian date string; CalcYr
  ; is used in leap year calculation
  ;
  Days = NUMVAL(SUBSTR(JDate,3,3))
  Yr   = SUBSTR(JDate,1,2)
  IF NUMVAL(Yr) < 50
    THEN Yr = "20" + Yr
    ELSE Yr = "19" + Yr
  ENDIF
  CalcYr = NUMVAL(Yr)

  IF MOD(CalcYr,4) = 0
    THEN WHILE Days > Leap[MoNum]
           MoNum = MoNum+1
         ENDWHILE
         Mo = STRVAL(MoNum)
         IF MoNum = 1
           THEN Dy = STRVAL(Days)
           ELSE Dy = STRVAL(Days-Leap[MoNum-1])
         ENDIF
    ELSE WHILE Days > Reg[MoNum]
           MoNum = MoNum+1
         ENDWHILE
         Mo = STRVAL(MoNum)
         IF MoNum = 1
           THEN Dy = STRVAL(Days)
           ELSE Dy = STRVAL(Days-Reg[MoNum-1])
         ENDIF
  ENDIF
  ;
  ; pad month and day strings with leading zero
  ; for a total length of two characters
  ;
  Mo = "00" + Mo
  Mo = SUBSTR(Mo,LEN(Mo)-1,2)
  Dy = "00" + Dy
  Dy = SUBSTR(Dy,LEN(Dy)-1,2)

  RETURN Mo+"/"+Dy+"/"+Yr
ENDPROC
