; Contains Licensed Material Copyright (C) 1987 Ansa Software -- MJP

; Modified to display more than 1 field Jan 06/89 -- GW

; The last line of this file (commented out) will write these
; modifications to the "toolkit" library. Make sure you have a
; backup of the "toolkit.lib" file before you do this.
; Although these routines have been tested, we assume no liability etc.......

; One problem with popups is encountered when the table has a composite
; primary key. This procedure modifies SetPopUp() to enable the display
; of an arbitrary number of fields.

; USAGE:  SetPopup("Table1,Table2,Table3...","2,4,1...")


;          WARNING          WARNING          WARNING          WARNING

; THIS MODIFIES THE BASIC WAY Popup() WORKS AND IS NOT FOR THE UNINITIATED

;To facilitate displaying more than 1 field in a popup it is necessary to
;change the return value of the procedure Popup() from a string to an index
;In other words:

; ALL CODE THAT WAS WRITTEN PRIOR TO THIS MODIFICATION THAT USES Popup()
;                            WILL FAIL

;Instead of using the result of Popup() directly, use the return value to
;index the record number (MOVETO RECORD returnvalue) and then grab the
;fields of interest with COPYTOARRAY, etc.
;A value of 0 indicates failure, as 0 is never a valid record number

; DON'T FORGET TO CHANGE THE 3 "Return" LINES IN Popup() FROM
; STRINGS TO INDICES

; Also, it is suggested below that SetPopup() be called at the beginning
; of the program. This will use a lot of memory if a large number of fields
; and records are viewed, so a better way might be to call SetPopup() just
; before a dataentry procedure and release the arrays after a successful
; dataentry session. Of course this means scanning tables at the beginning
; of the dataentry session, thereby implying we take a hit in performance.

; NO RANGE CHECKING IS DONE ON THE NUMBER OF FIELDS DISPLAYED.
; SetPopup("Table", "17") will linewrap unless the fields are very short and
; will keep repeating the last record if "Table" doesn't have 17 fields.

;                    END OF MODIFICATION DOCUMENTATION



; This procedure creates and fills the arrays POPUPLIST, POPUPSTART, POPUPLEN,
; and POPUPNUMBER, with information from (and about) the specified tables.
; These arrays are then used by the procedure Popup to cause a popup menu to
; be created.  The procedure also reads in the Popup procedures themselves.
;
; This procedure must be called once before the Popup procedure is invoked
; (generally at the beginning of the main program) while sysmode()="Main".  It
; is called by executing the command:  SetPopup(Tables), where Tables is a
; string in the form:
;                      Table1, Table2, ... , TableN   (N<=10)
;
; The information in each of the tables specified by "Tables" will be used to
; define a seperate pop-up menu.  NOTE:  If the information in the tables is
; static (not subject to change), then the need to call this procedure at run-
; time may be eliminated.  To do this, simply call this procedure once, and
; follow the procedure call with the command:  SAVEVARS POPUPLIST,POPUPSTART,
; POPUPLEN,POPUPNUMBER.  Then simply read in the values of these arrays into
; your program.  Last, remember to read in the procedures Popup, PopDraw, and
; PopRedraw from the toolkit library.
;
Proc SetPopup(Tables, Fieldsizes)
   Private;Tables,            ;List of tables for which to define popup menus
          ;Fieldsizes         ;List of number of fields to display for each
           TempName,          ;Array which stores the names of each table
           TempFieldsize,     ;Array which stores # of fields for each table
           NumMenus,          ;Number of tables specified in "Tables" parameter
           NumFieldsizes,     ;Just to check and make sure it matches NumMenus
           NumItems,          ;Number of items in current table
           CurrTable,         ;Current table being looked at
           CurrFieldsize,     ;Current fieldsize spec
           X,                 ;Loop index
           Y,                 ;Loop index
           PopupLenTemp       ;Stores incremental field addition to PopupLen[]
   Array TempName[10]         ;Table Names
   Array TempFieldsize[10]    ;Number of fields to display for each popup
   Array PopupStart[10]       ;Stores pointer to beginning of item list
   Array PopupNumber[10]      ;Stores number of items in menu list
   Array PopupLen[10]         ;Stores length of longest menu choice
   NumMenus=0
   NumItems=0
   Tables=Tables+","
   While match(Tables,"..,..",CurrTable,Tables)    ;Process each table name
      If not istable(CurrTable)
         Then Quit "Table "+CurrTable+" does not exist."
      Endif
      NumMenus=NumMenus+1                          ;Update which menu this is
      TempName[NumMenus]=CurrTable
      PopupStart[NumMenus]=NumItems                ;NumItems is a running total
      NumItems=NumItems+nrecords(CurrTable)
   Endwhile
   NumFieldsizes=0                       ;Repeat the above for fieldsizes
   Fieldsizes=Fieldsizes+","
   While match(Fieldsizes,"..,..",CurrFieldsize,Fieldsizes)
      NumFieldsizes=NumFieldsizes+1
      TempFieldsize[NumFieldsizes]=numval(CurrFieldsize) ;parse string to num
   Endwhile
   If NumMenus <> NumFieldsizes
      Then Quit "Number of Tables Does Not Equal Number Of Fieldsizes"
   Endif
   If NumItems<>0
      Then Array PopupList[NumItems]  ;Stores all line items from data tables
   Endif
   For X from 1 to NumMenus
      If isempty(TempName[X])
         Then PopupNumber[X]=0
         Else View TempName[X]
              Right
              PopupLen[X]=0
              PopupNumber[X]=0
              Scan
                 PopupNumber[X]=PopupNumber[X]+1
                 PopupLen[X]=max(PopupLen[X],len([])+4)      ;Update max width
                 PopupList[PopupNumber[X]+PopupStart[X]]=[]
              Endscan
              FOR Y from 1 to (TempFieldsize[X] - 1) ; -1 Because Y from 1 to 1
                 Right                               ;loops once, unlike 'C'
                 PopupLenTemp=0                      ;and some other languages
                 PopupNumber[X]=0
                 Scan
                    PopupNumber[X]=PopupNumber[X]+1
                    PopupLenTemp=max(PopupLenTemp, len([]) )
                    PopupList[PopupNumber[X]+PopupStart[X]]=
                         PopupList[PopupNumber[X]+PopupStart[X]] +
                            spaces(PopupLen[X] - (len(PopupList[PopupNumber[X]
                                                       + PopupStart[X] ]) + 4) )
                                                                     + " " + []
                 Endscan
                 PopupLen[X]=PopupLen[X]+PopupLenTemp + 1
              Endfor
              PopupLen[X]=max(PopupLen[X], 10)
              ClearImage
      Endif
   Endfor
   If not isassigned(TKLibName)
      Then TKLibName=sdir()+"Toolkit"
   Endif
   If isfile(TKLibName+".LIB")
      Then Readlib TKLibName Popup,PopDraw,PopRedraw
      Else Message "Library "+TKLibName+" does not exist."
           Debug
   Endif
Endproc

; This procedure creates a pop-up window.  It is intended to be used during
; data entry (or edit), but can be used in virtually any mode.
;
; Within the popup window are menu choices which can be selected by moving the
; cursor using Up, Down, PgUp, PgDn, Home, and End.  The information for the
; procedure is contained in four array variables (PopupList, PopupStart,
; PopupLen, and PopupNumber) which are set by the SetPopup procedure.
;
; Popup takes the following arguments:
;   R--   Row position of the upper left corner where menu is to be drawn.
;   C--   Column position of the upper left corner where menu is to be drawn.
;   Num-- Number of pop-up menu.  This corresponds to the position of the
;         table name in the arguement passed to the SetPopup procedure.  (For
;         example, if we say:  SetPopup("x,y,z"), then to create a menu
;         with information from the table "y" we say:  Popup(R,C,2,Size).)
;   Size- Vertical size of the menu.  This is the number of selections that
;         will be displayed at one time.  Choices will scroll up and down to
;         reveal other choices.  It is recommended that 8088-class computers
;         only provide menus with as many choices as will fit on the screen,
;         and set Size equal to 9999 to disable scrolling.
;
Proc Popup(R,C,Num,Size)
   Private;R,       ;Row position of popup window
          ;C,       ;Column position of popup window
          ;Num,     ;Popup menu number
          ;Size,    ;Number of choices to be displayed at one time
           Char,    ;Last key that was pressed
           MenuPos, ;Current position within menu
           Choice,  ;Current menu selection
           X        ;Counter
   If PopupNumber[Num]=0
      Then Return 0          ;CHANGED TO SUPPORT DISPLAY OF MORE THAN 1 FIELD
   Endif
   If Size>PopupNumber[Num]
      Then Size=PopupNumber[Num]
   Endif
   Echo Off
   Cursor Off
   @0,0
   ?? "Highlight the appropriate selection using the cursor movement keys."
   Clear Eol
   ? "Press [Enter] to accept, [Esc] to cancel menu selection."
   Clear Eol
   ;Draw menu box
   @R,C
   ?? "",fill("",PopupLen[Num]-2),""
   @R+1,C
   ?? " CHOOSE:",spaces(PopupLen[Num]-10),""
   @R+2,C
   ?? "",fill("",PopupLen[Num]-2),""
   For X from 1 to Size
      @R+2+X,C
      ?? " ",substr(strval(PopupList[PopupStart[Num]+X])+
              spaces(PopupLen[Num]),1,PopupLen[Num]-3),""
   Endfor
   @R+3+Size,C
   ?? "",fill("",PopupLen[Num]-2),""
   If Size<>PopupNumber[Num]      ;Is there more data that can't be displayed?
      Then @R+2+Size,C+1
           ?? ""                 ;Show that more items exist below
   Endif
   MenuPos=1
   Choice=1
   While True
      Style Reverse               ;Highlight current selection
      PopDraw()
      Style
      Char=getchar()
      Switch
         Case Char=-72:                          ;Key was [Up]
            If Choice=1                          ;Are we already at the top?
               Then Beep
               Else If MenuPos>1                 ;Can we move within the menu?
                       Then PopDraw()            ; Yes- Blank current selection
                            MenuPos=MenuPos-1    ;      Move window position
                       Else PopRedraw(Choice-2)  ; No-  Redraw entire menu
                    Endif
                    Choice=Choice-1              ;Select new choice
            Endif
         Case Char=-80:                          ;Key was [Down]
            If Choice=PopupNumber[Num]           ;Are we already at the bottom?
               Then Beep
               Else If MenuPos<Size              ;Can we move within the menu?
                       Then PopDraw()            ; Yes- Blank current selection
                            MenuPos=MenuPos+1    ;      Move window position
                       Else PopRedraw(Choice-Size+1); No-  Redraw entire menu
                    Endif
                    Choice=Choice+1              ;Select new choice
            Endif
         Case Char=-71:                          ;Key was [Home]
            If MenuPos=Choice                    ;Is first selection on screen?
               Then PopDraw()                    ; Yes- Blank current selection
               Else PopRedraw(0)                 ; No-  Redraw menu from start
            Endif
            MenuPos=1                            ;Position at first item
            Choice=1                             ;Select first item
         Case Char=-79:                          ;Key was [End]
            If Choice+Size-MenuPos=PopupNumber[Num];Is last selection on screen?
               Then PopDraw()                    ; Yes- Blank current selection
               Else PopRedraw(PopupNumber[Num]-Size); No-  Redraw end of menu
            Endif
            MenuPos=Size                         ;Position at bottom of menu
            Choice=PopupNumber[Num]              ;Select last item
         Case Char=-73:                          ;Key was [PgUp]
            If MenuPos=Choice                    ;Are we within first screen?
               Then Beep                         ; Yes- Disallow PgUp
               Else If Choice-MenuPos-Size>0
                       Then Choice=Choice-MenuPos-Size+1
                       Else Choice=1
                    Endif
                    PopRedraw(Choice-1)          ; No-  Redraw previous page
                    MenuPos=1                    ;   Position on that item
            Endif
         Case Char=-81:                          ;Key was [PgDn]
            If Choice+Size-MenuPos=PopupNumber[Num];Are we within last screen?
               Then Beep                           ; Yes- Disallow PgDn
               Else If PopupNumber[Num]-Size<Choice+Size-MenuPos
                       Then Choice=PopupNumber[Num]-Size+1
                       Else Choice=Choice+Size-MenuPos+1
                    Endif
                    PopRedraw(Choice-1)            ; No- Redraw next page
                    MenuPos=1                      ;     Position on that item
            Endif
         Case Char=13:                             ;Key was [Enter]
            Cursor Normal
            Return Choice       ;CHANGED!!! RETURNS INDEX TO SELECTION
         Case Char=27:                             ;Key was [Esc]
            Cursor Normal
            Return 0            ;CHANGED TO SUPPORT DISPLAY OF MORE THAN 1 FIELD
         Otherwise:                                ;Illegal key
            Beep
      Endswitch
   Endwhile
Endproc

; This procedure is used by the Popup procedure.  It positions the cursor and
; redraws current menu item (in either inverse or normal text).
;
Proc PopDraw()
   @MenuPos+R+2,C+2
   ?? PopupList[PopupStart[Num]+Choice]
Endproc

; This procedure is used by the PopUp procedure.  It redraws the entire
; contents of the popup window.
;
Proc PopRedraw(Start)
;Private Start           ;Location within PopupList to begin redraw
   For Z from 1 to Size            ;Redraw all information in the menu box
      @R+Z+2,C+2
      ?? substr(strval(PopupList[PopupStart[Num]+Start+Z])+
         spaces(PopupLen[Num]),1,PopupLen[Num]-3)
   Endfor
   @R+3,C+1
   If Start=0          ;Are there records above?
      Then ?? " "      ; No- Remove up arrow
      Else ?? ""      ; Yes- Place up arrow to signify more records
   Endif
   @R+Size+2,C+1
   If Start+Size=PopupNumber[Num]  ;Are there records below?
      Then ?? " "                  ; No- Remove down arrow
      Else ?? ""                  ; Yes- Place down arrow to signify more
   Endif
Endproc

;WriteLib "toolkit" SetPopup, Popup, PopDraw, PopRedraw
