; This is a modification made from the POPUP.SC script supplied with PARADOX.
; What it lets you do is define a lookup table that looks like this:
;
;     Field Key          A3
;     Field Description  A30
;
; If you set TKPopup2 = True the Field Description will displayed in the
; Popup window, but Field Key will be returned to the caller. This lets
; you store the smaller field key but display the longer Field Description
; for the user to select. If you want to use this script the same way that
; Ansa released it, just TKPopup2 = False.

; This script is supplied "as is".

; Contains Licensed Material Copyright (C) 1987 Ansa Software -- MJP

; This procedure creates and fills the arrays POPUPLIST, POPUPSTART, POPUPLEN,
; and POPUPNUMBER, with information from (and about) the specified tables.
; These arrays are then used by the procedure Popup to cause a popup menu to
; be created.  The procedure also reads in the Popup procedures themselves.
;
; This procedure must be called once before the Popup procedure is invoked
; (generally at the beginning of the main program) while sysmode()="Main".  It
; is called by executing the command:  SetPopup(Tables), where Tables is a
; string in the form:
;                      Table1, Table2, ... , TableN   (N<=10)
;
; The information in each of the tables specified by "Tables" will be used to
; define a seperate pop-up menu.  NOTE:  If the information in the tables is
; static (not subject to change), then the need to call this procedure at run-
; time may be eliminated.  To do this, simply call this procedure once, and
; follow the procedure call with the command:  SAVEVARS POPUPLIST,POPUPSTART,
; POPUPLEN,POPUPNUMBER.  Then simply read in the values of these arrays into
; your program.  Last, remember to read in the procedures Popup, PopDraw, and
; PopRedraw from the toolkit library.
;
Proc SetPopup(Tables)
   Private;Tables,            ;List of tables for which to define popup menus
           TempName,          ;Array which stores the names of each table
           NumMenus,          ;Number of tables specified in "Tables" parameter
           NumItems,          ;Number of items in current table
           CurrTable,         ;Current table being looked at
           X                  ;Loop index
   Array TempName[10]
   Array PopupStart[10]       ;Stores pointer to beginning of item list
   Array PopupNumber[10]      ;Stores number of items in menu list
   Array PopupLen[10]         ;Stores length of longest menu choice
   Array PopupLen2[10]        ;Stores length of longest 2nd menu choice
   NumMenus=0
   NumItems=0
   Tables=Tables+","
   While match(Tables,"..,..",CurrTable,Tables)    ;Process each table name
      If not istable(CurrTable)
         Then Quit "Table "+CurrTable+" does not exist."
      Endif
      NumMenus=NumMenus+1                          ;Update which menu this is
      TempName[NumMenus]=CurrTable
      PopupStart[NumMenus]=NumItems                ;NumItems is a running total
      NumItems=NumItems+nrecords(CurrTable)
   Endwhile
   If NumItems<>0
      Then Array PopupList[NumItems]  ;Stores all line items from data tables
           Array PopupList2[NumItems]  ;Stores all line items from data tables
   Endif
   For X from 1 to NumMenus
      If isempty(TempName[X])
         Then PopupNumber[X]=0
         Else View TempName[X]
              Right
              PopupNumber[X]=0
              PopupLen[X]=0
              PopupLen2[X]=0
              Scan
                 PopupLen[X]=max(PopupLen[X],len([])+4)      ;Update max width
                 PopupNumber[X]=PopupNumber[X]+1
                 PopupList[PopupNumber[X]+PopupStart[X]]=[]  ;Store line item
                 Right
                 PopupList2[PopupNumber[X]+PopupStart[X]]=[]  ;Store line item
                 PopupLen2[X]=max(PopupLen2[X],len([])+4)    ;Update max width
                 Left
              Endscan
              PopupLen[X]=max(PopupLen[X],10)
              PopupLen2[X]=max(PopupLen2[X],10)
              ClearImage
      Endif
   Endfor
   If not isassigned(TKLibName)
      Then TKLibName=sdir()+"Toolkit"
   Endif
   If isfile(TKLibName+".LIB")
      Then Readlib TKLibName Popup,PopDraw,PopRedraw
      Else Message "Library "+TKLibName+" does not exist."
           Debug
   Endif
Endproc

; This procedure creates a pop-up window.  It is intended to be used during
; data entry (or edit), but can be used in virtually any mode.
;
; Within the popup window are menu choices which can be selected by moving the
; cursor using Up, Down, PgUp, PgDn, Home, and End.  The information for the
; procedure is contained in four array variables (PopupList, PopupStart,
; PopupLen, and PopupNumber) which are set by the SetPopup procedure.
;
; Popup takes the following arguments:
;   R--   Row position of the upper left corner where menu is to be drawn.
;   C--   Column position of the upper left corner where menu is to be drawn.
;   Num-- Number of pop-up menu.  This corresponds to the position of the
;         table name in the arguement passed to the SetPopup procedure.  (For
;         example, if we say:  SetPopup("x,y,z"), then to create a menu
;         with information from the table "y" we say:  Popup(R,C,2,Size).)
;   Size- Vertical size of the menu.  This is the number of selections that
;         will be displayed at one time.  Choices will scroll up and down to
;         reveal other choices.  It is recommended that 8088-class computers
;         only provide menus with as many choices as will fit on the screen,
;         and set Size equal to 9999 to disable scrolling.
;
Proc Popup(R,C,Num,Size)
   Private;R,       ;Row position of popup window
          ;C,       ;Column position of popup window
          ;Num,     ;Popup menu number
          ;Size,    ;Number of choices to be displayed at one time
           Char,    ;Last key that was pressed
           MenuPos, ;Current position within menu
           Choice,  ;Current menu selection
           X        ;Counter
   If PopupNumber[Num]=0
      Then Return ""
   Endif
   If Size>PopupNumber[Num]
      Then Size=PopupNumber[Num]
   Endif
   Echo Off
   Cursor Off
   @0,0
   ?? "Highlight the appropriate selection using the cursor movement keys."
   Clear Eol
   ? "Press [Enter] to accept, [Esc] to cancel menu selection."
   Clear Eol
   ;Draw menu box
   @R,C
   If TKPopUp2 Then
       ?? "",fill("",PopupLen2[Num]-2),""
       @R+1,C
       ?? " CHOOSE:",spaces(PopupLen2[Num]-10),""
       @R+2,C
       ?? "",fill("",PopupLen2[Num]-2),""
   Else
       ?? "",fill("",PopupLen[Num]-2),""
       @R+1,C
       ?? " CHOOSE:",spaces(PopupLen[Num]-10),""
       @R+2,C
       ?? "",fill("",PopupLen[Num]-2),""
   EndIf
   For X from 1 to Size
      @R+2+X,C
      If TKPopup2 Then
         ?? " ",substr(strval(PopupList2[PopupStart[Num]+X])+
                 spaces(PopupLen2[Num]),1,PopupLen2[Num]-3),""
      Else
         ?? " ",substr(strval(PopupList[PopupStart[Num]+X])+
                 spaces(PopupLen[Num]),1,PopupLen[Num]-3),""
      EndIf
   Endfor
   @R+3+Size,C
   If TKPopUp2 then
       ?? "",fill("",PopupLen2[Num]-2),""
   Else
       ?? "",fill("",PopupLen[Num]-2),""
   EndIf
   If Size<>PopupNumber[Num]      ;Is there more data that can't be displayed?
      Then @R+2+Size,C+1
           ?? ""                 ;Show that more items exist below
   Endif
   MenuPos=1
   Choice=1
   While True
      Style Reverse               ;Highlight current selection
      PopDraw()
      Style
      Char=getchar()
      Switch
         Case Char=-72:                          ;Key was [Up]
            If Choice=1                          ;Are we already at the top?
               Then Beep
               Else If MenuPos>1                 ;Can we move within the menu?
                       Then PopDraw()            ; Yes- Blank current selection
                            MenuPos=MenuPos-1    ;      Move window position
                       Else PopRedraw(Choice-2)  ; No-  Redraw entire menu
                    Endif
                    Choice=Choice-1              ;Select new choice
            Endif
         Case Char=-80:                          ;Key was [Down]
            If Choice=PopupNumber[Num]           ;Are we already at the bottom?
               Then Beep
               Else If MenuPos<Size              ;Can we move within the menu?
                       Then PopDraw()            ; Yes- Blank current selection
                            MenuPos=MenuPos+1    ;      Move window position
                       Else PopRedraw(Choice-Size+1); No-  Redraw entire menu
                    Endif
                    Choice=Choice+1              ;Select new choice
            Endif
         Case Char=-71:                          ;Key was [Home]
            If MenuPos=Choice                    ;Is first selection on screen?
               Then PopDraw()                    ; Yes- Blank current selection
               Else PopRedraw(0)                 ; No-  Redraw menu from start
            Endif
            MenuPos=1                            ;Position at first item
            Choice=1                             ;Select first item
         Case Char=-79:                          ;Key was [End]
            If Choice+Size-MenuPos=PopupNumber[Num];Is last selection on screen?
               Then PopDraw()                    ; Yes- Blank current selection
               Else PopRedraw(PopupNumber[Num]-Size); No-  Redraw end of menu
            Endif
            MenuPos=Size                         ;Position at bottom of menu
            Choice=PopupNumber[Num]              ;Select last item
         Case Char=-73:                          ;Key was [PgUp]
            If MenuPos=Choice                    ;Are we within first screen?
               Then Beep                         ; Yes- Disallow PgUp
               Else If Choice-MenuPos-Size>0
                       Then Choice=Choice-MenuPos-Size+1
                       Else Choice=1
                    Endif
                    PopRedraw(Choice-1)          ; No-  Redraw previous page
                    MenuPos=1                    ;   Position on that item
            Endif
         Case Char=-81:                          ;Key was [PgDn]
            If Choice+Size-MenuPos=PopupNumber[Num];Are we within last screen?
               Then Beep                           ; Yes- Disallow PgDn
               Else If PopupNumber[Num]-Size<Choice+Size-MenuPos
                       Then Choice=PopupNumber[Num]-Size+1
                       Else Choice=Choice+Size-MenuPos+1
                    Endif
                    PopRedraw(Choice-1)            ; No- Redraw next page
                    MenuPos=1                      ;     Position on that item
            Endif
         Case Char=13:                             ;Key was [Enter]
            Cursor Normal
            TKPopup2 = False
            Return PopupList[PopupStart[Num]+Choice]       ;Return selection
         Case Char=27:                             ;Key was [Esc]
            Cursor Normal
            Return ""
         Otherwise:                                ;Illegal key
            Beep
      Endswitch
   Endwhile
Endproc

; This procedure is used by the Popup procedure.  It positions the cursor and
; redraws current menu item (in either inverse or normal text).
;
Proc PopDraw()
   @MenuPos+R+2,C+2
   If TKPopUp2 then
       ?? PopupList2[PopupStart[Num]+Choice]
   Else
       ?? PopupList[PopupStart[Num]+Choice]
   EndIf
Endproc

; This procedure is used by the PopUp procedure.  It redraws the entire
; contents of the popup window.
;
Proc PopRedraw(Start)
;Private Start           ;Location within PopupList to begin redraw
   For Z from 1 to Size            ;Redraw all information in the menu box
      @R+Z+2,C+2
      If TKPopUp2 then
         ?? substr(strval(PopupList2[PopupStart[Num]+Start+Z])+
            spaces(PopupLen2[Num]),1,PopupLen2[Num]-3)
      Else
         ?? substr(strval(PopupList[PopupStart[Num]+Start+Z])+
            spaces(PopupLen[Num]),1,PopupLen[Num]-3)
      EndIf
   Endfor
   @R+3,C+1
   If Start=0          ;Are there records above?
      Then ?? " "      ; No- Remove up arrow
      Else ?? ""      ; Yes- Place up arrow to signify more records
   Endif
   @R+Size+2,C+1
   If Start+Size=PopupNumber[Num]  ;Are there records below?
      Then ?? " "                  ; No- Remove down arrow
      Else ?? ""                  ; Yes- Place down arrow to signify more
   Endif
Endproc
