CREATELIB "Yourapp"           ; Get, check, enter IDs for data entry

PROC Mement()
   
   PRIVATE keyhold,           ; Hold entry for ID in LOCATE                                                  
           keyarray,          ; Array to hold record during LOCATE                                           
           L,                 ; Holds field assignment for states
           procname           ; Helps preclude inhibition of proc swapping 
   procname="Mement"          ; Holds procedure name for errorproc                                                                                                                          
                                                                                                           
   CLEAR                                                                                                   
   COEDIT "Members"                                                                                        
   END                                                                                                     
   DOWN                                                                                                    
   INS                        ; in case of networking                                                                             
   PICKFORM "F"                                                                                            
                                                                                                           
   WHILE true                                                                                              
       WAIT FIELD                                                                                          
       PROMPT "<Enter>; Arrow Keys; End=Another; F2=Finish; F9=Popup at *"                                 
       UNTIL "ENTER","PGDN","PGUP","F2","END","F9"                                                         
                              ;This is only a sample of keys to control.                                                   
         SWITCH                                                                                            
                                                                                                           
           CASE retval="ENTER" AND FIELD()="ID":                                                           
           COPYTOARRAY keyarray                                                                            
           keyhold=[]                                                                                      
           DEL                                                                                             
           LOCATE keyhold                                                                                  
               IF retval=FALSE
                 THEN END DOWN INS                                                                              
                      COPYFROMARRAY keyarray                                                                    
               ENDIF                                                                                       
           MOVETO [Title]                                                                                  
           LOOP                                                                                            
                                                                                                           
           CASE retval="ENTER" AND FIELD()<>"ID":                                                         
           ENTER                                                                                           
           LOOP                                                                                            
                                                                                                           
           CASE retval="F9" AND FIELD()="State":                                                           
           L=Statecode([])                                                                                 
           []=L                                                                                            
           LOOP                                                                                            
                                                                                                           
           CASE retval="F2":                                                                               
           Do_It!                  ; NOTE: Check here for required fields
           CLEAR                                                                                           
           CLEARALL                                                                                        
           RESET                                                                                           
           QUITLOOP                                                                                        
                                                                                                           
   ; Put in any other conditions/tests.                                                                     
                                                                                                           
           CASE retval="F9" AND FIELD()="Membership Type":                                                      
           Popup([])                                                                                            
           UPIMAGE                      ; Return from pop up procedure & go to
                                        ;  the "Members"section on the form   
           PGUP                         ; Go to the first page of the form    
           MOVETO [Membership Type]     ; Go to field procedure was called from
           []=retval                                                                                            
           LOOP                                                                                                 
                                                                                                           
           CASE retval="END":                                                                                   
           END                                                                                                  
           FORMKEY                                                                                              
           DOWN                                                                                                 
           INS                                                                                                  
           FORMKEY                                                                                              
           LOOP                         ; NOTE: check here for required fields

           OTHERWISE:                                                                                              
           BEEP                                                                                                    
           LOOP                                                                                                    

         ENDSWITCH                                                                                               
                                                                                                           
   ENDWHILE                                                                                                

ENDPROC

WRITELIB "Yourapp" Mement
RELEASE PROCS Mement

PROC Popup(typeval)

   PRIVATE procname                                                                          
   procname="Popup"                                                                          
                                                                                             
   PGDN                                                                                      
   DOWNIMAGE ;move to embedded table                                                         
                                                                                             
   WHILE TRUE                                                                                
   WAIT TABLE                                                                                
      PROMPT "Move to the CODE field and press <Enter> to " + 
             "choose or ESCAPE for no choice."   
      UNTIL "INS","Enter","DOS","DOSBIG","ZOOM","ESC","F2","F8",
            "F9","F10","F3","F4","PGUP","N","F35","FIELDVIEW","DEL",
            "LEFT","RIGHT"         ; This is only a sample of keys to control

   SWITCH                                                                                    

      CASE retval="Enter":                                                                   
      typeval=[Type Code]                                                                    
      QUITLOOP                                                                               
                                                                                             
      CASE retval="UP":                                                                      
      UP                                                                                     
      LOOP                                                                                   
                                                                                             
      CASE retval="DOWN":                                                                    
      DOWN                                                                                   
      LOOP                                                                                   
                                                                                             
      CASE retval="ESC":                                                                     
      QUITLOOP                          ; don't reset typeval                                                         
                                                                                             
      OTHERWISE:                                                                                
      BEEP                                                                                      
      LOOP                                                                                      
   
   ENDSWITCH                                                                                 
   
   ENDWHILE                                                                                  
                                                                                             
   RETURN typeval                                                                            

ENDPROC

WRITELIB "Yourapp" Popup
RELEASE PROCS Popup

PROC Statecode(curval)

   PRIVATE choice,                         ; Takes ACCEPT assignment                         
           picstate,                       ; Picture statement                               
           procname                                                                          
   procname="Statecode"                                                                      
                                                                                             
   STYLE REVERSE                                                                             
   @3,1   ?? " ͻ " 
   @4,1   ?? "                       UNITED STATES POSTAL CODES                          " 
   @5,1   ?? " Ķ " 
   @6,1   ?? "   AK ALAKSA         IL ILLINOIS       MT MONTANA        PR PUERTO RICO    " 
   @7,1   ?? "   AL ALABAMA        IN INDIANA        NC N. CAROLINA    RI RHODE ISLAND   " 
   @8,1   ?? "   AS ARKANSAS       IO IOWA           ND N. DAKOTA      SC S. CAROLINA    " 
   @9,1   ?? "   AZ ARIZONA        KS KANSAS         NE NEBRASKA       SD S. DAKOTA      " 
   @10,1  ?? "   CA CALIFORNIA     KY KENTUCKY       NH NEW HAMPSHIRE  TN TENNESSEE      " 
   @11,1  ?? "   CO COLORADO       LA LOUISIANA      NJ NEW JERSEY     TX TEXAS          " 
   @12,1  ?? "   CT CONNECTICUT    MA MASSACHUSETTS  NM NEW MEXICO     UT UTAH           " 
   @13,1  ?? "   DC DIST COLUMBIA  MD MARYLAND       NV NEVADA         VA VIRGINIA       " 
   @14,1  ?? "   DE DELAWARE       ME MAINE          NY NEW YORK       VT VERMONT        " 
   @15,1  ?? "   FL FLORIDA        MI MICHIGAN       OH OHIO           WA WASHINGTON     " 
   @16,1  ?? "   GA GEORGIA        MN MINNESOTA      OK OKLAHOMA       WI WISCONSIN      " 
   @17,1  ?? "   HA HAWAII         MO MISSOURI       OR OREGON         WV W. VIRGINIA    " 
   @18,1  ?? "   ID IDAHO          MS MISSISSIPPI    PA PENNSYLVLANIA  WY WYOMING        " 
   @19,1  ?? " ͼ " 
   @20,1  ?? " [Esc to exit]                Enter Choice =>                                " 
   @20,46                                                                                    
                                                                                             
   ; Set up an internal picture for the states to prevent false entries                      
                                                                                             
   picstate = "A[K,L,S,Z],C[A,O,T],D[C,E],F[L],G[A],H[A],I[D,L,N,O],K[S,Y],"                 
   picstate = PicState + "L[A],M[A,D,E,I,N,O,S,T],N[C,D,E,H,J,M,V,Y],O[H,K,R],"              
   PicState = PicState + "P[A,R],R[I],S[C,D],T[N,X],U[T],V[A,T],W[A,I,V,Y]"                  
                                                                                             
   ACCEPT "A2" PICTURE picstate TO choice                                                    
                                                                                             
   IF NOT retval       ; If retval is blank set choice to initial field value.               
     THEN choice = curval                                                                    
     ELSE choice = UPPER(choice)                                                             
   ENDIF                                                                                     
                                                                                             
   STYLE                                                                                     
                                                                                             
   RETURN choice                                                                             

ENDPROC

WRITELIB "Yourapp" Statecode
RELEASE PROCS Statecode

RELEASE PROCS ALL
RELEASE VARS  ALL

RETURN
