;ͻ
;                                                                          
;  POPUP CALCULATOR - SORTA OOpy                                           
;                                                                          
;  SOURCE FILE: POPCALC.ZIP                                                
;                                                                          
;   AUTHOR: Rich Frediani                                                  
;  ADDRESS: Legasys Legal Systems                                          
;           10960 Wilshire Blvd                                            
;           Suite 1238                                                     
;           Los Angeles, CA 90024                                          
;                                                                          
;    PHONE: (310) 444-9990                                                 
;      FAX: (310) 473-3205                                                 
;                                                                          
;                                                                          
;ͼ

LibName   = "POPCALC"
CreateLib LibName

; **************************************************************************
;
; TKTCALCULATOR - popup calculator
;
; **************************************************************************

Proc tktCalculator()

Private Win_Obj,      ; Dynarray of Calculator Window Handles and actions
        Key_Obj,      ; Dynarray of valid keystrokes
        Calc_WH,      ; Popup Calculator window Handle
        Calc_Val,     ; Calculator value
        Tot_Val,      ; Running total
        Math,         ; + - * / ; what kind of math are we doing
        Show_Tot,     ; Logical showing total after math operation
        Event_Array,  ; Dynarray event holder
        Obj_WH,       ; Button window handle
        Memory        ; Number in calculator memory

DynArray Win_Obj[]
DynArray Key_Obj[]
Calc_Val = "0"
Tot_Val  = 0
Math     = ""
Show_Tot = FALSE
Memory   = blanknum()

tktPaintCalculator()
tktSayNumberCalc(Calc_Val)

while true

   getevent MOUSE "DOWN"
            KEY "ALL"
            to Event_Array

   if Event_Array["TYPE"] = "KEY" then

      if isassigned(Key_Obj[Event_Array["KEYCODE"]]) then
         Obj_WH = Key_Obj[Event_Array["KEYCODE"]]
      else
         beep
         Obj_WH = -1
      endif

   else

      Obj_WH = windowat(Event_Array["ROW"],Event_Array["COL"])

   endif

   if isassigned(Win_Obj[Obj_WH]) then

      if not isblank(Win_Obj[Obj_WH]) then

         tktHighlightCalc(Obj_WH)

         switch
            case Win_Obj[Obj_WH] = "DoIt!" :

               tktCleanCalculator()
               return(numval(Calc_Val))

            case Win_Obj[Obj_WH] = "Esc"   :

               tktCleanCalculator()
               return("Esc")

            otherwise : execproc Win_Obj[Obj_WH]
         endswitch

         tktSayNumberCalc(Calc_Val)

      endif

   endif

endwhile

endproc

writelib LibName tktCalculator
release procs tktCalculator


; **************************************************************************
;
; TKTPAINTCALCULATOR - creates all of the windows for the calculator
;
; **************************************************************************

Proc tktPaintCalculator()

;Global Calc_WH      ; Calculator Window Handle

tktObjCreateCalc("CANCLOSE->FALSE,"        +     ; Calculator Window
                 "CANMAXIMIZE->FALSE,"     +
                 "CANRESIZE->FALSE,"       +
                 "CANMOVE->TRUE,"          +
                 "CANVASHEIGHT->8,"        +
                 "CANVASWIDTH->22,"        +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->10,"             +
                 "WIDTH->24,"              +
                 "TITLE->Calculator,"      +
                 "ORIGINROW->4,"           +
                 "ORIGINCOL->40",
                 "","","")
Calc_WH = GetWindow()
@1,0 ?? Fill("",22)
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Clear Window
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->9,"               +
                 "ORIGINROW->7,"           +
                 "ORIGINCOL->42",
                 "CLEAR SPC",32,"tktClsCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Return Value
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->7,"               +
                 "ORIGINROW->8,"           +
                 "ORIGINCOL->42",
                 "SAVE F2",-60,"DoIt!")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Memory Save
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->5,"               +
                 "ORIGINROW->9,"           +
                 "ORIGINCOL->42",
                 "M+ F5",-63,"tktSaveMemCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Memory Delete
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->5,"               +
                 "ORIGINROW->10,"          +
                 "ORIGINCOL->42",
                 "M- F6",-64,"tktDelMemCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Memory Recall
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->5,"               +
                 "ORIGINROW->11,"          +
                 "ORIGINCOL->42",
                 "MR F7",-65,"tktRecallCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; BackSpace
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->6,"               +
                 "ORIGINROW->12,"          +
                 "ORIGINCOL->42",
                 " BKSP",8,"tktTakeOneCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 7 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->8,"           +
                 "ORIGINCOL->52",
                 "7",55,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 4 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->9,"           +
                 "ORIGINCOL->52",
                 "4",52,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 1 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->10,"          +
                 "ORIGINCOL->52",
                 "1",49,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 0 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->11,"          +
                 "ORIGINCOL->52",
                 "0",48,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 8 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->8,"           +
                 "ORIGINCOL->55",
                 "8",56,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 5 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->9,"           +
                 "ORIGINCOL->55",
                 "5",53,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 2 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->10,"          +
                 "ORIGINCOL->55",
                 "2",50,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; . key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->11,"          +
                 "ORIGINCOL->55",
                 ".",46,"tktDecimalCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 9 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->8,"           +
                 "ORIGINCOL->58",
                 "9",57,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 6 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->9,"           +
                 "ORIGINCOL->58",
                 "6",54,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; 3 key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->10,"          +
                 "ORIGINCOL->58",
                 "3",51,"tktNumberCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; = key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->11,"          +
                 "ORIGINCOL->58",
                 "=",61,"tktTotalCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Enter key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->2,"               +
                 "ORIGINROW->12,"          +
                 "ORIGINCOL->57",
                 "",13,"tktTotalCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ;  key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->8,"           +
                 "ORIGINCOL->61",
                 "",47,"tktCalcCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; * key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->9,"           +
                 "ORIGINCOL->61",
                 "*",42,"tktCalcCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; - key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->10,"          +
                 "ORIGINCOL->61",
                 "-",45,"tktCalcCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; + key
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->1,"               +
                 "ORIGINROW->11,"          +
                 "ORIGINCOL->61",
                 "+",43,"tktCalcCalculator")
tktObjCreateCalc("HASFRAME->FALSE,"        +     ; Off Esc
                 "HASSHADOW->FALSE,"       +
                 "FLOATING->TRUE,"         +
                 "HEIGHT->1,"              +
                 "WIDTH->7,"               +
                 "ORIGINROW->7,"           +
                 "ORIGINCOL->55",
                 "OFF ESC",27,"Esc")

endproc

writelib LibName tktPaintCalculator
release procs tktPaintCalculator

; **************************************************************************
;
; TKTOBJCREATECALC - creates individual window objects
;
; **************************************************************************

Proc tktObjCreateCalc(Window_Attributes,Sayit,Key_Value,Proc_Name)

Private Window_Attributes,    ; Window attributes for window
        Sayit,                ; What to put in window
        WH,                   ; Window handle
        Key_Value,            ; Equivelant Key Value
        Proc_Name             ; Proc to call when pressed

;Global Win_Obj               ; Dynarray of window handles
;       Key_Obj               ; Dynarray of valid keystrokes

WH = tktWinCreate(Window_Attributes)
Win_Obj[WH] = Proc_Name
Key_Obj[Key_Value] = WH

window getattributes WH to Window_Attributes

if isblank(Window_Attributes["TITLE"]) then
   Window_Attributes["TITLE"] = Sayit
endif

window setattributes WH from Window_Attributes

if not isblank(Sayit) then
   @0,0 ?? Sayit
endif

endproc

writelib LibName tktObjCreateCalc
release procs tktObjCreateCalc

; **************************************************************************
;
; TKTSAYNUMBERCALC - display number
;
; **************************************************************************

Proc tktSayNumberCalc(Number)

Private Number,
        Now_WH    ; Current window handle

Now_WH = getwindow()

setcanvas Calc_WH
style reverse
if Show_tot then
   @0,1 ?? Format("W20.2,AR,SP,EC",numval(Number))
else
   @0,1 ?? Format("W19,AR,SP,EC",Number) + " "
endif
style

if iswindow(Now_WH) then
   setcanvas Now_WH
endif
endproc

writelib LibName tktSayNumberCalc
release procs tktSayNumberCalc

; **************************************************************************
;
; TKTHIGHLIGHTCALC - highlight button
;
; **************************************************************************

Proc tktHighlightCalc(WH)

Private WH,          ; Handle of window to highlight
        Win_Attr     ; Dynarray of window attributes

window select WH
setcanvas WH
window getattributes WH to Win_Attr
paintcanvas reverse,blink 0,0,0,Win_Attr["WIDTH"]
sleep 100
paintcanvas 0,0,0,Win_Attr["WIDTH"]

endproc

writelib LibName tktHighlightCalc
release procs tktHighlightCalc

; **************************************************************************
;
; TKTNUMBERCALCULATOR - Process numbers that have been pressed
;
; **************************************************************************

Proc tktNumberCalculator()

Private Win_Attr     ; Selected window attributes

;Global Calc_Val     ; Current total for calculator
;       Obj_WH       ; Object window handle
;       Show_Tot     ; Logical showing total after math operation

if Len(Calc_Val) > 15 then
   return
endif

window getattributes Obj_WH to Win_Attr

if numval(Win_Attr["TITLE"]) <> "Error" then

   switch
      case Show_Tot       : Calc_Val = Win_Attr["TITLE"] Show_Tot = FALSE
      case Calc_Val = "0" : Calc_Val = Win_Attr["TITLE"]
      otherwise           : Calc_Val = Calc_Val + Win_Attr["TITLE"]
   endswitch

endif

endproc

writelib LibName tktNumberCalculator
release procs tktNumberCalculator

; **************************************************************************
;
; TKTCLSCALCULATOR - Clear calculator
;
; **************************************************************************

Proc tktCLSCalculator()

;Global Calc_Val     ; Current value for calculator
;       Tot_Val      ; running total
;       Math         ; type of math operation to perform
;       Show_Tot     ; Logical showing total after math operation

Calc_Val = "0"
Tot_Val  = 0
Math     = ""
Show_Tot = FALSE
endproc


writelib LibName tktCLSCalculator
release procs tktCLSCalculator


; **************************************************************************
;
; TKTTAKEONECALCULATOR - Deletes one character from Calc_Val
;
; **************************************************************************

Proc tktTakeOneCalculator()

;Global Calc_Val  ; Current value for calculator
;       Show_Tot  ; Logical showing total after math operation

switch

   case Show_Tot          : tktCLSCalculator()

   case Len(Calc_Val) = 1 :

      Calc_Val = "0"

   case Calc_Val <> "0"   :

      Calc_Val = substr(Calc_Val,1,Len(Calc_Val)-1)

endswitch
endproc

writelib LibName tktTakeOneCalculator
release procs tktTakeOneCalculator

; **************************************************************************
;
; TKTDECIMALCALCULATOR - Puts decimal point on Calc_Val
;
; **************************************************************************

Proc tktDecimalCalculator()

;Global Calc_Val  ; Current value of calculator
;       Show_Tot  ; Logical showing total after math operation

if Show_Tot then

   Calc_Val = "0."
   Show_Tot = FALSE

else

   if not match(Calc_Val,"..\".\"..") then
      Calc_Val = Calc_Val + "."
   endif

endif
endproc

writelib LibName tktDecimalCalculator
release procs tktDecimalCalculator

; **************************************************************************
;
; TKTCALCCALCULATOR - Does the math
;
; **************************************************************************

Proc tktCalcCalculator()

Private Win_Attr  ; Window attributes for selected key

;Global Calc_Val  ; Current value of calculator
;       Obj_WH    ; Object window handle
;       Show_Tot  ; Logical showing total after math operation
;       Math      ; type of math operation to perform

window getattributes Obj_WH to Win_Attr

if Win_Attr["TITLE"] = "" then
   Win_Attr["TITLE"] = "/"
endif

if not isblank(Math) and Calc_Val <> "0" then

   execute "Tot_Val = Tot_Val " + Math + " numval(Calc_Val)"
   Calc_Val = strval(Tot_Val)

else

   Tot_Val  = numval(Calc_Val)

endif

Math = Win_Attr["TITLE"]
Show_Tot = TRUE

if Len(Calc_Val) > 15 then
   tktCLSCalculator()
endif
endproc

writelib LibName tktCalcCalculator
release procs tktCalcCalculator

; **************************************************************************
;
; TKTTOTALCALCULATOR - Totals Calculator
;
; **************************************************************************

Proc tktTotalCalculator()

;Global Calc_Val     ; Value of current calculator
;       Tot_Val      ; Running total
;       Math         ; math operation to be performed
;       Show_Tot     ; Logical showing total after math operation

if not isblank(Math) then

   execute "Tot_Val = Tot_Val " + Math + " numval(Calc_Val)"
   Calc_Val = strval(Tot_Val)

endif

Math     = ""
Show_Tot = TRUE
Tot_Val  = 0

if Len(Calc_Val) > 15 then
   tktCLSCalculator()
endif
endproc

writelib LibName tktTotalCalculator
release procs tktTotalCalculator

; **************************************************************************
;
; TKTSAVEMEMCALCULATOR - Save number in memory
;
; **************************************************************************

Proc tktSaveMemCalculator()

Private Now_WH    ; Current window handle

;Global Memory    ; Value saved in calculators memory
;       Calc_WH   ; Calculator window handle

if Calc_Val <> "0" then

   Now_WH = getwindow()
   Memory = Calc_Val

   setcanvas Calc_WH
   style reverse,blink
   @7,11 ?? "M"
   style

   if iswindow(Now_WH) then
      setcanvas Now_WH
   endif

endif

endproc

writelib LibName tktSaveMemCalculator
release procs tktSaveMemCalculator

; **************************************************************************
;
; TKTDELMEMCALCULATOR - Remove number from memory
;
; **************************************************************************

Proc tktDelMemCalculator()

Private Now_WH    ; Current window handle

;Global Calc_WH   ; Calculator window handle

Now_WH = getwindow()

setcanvas Calc_WH
@7,11 ?? " "
Memory = blanknum()

if iswindow(Now_WH) then
   setcanvas Now_WH
endif

endproc

writelib LibName tktDelMemCalculator
release procs tktDelMemCalculator

; **************************************************************************
;
; TKTRECALLCALCULATOR - Recalls stored memory value to Calculator
;
; **************************************************************************

Proc tktRecallCalculator()

;Global Memory    ; Value stored in calculators memory

if not isblank(Memory) then
   Show_Tot = FALSE
   Calc_Val = strval(Memory)
endif
endproc

writelib LibName tktRecallCalculator
release procs tktRecallCalculator

; **************************************************************************
;
; TKTCLEANCALCULATOR - Close all windows related to calculator
;
; **************************************************************************

Proc tktCleanCalculator()

Private WH        ; Window handle

;Global Win_Obj

foreach WH in Win_Obj

   window select numval(WH)
   window close

endforeach

endproc

writelib LibName tktCleanCalculator
release procs tktCleanCalculator

; ***************************************************************************
;
; TKTWINCREATE - Sets window attributes for specified window
;
; ***************************************************************************

Proc tktWinCreate(Parameters)
Private Win_Handle,    ; Handle for window you wish to change
        Parameters,    ; Window Attributes (ie "CANCLOSE->TRUE,CANMOVE->FALSE")
        Ind_Param,     ; Individual parameters (ie "CANCLOSE->TRUE")
        Win_Attr,      ; Dynarray to hold new attributes
        Attr,          ; Individual attributes to be loaded into Dynarray
        Element        ; Dynarray Element

DynArray Win_Attr[]

while match(Parameters,"..,..",Ind_Param,Parameters)

   if match(Ind_Param,"..->..",Element,Attr) then
      Win_Attr[Element] = tktWinFormat(Attr)
   endif

endwhile

if match(Parameters,"..->..",Element,Attr) then
   Win_Attr[Element] = tktWinFormat(Attr)
endif

Window Create Attributes Win_Attr to Win_Handle

return(Win_Handle)
endproc

writelib LibName tktWinCreate
release procs tktWinCreate


; ***************************************************************************
;
; TKTWINFORMAT - Converts Text string Attributes to TRUE/FALSE
;                        or NUMBERS
;
; ***************************************************************************

Proc tktWinFormat(Attr)
Private Attr   ; Attribute to be converted

switch
   case Upper(Attr) = "TRUE"    : Attr = TRUE
   case Upper(Attr) = "FALSE"   : Attr = FALSE
   case numval(Attr) <> "Error" : Attr = numval(Attr)
endswitch

return(Attr)
endproc


writelib LibName tktWinFormat
release procs tktWinFormat


; --------------------------------------------------------------------------
; Calculator returns a value so that you can make your own WaitProcHandler()
; toolkit function that will test the TYPE() of the field your sitting on
; (ie "N","S","$") and if the user presses [F1], for instance, the
; calculator will popup so they can do any needed calculations!
; --------------------------------------------------------------------------

autolib                = LibName
who_cares_in_this_case = tktCalculator()
