; The Program Library Utility Selector (PLUS)
; user interface script for accessing library
; utility procedures.

; By Dr. K. Buchholz
; Select LIB File to Use 
FileDir = DIRECTORY()
LibFils = FileDir + "\*.LIB"
LibButtonValue = "Cancel"
LibFileChoice = ""
SHOWDIALOG "Utility Library Selector"
  @4,13 HEIGHT 13 WIDTH 60
  PICKFILE @1,14 HEIGHT 7 WIDTH 30
  LIBFILS
  NOEXT
  TAG "ChooseLibFile"
  TO LibFileChoice
  PUSHBUTTON @9,14 WIDTH 10
    "~O~K"
    OK
    DEFAULT
    VALUE
    "Accept"
    TAG "AcceptTag"
    TO LibButtonValue
  PUSHBUTTON @9,34 WIDTH 10
    "~C~ancel"
    CANCEL
    VALUE "Cancel"
    TAG "CancelTag"
    TO LibButtonValue
ENDDIALOG
IF LibButtonValue = "Cancel" THEN
  QUIT
ENDIF
CLEARALL

; Create LibList Table (Sorted) 
IF IsTable("List") THEN
  DELETE "List"
ENDIF
IF ISTABLE("LibList") THEN
  DELETE "LibList"
ENDIF
INFOLIB LibFileChoice
SORT "List" ON "Procedure" TO "LibList"

; Load LibList into Fixed Array 
NumberOfRecords = NRECORDS("LibList")
ARRAY UtilsArray[NumberOfRecords]
VIEW "LibList"
SCAN
  UtilsArray[RECNO()] = [Procedure]
ENDSCAN
CLEARALL
; Choose Lib Utility From List 
ButtonValue = "Cancel"
SHOWDIALOG "Utility Library Selector"
  @4,13 HEIGHT 13 WIDTH 60
  PICKARRAY @1,14 HEIGHT 7 WIDTH 30
    UtilsArray
    TAG "ArrayTag"
    TO ArrayElement
  PUSHBUTTON @9,14 WIDTH 10
    "~O~K"
    OK
    DEFAULT
    VALUE
    "Accept"
    TAG "AcceptTag"
    TO ButtonValue
  PUSHBUTTON @9,34 WIDTH 10
    "~C~ancel"
    CANCEL
    VALUE "Cancel"
    TAG "CancelTag"
    TO ButtonValue
ENDDIALOG
IF ButtonValue = "Cancel" THEN
  QUIT
ENDIF
CLEARALL

; Now Execute the Utility Selected 
AUTOLIB = LibFileChoice
EXECPROC UtilsArray[ArrayElement]

