


PROC elapsed_time(start_time,end_time)
  PRIVATE a,b,c,D,e,f,x,y

  x=MATCH (start_time,"..:..:..",a,b,c)
  y=MATCH (end_time,"..:..:..",D,e,f)

  IF x=false OR y=false
    THEN
    MESSAGE
    "Wrong time format (hh:mm:ss)"
    SLEEP 3000
    RETURN
  ENDIF


  elapsed_time =
  (NUMVAL (D)*60 + NUMVAL (e) + (NUMVAL (f)/60))
  - (NUMVAL (a)*60 + NUMVAL (b) + (NUMVAL (c)/60))

  IF elapsed_time <0
    THEN
    elapsed_time = elapsed_time + 1440
  ENDIF

  hours= STRVAL (INT (elapsed_time/60))
  minutes= STRVAL (INT (MOD(elapsed_time,60)))
  seconds= STRVAL (ROUND(60*(elapsed_time - INT (elapsed_time)),2))

  IF LEN (hours) =1
    THEN
    hours="0"+hours
  ENDIF

  IF LEN (minutes) =1
    THEN
    minutes="0"+minutes
  ENDIF

  IF LEN (seconds) =1
    THEN
    seconds="0"+seconds
  ENDIF

  RETURN hours+":"+minutes+":"+seconds

ENDPROC


PROC perftest (ui_mode)
  EXECUTE "setuimode "+ui_mode
  start_time=TIME ()
  CURSOR OFF
  STYLE BLINK,REVERSE
  @10,20??"Now performing test in "+ui_mode+" mode..."
  CREATE "Test"
  "field1"  : "A32",
  "field2"  : "A32",
  "field3"  : "A32",
  "field4"  : "A32",
  "field5"  : "A32",
  "field6"  : "A32",
  "field7"  : "A32",
  "field8"  : "A32",
  "field9"  : "A32",
  "field10" : "A32",
  "field11" : "A32",
  "field12" : "A32",
  "field13" : "A32",
  "field14" : "A32",
  "field15" : "A32"

  CoEdit "test"

  [field1]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field2]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field3]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field4]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field5]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field6]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field7]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field8]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field9]  =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field10] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field11] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field12] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field13] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field14] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  [field15] =  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
  Do_It!

  count=1
  FOR count TO 14
  ADD "test" "test"
  ENDFOR

  SCAN
    FormKey
    FormKey
  ENDSCAN

  end_time= TIME ()

ENDPROC

PROC result ()
  CLEAR
  STYLE REVERSE
  @10,20??" Compatible duration: "+cp_time
  @12,20??" Standard duration  : "+st_time
  @14,20??" Difference         : "+elapsed_time (cp_time,st_time)
  message "Hit any key to quit"
  x= GETCHAR ()
  ClearAll
ENDPROC

release vars all
reset
perftest ("Compatible")
cp_time=elapsed_time (start_time,end_time)

perftest ("Standard")
st_time=elapsed_time (start_time,end_time)

result ()
