; The following scripts are hoped to help some one learning PAL.  I use these
; scripts, but I also trim, reshape, rework, customize, pound, and say the
; nicest things about my own code, so feel free to join in.  However, I do
; NOT, nor should any one else, take on blind faith that the code they have
; just obtained is just got to work.  If you read the code, and understand
; it, then you can improve it and feed it back to others to improve.  If
; you don't understand it, then set it up in dummy programs and run the 
; debugger on it to see how it works.  In any event, always know what the
; effects of the code are you implement.
;
; {Got nailed pretty hard once for making a 2 minute answer online that
;  somebody took to heart.  My intention then, as it is now, is to try
;  to help through suggestions, not infalliably solve code problems from
;  afar.  So I want to be of some assistance and I don't want to screw up
;  any one's day, so we'll all look before we code.}
;
; There now, now that that is done... The first bit is a header template
; I find useful.  After piles of scripts are about, it's nice to be able
; to pull up the first screen and see what the script is about.  It's
; even nicer if all the headers are consistant so that you don't have to
; decipher how what's being displayed is being said.
;
; The next script, YESNO, accepts only a y,Y,n,N before returning the
; user's keypress as upper case to the calling routine.  This kind of
; routine I adore.  In one place, one routine can accomplish for all
; others a common task.  If it needs revision, change just this routine
; and you have in affect changed all other routines using it.  Might
; actually be something to that loosely linked highly cohesive jargon
; Coad/Martin et. al. are so about.  It's just hard to get a really good
; task that lends itself so cleanly to it (for me at any rate.)
;
; The following script, MenuFilter, is an expanded YESNO.  I tried to
; suggest a way to do a generic function like YESNO except that there were
; more than two possible valid results. (yes, yes but higher, no, no - well
; ok just this once...)  A mention of sorting is made as a better example of
; a more appropriate routine, but the code, while possibly being loosely 
; linked and highly cohesive would be very application specific and much more
; convoluted than the general example I wanted to post.  So, here's a poor
; example of a good idea.
;
; Lastly, there is always the problem of key commands.  They're powerful when
; you need them and when they're included in the environment it's great not
; to have to write your own tricky stuff.  DOS shell out of a Paradox 
; application with BigDOS key is a great idea.  But sometimes inexperienced
; users who were just at a lovely Paradox interface you spent weeks to develop
; become your worst nigthmare when suddenly they find themselves at the DOS
; prompt.  With fear and loathing in their eyes they are determined that no
; will see them blankly staring at a screen which demands to know what 'C' is
; greater than.  They would rather force the issue until the most remote and
; least likely thing that could happen is accomplished by a novice what it
; will take wizzen database coders weeks to figure out.  Moreover, they won't
; tell a soul that they reset the system with 12 open tables during a remote
; upload of 25 others.  Point of this raving: trap valid user input from WAIT.
; This last part is a template of all the Paradox 3.5 key codes in an UNTIL
; statement followed by a table of their meaning.  Just read-in the whole
; thing as you develop and delete the pieces not needed. 
;
; That's it then.  If this gets downloaded, or I get an E-Mail or two, or any
; interest at all can be detected, there's more stuff to share.  I download
; quite a bit, lurk on the PDoxDOS threads often, and generally have pleasant
; time in this forum.  (If I could get a local CIS node... )  So it's good to
; send something back.  Hope that this may be of use, use it as you please.
;
; Charles Ruether   71241,2003   VI System Art, Database Designs    STL metro
;
;*****************************************************************************
;*
;*  A documenting tool.  Copy the last revision box in you text editior to
;*    keep it current.  Try to leave a blank line somewhere in it so that
;*    you can cut and paste it to expand a box.  Fill in the PROC and the
;*    LIBRARY lines, put something in between, and there you have it!
;*
;*****
;
;Ŀ
; Script Name                                                                
;Ĵ
; File Name                                                                  
;Ĵ
; Description                                                                
; or  Purpose                                                                
;Ĵ
; Caller or                                                                  
;    Sequence                                                                
;Ĵ
; Return Value                                                               
;Ĵ
; Parameters                                                                 
;                                                                            
;Ĵ
; Source                                                                     
;                                                                            
;creationĴ
;     /  /19    Project/Library                                             
;revisionPDoxĳ
;     /  /19    CopyRight                                              3.5 
;revisionver
;                                                                            
;

;Proc 

;EndProc
;WriteLib "

;*****************************************************************************
;*
;*     Won't take anything but y,Y,n,N (YES or NO) for an user's responce.
;*         Returns the responce accepted as upper case so your calling 
;*         script doesn't have the the case check again.  Easily can change
;*         the WHILE to ASCII characters like c,C,s,S (continue or stop) or
;*         like binary decisions.  For many possible decisions, perhaps a
;*         SWITCH statement could reside within a WHILE TRUE loop, the code
;*         executed after a match could do the case checking, and if the 
;*         case was alright, do a QUITLOOP to break the loop.  
;*
;*****
;
Proc YesNo ()
Private GC

GC = 0
While GC <> 110 AND GC <> 121 AND GC <> 78 AND GC <> 89 
	GC = GetChar()
EndWhile
Return (Upper(Chr(GC)))

EndProc
;WriteLib "ALib" YesNo

;*****************************************************************************
;*
;*     Won't take anything but whatever you need to continue.  You will
;*         likely have put the function of the procedure below locally
;*         in after a ShowMenu.  I just wanted something to indicate a
;*         numerous set of acceptable user keypresses indicating several
;*         valid actions.  Perhaps a better example could have been a
;*         example of sorting a table to a temporary table by several
;*         different methods.  Maybe a decision to output one of several
;*         'standard' reports needs to be made.  In any case, this switch
;*         could handle any routine and common function - in one place -
;*         that an application might need.  It is assumed that a menu
;*         has been displayed of the valid choices before calling this
;*         procedure.
;*
:*****

PROC MenuFilter ()
Private DoLoop, CommonVar, GC, MinChar, MaxChar

DoLoop     = True                         ;Set DoLoop for iteration
CommonVar  = ""                           ;ReSet CommonVar to NUL
GC         = 255                          ;GC = 255 = largest ASCII char
MinChar    = 20                           ;Don't set MinChar above ESC key
MaxChar    = 122                          ;MaxChar = 122 = 'z'

While DoLoop
   If Len(CommonVar) > 0                  ;Double duty for CommonVar, if it
       QuitLoop                           ;  it is assigned, break the loop
   Endif                                  ;  on the next iteration

   While GC < MinChar OR GC > MaxChar     ;Don't SWTICH until have an alpha
       GC = GetChar()
   EndWhile
   
   GC = Upper(GC)                         ;Convert to upper case just here

   Switch (GC)
       Case GC = ASC('A'): 
           CommonVar = "AgeInvoicesMenu"  ;Keep to pass back to caller
           AgeInvoicesMenu()              ;Go do the routine requested
       Case GC = ASC('B'): 
           CommonVar = "BackUpMenu"
           BackUpMenu ()
       Case GC = ASC('C'): 
           CommonVar = "CommLinkMenu"
           CommLinkMenu ()
       Case GC = ASC('D'): 
           CommonVar = "DirectoryMenu"
           DirectoryMenu ()
       Case GC = ASC('E'): 
           CommonVar = "EditorMenu"
           EditorMenu ()
       Case GC = ASC('F'): 
           CommonVar = "FileMenu"
           FileMenu ()
       Case GC = ASC('G'): 
           CommonVar = "GlobalThemonuclearWar"
           GoSeeAMovie ()
       Case GC = ASC('I'): 
           CommonVar = "InventoryMenu"
           InventoryMenu ()
       Case GC = ASC('U'): 
           CommonVar = "ULSI"
           UltraLargeScaleIntergration ()
       Case GC = 27      : 
           CommonVar = "UserBreak"
       Case Otherwise    : 
           Message "Invalid selection.  ESCape to quit. Keypress to continue."
   EndSwtich
   
   Return CommonVar                        ;Let the caller know what's done

EndWhile
EndProc
;WriteLib "ALib" MenuFilter

;*****************************************************************************
;*
;*     If concerned programmers are out there concerned that an otherwise
;*         bullet-proof application can be wiped by an inexperinced user
;*         user trying to get back from a DOS shell (BIGDOS or DOS) after
;*         pressing a Alt-O or Ctrl-O for a Shift-O, then UNTIL traps are
;*         for you.  In developing code, import this code template into
;*         your WAITs.  Edit out what you don't want, keep the protection
;*         you need.  You don't even have to lookup a negative code, its
;*         bringing its documentation with it.  When you're done, cut the
;*         documentation.  Default is everything trapped (which you don't
;*         want) except ESCape.
;*
;*****
;
While True
   Wait Record
       Prompt  "Wait",
               "Prompt"
       Message " All Paradox 3.5 Keys Trapped "
   Until 6,8,9,12,13,15,18,22,25,26,27,127,-15,-19,-24,-37,-38,-44,-45,-59,-60,-61,-62,-63,-64,-65,-66,-67,-68,
         -71,-72,-73,-75,-77,-80,-81,-82,-83,-106,-107,-108,-109,-110,-111,-112,-113,-114,-115,-116,-117,-118,-119
   Switch
       Case RetVal = 27    :
           QuitLoop
       Otherwise           :
           BEEP
           Message " Key Trap ["+StrVal(RetVal)+"], key inactive "
           Sleep 1500
   EndSwitch
EndWhile
;
; Keyboard Codes as understood by Paradox 3.5
;
;   0              Ctrl 2                                 
;   1              Ctrl A                                     -1                                           
;   2              Ctrl B                                     -2                                           
;   3              Ctrl C                                     -3              (NULL)                       
;   4              Ctrl D                                     -4                                           
;   5              Ctrl E                                     -5                                           
;   6 FieldView    Ctrl F                                     -6                                           
;   7              Ctrl G                                     -7                                           
;   8 Backspace    Ctrl H     (BackSpace)                     -8                                           
;   9 Tab          Tab        (Tab Character      \t)         -9                                           
;  10              Ctrl Enter (Linefeed Character \n)        -10                                           
;  11              Ctrl K                                    -11                                           
;  12 Resume key   Ctrl L     (Formfeed Character \f)        -12                                           
;  13 Enter        Enter, Ctrl M                             -13                                           
;  14              Ctrl N                                    -14                                           
;  15 Dos          Ctrl O                                    -15 ReverseTab               Shift Tab 
;  16              Ctrl P                                    -16                          Alt Q     
;  17              Ctrl Q                                    -17                          Alt W     
;  18 Rotate       Ctrl R                                    -18                          Alt E     
;  19              Ctrl S                                    -19 Refresh                  Alt R     
;  20              Ctrl T                                    -20                          Alt T     
;  21              Ctrl U                                    -21                          Alt Y     
;  22 VertRuler    Ctrl V                                    -22                          Alt U     
;  23              Ctrl W                                    -23                          Alt I     
;  24              Ctrl-X                                    -24 DosBig                   Alt O     
;  25 DeleteLine   Ctrl Y                                    -25                          Alt P     
;  26 Zoom         Ctrl-Z                                    -26                                    
;  27 Esc          Esc, Ctrl Esc, Ctrl ]                     -27                                    
;  28              Ctrl \                                    -28                                    
;  29              Ctrl ]                                    -29                                    
;  30              Ctrl 6                                    -30                          Alt A     
;  31              Ctrl -                                    -31                          Alt S     
;  32 Spacebar     Space, Shift/Ctrl/Alt Space               -32                          Alt D     
;  33 !            !                                         -33                          Alt F     
;  34 \"           "                                         -34                          Alt G     
;  35 #            #                                         -35                          Alt H     
;  36 $            $                                         -36                          Alt J     
;  37 %            %                                         -37 KeyLookUp                Alt K     
;  38 &            &                                         -38 LockKey                  Alt L     
;  39             '                                         -39                                           
;  40 (            (                                         -40                                           
;  41 )            )                                         -41                                           
;  42 *                                                      -42                                           
;  43 +                                                      -43                                           
;  44 ,                                                      -44 ZoomNext                 Alt Z            
;  45 -                                                      -45 CrossTab                 Alt X             
;  46 .                                                      -46                          Alt C
;  47 /                                                      -47                          Alt V            
;  48 0                                                      -48                          Alt B            
;  49 1                                                      -49                          Alt N
;  50 2                                                      -50                          Alt M              
;  51 3                                                      -51                                             
;  52 4                                                      -52                                             
;  53 5                                                      -53                                             
;  54 6                                                      -54                                             
;  55 7                                                      -55                                             
;  56 8                                                      -56                                             
;  57 9                                                      -57                                             
;  58 :                                                      -58                                             
;  59 ;                                                      -59 Help                     F1                 
;  60 <                                                      -60 DO_IT!                   F2                 
;  61 =                                                      -61 UpImage                  F3                 
;  62 >                                                      -64 DownImage                F4                 
;  63 ?                                                      -63 Example                  F5                 
;  64 @                                                      -64 Check                    F6                 
;  65 A                                                      -65 FormKey                  F7                 
;  66 B                                                      -66 ClearImage               F8                 
;  67 C                                                      -67 EditKey                  F9                 
;  68 D                                                      -68 Menu                     F10                
;  69 E                                                      -69                                             
;  70 F                                                      -70
;  71 G                                                      -71 Home                     HOME                
;  72 H                                                      -72 Up                       Up Arrow            
;  73 I                                                      -73 PgUp                     Page Up             
;  74 J                                                      -74                                              
;  75 K                                                      -75 Left                     Left Arrow          
;  76 L                                                      -76                                              
;  77 M                                                      -77 Right Arrow              Right Arrow         
;  78 N                                                      -78                                              
;  79 O                                                      -79                                              
;  80 P                                                      -80 Down Arrow               Down Arrow          
;  81 Q                                                      -81 PgDn                     Page Down           
;  82 R                                                      -82 Ins                      INS                 
;  83 S                                                      -83 Del                      DEL                 
;  84 T                                                      -84                  F11     Shift F1            
;  85 U                                                      -85                  F12     Shift F2            
;  86 V                                                      -86                  F13     Shift F3            
;  87 W                                                      -87                  F14     Shift F4            
;  88 X                                                      -88                  F15     Shift F5            
;  89 Y                                                      -89                  F16     Shift F6            
;  90 Z                                                      -90                  F17     Shift F7            
;  91 [                                                      -91                  F18     Shift F8            
;  92 \                                                      -92                  F19     Shift F9            
;  93 ]                                                      -93                  F20     Shift F10           
;  94 ^                                                      -94                  F21     Ctrl F1             
;  95 _                                                      -95                  F22     Ctrl F2             
;  96 `                                                      -96                  F23     Ctrl F3             
;  97 a                                                      -97                  F24     Ctrl F4             
;  98 b                                                      -98                  F25     Ctrl F5             
;  99 c                                                      -99                  F26     Ctrl F6             
; 100 d                                                     -100                  F27     Ctrl F7             
; 101 e                                                     -101                  F28     Ctrl F8             
; 102 f                                                     -102                  F29     Ctrl F9             
; 103 g                                                     -103                  F30     Ctrl F10            
; 104 h                                                     -104                  F31     Alt F1              
; 105 i                                                     -105                  F32     Alt F2              
; 106 j                                                     -106 Instant Record,  F33     Alt F2              
; 107 k                                                     -107 Instant Play,    F34     Alt F3              
; 108 l                                                     -108 FieldView        F35     Alt F5              
; 109 m                                                     -109 CheckPlus        F36     Alt F6              
; 110 n                                                     -110 InstantReport    F37     Alt F7              
; 111 o                                                     -111 ClearAll         F38     Alt F8              
; 112 p                                                     -112 CoEditKey        F39     Alt F9              
; 113 q                                                     -113 PalMenu          F40     Alt F10             
; 114 r                                                     -114                          Ctrl PrntScrn       
; 115 s                                                     -115 CtrlLeft                 Ctrl Left           
; 116 t                                                     -116 CtrlRight                Ctrl Right          
; 117 u                                                     -117 CtrlEnd                  Ctrl End            
; 118 v                                                     -118 CtrlPgDn                 Ctrl PgDn           
; 129 w                                                     -119 CtrlHome                 Ctrl Home           
; 120 x                                                     -120                          Alt  1              
; 121 y                                                     -121                          Alt  2              
; 122 z                                                     -122                          Alt  3              
; 123 {                                                     -123                          Alt  4              
; 124 |                                                     -124                          Alt  5              
; 125 }                                                     -125                          Alt  6              
; 126 ~                                                     -126                          Alt  7              
; 127 CtrlBackspace Ctrl BackSpace                          -127                          Alt  8              
; 128 - 255    Alt KeyPad Characters                        -128                          Alt  9              
;                                                           -129                          Alt  0              
;                                                           -130                          Alt  -              
;                                                           -131                          Alt  =              
;                                                           -132                          Alt  PgUp           


