;ķ
; Dale W. Harrison                 
; 3815 Richmond Ave.               
; Suite 111                        
; Houston, TX 77027                
; Phone:  (713) 888-1479           
; CIS ID: 76535,1364               
;                                  
; Copyright 1991,                  
; All Rights Reserved              
;ͼ


;Ŀ
; Control data entry for Primary Applications Screen.                    
;
Proc Main()
   Reset
   Release VARS All
   ClearAll

   View     "Apps"
   PickForm "F"
   CoEditKey
   WaitMsg = ""

   While TRUE
      Switch
         Case  Table() = "Apps"  :
         PromptLine1 = "[F1]- Lookup Help   [F4]- 'Area of "      +
                       "Practice' Window    [F5]- 'Claims' Window "
         PromptLine2 = "[F2]- Quit & Save   [PgUp/PgDn]- Record " +
                       "Up/Down        [F6]- 'Rejections' Window  "

         Case  Table() = "Area"  :
         PromptLine1 = "[F1]       - Lookup Help"
         PromptLine2 = "[Esc]/[F4] - Return to Application Form"
      EndSwitch

      Wait Table
         Prompt   PromptLine1,
                  PromptLine2
         Message  WaitMsg
         Until    "Esc" ,  "Enter"   ,
                  "F2"  ,  "F4"      , "F5"  ,  "F6"      ,
                  "PgUp",  "CtrlPgUp", "Home",  "CtrlHome",
                  "PgDn",  "CtrlPgDn", "End" ,  "CtrlEnd" ,
                  "Down",  "Right"   , "Up"  ,  "Left"

      WaitKey = retval
      WaitMsg = ""


      Switch
         Case  WaitKey = "Esc"   :  If Table() = "Apps"
                                       Then  QuitLoop
                                       Else  UpImage
                                    EndIf

         Case  WaitKey = "F2"    :  QuitLoop
         Case  WaitKey = "PgUp"  :  CtrlPgUp CtrlHome
         Case  WaitKey = "PgDn"  :  CtrlPgDn CtrlHome

         Case  WaitKey = "F5"    :  Claims()
                                    If not retval
                                       Then  Beep
                                             WaitMsg = "Application isn't " +
                                                       "marked as having 'Claims'!"
                                    EndIf

         Case  WaitKey = "F6"    :  Reject()
                                    If not retval
                                       Then  Beep
                                             WaitMsg = "Application isn't marked " +
                                                       "as having been 'Rejected'!"
                                    EndIf

         Case  WaitKey = "Up" or
               WaitKey = "Left"  :  If Field() = "Customer ID"
                                       Then  MoveTo [Rejected]
                                       Else  KeyPress WaitKey
                                    EndIf

         Case  WaitKey = "Dn" or
               WaitKey = "Right" :  If Field() = "Rejected"
                                       Then  MoveTo [Customer ID]
                                       Else  KeyPress WaitKey
                                    EndIf

         Case  WaitKey = "CtrlPgUp" or
               WaitKey = "CtrlPgDn"    :  Loop

         Otherwise   :  KeyPress WaitKey
      EndSwitch

      If PageNo() <> 1
         Then  CtrlHome
         Else  WaitMsg = Window()
               If Search("Insufficient",WaitMsg) > 0
                  Then  WaitMsg = ""
               EndIf
      EndIf
   EndWhile

   Do_It!
   ClearAll
   Quit
EndProc




;Ŀ
; Control data entry for 'Claims' Window.                                
;
Proc Claims()

   If [Claims] = "Yes"
      Then  Fld  = Field()
            MoveTo "Claims"
            MoveTo [Claim Number]
      Else  Return FALSE
   EndIf

   While TRUE
      Wait Table
         Prompt   "[F1]       - Lookup Help",
                  "[Esc]/[F5] - Return to Application Form"
         Message  WaitMsg
         Until    "Esc" ,  "F5"

      WaitKey = retval
      WaitMsg = ""

      Switch
         Case  WaitKey = "Esc"   :  QuitLoop
         Case  WaitKey = "F5"    :  QuitLoop
      EndSwitch

      WaitMsg = Window()
   EndWhile

   UpImage
   MoveTo Field  Fld

   Return TRUE
EndProc




;Ŀ
; Control data entry for 'Rejections' Window.                            
;
Proc Reject()

   If [Rejected] = "Yes"
      Then  Key  = [Customer ID]
            Fld  = Field()
            MoveTo [New Carrier]
      Else  Return FALSE
   EndIf

   While TRUE
      Switch
         Case  Table() = "Apps"  :
         PromptLine1 = "[F1]       - Lookup Help                 [F3] - 'Reasons for Reject' Window"
         PromptLine2 = "[Esc]/[F6] - Return to Application Form "

         Case  Table() = "Reject":
         PromptLine1 = "[F1]       - Lookup Help"
         PromptLine2 = "[Esc]/[F3] - Return to 'Rejection' Window"
      EndSwitch

      Wait Record
         Prompt   PromptLine1,
                  PromptLine2
         Message  WaitMsg
         Until    "Esc" ,  "Enter"   , "Del" ,
                  "F2"  ,  "F3"      , "F6"  ,
                  "PgUp",  "CtrlPgUp", "Home",  "CtrlHome",
                  "PgDn",  "CtrlPgDn", "End" ,  "CtrlEnd" ,
                  "Down",  "Right"   , "Up"  ,  "Left"

      WaitKey = retval
      WaitMsg = ""

      Switch
         Case  WaitKey = "F3"    :  KeyPress WaitKey

         Case  WaitKey = "F6" or
               WaitKey = "Esc"   :  If Table() = "Reject"
                                       Then  UpImage
                                             QuitLoop
                                       Else  QuitLoop
                                    EndIf

         Case  WaitKey = "Del"   :  If Table() = "Apps"
                                       Then  Loop
                                       Else  KeyPress WaitKey
                                    EndIf

         Case  WaitKey = "Up"   or
               WaitKey = "Right" :  If Table() = "Apps"  and
                                       Field() = "New Carrier"
                                       Then  Beep
                                       Else  KeyPress WaitKey
                                    EndIf

         Case  WaitKey = "Down" or
               WaitKey = "Left" or
               WaitKey = "Enter" :  If Table() = "Apps"  and
                                       Field() = "Premium Quoted (reject)"
                                       Then  Beep
                                       Else  KeyPress WaitKey
                                    EndIf

         Otherwise               :  Beep
      EndSwitch

      WaitMsg = Window()
   EndWhile

   MoveTo [Customer ID]
   Locate Key
   MoveTo Field  Fld

   Return TRUE
EndProc



;Ŀ
; Execute the Procedure MAIN() compilied above.                          
;
 Main()


