Listing 1 (C Si!)

/* pdrptwin.h     Aug 1991
 *
 * header file required to be "included" in file
 * using windows library - for linking pdrptwin.obj
 */

extern void open_window(int,int,int,int,int,int);
extern void close_window(int,int,int,int);
extern void save_screen(void);
extern void restore_screen(void);
extern void hide_cur(void);
extern void show_cur(void);


/* pdrptwin.c     Aug 1991
 *
 * windows object file for linking to pdoxrpt.exe;
 * includes functions to open and close windows and
 * turn the cursor on and off
 */

#include <stdlib.h>
#include <conio.h>
#include <dos.h>

/* maximum number of windows open at one time
 * arbitrarily set to 5
 */
#define MAXWINDOWS  5

int  scr_num=0;

char  *screen[MAXWINDOWS];

struct text_info  screen_info[MAXWINDOWS];

union REGS  regs;

void open_window(int,int,int,int,int,int);
void close_window(int,int,int,int);
void save_screen(void);
void restore_screen(void);
void hide_cur(void);
void show_cur(void);

/* open_window( ) is passed coordinates for the upper left
 * and lower right corners of desired window area and the
 * foreground and background colors to be used; screen
 * information (e.g. cursor location) is first saved to
 * to screen_info[] and screen data saved in screen[]
 */
void open_window(int x1,int y1,int x2,int y2,int text,int back)
{
  gettextinfo(&screen_info[scr_num]);
  screen[scr_num]=malloc((x2-x1+1)*(y2-y1+1)*2);
  gettext(x1,y1,x2,y2,screen[scr_num++]);

  textattr(text+(back<<4));
  window(x1,y1,x2,y2);
  clrscr( );
}


/* close_window( ) is passed coordinates of the screen area
 * to be closed; closure is accomplished by restoring the
 * most recently saved screen and resetting its attributes
 * and cursor location
 */
void close_window(int x1,int y1,int x2,int y2)
{
  puttext(x1,y1,x2,y2,screen[--scr_num]);
  free(screen[scr_num]);
  window(screen_info[scr_num].winleft,
    screen_info[scr_num].wintop,
    screen_info[scr_num].winright,
    screen_info[scr_num].winbottom);
  textattr(screen_info[scr_num].attribute);
  gotoxy(screen_info[scr_num].curx,screen_info[scr_num].cury);
}


/* save_screen( ) and restore_screen( ) are essentially subsets
 * of the open and close window functions, and are used to save
 * and restore the screen existing prior to execution of the
 * report program
 */
void save_screen(void)
{
  gettextinfo(&screen_info[scr_num]);
  /* saving a screen requires two bytes for each character
   * displayed (one for the character itself and one for its
   * color attribute); therefore, 80*25*2=4000 is the size of
   * the storage area needed to store a full screen
   */
  screen[scr_num]=malloc(4000);
  gettext(1,1,80,25,screen[scr_num++]);
}

void restore_screen(void)
{
  puttext(1,1,80,25,screen[--scr_num]);
  free(screen[scr_num]);
  textattr(screen_info[scr_num].attribute);
  gotoxy(screen_info[scr_num].curx,screen_info[scr_num].cury);
}


/* hide_cur( ) and show_cur( ) load the indicated register
 * values and make a call to interrupt 16 to turn the cursor
 * off and on
 */
void hide_cur(void)
{
  regs.h.ch=32;
  regs.h.ah=1;
  int86(0x10,&regs,&regs);
}


void show_cur(void)
{
  regs.h.ch=6;
  regs.h.cl=7;
  regs.h.ah=1;
  int86(0x10,&regs,&regs);
}



Listing 2 (C Si!)

/* pdptrck.h      Aug 1991
 *
 * header file required to be "included" in file
 * using printer library - for linking pdptrck.obj
 */

extern int  check_printer(void);
extern void report_msg(void);


/* pdptrck.c      Aug 1991
 *
 * printer check and message object file for
 * linking to pdoxrpt.exe; requires availability
 * of pdrptwin.obj for window and cursor functions
 */

#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>

#define TRUE   1
#define FALSE  0
#define CR    13
#define ESC   27

extern void open_window(int,int,int,int,int,int);
extern void close_window(int,int,int,int);
extern void hide_cur(void);
extern void show_cur(void);
extern int  getkey(void);

int  check_printer(void);
int  printer_error(void);
void report_msg(void);

/* check_printer( ) is called by print_rpt( ) to
 * manage the printer checking activity
 */
int check_printer(void)
{
  int status;

  while(TRUE)
  {
    status=biosprint(2,0,0);
    if(status==144)
      return(TRUE);
    status=printer_error( );
    if(!status)
      return(FALSE);
  }
}


/* printer_error( ) is called by check_printer( ) to
 * inform the user of a printer error - printer is off
 * or off line - and get user response; the cursor is
 * turned off for the duration of the message with
 * hide_cur( ) and turned back on with show_cur( )
 */
int printer_error(void)
{
  int action;

  hide_cur( );
  open_window(25,10,56,15,LIGHTGRAY,RED);
  cputs("\r\n          PRINTER ERROR\r\n");
  cputs("\r\n");
  cputs("  Check printer and press [\x11\xD9]\n\r");
  cputs("     or use [ESC] to cancel\a");

  while(TRUE)
  {
    switch(getkey( ))
    {
      case CR:
        action=TRUE;
        break;
      case ESC:
        action=FALSE;
        break;
      default:
        putch('\a');
        continue;
    }
    break;
  }
  close_window(25,10,56,15);
  show_cur( );
  return(action);
}

/* report_msg( ) is called by print_rpt( ) to display
 * current program status to the user for the duration
 * of the printing activity; sleep( ) is included to
 * provide a minimum message display time
 */
void report_msg(void)
{
  open_window(25,11,56,13,LIGHTGRAY,BLUE);
  cputs("\r\n  Sending report to printer");
  textcolor(LIGHTGRAY+BLINK);
  cputs("...");
  sleep(1);
}
