;******************************************************************************
; SCRIPT NAME   : PASS.SC
;
; PURPOSE       : This script is the frontend program for the password change
;                 utility.  The user this program anytime they wish to change
;                 the password for their table(s).
;
; WRITTEN BY    : T. Bonney / April 1988
;
; UPDATED BY    :
;
; NOTES         : This script is executed from DOS level within the user's
;                 Paradox application directory.
;******************************************************************************


READLIB "TOOLKIT" INITWAIT,SETKEYCODES
    INITWAIT("FLDSPEC","KEYSPEC")
    SETKEYCODES()
RELEASE PROCS INITWAIT,SETKEYCODES


IF (SYSMODE() <> "Main") THEN
    MESSAGE "The application can only be started from Paradox main mode"
    SLEEP 3000
    RETURN
ENDIF

ECHO OFF
CLEAR
RESET
CURSOR OFF


;** A logo screen is displayed (ICEG2.SC) and the current
;** application password is requested

MONTYPE = MONITOR()

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 2
    ELSE STYLE ATTRIBUTE 13
ENDIF
@2,0
    PLAY "ICEG2"
STYLE

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 10
    ELSE STYLE ATTRIBUTE 15
ENDIF
@0,60 ?? "OR  [Esc] to Cancel"
STYLE

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 138
    ELSE STYLE ATTRIBUTE 143
ENDIF
@0,1 ?? "ENTER PASSWORD"

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 10
    ELSE STYLE ATTRIBUTE 15
ENDIF
@0,16 ?? "(It will not appear when typed)"

    STYLE ATTRIBUTE 0
@1,1 ? ": "
    CURSOR NORMAL
    ACCEPT "A49" TO PWORD
        ESCENTER = NOT RETVAL
    CURSOR OFF
    STYLE

IF (ESCENTER) THEN
    MESSAGE "CANCELLING PASSWORD CHANGE UTILITY"
    SLEEP 2000
    CLEAR
    RETURN
ENDIF

IF (PWORD <> "") THEN
    PASSWORD PWORD
ENDIF


PLAY "PASSCHG"

