;THIS IS A SAMPLIE SCRIPT APPLICATION

Createlib "Zoomkit"

PROC ShowHeader()
;=
; This is the ShowHeader routine.  It displays a text screen.
;=
cursor off
clear
@ 3,0 ?? format("w80,ac","L E O   B U R N E T T   U. S. A.")
@ 4,0 ?? format("w80,ac","+")
@ 5,0 ?? format("w80,ac","+                         +")
@ 6,0 ?? format("w80,ac","+                                             +")
@ 7,0
text
                                      
                                        
                                      
                                    
                                  
                                   
                                 
                                 
                               
                                
                                 
                                  
                                  
                                   
                                   
endtext
message "Just A Moment ...." style
echo off
sleep 3000
ENDPROC

writelib "zoomkit" ShowHeader
release procs ShowHeader

PROC GetTableNames()
;=
; This is the GetTableNames routine.  It retrieves tables for
; an array to be used later.
;=
private sub_script,maxflds,maxtables,x,y,saverecno
   message "Validating The Tables ...."
   echo off
   moveto table_table
   if sysmode() = "Edit" then
      do_it!
   endif
   maxtables = nrecords(table())
   array tablenames[nrecords(table())]
   array tabledesc[nrecords(table())]
   sub_script = 0
   maxflds = 0
   scan
      sub_script = sub_script + 1
      maxflds = max(maxflds,nfields([Table Name]))
      tablenames[sub_script] = [Table Name]
      tabledesc[sub_script] = [Menu Description]
   endscan
   x = 0
   scan
      saverecno = recno()
      view path+[Table Name]
      x = x + 1
      ctrlhome right
      execute "Array TableField"+strval(x)+"[nfields(table())]"
      execute "Array TableDummy"+strval(x)+"[nfields(table())]"
      for y from 1 to nfields(table())
         set_array("TableField",saverecno,y,field())
         set_array("TableDummy",saverecno,y,"")
         right
      endfor
      clearimage
      moveto table_table
   endscan
   @22,0 clear eol
ENDPROC

writelib "zoomkit" GetTableNames
release procs GetTableNames

PROC GetFunctions()
;=
; This is the GetFunctions routine.  It builds an array of
; function key values.
;=
private sub_script
array function[nrecords(table())]
array description[nrecords(table())]
array procedure[nrecords(table())]
sub_script = 0
scan
    sub_script = sub_script + 1
    function[sub_script] = [Description]
    description[sub_script] = [Function]
    procedure[sub_script] =[Procedure]
endscan
ENDPROC

writelib "zoomkit" GetFunctions
release procs GetFunctions

PROC RetrieveTables()
;=
; This routine brings the worktables into Paradox's workspace.
;=
   table_name = "table"
   lookup_name = "lookup"
   function_name = "function"
   pchild_name = "pchild"
   tfunc_name = "tfunc"
   table_table = path + table_name
   lookup_table = path + lookup_name
   function_table = path + function_name
   pchild_table = path + pchild_name
   tfunc_table = path + tfunc_name
   if not istable(table_table) then
      message "System Tables Cannot Be Found ....Reset Directory"
      sleep 3000
      return false
   endif
   view table_table
   if not isempty(table()) then
      GetTableNames()
   endif
   view lookup_table
   view pchild_table
   view tfunc_table
   view function_table
   GetFunctions()
   return true
ENDPROC

writelib "zoomkit" RetrieveTables
release procs RetrieveTables

PROC ResetDirectory()
;=
; This routine allows a user to reset Paradox's work directory
; indirectly.  Afterwards, the worktables are re-initialized.
;=
   ChangeDirectory()
   Initialize()
ENDPROC

writelib "zoomkit" ResetDirectory
release procs ResetDirectory

PROC ChangeDirectory()
;=
; Prompt the user for a new working directory.
;=
private continue
   if sysmode() = "Edit" then
      beep beep
      @ 1,0 clear eol
      @ 0,0 clear eol ?? "Current Changes Not Saved .... Save Current Changes (Y/N)? "
      style reverse
      accept "a1" picture "[Y,N,y,n]" default "Y" to continue
      style
      @ 0,0 clear eol
      if upper(continue) = "Y" then
         do_it!
      else
         canceledit
         clearall
      endif
   endif
   @0,0 clear eol ?? "Enter The New Directory:"
   @1,0 clear eol style reverse accept "a80" picture "*[!]" default path to path style
   if not retval then
      clearall
      Quit "Program Aborted ...."
   endif
   if path <> "" then
      if substr(path,len(path),1) <> "\\" then
         path = path + "\\"
      endif
   endif
   @0,0 clear eol
   @1,0 clear eol
ENDPROC

writelib "zoomkit" ChangeDirectory
release procs ChangeDirectory

PROC Initialize()
;=
; Initialize the worktables.
;=
private script_name, ok, overwrite, script_name_ext
while not RetrieveTables()
  @22,0 clear eol
  ChangeDirectory()
endwhile
@22,0 clear eol
;=
; This line of documentation occurs in the middle of this procedure.
;=
cursor normal
ok = false
while not ok
   @ 0,0 clear eol ?? "Enter The Script Name To Generate: "
   style reverse
   accept "a8" picture "*[!]" required to script_name
   style
   @ 0,0 clear eol
   if not retval then
      clearall
      Quit "Program Aborted ...."
   else
      script_name_ext = script_name + ".SC"
   endif
   if isfile(path+script_name_ext) then
      beep
      @ 0,0 clear eol ?? "Script Already Exists .... Overwrite (Y/N)? "
      style reverse
      accept "a1" picture "[Y,N,y,n]" default "N" to overwrite
      style
      @ 0,0 clear eol
      if upper(overwrite) = "Y" then
         ok = true
      endif
   else
      ok = true
   endif
endwhile
return script_name
ENDPROC

writelib "zoomkit" Initialize
release procs Initialize

PROC DisplayMenu()
;=
; Display the main menu.
;
; See how in-line documentation can be accomplished.  No more
; documentation will follow.
;=
showmenu "Tables":"Define Primary Tables In This System",
         "Reltnshp":"Enter Parent/Child Table Relationships",
         "Procs":"Enter Procedure Names For Function Keys",
         "Lookup":"Define Lookup Tables",
         "Do_It!":"Save System Tables, Generate The Script & Exit",
         "Save":"Save System Tables",
         "Init":"Re-Initialize The System Tables",
         "ChgDir":"Change Working Directory",
         "Restart":"Abort Any Changes Made & Close System Tables",
         "Exit":"Exit System"
 default prev_choice
      to option
if option = "Esc" then
  option = ""
  beep
else
  prev_choice = option
endif
ENDPROC

writelib "zoomkit" DisplayMenu
release procs DisplayMenu

PROC Driver()
done = false
while not done
   DisplayMenu()
   if option = "Reltnshp" or
      option = "Procs"         or
      option = "Lookup"        or
      option = "Do_It!"        then
       if not CheckTableNames() then
          loop
       endif
   endif
   switch
      case option = "Tables": LoadTables()
      case option = "Reltnshp": LoadRelations()
      case option = "Procs": LoadProcs()
      case option = "Lookup": LoadLookups()
      case option = "Init": InitTables()
      case option = "ChgDir": ResetDirectory()
      case option = "Do_It!": Generate() quitloop
      case option = "Save": Do_It!
      case option = "Restart": Restart()
      case option = "Exit": ExitProc()
   endswitch
endwhile
ENDPROC

writelib "zoomkit" Driver
release procs Driver

PROC Restart()
   if sysmode() = "Edit" then
      canceledit
      message "Tables Closed & Restored To Original Contents Before Edit ...."
      sleep 1000
      @ 22,0 clear eol
   endif
ENDPROC

writelib "zoomkit" Restart
release procs Restart

PROC CheckTableNames()
private ok,ch
   ok = true
   if isempty(table_name) then
      beep beep
      message "Must First Define All Tables To Be Used .... Press Any Key"
      ch = getchar()
      @ 22,0 clear eol
      ok = false
   endif
   return ok
ENDPROC

writelib "zoomkit" CheckTableNames
release procs CheckTableNames

PROC LoadTables()
private tabname, maxvalue, first_time, delete_table_id, new_table_id, done, ok
done = false
delete_table_id = 0
first_time = false
moveto table_name
if isempty(table_name) then
   first_time = true
endif
if sysmode() <> "Edit" then
   editkey
endif
if first_time then
  [Table Id] = 1
endif
if not isformview() then
   formkey
endif
while not done
   wait record
        prompt "[F1] = Lookup       [F2]  = Exit       [PgUp] = Page Up       [PgDn] = Page Down",
               "       Tables       [Ins] = Insert     [Del]  = Delete"
        until "F1", "F2", "PgUp", "PgDn", "Ins", "Del"
   switch
      case retval = "F1": if field() = "Table Name" then
                             showtables "" "Highlight Table To Select, Then Press Enter"
                                     to tabname
                             if tabname <> "Esc" then
                                 [] = tabname
                             endif
                          else
                             beep
                          endif
      case retval = "PgUp": ok = CheckForTableName()
                            if not bot() and ok then
                               skip -1
                            else
                               beep
                               message "Invalid/Duplicate Table Name Entered"
                            endif
      case retval = "PgDn": ok = CheckForTableName()
                            if not eot() and ok then
                               skip
                            else
                               beep
                               message "Invalid/Duplicate Table Name Entered"
                            endif
      case retval = "Ins":  end
                            PgDn
                            [Table Id] = cmax(table_name,"Table Id")+1
      case retval = "Del":  delete_table_id = [Table Id]
                            del
                            DeleteReferences()
      case retval = "F2" :  ok = CheckForTableName()
                            if ok then
                               GetTableNames()
                               done = true
                            else
                               beep
                               message "Invalid/Duplicate Table Name Entered"
                            endif
   endswitch
endwhile
clear
ENDPROC

writelib "zoomkit" LoadTables
release procs LoadTables

PROC DeleteReferences()
private saverecno
   message "Deleting All Other References To This Table .... Just A Moment"
   echo off
   moveto tfunc_name moveto field "table id"
   locate delete_table_id
   while retval
      del
      locate next delete_table_id
   endwhile
   moveto lookup_name moveto field "table id"
   locate delete_table_id
   while retval
      del
      locate next delete_table_id
   endwhile
   moveto pchild_name moveto field "parent id"
   locate delete_table_id
   while retval
      del
      locate next delete_table_id
   endwhile
   moveto field "child id"
   locate delete_table_id
   while retval
      del
      locate next delete_table_id
   endwhile
   message "Re-aligning Table Id Numbers .... Just A Moment"
   echo off
   moveto table_name
   scan
      saverecno = recno()
      moveto tfunc_name moveto field "table id"
      scan for [table id] = [table -> table id]
         [table id] = saverecno
      endscan
      moveto lookup_name moveto field "table id"
      scan for [table id] = [table -> table id]
         [table id] = saverecno
      endscan
      moveto pchild_name moveto field "parent id"
      scan for [parent id] = [table -> table id]
         [parent id] = saverecno
      endscan
      scan for [child id] = [table -> table id]
         [child id] = saverecno
      endscan
      moveto table_name
      [table id] = recno()
   endscan
   if not isformview() then
      formkey
   endif
ENDPROC

writelib "zoomkit" DeleteReferences
release procs DeleteReferences

PROC CheckForTableName()
private saverecno
saverecno = recno()
if isblank([Table Name]) then
   return false
else
   execute "locate \""+[Table Name]+"\""
   if recno() <> saverecno then
      moveto record saverecno
      return false
   endif
endif
return true
ENDPROC

writelib "zoomkit" CheckForTableName
release procs CheckForTableName

PROC Generate()
   Do_it!
   message "Generating Script ....Just A Moment"
   add_key    = 5
   enter_key  = 17
   exit_key   = 12
   return_key = 11
   lookup_key = 1
   search_key = 3
   snext_key  = 4
   child_key  = 7
   parent_key = 8
   Setup()
   release vars function_name, function_table, procedure
   release vars lookup_name, lookup_table, tfunc_name, tfunc_table
   release vars pchild_name, pchild_table, tablenames, done, retval
   release vars description, function, prev_choice, option, tabledesc
   for k from 1 to nrecords(table_table)
      execute "release vars tablefield"+strval(k)
      execute "release vars tabledummy"+strval(k)
   endfor
   release vars table_table, table_name, k
   savevars all
   if isfile(path+script_name+".sc") then
      MENU {Tools} {Delete} {Script} typein(script_name) ENTER {Ok}
   endif
   MENU {Tools} {Rename} {Script} {savevars} typein(script_name) ENTER
   if path <> sdir() then
      MENU {Tools} {Copy} {Script} typein(script_name) ENTER typein(path+script_name) ENTER
      MENU {Tools} {Delete} {Script} typein(script_name) ENTER {Ok}
   endif
ENDPROC

writelib "zoomkit" Generate
release procs Generate

PROC LoadProcs()
private tabname, done, x, description_key
done = false
moveto tfunc_name
if sysmode() <> "Edit" then
   editkey
endif
if not isformview() then
   formkey
endif
while not done
   wait record
        prompt "[F1] = Lookup       [F2]  = Exit       [PgUp] = Page Up       [PgDn] = Page Down",
               "[^D] = Ditto Prev   [Ins] = Insert     [Del]  = Delete"
        until "F1", "F2", "PgUp", "PgDn", "Ins", "Del"
   @ 22,0 clear eol
   switch
      case retval = "F1": if field() = "Function Key" then
                             showarray Description Function
                               default Description[1]
                                    to description_key
                             if description_key <> "Esc" then
                                for x from 1 to nrecords(function_table)
                                    if description[x] = description_key then
                                       [] = function[x]
                                       [Proc Name] = procedure[x]
                                       quitloop
                                    endif
                                endfor
                             endif
                          else
                             if field() = "Table Name" then
                                showarray tablenames tabledesc
                                  default tablenames[1]
                                       to tabname
                                if tabname <> "Esc" then
                                   [] = tabname
                                endif
                             else
                                beep
                             endif
                          endif
     case retval = "F2"  :  GetIdsForProcs()
                            done = true
     case retval = "PgUp":  if not bot() then
                               skip -1
                            else
                               beep
                            endif
      case retval = "PgDn": if not eot() then
                               skip
                            else
                               beep
                            endif
      case retval = "Ins":  end
                            PgDn
      case retval = "Del":  del
   endswitch
endwhile
clear
ENDPROC

writelib "zoomkit" Loadprocs
release procs Loadprocs

PROC LoadLookups()
private tabname, done, savetablename,tabledummyname
done = false
moveto lookup_name
if sysmode() <> "Edit" then
   editkey
endif
if not isformview() then
   formkey
endif
while not done
   wait record
        prompt "[F1] = Lookup       [F2]  = Exit       [PgUp] = Page Up       [PgDn] = Page Down",
               "                    [Ins] = Insert     [Del]  = Delete"
        until "F1", "F2", "PgUp", "PgDn", "Ins", "Del"
   @ 22,0 clear eol
   switch
      case retval = "F1" :  if field() = "Table Name" then
                              showarray tablenames tabledesc
                                default tablenames[1]
                                     to tabname
                              if tabname <> "Esc" then
                                 [] = tabname
                              endif
                            else
                              savetablename = "TableField"
                              tabledummyname = "TableDummy"
                              if field() = "Field Name" then
                                 GetATableId()
                                 savetablename = savetablename + strval([Table Id])
                                 tabledummyname = tabledummyname + strval([Table Id])
                                 execute "showarray "+savetablename+" "+tabledummyname+" "+
                                         "  default "+savetablename+"[1]"+
                                         "       to fldname"
                                 if fldname <> "Esc" then
                                    [] = fldname
                                    [Field Id] = fieldno(fldname,[Table Name])
                                 endif
                              else
                                 beep
                              endif
                            endif
     case retval = "F2"  :  GetIdsForTables()
                            done = true
     case retval = "PgUp":  if not bot() then
                               skip -1
                            else
                               beep
                            endif
      case retval = "PgDn": if not eot() then
                               skip
                            else
                               beep
                            endif
      case retval = "Ins":  end
                            PgDn
      case retval = "Del":  del
   endswitch
endwhile
clear
ENDPROC

writelib "zoomkit" LoadLookups
release procs LoadLookups

PROC GetIdsForTables()
private tabname, saverecno, tab_id
message "Verifying Table Names ...."

echo off
scan
   tabname = [Table Name]
   saverecno = recno()
   moveto table_name moveto field "table name"
   locate tabname
   if not retval then
     beep
     message "Found Invalid Table Name In Record # "+strval(saverecno)
     tab_id = blanknum()
     sleep 5000
   else
     tab_id = [table id]
   endif
   moveto lookup_name
   [Table Id] = tab_id
endscan
@22,0 clear eol
ENDPROC

writelib "zoomkit" GetIdsForTables
release procs GetIdsForTables

PROC GetATableId()
private tabname, tab_id
   tabname = [Table Name]
   moveto table_name moveto field "table name"
   locate tabname
   if not retval then
     beep
     message "Found Invalid Table Name In Record # "+strval(saverecno)
     tab_id = blanknum()
     sleep 5000
   else
     tab_id = [table id]
   endif
   moveto lookup_name
   [Table Id] = tab_id
   if not isformview() then
     formkey
   endif
ENDPROC

writelib "zoomkit" GetATableId
release procs GetATableId

PROC GetIdsForProcs()
private function_key, tabname, function_id, tab_id, saverecno
message "Verifying Function Keys & Table Names ...."

echo off
scan
   function_key = [Function Key]
   tabname = [Table Name]
   saverecno = recno()
   moveto function_name moveto field "description"
   locate function_key
   if not retval then
     beep
     message "Found Invalid Function Key In Record # "+strval(saverecno)
     function_id = blanknum()
     sleep 5000
   else
     function_id = [function id]
   endif
   function_id = [function id]
   moveto table_name moveto field "table name"
   locate tabname
   if not retval then
     beep
     message "Found Invalid Table Name In Record # "+strval(saverecno)
     tab_id = blanknum()
     sleep 5000
   else
     tab_id = [table id]
   endif
   moveto tfunc_name
   [Function Id] = function_id
   [Table Id] = tab_id
endscan
@22,0 clear eol
ENDPROC

writelib "zoomkit" GetIdsForProcs
release procs GetIdsForProcs

PROC LoadRelations()
private tabname, tab_id, done
done = false
moveto pchild_name
if sysmode() <> "Edit" then
   editkey
endif
if not isformview() then
   formkey
endif
while not done
   wait record
        prompt "[F1] = Lookup       [F2]  = Exit       [PgUp] = Page Up       [PgDn] = Page Down",
               "[^D] = Ditto Prev   [Ins] = Insert     [Del]  = Delete"
        until "F1", "F2", "PgUp", "PgDn", "Ins", "Del"
   @ 22,0 clear eol
   switch
      case retval = "F1": if field() = "Parent Table" then
                             showarray tablenames tabledesc
                               default tablenames[1]
                                    to tabname
                             if tabname <> "Esc" then
                                [] = tabname
                             endif
                          else
                             if field() = "Child Table" then
                                showarray tablenames tabledesc
                                  default tablenames[1]
                                       to tabname
                                if tabname <> "Esc" then
                                   [] = tabname
                                endif
                             else
                                beep
                             endif
                          endif
      case retval = "F2"  : GetIdsForRelationships()
                            done = true
      case retval = "PgUp": if not bot() then
                               skip -1
                            else
                               beep
                            endif
      case retval = "PgDn": if not eot() then
                               skip
                            else
                               beep
                            endif
      case retval = "Ins":  end
                            PgDn
      case retval = "Del":  del
   endswitch
endwhile
clear
ENDPROC

writelib "zoomkit" LoadRelations
release procs LoadReleations

PROC GetIdsForRelationships()
private parent_table, child_table, parent_id, child_id, saverecno
message "Verifying Table Names ...."

echo off
scan
   parent_table = [Parent Table]
   child_table  = [Child Table]
   saverecno = recno()
   moveto table_name moveto field "table name"
   locate parent_table
   if not retval then
     beep
     message "Found Invalid Parent Name In Record # "+strval(saverecno)
     parent_id = blanknum()
     sleep 5000
   else
     parent_id = [table id]
   endif
   parent_id = [table id]
   locate child_table
   if not retval then
     beep
     message "Found Invalid Child Name In Record # "+strval(saverecno)
     child_id = blanknum()
     sleep 5000
   else
     child_id = [table id]
   endif
   child_id = [table id]
   moveto pchild_name
   [Parent Id] = parent_id
   [Child Id] = child_id
endscan
@22,0 clear eol
ENDPROC

writelib "zoomkit" GetIdsForRelationships
release procs GetIdsForRelationships

PROC InitTables()
private continue,ch
   if sysmode() = "Main" then
      beep
      @ 0,0 clear eol ?? "This Will Empty All System Tables .... Continue (Y/N)? "
      style reverse
      accept "a1" picture "[Y,N,y,n]" default "N" to continue
      style
      @ 0,0 clear eol
      if upper(continue) = "Y" then
         empty table_name
         empty pchild_name
         empty tfunc_name
         empty lookup_name
      endif
   else
      beep
      message "Tables In Edit Mode: Cannot Initialize - Execute [RESTART] .... Press Any Key"
      ch = getchar()
      @ 22,0 clear eol
   endif
ENDPROC

writelib "zoomkit" InitTables
release procs InitTables

PROC ExitProc()
private continue
   if sysmode() = "Edit" then
      beep beep
      @ 0,0 clear eol ?? "Changes Not Saved .... Exit System Without Saving (Y/N)? "
      style reverse
      accept "a1" picture "[Y,N,y,n]" default "N" to continue
      style
      @ 0,0 clear eol
      if upper(continue) = "Y" then
         canceledit
         done = true
      endif
   else
      done = true
   endif
ENDPROC

writelib "zoomkit" ExitProc
release procs ExitProc

PROC ZoomKit()
   readlib "zoomkit" showheader, initialize, retrievetables, gettablenames,
           set_array, getfunctions, changedirectory, driver, displaymenu,
           checktablenames, loadtables, checkfortablename, deletereferences,
           loadrelations, getidsforrelationships, loadprocs, getidsforprocs,
           loadlookups, getatableid, getidsfortables, inittables, resetdirectory,
           generate, setup, set_table_array, set_function_array, set_table_func_array,
           declare_array, set_table_child_array, get_max_fields, restart,
           exitproc
   echo normal
   echo off
   prev_choice = "Tables"
   path=sdir()
   ShowHeader()
   script_name = Initialize()
   Driver()
   clear
   clearall
ENDPROC

writelib "zoomkit" ZoomKit
release procs Zoomkit

Proc Set_Array(name,dim1,dim2,value)
private dims1,dims2
    dims1=strval(dim1)
    dims2=strval(dim2)
    execute name+dims1+"["+dims2+"]=value"
endproc

writelib "zoomkit" Set_Array
release procs Set_Array

Proc Declare_Array(name,dim1,dim2,initval)
private counter,dims1,dims2,counter2
    dims2=strval(dim2)
    for counter from 1 to dim1 step 1
       dims1=strval(counter)
       execute "Array "+name+dims1+"["+dims2+"]"
    endfor
    for counter from 1 to dim1 step 1
       for counter2 from 1 to dim2 step 1
          set_array(name,counter,counter2,initval)
       endfor
    endfor
EndProc

writelib "zoomkit" Declare_Array
release procs Declare_Array

proc Get_Array(name,dim1,dim2)
private dims1,dims2,tempval
    dims1=strval(dim1)
    dims2=strval(dim2)
    execute "tempval="+name+dims1+"["+dims2+"]"
    return tempval
endproc

writelib "zoomkit" Get_Array
release procs Get_Array

proc Set_Table_Array()
private counter
  view "table"
  max_tables=nrecords("table")
  if max_tables>0
     then array table_array[max_tables]
          array show_array[max_tables]
          array prompt_array[max_tables]
          counter=0
          scan
             counter=counter+1
             table_array[counter]=[Table Name]
             show_array[counter]=[menu item]
             prompt_array[counter]=[menu description]
          endscan
  endif
  clearimage
endproc

writelib "zoomkit" Set_Table_Array
release procs Set_Table_Array

proc get_max_fields()
private counter,max_fields,numfields
   max_fields=0
   for counter from 1 to max_tables
       view table_array[counter]
       numfields=nfields(table_array[counter])
       if numfields>max_fields
          then max_fields=numfields
       endif
   endfor
   return max_fields
endproc

writelib "zoomkit" get_max_fields
release procs get_max_fields

proc Set_Function_Array()
private counter
  view "function"
  max_funcs=nrecords("function")
  if max_funcs>0
     then array function_array[max_funcs]
          array key_array[max_funcs]
          array key2_array[max_funcs]
          counter=0
          scan
             counter=counter+1
             function_array[counter]=[description]
             key_array[counter]=[key]
             key2_array[counter]=[function]
          endscan
  endif
  clearimage
endproc

writelib "zoomkit" Set_Function_Array
release procs Set_Function_Array

proc Set_Table_Func_Array()
  if (max_tables>0) and (max_funcs>0)
     then view "tfunc"
          Declare_array("tfunc",max_tables,max_funcs*2,0)
          scan
            if [function type]="Y"
               then Set_array("tfunc",[table id],[function id]+max_funcs,[proc name])
               else Set_array("tfunc",[table id],[function id],[proc name])
            endif
          endscan
          clearimage
  endif
endproc

writelib "zoomkit" Set_Table_Func_Array
release procs Set_Table_Func_Array

proc Set_Table_Child_Array()
private counter
  if (max_tables>0)
     then view "pchild"
          view "Lookup"
          max_relation=nrecords("pchild")+nrecords("lookup")
          array relation_array[max_relation]
          Declare_array("pchild",max_tables,max_tables,0)
          counter=0
          moveto "pchild"
          scan
             counter=counter+1
             relation_array[counter]=[parameters]
             Set_array("pchild",[parent id],[child id],counter)
          endscan
          max_fields=get_max_fields()
          Declare_array("Lookup",max_tables,max_fields,0)
          moveto "lookup"
          scan
             counter=counter+1
             relation_array[counter]=[parameters]
             Set_array("Lookup",[table id],[field id],counter)
          endscan
          clearimage
          clearimage
  endif
endproc

writelib "zoomkit" Set_Table_Child_Array
release procs Set_Table_Child_Array

PROC Setup()
   echo off
   Set_Table_Array()
   Set_Function_Array()
   Set_Table_Func_Array()
   Set_Table_Child_Array()
ENDPROC

writelib "zoomkit" Setup
release procs Setup
