I recently had to develop an application in Paradox where several
offices would be sending and receiving data - in the form of ASCII
text files - over a MODEM.  The pathnames for these ASCII files are
to be input by the operator and saved in a table until used.

The problem: how to bullet proof the imputing of pathnames that
might not exist yet, and how to check the validity of the pathname
when ready to use it (before Paradox jumps into CANCEL DEBUG !).

It is impossible to verify a drive, path, or file that does not
exist yet.  The best that can be done is verify that it can exit. 
So, it is impossible to completely bullet proof the pathname during
input, if the pathname does not yet exist (but we must try our
best).  Then, when ready to import or export ASCII files, full
verification of the pathname must be made.  Even that is not always
so simple.  For instance, for importing, there must exist an
accessible drive, path, and file name (if the drive and paths are
not defaults).  But it is not necessary to verify a file name for
exporting a ASCII file since the file will be created at the time
of export.  The drive and path, however, must exist if used.

To see some of the problems this presents, refer to Figures (A)
through (D):

          (A) a:first
          (B) a:\first
          (C) a:\first\second
          (D) a:\first\second\

First, lets deal with only a drive letter and a name; figures (A)
and (B).  The problem here is: is "first" a file name or is it a
directory name.  To DOS there is no difference between (A) and
(B) providing that "first" is a file name.  But, if "first" is a
directory name, then (A) is invalid.  The problem is: how do we
know?  We would have to test "first"in (B) as both a file name and
a directory name to know which it is.  But, that can only be done
providing that drive "a:" is a valid drive and is accessible. 
Otherwise, we can only check that "first" is a valid name, but
cannot know if it is a file or directory name. 

Looking at (C) and (D) we have a similar but more complex situation
due to adding a path.  The Paradox DIREXISTS() function makes no
distinction between (C) and (D) if "second" is a directory name. 
But if "second" in figure (C) is a file name, then DIREXISTS() will
find it invalid.  This can only be checked, of course, providing
that a:\first\ is valid and accessible.

At first it does not appear to be very difficult to ascertain if
the last name is a file name or a path: first use ISFILE() to test
for a file name, and if that's False, test for DIREXISTS(). 
However, if DIREXISTS() comes back with a 0, you have not learned
anything because "second" could still be a file name.

All the above may not matter for experienced computer users; you
can simple pop up a error message telling them they have a bad
pathname and let them figure it out.  But, for the average
operator, who may not be conversant in DOS, that method won't work. 
You have to be more explicit.

My answer to all this is a procedure called "PathFinder()"

The script pathfind contains the procedure "PathFinder(pathname.a)"
which parses a pathname (pathname.a) and returns a three digit code
of the  results.  I added a short script at the end of the
procedure for demonstration.  If you play pathfind.sc, it will run
the script and demonstrate how "PathFinder()" works.  It uses the
table "pathmsg" for converting (looking up) the results for
display.  In normal use, by a Paradox programmer, the returned
result can be checked for specific conditions before deciding what
action to take.

The procedure "PathFinder()" does not check out every possible
condition for a valid DOS file name (I never seem to get time to
finish up the last 10% of my scripts).  It does, however, work
pretty good (I think).


Raymond O. Templin
(516) 957-5813

PS: There may be an easier way to do this, but I could not figure
it out. If someone else has, I would like to know about it.
